/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.summary;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropMediaType;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.scala.immutable.Indexer;
import org.openprovenance.prov.scala.immutable.ProvFactory;
import org.openprovenance.prov.scala.summary.Level0Mapper;
import org.openprovenance.prov.scala.summary.Level0MapperJson;
import org.openprovenance.prov.scala.summary.SummaryAPI;
import org.openprovenance.prov.scala.summary.SummaryConfig;
import org.openprovenance.prov.scala.summary.SummaryConfiguration;
import org.openprovenance.prov.scala.summary.SummaryDescriptionJson;
import org.openprovenance.prov.scala.summary.SummaryIndex;
import org.openprovenance.prov.scala.summary.TypePropagator;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.Constants;
import org.openprovenance.prov.service.core.EmptyOtherActionPerformer;
import org.openprovenance.prov.service.core.OtherActionPerformer;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.jobs.JobManagement;
import org.openprovenance.prov.service.core.memory.DocumentResourceInMemory;
import org.openprovenance.prov.service.summary.ActionSummary;
import org.openprovenance.prov.service.summary.ActionUpload;
import org.openprovenance.prov.service.summary.SummaryDocumentResource;
import org.openprovenance.prov.service.summary.SummaryDocumentResourceInMemory;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.NonDocumentResource;
import org.openprovenance.prov.storage.api.NonDocumentResourceIndex;
import org.openprovenance.prov.storage.api.NonDocumentResourceStorage;
import org.openprovenance.prov.storage.api.ResourceIndex;
import org.openprovenance.prov.storage.api.ResourceStorage;
import scala.Tuple2;

@Path(value="")
public class SummaryService
implements Constants,
InteropMediaType {
    static Logger logger = LogManager.getLogger(SummaryService.class);
    private final ServiceUtils utils;
    private static final String KEYSTORE_PATH = "keystore_path";
    private static final String KEYSTORE_PASS = "keystore_pass";
    private static final String KEYSTORE_KEY = "keystore_key";
    private static final String KEYSTORE_KEYPASS = "keystore_keypass";
    private final JobManagement jobManager;
    private final NonDocumentResourceStorage ndStorage;

    public SummaryService(PostService postService) {
        this(postService, new LinkedList<ActionPerformer>(), Optional.empty());
    }

    public SummaryService(PostService postService, List<ActionPerformer> performers, Optional<OtherActionPerformer> otherPerformer) {
        this.utils = postService.getServiceUtils();
        postService.addToPerformers(PostService.addToList((Object)new ActionUpload(this.utils), (List)PostService.addToList((Object)new ActionSummary(this.utils), performers)));
        postService.addOtherPerformer(Optional.of(otherPerformer.orElse((OtherActionPerformer)new EmptyOtherActionPerformer())));
        this.jobManager = postService.getJobManager();
        this.ndStorage = this.utils.getNonDocumentResourceStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/documents/{docId}/summary")
    @Tag(name="summary")
    @Consumes(value={"application/json"})
    @Operation(summary="Post a summary configuration document, directly, creates a resource, supports content negotiation, redirects to URL providing serialization for the resource", description="It supports the direct posting of configuration documents in json format.", responses={@ApiResponse(responseCode="200", content={@Content(mediaType="text/turtle"), @Content(mediaType="text/provenance-notation"), @Content(mediaType="application/provenance+xml"), @Content(mediaType="application/trig"), @Content(mediaType="application/rdf+xml"), @Content(mediaType="application/json")}), @ApiResponse(responseCode="303", headers={@Header(name="location", description="Location of posted document")}, description="See other url for serialization of posted resource as requested by accept header."), @ApiResponse(responseCode="404", description="Provenance not found")})
    public Response submit(@Parameter(name="input", description="input file in a prov serialization", example="{\"level\": \"2\", \"level0\": {\"mapper\":{},\"ignore\":[]}}") InputStream input, @PathParam(value="docId") String msg, @Context HttpHeaders headers, @Context Request request) throws IOException {
        System.out.println("in submit summary configuration for " + msg);
        SummaryConfiguration sc = (SummaryConfiguration)TypePropagator.om().readValue(input, SummaryConfiguration.class);
        Level0Mapper level0 = new Level0Mapper(sc.level0());
        int level = sc.level();
        boolean aggregated = sc.aggregated();
        System.out.println("summary level is " + level);
        SummaryIndex ndx = this.getSummary(msg, level, level0, aggregated);
        ResourceIndex resourceIndexer = this.utils.getDocumentResourceIndex();
        NonDocumentResourceIndex ndIndex = this.utils.getNonDocumentResourceIndex();
        try (ResourceIndex index = resourceIndexer.getIndex();){
            String serialConfigId = this.storeSummaryConfiguration(sc, (NonDocumentResourceIndex<NonDocumentResource>)ndIndex);
            String ptypesId = this.storeSummaryDescription(ndx, (NonDocumentResourceIndex<NonDocumentResource>)ndIndex);
            String storageId = this.storeSummaryDocument(ndx);
            String configId = index.newId();
            SummaryDocumentResourceInMemory sdr = new SummaryDocumentResourceInMemory((DocumentResource)new DocumentResourceInMemory());
            sdr.setVisibleId(configId);
            sdr.setStorageId(storageId);
            sdr.setConfigId(serialConfigId);
            sdr.setPtypesId(ptypesId);
            this.utils.getDocumentResourceIndex().put(configId, (DocumentResource)sdr);
            Date date = this.jobManager.scheduleJob(sdr.getVisibleId());
            sdr.setExpires(date);
            Response response = this.utils.composeResponseSeeOther("documents/" + sdr.getVisibleId()).header("Expires", (Object)date).build();
            return response;
        }
    }

    public String storeSummaryDocument(SummaryIndex ndx) throws IOException {
        ResourceStorage storageManager = this.utils.getStorageManager();
        String storageId = storageManager.newStore(Formats.ProvFormat.PROVN);
        org.openprovenance.prov.scala.immutable.Document summaryDocument = ndx.document();
        this.utils.documentCache.put((Object)storageId, (Object)summaryDocument);
        storageManager.writeDocument(storageId, (Document)summaryDocument, Formats.ProvFormat.PROVN);
        return storageId;
    }

    public String storeSummaryDescription(SummaryIndex ndx, NonDocumentResourceIndex<NonDocumentResource> ndIndex) throws IOException {
        NonDocumentResource aResource2 = ndIndex.newResource();
        String ptypesId = aResource2.getVisibleId();
        aResource2.setMediaType("application/json");
        String resourceName2 = this.ndStorage.newStore("json", "application/json");
        this.ndStorage.serializeObjectToStore(TypePropagator.om(), (Object)ndx.summaryDescription(), resourceName2);
        aResource2.setStorageId(resourceName2);
        ndIndex.put(ptypesId, aResource2);
        return ptypesId;
    }

    public String storeSummaryConfiguration(SummaryConfiguration sc, NonDocumentResourceIndex<NonDocumentResource> ndIndex) throws IOException {
        NonDocumentResource aResource1 = ndIndex.newResource();
        String serialConfigId = aResource1.getVisibleId();
        aResource1.setMediaType("application/json");
        String resourceName1 = this.ndStorage.newStore("json", "application/json");
        this.ndStorage.serializeObjectToStore(TypePropagator.om(), (Object)sc, resourceName1);
        aResource1.setStorageId(resourceName1);
        ndIndex.put(serialConfigId, aResource1);
        return serialConfigId;
    }

    public SummaryIndex getSummary(String docId, int level, Level0Mapper level0, boolean aggregated) throws IOException {
        return this.getSummaryIndex(docId, level, level0, false, aggregated);
    }

    public SummaryIndex getProvenanceKernel(String docId, int level, Level0Mapper level0, boolean aggregated) throws IOException {
        return this.getSummaryIndex(docId, level, level0, true, aggregated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SummaryIndex getSummaryIndex(String docId, int level, Level0Mapper level0, boolean kernel, boolean aggregated) throws IOException {
        try (ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();){
            SummaryIndex indexed;
            org.openprovenance.prov.scala.immutable.Document d2;
            DocumentResource dr = index.get(docId);
            Document doc = this.utils.getDocumentFromCacheOrStore(dr.getStorageId());
            org.openprovenance.prov.scala.immutable.Document d3 = d2 = ProvFactory.pf().newDocument(doc);
            SummaryConfig config = new SummaryConfig(level, kernel, aggregated);
            Tuple2 pair = SummaryAPI.sum((org.openprovenance.prov.scala.immutable.Document)d3, (SummaryConfig)config, (Level0Mapper)level0);
            Indexer ind = (Indexer)pair._1;
            TypePropagator tp = (TypePropagator)pair._2;
            SummaryIndex summaryIndex = indexed = SummaryAPI.makeSummaryIndex((SummaryConfig)config, (TypePropagator)tp, (Indexer)ind, (int)level, null, null);
            return summaryIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/documents/{docId}/config")
    @Operation(summary="Summary Configuration Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    @Produces(value={"application/json"})
    @Tag(name="summary")
    public Response getConfiguration(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg) {
        try (ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();){
            DocumentResource dr = index.get(msg);
            if (dr == null) {
                Response response2 = this.utils.composeResponseNotFoundResource(msg);
                return response2;
            }
            if (!(dr instanceof SummaryDocumentResource)) {
                Response response3 = this.utils.composeResponseNotFoundSummarisation(msg);
                return response3;
            }
            SummaryDocumentResource sdr = (SummaryDocumentResource)dr;
            NonDocumentResourceIndex ndIndex = this.utils.getNonDocumentResourceIndex();
            NonDocumentResource ndr = ndIndex.get(sdr.getConfigId());
            SummaryConfiguration sc = (SummaryConfiguration)this.ndStorage.deserializeObjectFromStore(TypePropagator.om(), ndr.getStorageId(), SummaryConfiguration.class);
            StreamingOutput so = out -> TypePropagator.om().writeValue(out, (Object)sc);
            Response response4 = ServiceUtils.composeResponseOK((Object)so).type("application/json").build();
            return response4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/documents/{docId}/details")
    @Operation(summary="Summary Prov Types", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    @Produces(value={"application/json"})
    @Tag(name="summary")
    public Response getSummaryProvTypes(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg) {
        try (ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();){
            DocumentResource dr = index.get(msg);
            if (dr == null) {
                Response response2 = this.utils.composeResponseNotFoundResource(msg);
                return response2;
            }
            if (!(dr instanceof SummaryDocumentResource)) {
                Response response3 = this.utils.composeResponseNotFoundSummarisation(msg);
                return response3;
            }
            SummaryDocumentResource sdr = (SummaryDocumentResource)dr;
            System.out.println("Found ptypes " + sdr.getPtypesId());
            NonDocumentResourceIndex ndIndex = this.utils.getNonDocumentResourceIndex();
            NonDocumentResource ndr = ndIndex.get(sdr.getPtypesId());
            System.out.println("Found ptypes storage id" + ndr.getStorageId());
            SummaryDescriptionJson sdj = (SummaryDescriptionJson)this.ndStorage.deserializeObjectFromStore(TypePropagator.om(), ndr.getStorageId(), SummaryDescriptionJson.class);
            StreamingOutput so = out -> TypePropagator.om().writeValue(out, (Object)sdj);
            Response response4 = ServiceUtils.composeResponseOK((Object)so).type("application/json").build();
            return response4;
        }
    }

    @POST
    @Path(value="/documents/{docId}/provtypes")
    @Tag(name="summary")
    @Consumes(value={"application/json"})
    @Operation(summary="Post a PROV Type configuration document, directly, creates a resource, redirects to URL providing serialization for the resource", description="It supports the direct posting of configuration documents in json format.", responses={@ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="303", headers={@Header(name="location", description="Location of posted document")}, description="See other url for serialization of posted resource as requested by accept header."), @ApiResponse(responseCode="404", description="Provenance not found")})
    public Response submitProvtypesConfig(@Parameter(name="input", description="input file in a prov serialization", example="{\"level\": \"2\", \"level0\": {\"mapper\":{},\"ignore\":[]}}") InputStream input, @PathParam(value="docId") String msg, @Context HttpHeaders headers, @Context Request request) throws IOException {
        System.out.println("in submit prov types configuration for " + msg);
        SummaryConfiguration sc = (SummaryConfiguration)TypePropagator.om().readValue(input, SummaryConfiguration.class);
        System.out.println("submit " + sc.level());
        NonDocumentResourceIndex ndIndex = this.utils.getNonDocumentResourceIndex();
        System.out.println(ndIndex);
        String visibleId = this.storeSummaryConfiguration(sc, (NonDocumentResourceIndex<NonDocumentResource>)ndIndex);
        return this.utils.composeResponseSeeOther("documents/" + msg + "/provtypes/" + visibleId + ".json").build();
    }

    @GET
    @Path(value="/documents/{docId}/provtypes/{configId}.json")
    @Tag(name="summary")
    @Consumes(value={"application/json"})
    @Operation(summary="Returns the prov type mapping as json file", description="Returns the prov type mapping as json file.", responses={@ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Provenance not found")})
    public Response getProvtypes(@PathParam(value="docId") String msg, @PathParam(value="configId") String configId, @Context HttpHeaders headers, @Context Request request) throws IOException {
        System.out.println("in get prov types configuration for " + msg + " " + configId);
        NonDocumentResourceIndex index = this.utils.getNonDocumentResourceIndex();
        NonDocumentResource nd = index.get(configId);
        System.out.println("nd resource " + configId + " " + nd.getStorageId());
        SummaryConfiguration sc = (SummaryConfiguration)this.ndStorage.deserializeObjectFromStore(TypePropagator.om(), nd.getStorageId(), SummaryConfiguration.class);
        Level0MapperJson level0 = sc.level0();
        System.out.println("level 0 " + level0);
        SummaryIndex ndx = this.getProvenanceKernel(msg, sc.level(), new Level0Mapper(level0), sc.aggregated());
        StreamingOutput promise2 = out -> ndx.exportToJsonDescription(out);
        return ServiceUtils.composeResponseOK((Object)promise2).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Path(value="/documents/{docId}/provtypes/{configId}/config")
    @Tag(name="summary")
    @Consumes(value={"application/json"})
    @Operation(summary="Returns the prov type mapping as json file", description="Returns the prov type mapping as json file.", responses={@ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Provenance not found")})
    public Response getProvtypesConfiguration(@PathParam(value="docId") String msg, @PathParam(value="configId") String configId, @Context HttpHeaders headers, @Context Request request) throws IOException {
        System.out.println("in get prov types configuration for " + msg + " " + configId);
        NonDocumentResourceIndex index = this.utils.getNonDocumentResourceIndex();
        NonDocumentResource nd = index.get(configId);
        System.out.println("nd resource " + configId + " " + nd.getStorageId());
        SummaryConfiguration sc = (SummaryConfiguration)this.ndStorage.deserializeObjectFromStore(TypePropagator.om(), nd.getStorageId(), SummaryConfiguration.class);
        Level0MapperJson level0 = sc.level0();
        System.out.println("level 0 " + level0);
        StreamingOutput promise2 = out -> TypePropagator.om().writeValue(out, (Object)sc);
        return ServiceUtils.composeResponseOK((Object)promise2).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

