/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.summary.actions;

import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.openprovenance.prov.log.ProvLevel;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.storage.api.DocumentResource;

public final class ActionUpload
implements ActionPerformer {
    private static Logger logger = LogManager.getLogger(ActionUpload.class);
    private final ServiceUtils utils;

    public ActionUpload(ServiceUtils utils) {
        this.utils = utils;
    }

    public ServiceUtils.Action getAction() {
        return ServiceUtils.Action.UPLOAD;
    }

    public Response doAction(Map<String, List<InputPart>> formData, DocumentResource vr, Date date) {
        String location = "documents/" + vr.getVisibleId();
        this.doLog("summarisation", vr);
        return this.utils.composeResponseSeeOther(location).header("Expires", (Object)date).build();
    }

    private void doLog(String action, DocumentResource vr) {
        logger.log(ProvLevel.PROV, "" + action + "," + vr.getVisibleId() + "," + vr.getStorageId());
    }

    public String toString() {
        return "<<performer:" + this.getAction() + ">>";
    }
}

