/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.validation;

import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.ServiceUtilsConfig;
import org.openprovenance.prov.service.validation.ValidationObjectMaker;
import org.openprovenance.prov.service.validation.ValidationResource;
import org.openprovenance.prov.service.validation.ValidationService;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.NonDocumentGenericResourceStorage;
import org.openprovenance.prov.storage.api.NonDocumentResourceStorage;
import org.openprovenance.prov.storage.api.ResourceIndex;
import org.openprovenance.prov.storage.api.ResourceStorage;
import org.openprovenance.prov.validation.Config;
import org.openprovenance.prov.validation.Constraints;
import org.openprovenance.prov.validation.ObjectMaker;
import org.openprovenance.prov.validation.Validate;
import org.openprovenance.prov.validation.report.ValidationReport;

public class ValidationServiceUtils
extends ServiceUtils {
    static Logger logger = LogManager.getLogger(ValidationServiceUtils.class);
    private final ProvFactory f;
    private final Namespace ns;
    private final ServiceUtils utils;
    private final ResourceIndex<ValidationResource> validationDocumentResourceIndex;

    public ResourceIndex<DocumentResource> getDocumentResourceIndex() {
        return this.utils.getDocumentResourceIndex();
    }

    public ResourceStorage getStorageManager() {
        return this.utils.getStorageManager();
    }

    public ValidationServiceUtils(PostService ps, ProvFactory f, Namespace ns, ServiceUtils utils, ServiceUtilsConfig config) {
        super(ps, config);
        ResourceIndex indexer;
        this.f = f;
        this.ns = ns;
        this.utils = utils;
        this.validationDocumentResourceIndex = indexer = (ResourceIndex)utils.getExtensionMap().get(ValidationResource.getResourceKind());
    }

    public ResourceIndex<ValidationResource> getValidationResourceIndex() {
        return this.validationDocumentResourceIndex;
    }

    public Object normalizedDocument(String visibleId) {
        ValidationResource vr = (ValidationResource)this.getValidationResourceIndex().get(visibleId);
        if (vr == null) {
            String result = "Not found resource for : " + visibleId;
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)result).build();
        }
        ValidationResource vr2 = vr;
        if (!vr.getCompleted()) {
            String result = "Not found constraints resource for : " + visibleId;
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)result).build();
        }
        return null;
    }

    public boolean performValidation(Document doc, ValidationResource vr, ResourceIndex<ValidationResource> index, NonDocumentGenericResourceStorage<ValidationReport> reportStorage, NonDocumentGenericResourceStorage<String> matrixStorage, NonDocumentResourceStorage nonDocumentResourceStorage) throws IOException {
        logger.debug("validating document " + vr.getVisibleId());
        Validate validator = new Validate(Config.newYesToAllConfig((ProvFactory)this.f, (ObjectMaker)new ValidationObjectMaker()));
        ValidationReport report = validator.validate(doc);
        Namespace ns = doc.getNamespace();
        Constraints constraints = validator.getConstraints();
        boolean completed = constraints != null;
        vr.setCompleted(completed);
        logger.debug("This is vr before saving " + vr + " " + vr.getCompleted() + " " + completed);
        if (completed) {
            String reportStorageId = nonDocumentResourceStorage.newStore("xml", "application/xml");
            String jsonReportStorageId = reportStorage.newStore("json", "application/json");
            String matrixTextId = matrixStorage.newStore("txt", "text/plain");
            String matrixPngId = matrixStorage.newStore("png", ValidationService.IMAGE_PNG_TYPE.toString());
            vr.setReport(reportStorageId);
            vr.setJsonReport(jsonReportStorageId);
            vr.setMatrix(matrixTextId);
            vr.setPngMatrix(matrixPngId);
            logger.debug("This is vr before saving " + vr);
            index.put(vr.getVisibleId(), (DocumentResource)vr);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.utils.getConfig().serialiser.serialiseObject((OutputStream)baos, (Object)report, "ignore", false);
            nonDocumentResourceStorage.copyStringToStore((CharSequence)baos.toString(), reportStorageId);
            ns.register("val", "http://foo.foo/");
            report.setNamespace(ns);
            reportStorage.serializeObjectToStore((Object)report, jsonReportStorageId);
            String matrix = constraints.getMatrix().displayMatrix2();
            matrixStorage.copyStringToStore((CharSequence)matrix, matrixTextId);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            constraints.getMatrix().generateImage1((OutputStream)baos2);
            matrixStorage.copyStringToStore((CharSequence)Base64.getEncoder().encodeToString(baos2.toByteArray()), matrixPngId);
            logger.debug("stored validation report document and matrix " + vr.getReport());
        } else {
            index.put(vr.getVisibleId(), (DocumentResource)vr);
        }
        return vr.getCompleted();
    }
}

