/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.validation.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mongojack.internal.MongoJackModule;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.service.core.ServiceUtilsConfig;
import org.openprovenance.prov.service.core.memory.DocumentResourceIndexInMemory;
import org.openprovenance.prov.service.translation.storage.EnvironmentVariables;
import org.openprovenance.prov.service.validation.ValidationResource;
import org.openprovenance.prov.service.validation.memory.ValidationResourceIndexInMemory;
import org.openprovenance.prov.service.validation.redis.RedisValidationResourceIndex;
import org.openprovenance.prov.service.validation.storage.ValidationReportWrapper;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.ResourceIndex;
import org.openprovenance.prov.storage.filesystem.NonDocumentGenericResourceStorageFileSystem;
import org.openprovenance.prov.storage.mongodb.MongoAsciiBlobStorage;
import org.openprovenance.prov.storage.mongodb.MongoGenericResourceStorage;
import org.openprovenance.prov.storage.redis.RedisDocumentResourceIndex;
import org.openprovenance.prov.validation.report.ValidationReport;
import org.openprovenance.prov.validation.report.json.Mapper;

public class StorageConfiguration
extends org.openprovenance.prov.service.translation.storage.StorageConfiguration
implements EnvironmentVariables {
    static Logger logger = LogManager.getLogger(StorageConfiguration.class);

    public ServiceUtilsConfig withMongoDb(ServiceUtilsConfig utilsConfig2, ProvFactory factory, Map<String, String> configuration) {
        ServiceUtilsConfig utilsConfig = super.withMongoDb(utilsConfig2, factory, configuration);
        ObjectMapper mapper = Mapper.getValidationReportMapper();
        mapper.registerModule(MongoJackModule.INSTANCE);
        String mongoHost = configuration.get("PSERVICE_MONGO_HOST");
        String mongoDbName = configuration.get("PSERVICE_DBNAME");
        MongoGenericResourceStorage reportStorage = new MongoGenericResourceStorage(mongoHost, mongoDbName, "report", mapper, ValidationReport.class, ValidationReportWrapper::new);
        utilsConfig.genericResourceStorageMap.put("report", reportStorage);
        MongoAsciiBlobStorage matrixStorage = new MongoAsciiBlobStorage(mongoHost, mongoDbName, "matrix");
        utilsConfig.genericResourceStorageMap.put("matrix", matrixStorage);
        return utilsConfig;
    }

    public ServiceUtilsConfig withFileSystem(ServiceUtilsConfig utilsConfig2, ProvFactory factory, Map<String, String> configuration) {
        ServiceUtilsConfig utilsConfig = super.withFileSystem(utilsConfig2, factory, configuration);
        utilsConfig.genericResourceStorageMap.put("report", new NonDocumentGenericResourceStorageFileSystem(Mapper.getValidationReportMapper(), ValidationReport.class, this.path));
        utilsConfig.genericResourceStorageMap.put("matrix", new NonDocumentGenericResourceStorageFileSystem(new ObjectMapper(), Object.class, this.path));
        return utilsConfig;
    }

    public Map<String, ResourceIndex<?>> initInMemory(ServiceUtilsConfig config, Map<String, String> configuration) {
        Map extensionMap = super.initInMemory(config, configuration);
        ResourceIndex di = (ResourceIndex)extensionMap.get(DocumentResource.getResourceKind());
        extensionMap.put(ValidationResource.getResourceKind(), new ValidationResourceIndexInMemory((ResourceIndex<DocumentResource>)((DocumentResourceIndexInMemory)di), ValidationResourceIndexInMemory.factory));
        return extensionMap;
    }

    public Map<String, ResourceIndex<?>> initRedis(ServiceUtilsConfig config, Map<String, String> configuration) {
        Map extensionMap = super.initRedis(config, configuration);
        ResourceIndex di = (ResourceIndex)extensionMap.get(DocumentResource.getResourceKind());
        extensionMap.put(ValidationResource.getResourceKind(), new RedisValidationResourceIndex((RedisDocumentResourceIndex)di, RedisValidationResourceIndex.factory));
        return extensionMap;
    }
}

