/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.validation;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.Variant;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.interop.InteropMediaType;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.Constants;
import org.openprovenance.prov.service.core.EmptyOtherActionPerformer;
import org.openprovenance.prov.service.core.OtherActionPerformer;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.SwaggerTags;
import org.openprovenance.prov.service.translation.actions.ActionTranslate;
import org.openprovenance.prov.service.validation.ActionValidate;
import org.openprovenance.prov.service.validation.ValidationResource;
import org.openprovenance.prov.service.validation.ValidationServiceUtils;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.NonDocumentGenericResourceStorage;
import org.openprovenance.prov.storage.api.ResourceIndex;

@Path(value="")
public class ValidationService
implements Constants,
InteropMediaType,
SwaggerTags {
    public static final MediaType IMAGE_PNG_TYPE = MediaType.valueOf((String)"image/png");
    static Logger logger = LogManager.getLogger(ValidationService.class);
    public static String VS = "http://openprovenance.org/validation/service";
    public static String VS_PREFIX = "vs";
    public static String VSI = "http://openprovenance.org/validation/service/instance";
    public static String VSI_PREFIX = "vsi";
    final ProvFactory f;
    final ValidationServiceUtils utils;
    final ActionValidate actionValidate;
    final ActionTranslate actionTranslate;
    final Namespace namespace = new Namespace();

    public ValidationService(PostService postService) {
        this(postService, new LinkedList<ActionPerformer>(), Optional.empty());
    }

    public ValidationService(PostService postService, List<ActionPerformer> performers, Optional<OtherActionPerformer> otherPerformer) {
        this.f = postService.getServiceUtils().getProvFactory();
        this.utils = new ValidationServiceUtils(postService, this.f, new Namespace(), postService.getServiceUtils(), postService.getServiceUtils().getConfig());
        postService.addToPerformers(PostService.addToList((Object)new ActionValidate(this.utils), performers));
        postService.addOtherPerformer(Optional.of(otherPerformer.orElse((OtherActionPerformer)new EmptyOtherActionPerformer())));
        this.actionValidate = new ActionValidate(this.utils);
        this.actionTranslate = new ActionTranslate((ServiceUtils)this.utils);
        this.namespace.addKnownNamespaces();
        this.namespace.register("val", "http://openprovenance.org/validation#");
        this.namespace.register(VS_PREFIX, VS);
        this.namespace.register(VSI_PREFIX, VSI);
    }

    @GET
    @Path(value="/documents/{docId}/validation/normalForm")
    @Tag(name="validation")
    @Operation(summary="Document in normal form", description="It is expected that validation has taken place.", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response getNormalized(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, @Parameter(name="Accept", description="Accept header parameter", example="application/json,text/provenance-notation,application/provenance+xml,image/svg+xml,image/png,image/jpeg,application/pdf", required=false) @HeaderParam(value="Accept") String accept) {
        return this.utils.contentNegotiationForDocument(request, msg, "/validation/normalForm.");
    }

    @GET
    @Path(value="/documents/{docId}/validation/normalForm.{type}")
    @Tag(name="validation")
    @Operation(summary="Normal form of a document into given representation", description="Validation expected to have taken place. No content negotiation allowed here", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response getNormalFormAsType(@Context HttpServletResponse response, @Context HttpServletRequest request, @Parameter(name="docId", description="document id", required=true) @PathParam(value="docId") String msg, @Parameter(name="type", description="serialization type", example="ttl,provn,provx,json,rdf,trig,svg,png,pdf,jpg,jpeg,jsonld", required=true) @PathParam(value="type") String type) throws FileNotFoundException, IOException, ServletException {
        logger.debug("normal form to " + type);
        if (type == null || !translationExtensions.contains(type)) {
            return this.utils.composeResponseNotFoundResource(msg);
        }
        DocumentResource vr = this.utils.getValidationResourceIndex().get(msg);
        if (vr == null) {
            return this.utils.composeResponseNotFoundResource(msg);
        }
        Object o = this.utils.normalizedDocument(msg);
        if (!(o instanceof Document)) {
            return (Response)o;
        }
        Document doc = (Document)o;
        String outFile = vr.getStorageId() + "-normalForm." + type;
        logger.warn("TODO: need to call storage functionality for " + outFile);
        InteropFramework intF = new InteropFramework();
        intF.writeDocument(outFile, doc);
        File f = new File(outFile);
        String mimeType = intF.convertExtensionToMediaType(type);
        logger.debug("setting mimeType " + mimeType + " for " + type);
        return ServiceUtils.composeResponseOK((Object)f).type(mimeType).build();
    }

    @GET
    @Path(value="/documents/{docId}/validation/report")
    @Tag(name="validation")
    @Operation(summary="Validation Report", description="Use content negotiation to select representation", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response getValidationReport(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, @Parameter(name="Accept", description="Accept header parameter", example="text/html,application/json", required=false) @HeaderParam(value="Accept") String accept) {
        List vs = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build();
        Variant v = request.selectVariant(vs);
        if (v == null) {
            return this.utils.composeResponseNotAcceptable(vs);
        }
        MediaType mt = v.getMediaType();
        if (mt.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            return this.utils.composeResponseSeeOther("view/documents/" + msg + "/validation/report.html").build();
        }
        if (mt.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            return this.utils.composeResponseSeeOther("documents/" + msg + "/validation/report.json").build();
        }
        String result = "Found MediaType not supported " + String.valueOf(mt);
        return this.utils.composeResponseNotFOUND(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/documents/{docId}/validation/report.json")
    @Produces(value={"application/json"})
    @Tag(name="validation")
    @Operation(summary="Validation Report -- JSON representation", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response getValidationReportAsJson(@PathParam(value="docId") String msg) {
        try (ResourceIndex index = this.utils.getValidationResourceIndex().getIndex();){
            ValidationResource vr = (ValidationResource)index.get(msg);
            if (vr == null) {
                Response response = this.utils.composeResponseNotFoundResource(msg);
                return response;
            }
            if (!vr.getCompleted()) {
                Response response = this.utils.composeResponseNotFoundConstraintResource(msg);
                return response;
            }
            StreamingOutput out = outputStream -> ((NonDocumentGenericResourceStorage)this.utils.getGenericResourceStorageMap().get("report")).copyStoreToOutputStream(vr.getJsonReportStorageId(), outputStream);
            Response response = ServiceUtils.composeResponseOK((Object)out).type("application/json").build();
            return response;
        }
    }

    public String stackTraceToString(Throwable thrown) {
        Object result = "";
        while (thrown != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stringWriter);
            thrown.printStackTrace(pw);
            result = (String)result + stringWriter.toString() + "<p><p>";
            thrown = thrown.getCause();
        }
        result = (String)result + "</pre>";
        return result;
    }

    @GET
    @Path(value="/documents/{docId}/validation/matrix")
    @Tag(name="validation")
    @Operation(summary="Event Matrix", description="It is expected that validation has taken place; note that this is a non information resource and content negotiation should be used to retrieve a suitable representation.", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response getMatrix(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, @Parameter(name="Accept", description="accept header parameter", example="image/png,text/plain", required=false) @HeaderParam(value="Accept") String accept) {
        List vs = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.TEXT_PLAIN_TYPE, IMAGE_PNG_TYPE}).build();
        Variant v = request.selectVariant(vs);
        if (v == null) {
            return this.utils.composeResponseNotAcceptable(vs);
        }
        MediaType mt = v.getMediaType();
        if (mt.equals((Object)IMAGE_PNG_TYPE)) {
            return this.utils.composeResponseSeeOther("documents/" + msg + "/validation/matrix.png").build();
        }
        if (mt.equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
            return this.utils.composeResponseSeeOther("documents/" + msg + "/validation/matrix.txt").build();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/documents/{docId}/validation/matrix.txt")
    @Produces(value={"text/plain"})
    @Tag(name="validation")
    @Operation(summary="Event Matrix -- Text Representation", description="It is expected that validation has taken place. No content negotiation applies here.", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response getMatrixAsText(@PathParam(value="docId") String msg) throws IOException {
        try (ResourceIndex index = this.utils.getValidationResourceIndex().getIndex();){
            ValidationResource vr = (ValidationResource)index.get(msg);
            if (vr == null) {
                Response response = this.utils.composeResponseNotFoundResource(msg);
                return response;
            }
            if (!vr.getCompleted()) {
                Response response = this.utils.composeResponseNotFoundConstraintResource(msg);
                return response;
            }
            logger.info("Returning matrix from file: " + vr.getMatrix());
            StreamingOutput promise = out -> ((NonDocumentGenericResourceStorage)this.utils.getGenericResourceStorageMap().get("matrix")).copyStoreToOutputStream(vr.getMatrix(), out);
            Response response = ServiceUtils.composeResponseOK((Object)promise).type("text/plain").build();
            return response;
        }
    }

    @GET
    @Path(value="/documents/{docId}/validation/matrix.png")
    @Produces(value={"image/png"})
    @Tag(name="validation")
    @Operation(summary="Event Matrix -- Image Representation", description="It is expected that validation has taken place. No content negotiation applies here.", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response getMatrixAsPng(@PathParam(value="docId") String msg) throws IOException {
        ValidationResource vr = (ValidationResource)this.utils.getValidationResourceIndex().get(msg);
        if (vr == null) {
            return this.utils.composeResponseNotFoundResource(msg);
        }
        if (!vr.getCompleted()) {
            return this.utils.composeResponseNotFoundConstraintResource(msg);
        }
        String matrixBase64 = (String)((NonDocumentGenericResourceStorage)this.utils.getGenericResourceStorageMap().get("matrix")).deserializeObjectFromStore(vr.getPngMatrix());
        return ServiceUtils.composeResponseOK((Object)Base64.getDecoder().decode(matrixBase64)).type("image/png").build();
    }
}

