/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.validation;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.jobs.JobManagement;
import org.openprovenance.prov.service.validation.JobDeleteValidationResource;
import org.openprovenance.prov.service.validation.ValidationResource;
import org.openprovenance.prov.service.validation.ValidationServiceUtils;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.NonDocumentGenericResourceStorage;
import org.openprovenance.prov.storage.api.NonDocumentResourceStorage;
import org.openprovenance.prov.storage.api.ResourceIndex;
import org.openprovenance.prov.validation.report.ValidationReport;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class ActionValidate
implements ActionPerformer {
    public static final String REPORT_KEY = "report";
    public static final String MATRIX_KEY = "matrix";
    static final String VALIDATION_UTILS_KEY = "VALIDATION_UTILS_KEY";
    static Logger logger = LogManager.getLogger(ActionValidate.class);
    private final ValidationServiceUtils utils;
    private final ResourceIndex<ValidationResource> validationResourceIndex;
    private final NonDocumentGenericResourceStorage<ValidationReport> reportStorage;
    private final NonDocumentGenericResourceStorage<String> matrixStorage;
    private final NonDocumentResourceStorage nonDocumentResourceStorage;

    public ActionValidate(ServiceUtils utils) {
        this.utils = (ValidationServiceUtils)utils;
        this.validationResourceIndex = this.utils.getValidationResourceIndex();
        this.nonDocumentResourceStorage = this.utils.getNonDocumentResourceStorage();
        this.reportStorage = (NonDocumentGenericResourceStorage)this.utils.getGenericResourceStorageMap().get(REPORT_KEY);
        this.matrixStorage = (NonDocumentGenericResourceStorage)this.utils.getGenericResourceStorageMap().get(MATRIX_KEY);
        try {
            this.utils.getJobManager();
            JobManagement.getScheduler().getContext().put(VALIDATION_UTILS_KEY, (Object)this.utils);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    public ServiceUtils.Action getAction() {
        return ServiceUtils.Action.VALIDATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doAction(Map<String, List<InputPart>> formData, DocumentResource dr, Date date) throws IOException {
        try (ResourceIndex index = this.validationResourceIndex.getIndex();){
            ValidationResource vr = (ValidationResource)index.newResource(dr);
            index.put(dr.getVisibleId(), (DocumentResource)vr);
            Document doc = this.utils.getDocumentFromCacheOrStore(vr.getStorageId());
            this.utils.performValidation(doc, vr, (ResourceIndex<ValidationResource>)index, this.reportStorage, this.matrixStorage, this.nonDocumentResourceStorage);
            this.scheduleNewJob(vr.getVisibleId());
            logger.info("actionValidate: " + String.valueOf(date));
            Response response = this.utils.composeResponseSeeOther("documents/" + vr.getVisibleId() + "/validation/report").header("Expires", (Object)date).build();
            return response;
        }
    }

    public String toString() {
        return "<<performer:" + String.valueOf(this.getAction()) + ">>";
    }

    public Date scheduleNewJob(String visibleId) {
        try {
            JobManagement.getScheduler().deleteJob(new JobKey(visibleId, "graph"));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return this.utils.getJobManager().scheduleJob(JobDeleteValidationResource.class, visibleId, "-validation", "graph");
    }
}

