/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.narrative;

import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.scala.interop.Input;
import org.openprovenance.prov.scala.interop.Output;
import org.openprovenance.prov.scala.nlg.Config;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters;

public class ServiceConfig
implements Config {
    private final String template;
    private final String profile0;
    private final String language;
    private final String batch;
    private final int format_option;
    private String infiles;

    ServiceConfig(String template, String profile0, String language, int format_option) {
        if (template.startsWith("batch:")) {
            this.template = null;
            this.batch = template.substring("batch:".length());
        } else {
            this.template = template;
            this.batch = null;
        }
        this.profile0 = profile0;
        this.language = language;
        this.format_option = format_option;
    }

    public Output snlg() {
        return null;
    }

    public boolean languageAsFilep() {
        return false;
    }

    public Seq<String> selected_templates() {
        LinkedList<String> templates = new LinkedList<String>();
        if (templates != null) {
            templates.add(this.template);
        }
        return this.convertListToSeq(templates);
    }

    public String profile() {
        return this.profile0;
    }

    public Option<String> batch_templates() {
        if (this.batch == null) {
            return Option.empty();
        }
        return Option.apply((Object)this.batch);
    }

    public Seq<String> language() {
        LinkedList<String> languages = new LinkedList<String>();
        languages.add(this.language);
        return this.convertListToSeq(languages);
    }

    public boolean linear() {
        return false;
    }

    public Input infile() {
        throw new UnsupportedOperationException("ServiceConfig.infile() method is not implemented");
    }

    public int format_option() {
        return this.format_option;
    }

    public String infiles() {
        return this.infiles;
    }

    public String toString() {
        return "ServiceConfig{template='" + this.template + '\'' + ", profile0='" + this.profile0 + '\'' + ", language='" + this.language + '\'' + ", batch='" + this.batch + '\'' + ", format_option=" + this.format_option + '}';
    }

    public Seq<String> convertListToSeq(List<String> inputList) {
        return CollectionConverters.ListHasAsScala(inputList).asScala().toSeq();
    }
}

