/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.narrative;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.vanilla.Document;

@Provider
@Consumes(value={"text/provenance-notation", "application/json", "application/ld+json"})
public class VanillaDocumentMessageBodyReader
implements MessageBodyReader<Document> {
    private final InteropFramework intF;

    public VanillaDocumentMessageBodyReader(InteropFramework interopFramework) {
        this.intF = interopFramework;
    }

    public String trimCharSet(MediaType mediaType) {
        String med = mediaType.toString();
        int ind = med.indexOf(";");
        if (ind > 0) {
            med = med.substring(0, ind);
        }
        return med;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Formats.ProvFormat format = (Formats.ProvFormat)this.intF.mimeTypeRevMap.get(this.trimCharSet(mediaType));
        return format != null;
    }

    public Document readFrom(Class<Document> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream is) throws IOException, WebApplicationException {
        Formats.ProvFormat format = (Formats.ProvFormat)this.intF.mimeTypeRevMap.get(this.trimCharSet(mediaType));
        Document doc = (Document)this.intF.deserialiseDocument(is, format);
        return doc;
    }
}

