/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.narrative;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.narrative.NarrativeServiceUtils;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.ResourceIndex;

public class ActionExplain
implements ActionPerformer {
    static Logger logger = LogManager.getLogger(ActionExplain.class);
    private final NarrativeServiceUtils utils;

    public ActionExplain(NarrativeServiceUtils utils) {
        this.utils = utils;
    }

    public ServiceUtils.Action getAction() {
        return ServiceUtils.Action.EXPLANATION;
    }

    public Response doAction(Map<String, List<InputPart>> formData, DocumentResource dr, Date date) throws IOException {
        List<InputPart> templates = formData.get("xplain-template");
        String templates_str = null;
        List<InputPart> profiles = formData.get("xplain-profile");
        String profiles_str = null;
        if (templates != null) {
            templates_str = templates.get(0).getBodyAsString();
        }
        if (profiles != null) {
            profiles_str = profiles.get(0).getBodyAsString();
        }
        logger.debug("templates " + templates_str);
        logger.debug("profiles " + profiles_str);
        ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();
        String keyId = this.utils.createEntryForTemplateAndProfile((ResourceIndex<DocumentResource>)index, dr.getVisibleId(), dr, templates_str, profiles_str);
        index.put(dr.getVisibleId(), dr);
        return this.utils.composeResponseSeeOther("documents/" + dr.getVisibleId() + "/explanation/" + keyId).header("Expires", (Object)date).build();
    }

    public String toString() {
        return "<<performer:" + this.getAction() + ">>";
    }
}

