/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.xplain;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.ServiceUtilsConfig;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.ResourceIndex;

public class NarrativeServiceUtils
extends ServiceUtils {
    public static final String KEY_EXPLANATIONS = "explanations";
    public static final String KEY_MAP = "keymap";
    public static final String DETAILS = "details";
    public static final String KEY_TEMPLATES = "templates";
    public static final String KEY_PROFILES = "profiles";

    public NarrativeServiceUtils(PostService ps, ServiceUtilsConfig config) {
        super(ps, config);
    }

    Map<String, Object> getExtension(ResourceIndex<DocumentResource> index, String id, DocumentResource dr) {
        Object result = dr.getExtension().get(KEY_EXPLANATIONS);
        if (result == null) {
            result = new HashMap();
            dr.getExtension().put(KEY_EXPLANATIONS, result);
            dr.setExtension(dr.getExtension());
            index.put(id, dr);
        }
        return (Map)result;
    }

    Map<String, Integer> getKeymap(ResourceIndex<DocumentResource> index, String id, DocumentResource dr) {
        Map<String, Object> extension = this.getExtension(index, id, dr);
        HashMap result = extension.get(KEY_MAP);
        if (result == null) {
            result = new HashMap();
            extension.put(KEY_MAP, result);
            dr.setExtension(dr.getExtension());
            index.put(id, dr);
        }
        return result;
    }

    Map<String, Map<String, String>> getDetails(ResourceIndex<DocumentResource> index, String id, DocumentResource dr) {
        Map<String, Object> extension = this.getExtension(index, id, dr);
        HashMap result = extension.get(DETAILS);
        if (result == null) {
            result = new HashMap();
            extension.put(DETAILS, result);
            dr.setExtension(dr.getExtension());
            index.put(id, dr);
        }
        return result;
    }

    public String createEntryForTemplateAndProfile(ResourceIndex<DocumentResource> index, String id, DocumentResource dr, String templates_str, String profiles_str) {
        String key = "" + templates_str + "|" + profiles_str;
        String keyId = null;
        Map<String, Integer> map = this.getKeymap(index, id, dr);
        if (map.containsKey(key)) {
            keyId = map.get(key).toString();
        } else {
            int size = map.size();
            map.put(key, size);
            keyId = "" + size;
        }
        Map<String, Map<String, String>> details = this.getDetails(index, id, dr);
        HashMap<String, String> entry = new HashMap<String, String>();
        entry.put(KEY_TEMPLATES, templates_str);
        entry.put(KEY_PROFILES, profiles_str);
        details.put(keyId, entry);
        dr.setExtension(dr.getExtension());
        return keyId;
    }

    public Response.ResponseBuilder composeResponseCreated(Object o, String path, UriInfo uriInfo) {
        UriBuilder builder = uriInfo.getAbsolutePathBuilder();
        builder.path(path);
        return Response.created((URI)builder.build(new Object[0])).entity(o).header("Access-Control-Allow-Origin", (Object)"*");
    }
}

