/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.xplain;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.openprovenance.prov.interop.InteropMediaType;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.Constants;
import org.openprovenance.prov.service.core.OtherActionPerformer;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.SwaggerTags;
import org.openprovenance.prov.service.xplain.NarrativeLogic;
import org.openprovenance.prov.service.xplain.TemplateAndProfile;

@Path(value="")
@Tag(name="narrative")
public class NarrativeService
implements Constants,
InteropMediaType,
SwaggerTags {
    public final NarrativeLogic narrativeLogic;

    public NarrativeService(PostService postService) {
        this(postService, new LinkedList<ActionPerformer>(), Optional.empty());
    }

    public NarrativeService(PostService postService, List<ActionPerformer> performers, Optional<OtherActionPerformer> otherPerformer) {
        this.narrativeLogic = new NarrativeLogic(postService, performers, otherPerformer);
    }

    @GET
    @Path(value="/documents/{docId}/random_narrative")
    @Tag(name="narrative")
    @Operation(summary="Random Narrative of Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response random_nar(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, @Parameter(name="Accept", description="Accept header parameter", example="text/plain,text/xml", required=false) @HeaderParam(value="Accept") String accept) {
        return this.narrativeLogic.random_nar(response, request, msg, accept);
    }

    @GET
    @Path(value="/documents/{docId}/explanation/{expid}")
    @Tag(name="narrative")
    @Produces(value={"application/json"})
    @Operation(summary="Explanation from Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response explanations(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String docId, @PathParam(value="expid") String explanationId, @Parameter(name="Accept", description="Accept header parameter", example="text/plain,text/xml", required=false) @HeaderParam(value="Accept") String accept) {
        return this.narrativeLogic.explanations(response, request, docId, explanationId, accept);
    }

    @GET
    @Path(value="/documents/{docId}/explanationdetails/{expid}")
    @Tag(name="narrative")
    @Produces(value={"application/json"})
    @Operation(summary="Explanation from Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response explanationDetails(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, @PathParam(value="expid") String explanationId, @Parameter(name="Accept", description="Accept header parameter", example="text/plain,text/xml", required=false) @HeaderParam(value="Accept") String accept) {
        return this.narrativeLogic.explanationDetails(response, request, msg, explanationId, accept);
    }

    @GET
    @Path(value="/documents/{docId}/animation.svg")
    @Tag(name="narrative")
    @Produces(value={"image/svg+xml"})
    @Operation(summary="SVG for animation from Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response svg4anim(@Context HttpServletResponse ignoredResponse, @Context Request ignoredRequest, @PathParam(value="docId") String msg, @Parameter(name="Accept", description="Accept header parameter", example="text/plain,text/xml", required=false) @HeaderParam(value="Accept") String ignoredAccept) throws IOException {
        return this.narrativeLogic.svg4anim(ignoredResponse, ignoredRequest, msg, ignoredAccept);
    }

    @GET
    @Path(value="/documents/{docId}/explanationdetails/{expid}/config")
    @Tag(name="narrative")
    @Produces(value={"application/json"})
    @Operation(summary="Configuration of Explanation for Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response explanationDetailsConfig(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, @PathParam(value="expid") String explanationId) {
        return this.narrativeLogic.explanationDetailsConfig(response, request, msg, explanationId);
    }

    @GET
    @Path(value="/documents/{docId}/explanation/{expid}/config")
    @Tag(name="narrative")
    @Produces(value={"application/json"})
    @Operation(summary="Configuration of Explanation for Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response explanationConfig(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, @PathParam(value="expid") String explanationId) {
        return this.narrativeLogic.explanationConfig(response, request, msg, explanationId);
    }

    @POST
    @Path(value="/documents/{docId}/explanation/")
    @Tag(name="narrative")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Create explanation from existing Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response explanationsForDoc(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, TemplateAndProfile tap, @Context UriInfo uriInfo, @Parameter(name="Accept", description="Accept header parameter", example="text/plain,text/xml", required=false) @HeaderParam(value="Accept") String accept) {
        return this.narrativeLogic.explanationsForDoc(response, request, msg, tap, uriInfo, accept);
    }

    @POST
    @Path(value="/documents/{docId}/explanationdetails/")
    @Tag(name="narrative")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Create explanation, and returns all details for existing Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response explanationsDetailsForDoc(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, TemplateAndProfile tap, @Context UriInfo uriInfo, @Parameter(name="Accept", description="Accept header parameter", example="text/plain,text/xml", required=false) @HeaderParam(value="Accept") String accept) {
        return this.narrativeLogic.explanationsDetailsForDoc(response, request, msg, tap, uriInfo, accept);
    }

    @GET
    @Path(value="/documents/{docId}/linear_narrative")
    @Tag(name="narrative")
    @Produces(value={"application/json", "text/plain"})
    @Operation(summary="Linear Narrative of Document", description="", responses={@ApiResponse(responseCode="404", description="Document not found")})
    public Response linear_narrative(@Context HttpServletResponse response, @Context Request request, @PathParam(value="docId") String msg, @Parameter(name="Accept", description="Accept header parameter", example="text/plain,text/xml", required=false) @HeaderParam(value="Accept") String accept) {
        return this.narrativeLogic.linear_narrative(response, request, msg, accept);
    }
}

