/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.xplain;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.core.Variant;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.BeanTraversal;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.scala.iface.Explainer;
import org.openprovenance.prov.scala.iface.Narrator;
import org.openprovenance.prov.scala.iface.XFactory;
import org.openprovenance.prov.scala.immutable.ProvFactory;
import org.openprovenance.prov.scala.narrator.NarratorFunctionality;
import org.openprovenance.prov.scala.narrator.XConfig;
import org.openprovenance.prov.scala.summary.TypePropagator;
import org.openprovenance.prov.scala.wrapper.IO;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.EmptyOtherActionPerformer;
import org.openprovenance.prov.service.core.OtherActionPerformer;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.memory.LRUHashMap;
import org.openprovenance.prov.service.summary.actions.ActionUpload;
import org.openprovenance.prov.service.xplain.NarrativeServiceUtils;
import org.openprovenance.prov.service.xplain.ServiceConfig;
import org.openprovenance.prov.service.xplain.TemplateAndProfile;
import org.openprovenance.prov.service.xplain.actions.ActionExplain;
import org.openprovenance.prov.service.xplain.actions.ActionLinear;
import org.openprovenance.prov.service.xplain.actions.ActionRandom;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.ResourceIndex;

public class NarrativeLogic {
    public static final String PLEAD_CS_TEMPLATE_LIBRARY_JSON = "/nlg/templates/plead.cs/plead-template-library.json";
    final NarrativeServiceUtils utils;
    final LRUHashMap<String, org.openprovenance.prov.scala.immutable.Document> scalaDocumentCache;
    int format_option = 1;
    public String the_template_library = "/nlg/templates/plead.cs/plead-template-library.json";
    static final Logger logger = LogManager.getLogger(NarrativeLogic.class);
    ProvFactory pFactoryS = ProvFactory.pf();
    final List<Variant> narrativeVariants;
    ObjectMapper mapper = TypePropagator.om();
    final XFactory factory = new XFactory();
    final Explainer explainer = this.factory.makeExplainer();
    final Narrator narrator = this.factory.makeNarrator();

    public NarrativeLogic(PostService postService, List<ActionPerformer> performers, Optional<OtherActionPerformer> otherPerformer) {
        this.utils = new NarrativeServiceUtils(postService, postService.getServiceUtils().getConfig());
        postService.addToPerformers(PostService.addToList((Object)new ActionRandom(this.utils), (List)PostService.addToList((Object)new ActionLinear(this.utils), (List)PostService.addToList((Object)new ActionExplain(this.utils), (List)PostService.addToList((Object)new ActionUpload((ServiceUtils)this.utils), performers)))));
        postService.addOtherPerformer(Optional.of(otherPerformer.orElse((OtherActionPerformer)new EmptyOtherActionPerformer())));
        this.scalaDocumentCache = new LRUHashMap(postService.getServiceUtils().getConfig().documentCacheSize);
        this.narrativeVariants = Arrays.asList(new Variant(MediaType.APPLICATION_JSON_TYPE, (Locale)null, null), new Variant(MediaType.TEXT_PLAIN_TYPE, (Locale)null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response random_nar(HttpServletResponse response, Request request, String msg, String ignoredAccept) {
        try (ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();){
            DocumentResource vr = index.get(msg);
            if (vr == null) {
                Response response2 = this.utils.composeResponseNotFoundResource(msg);
                return response2;
            }
            Variant v = request.selectVariant(this.narrativeVariants);
            MediaType mediaType = v.getMediaType();
            Object textDocument = this.getRandomNarrative(vr, mediaType);
            Response response3 = ServiceUtils.composeResponseOK((Object)textDocument).type(mediaType).build();
            return response3;
        }
    }

    public Response explanations(HttpServletResponse ignoredResponse, Request ignoredRequest, String docId, String explanationId, String ignoredAccept) {
        return this.getExplanationForDocument(docId, explanationId, true);
    }

    public Response explanationDetails(HttpServletResponse ignoredResponse, Request ignoredRequest, String docId, String explanationId, String ignoredAccept) {
        return this.getExplanationForDocument(docId, explanationId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getExplanationForDocument(String docId, String explanationId, boolean partial) {
        try (ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();){
            DocumentResource dr = index.get(docId);
            if (dr == null) {
                Response response = this.utils.composeResponseNotFoundResource(docId);
                return response;
            }
            Map<String, Map<String, String>> details = this.utils.getDetails((ResourceIndex<DocumentResource>)index, docId, dr);
            Map<String, String> entry = details.get(explanationId);
            String templates = entry.get("templates");
            String profiles = entry.get("profiles");
            try {
                StreamingOutput promise;
                scala.collection.immutable.Map result;
                Document doc = this.utils.getDocumentFromCacheOrStore(dr.getStorageId());
                ServiceConfig config = new ServiceConfig(templates, profiles, this.the_template_library, this.format_option);
                org.openprovenance.prov.scala.immutable.Document doc1 = this.getScalaDocument(docId, doc);
                if (partial) {
                    result = this.narrator.getTextOnly(this.explainer.explain(doc1, (XConfig)config));
                    promise = out -> IO.mapper().writeValue(out, (Object)result);
                } else {
                    result = this.explainer.explain(doc1, (XConfig)config);
                    promise = out -> IO.mapper().writeValue(out, (Object)result);
                }
                Response response = ServiceUtils.composeResponseOK((Object)promise).type("application/json").build();
                return response;
            }
            catch (Throwable e) {
                logger.throwing(e);
                String result = "Failed to create an explanation";
                Response response = this.utils.composeResponseBadRequest(result, e);
                index.close();
                return response;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openprovenance.prov.scala.immutable.Document getScalaDocument(String id, Document doc) {
        org.openprovenance.prov.scala.immutable.Document cached;
        NarrativeLogic narrativeLogic = this;
        synchronized (narrativeLogic) {
            cached = (org.openprovenance.prov.scala.immutable.Document)this.scalaDocumentCache.get((Object)id);
        }
        if (cached == null) {
            org.openprovenance.prov.scala.immutable.Document doc2 = (org.openprovenance.prov.scala.immutable.Document)new BeanTraversal((ModelConstructor)this.pFactoryS, (org.openprovenance.prov.model.ProvFactory)this.pFactoryS).doAction(doc);
            NarrativeLogic narrativeLogic2 = this;
            synchronized (narrativeLogic2) {
                this.scalaDocumentCache.put((Object)id, (Object)doc2);
            }
            cached = doc2;
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response svg4anim(HttpServletResponse ignoredResponse, Request ignoredRequest, String msg, String ignoredAccept) throws IOException {
        try (ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();){
            DocumentResource vr = index.get(msg);
            if (vr == null) {
                Response response = this.utils.composeResponseNotFoundResource(msg);
                return response;
            }
            Document doc = this.utils.getDocumentFromCacheOrStore(vr.getStorageId());
            org.openprovenance.prov.scala.immutable.Document sdoc = this.getScalaDocument(msg, doc);
            Response response = ServiceUtils.composeResponseOK((Object)sdoc).type("image/svg+xml").build();
            return response;
        }
    }

    public Response explanationDetailsConfig(HttpServletResponse response, Request request, String msg, String explanationId) {
        return this.explanationConfig(response, request, msg, explanationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response explanationConfig(HttpServletResponse response, Request ignoredRequest, String msg, String explanationId) {
        try (ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();){
            DocumentResource dr = index.get(msg);
            if (dr == null) {
                Response response2 = this.utils.composeResponseNotFoundResource(msg);
                return response2;
            }
            Map<String, Map<String, String>> details = this.utils.getDetails((ResourceIndex<DocumentResource>)index, msg, dr);
            Map<String, String> entry = details.get(explanationId);
            String templates = entry.get("templates");
            String profiles = entry.get("profiles");
            TemplateAndProfile tap = new TemplateAndProfile();
            tap.profile = profiles;
            tap.template = templates;
            Response response3 = ServiceUtils.composeResponseOK((Object)tap).type("application/json").build();
            return response3;
        }
    }

    public Response explanationsForDoc(HttpServletResponse response, Request request, String msg, TemplateAndProfile tap, UriInfo uriInfo, String accept) {
        return this.explanationsForDoc1(response, request, msg, tap.template, tap.profile, true, uriInfo, accept);
    }

    public Response explanationsDetailsForDoc(HttpServletResponse response, Request request, String msg, TemplateAndProfile tap, UriInfo uriInfo, String accept) {
        return this.explanationsForDoc1(response, request, msg, tap.template, tap.profile, false, uriInfo, accept);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response explanationsForDoc1(HttpServletResponse ignoredResponse, Request ignoredRequest, String msg, String template, String profile, boolean partial, UriInfo uriInfo, String ignoredAccept) {
        try (ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();){
            DocumentResource dr = index.get(msg);
            if (dr == null) {
                Response response = this.utils.composeResponseNotFoundResource(msg);
                return response;
            }
            Map<String, Map<String, String>> details = this.utils.getDetails((ResourceIndex<DocumentResource>)index, msg, dr);
            String explanationId = this.utils.createEntryForTemplateAndProfile((ResourceIndex<DocumentResource>)index, msg, dr, template, profile);
            Map<String, String> entry = details.get(explanationId);
            String templates = entry.get("templates");
            String profiles = entry.get("profiles");
            index.put(msg, dr);
            logger.debug("found templates: " + templates);
            logger.debug("found profiles: " + profiles);
            logger.debug("explanation id: " + explanationId);
            try {
                String s;
                scala.collection.immutable.Map result;
                Document doc = this.utils.getDocumentFromCacheOrStore(dr.getStorageId());
                ServiceConfig config = new ServiceConfig(templates, profiles, this.the_template_library, this.format_option);
                org.openprovenance.prov.scala.immutable.Document doc1 = this.getScalaDocument(msg, doc);
                if (partial) {
                    result = this.narrator.getTextOnly(this.explainer.explain(doc1, (XConfig)config));
                    s = IO.mapper().writeValueAsString((Object)result);
                } else {
                    result = this.explainer.explain(doc1, (XConfig)config);
                    s = IO.mapper().writeValueAsString((Object)result);
                }
                Response response = this.utils.composeResponseCreated(s, explanationId, uriInfo).type("application/json").build();
                return response;
            }
            catch (Throwable e) {
                logger.throwing(e);
                String result = "Failed to create an explanation";
                Response response = this.utils.composeResponseBadRequest(result, e);
                index.close();
                return response;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response linear_narrative(HttpServletResponse ignoredResponse, Request request, String msg, String ignoredAccept) {
        try (ResourceIndex index = this.utils.getDocumentResourceIndex().getIndex();){
            DocumentResource dr = index.get(msg);
            if (dr == null) {
                Response response = this.utils.composeResponseNotFoundResource(msg);
                return response;
            }
            Variant v = request.selectVariant(this.narrativeVariants);
            MediaType mediaType = v.getMediaType();
            Object textDocument = this.getLinearNarrative(dr, mediaType);
            System.out.println("debug --> " + textDocument.toString());
            Response response = ServiceUtils.composeResponseOK((Object)textDocument).type(mediaType).build();
            return response;
        }
    }

    public Object getLinearNarrative(DocumentResource vr, MediaType variant) throws IOException {
        return this.getNarrative(vr, NarratorFunctionality.linearConfig(), variant);
    }

    public Object getRandomNarrative(DocumentResource vr, MediaType variant) throws IOException {
        return this.getNarrative(vr, NarratorFunctionality.randomConfig(), variant);
    }

    public Object getNarrative(DocumentResource vr, XConfig config, MediaType variant) throws IOException {
        Document doc = this.utils.getDocumentFromCacheOrStore(vr.getStorageId());
        org.openprovenance.prov.scala.immutable.Document d2 = ProvFactory.pf().newDocument(doc);
        logger.info("variant: " + String.valueOf(variant));
        if (MediaType.TEXT_PLAIN_TYPE.equals((Object)variant)) {
            scala.collection.immutable.Map result = this.narrator.narrate2string(d2, config);
            return result.mkString("", "\n", "");
        }
        scala.collection.immutable.Map result = this.narrator.narrate2(d2, config);
        return out -> this.mapper.writeValue(out, (Object)result);
    }
}

