/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.xplain;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.Variant;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nlg.wrapper.Block;
import nlg.wrapper.Root;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.interop.InteropMediaType;
import org.openprovenance.prov.scala.immutable.ProvFactory;
import org.openprovenance.prov.scala.nlgspec_transformer.SpecLoader;
import org.openprovenance.prov.scala.nlgspec_transformer.defs;
import org.openprovenance.prov.scala.nlgspec_transformer.specTypes;
import org.openprovenance.prov.scala.wrapper.BlocklySerializer;
import org.openprovenance.prov.scala.wrapper.defs;
import org.openprovenance.prov.scala.xplain.RealiserFactory;
import org.openprovenance.prov.service.core.Constants;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.SwaggerTags;
import org.openprovenance.prov.service.xplain.PhraseEnvironment;
import scala.Option;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import simplenlg.framework.NLGElement;
import simplenlg.lexicon.XMLLexicon;
import simplenlg.realiser.english.Realiser;

@Path(value="")
@Tag(name="nlg")
public class NlgService
implements Constants,
InteropMediaType,
SwaggerTags {
    static final Logger logger = LogManager.getLogger(NlgService.class);
    private final ServiceUtils utils;
    private final String client_id;
    private final String client_secret;
    private final Map<String, String> config;
    public Map<String, String> defaultConfiguration = this.theDefaultConfiguration();
    static final String PHRASE_EXAMPLE = "{\n  \"type\" : \"clause\",\n  \"subject\" : {\n    \"type\" : \"noun_phrase\",\n    \"head\" : \"Luc\",\n    \"modifiers\" : [ ],\n    \"pre-modifiers\" : [ ],\n    \"post-modifiers\" : [ ],\n    \"specifier\" : null,\n    \"complements\" : [ ],\n    \"features\" : { }\n  },\n  \"verb\" : {\n    \"type\" : \"verb_phrase\",\n    \"head\" : \"eats\",\n    \"modifiers\" : [ ],\n    \"pre-modifiers\" : [ ],\n    \"post-modifiers\" : [ ],\n    \"features\" : { }\n  },\n  \"object\" : {\n    \"type\" : \"coordinated_phrase\",\n    \"coordinates\" : [ {\n      \"type\" : \"noun_phrase\",\n      \"head\" : \"cabbage\",\n      \"modifiers\" : [ ],\n      \"pre-modifiers\" : [ ],\n      \"post-modifiers\" : [ ],\n      \"specifier\" : null,\n      \"complements\" : [ ],\n      \"features\" : { }\n    }, {\n      \"type\" : \"noun_phrase\",\n      \"head\" : \"lettuce\",\n      \"modifiers\" : [ ],\n      \"pre-modifiers\" : [ ],\n      \"post-modifiers\" : [ ],\n      \"specifier\" : null,\n      \"complements\" : [ ],\n      \"features\" : { }\n    } ],\n    \"conjunction\" : \"and\",\n    \"features\" : {\n      \"markup_element\" : \"ol\"\n    }\n  },\n  \"indirect_object\" : null,\n  \"complements\" : [ ],\n  \"modifiers\" : [ ],\n  \"features\" : {\n    \"markup_element\" : \"span\",\n    \"markup_attributes\" : \"class=\\\"explanation\\\"\"\n  }\n}";
    static final Realiser realiserWithMarkups = defs.withMarkupFormatter();
    static final Realiser realiserDefault = defs.theRealiser();
    static XMLLexicon lexicon = new XMLLexicon();
    final ObjectMapper objectMapper = new ObjectMapper();

    public Map<String, String> theDefaultConfiguration() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("GITHUB_CLIENT_SECRET", "**secret_needed_to_be_provided**");
        config.put("GITHUB_CLIENT_ID", "Iv1.c3c8c66c0772c07b");
        return config;
    }

    public NlgService(PostService ps) {
        this.utils = new ServiceUtils(ps, ps.getServiceUtils().getConfig());
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(this.defaultConfiguration);
        config.putAll(ServiceUtils.loadConfigFromSystem(this.defaultConfiguration));
        config.putAll(ServiceUtils.loadConfigFromEnvironment(this.defaultConfiguration));
        logger.info("Configuration: " + String.valueOf(config));
        System.out.println("Configuration: " + String.valueOf(config));
        System.out.println("Configuration: GITHUB_CLIENT_SECRET");
        this.config = config;
        this.client_id = (String)config.get("GITHUB_CLIENT_ID");
        this.client_secret = (String)config.get("GITHUB_CLIENT_SECRET");
    }

    @POST
    @Path(value="/nlg/realiser/")
    @Tag(name="nlg")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    @Operation(summary="Posts a sentence description. Payload is 'Phrase' in json format. ", description="Construct english sentence from sentence description", requestBody=@RequestBody(content={@Content(mediaType="application/json", examples={@ExampleObject(name="cabbage", summary="a simple example", value="{\n  \"type\" : \"clause\",\n  \"subject\" : {\n    \"type\" : \"noun_phrase\",\n    \"head\" : \"Luc\",\n    \"modifiers\" : [ ],\n    \"pre-modifiers\" : [ ],\n    \"post-modifiers\" : [ ],\n    \"specifier\" : null,\n    \"complements\" : [ ],\n    \"features\" : { }\n  },\n  \"verb\" : {\n    \"type\" : \"verb_phrase\",\n    \"head\" : \"eats\",\n    \"modifiers\" : [ ],\n    \"pre-modifiers\" : [ ],\n    \"post-modifiers\" : [ ],\n    \"features\" : { }\n  },\n  \"object\" : {\n    \"type\" : \"coordinated_phrase\",\n    \"coordinates\" : [ {\n      \"type\" : \"noun_phrase\",\n      \"head\" : \"cabbage\",\n      \"modifiers\" : [ ],\n      \"pre-modifiers\" : [ ],\n      \"post-modifiers\" : [ ],\n      \"specifier\" : null,\n      \"complements\" : [ ],\n      \"features\" : { }\n    }, {\n      \"type\" : \"noun_phrase\",\n      \"head\" : \"lettuce\",\n      \"modifiers\" : [ ],\n      \"pre-modifiers\" : [ ],\n      \"post-modifiers\" : [ ],\n      \"specifier\" : null,\n      \"complements\" : [ ],\n      \"features\" : { }\n    } ],\n    \"conjunction\" : \"and\",\n    \"features\" : {\n      \"markup_element\" : \"ol\"\n    }\n  },\n  \"indirect_object\" : null,\n  \"complements\" : [ ],\n  \"modifiers\" : [ ],\n  \"features\" : {\n    \"markup_element\" : \"span\",\n    \"markup_attributes\" : \"class=\\\"explanation\\\"\"\n  }\n}")})}), responses={@ApiResponse(responseCode="200", content={@Content(mediaType="text/html"), @Content(mediaType="text/plain"), @Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Document not found")})
    public Response nlgRealiser(@Context HttpServletResponse ignoredResponse, @Context Request ignoredRequest, @Parameter(name="phrase", description="description of sentence to be constructed", required=true) defs.Phrase phrase, @HeaderParam(value="Accept") String accept) {
        System.out.println(phrase);
        NLGElement spec = (NLGElement)phrase.expand();
        System.out.println(spec.printTree("  "));
        switch (accept) {
            case "application/json": {
                logger.debug("producing json");
                String result = defs.realise((NLGElement)spec, (Realiser)realiserWithMarkups);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("result", result);
                return ServiceUtils.composeResponseOK(map).type(accept).build();
            }
            case "text/html": {
                logger.debug("producing html");
                String result = defs.realise((NLGElement)spec, (Realiser)realiserWithMarkups);
                return ServiceUtils.composeResponseOK((Object)result).type(accept).build();
            }
            case "text/plain": {
                logger.debug("producing plain text");
                String result = realiserDefault.realiseSentence(spec);
                return ServiceUtils.composeResponseOK((Object)result).type(accept).build();
            }
        }
        throw new UnsupportedOperationException("media type not supported: " + accept);
    }

    @POST
    @Path(value="/nlg/expander/")
    @Tag(name="nlg")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    @Operation(summary="Posts a sentence description. Payload is 'Phrase' in json format. ", description="Construct english sentence from sentence description", requestBody=@RequestBody(content={@Content(mediaType="application/json", examples={@ExampleObject(name="cabbage", summary="a simple example", value="{\n  \"type\" : \"clause\",\n  \"subject\" : {\n    \"type\" : \"noun_phrase\",\n    \"head\" : \"Luc\",\n    \"modifiers\" : [ ],\n    \"pre-modifiers\" : [ ],\n    \"post-modifiers\" : [ ],\n    \"specifier\" : null,\n    \"complements\" : [ ],\n    \"features\" : { }\n  },\n  \"verb\" : {\n    \"type\" : \"verb_phrase\",\n    \"head\" : \"eats\",\n    \"modifiers\" : [ ],\n    \"pre-modifiers\" : [ ],\n    \"post-modifiers\" : [ ],\n    \"features\" : { }\n  },\n  \"object\" : {\n    \"type\" : \"coordinated_phrase\",\n    \"coordinates\" : [ {\n      \"type\" : \"noun_phrase\",\n      \"head\" : \"cabbage\",\n      \"modifiers\" : [ ],\n      \"pre-modifiers\" : [ ],\n      \"post-modifiers\" : [ ],\n      \"specifier\" : null,\n      \"complements\" : [ ],\n      \"features\" : { }\n    }, {\n      \"type\" : \"noun_phrase\",\n      \"head\" : \"lettuce\",\n      \"modifiers\" : [ ],\n      \"pre-modifiers\" : [ ],\n      \"post-modifiers\" : [ ],\n      \"specifier\" : null,\n      \"complements\" : [ ],\n      \"features\" : { }\n    } ],\n    \"conjunction\" : \"and\",\n    \"features\" : {\n      \"markup_element\" : \"ol\"\n    }\n  },\n  \"indirect_object\" : null,\n  \"complements\" : [ ],\n  \"modifiers\" : [ ],\n  \"features\" : {\n    \"markup_element\" : \"span\",\n    \"markup_attributes\" : \"class=\\\"explanation\\\"\"\n  }\n}")})}), responses={@ApiResponse(responseCode="200", content={@Content(mediaType="text/html"), @Content(mediaType="text/plain"), @Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Document not found")})
    public Response nlgExpander(@Context HttpServletResponse ignoredResponse, @Context Request ignoredRequest, @Parameter(name="phrase", description="description of sentence to be expanded", required=true) PhraseEnvironment phraseEnvironment, @HeaderParam(value="Accept") String accept, @HeaderParam(value="prov_xpand_only") String expandOnlyParam) {
        specTypes.Phrase phrase = phraseEnvironment.getPhrase();
        specTypes.TransformEnvironment te = specTypes.convertToTransformEnvironment((org.openprovenance.prov.vanilla.Document)phraseEnvironment.getDocument(), (defs.Dictionary)phraseEnvironment.getDictionary(), phraseEnvironment.getContext(), phraseEnvironment.getProfiles(), (String)phraseEnvironment.getTheProfile());
        System.out.println(phrase);
        boolean expandOnly = "true".equals(expandOnlyParam) || "TRUE".equals(expandOnlyParam);
        ClassTag tag = ClassTag$.MODULE$.apply(te.getClass());
        Option transformedPhrase = phrase.transform(te, tag);
        if (!transformedPhrase.isDefined()) {
            return ServiceUtils.composeResponseOK((Object)"empty").type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        specTypes.Phrase phrase2 = (specTypes.Phrase)transformedPhrase.get();
        if (expandOnly) {
            System.out.println(phrase2);
            StreamingOutput promise = out -> SpecLoader.phraseExport((OutputStream)out, (specTypes.Phrase)phrase2);
            return ServiceUtils.composeResponseOK((Object)promise).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        NLGElement spec = (NLGElement)phrase2.expand();
        System.out.println(spec.printTree("  "));
        switch (accept) {
            case "application/json": {
                logger.debug("producing json");
                String result = defs.realise((NLGElement)spec, (Realiser)realiserWithMarkups);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("result", result);
                return ServiceUtils.composeResponseOK(map).type(accept).build();
            }
            case "text/html": {
                logger.debug("producing html");
                String result = defs.realise((NLGElement)spec, (Realiser)realiserWithMarkups);
                return ServiceUtils.composeResponseOK((Object)result).type(accept).build();
            }
            case "text/plain": {
                logger.debug("producing plain text");
                String result = realiserDefault.realiseSentence(spec);
                return ServiceUtils.composeResponseOK((Object)result).type(accept).build();
            }
        }
        throw new UnsupportedOperationException("media type not supported: " + accept);
    }

    @POST
    @Path(value="/nlg/expander2/")
    @Tag(name="nlg")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    @Operation(summary="Posts a sentence description. Payload is 'Phrase' in json format. ", description="Construct english sentence from sentence description", requestBody=@RequestBody(content={@Content(mediaType="application/json", examples={@ExampleObject(name="cabbage", summary="a simple example", value="{\n  \"type\" : \"clause\",\n  \"subject\" : {\n    \"type\" : \"noun_phrase\",\n    \"head\" : \"Luc\",\n    \"modifiers\" : [ ],\n    \"pre-modifiers\" : [ ],\n    \"post-modifiers\" : [ ],\n    \"specifier\" : null,\n    \"complements\" : [ ],\n    \"features\" : { }\n  },\n  \"verb\" : {\n    \"type\" : \"verb_phrase\",\n    \"head\" : \"eats\",\n    \"modifiers\" : [ ],\n    \"pre-modifiers\" : [ ],\n    \"post-modifiers\" : [ ],\n    \"features\" : { }\n  },\n  \"object\" : {\n    \"type\" : \"coordinated_phrase\",\n    \"coordinates\" : [ {\n      \"type\" : \"noun_phrase\",\n      \"head\" : \"cabbage\",\n      \"modifiers\" : [ ],\n      \"pre-modifiers\" : [ ],\n      \"post-modifiers\" : [ ],\n      \"specifier\" : null,\n      \"complements\" : [ ],\n      \"features\" : { }\n    }, {\n      \"type\" : \"noun_phrase\",\n      \"head\" : \"lettuce\",\n      \"modifiers\" : [ ],\n      \"pre-modifiers\" : [ ],\n      \"post-modifiers\" : [ ],\n      \"specifier\" : null,\n      \"complements\" : [ ],\n      \"features\" : { }\n    } ],\n    \"conjunction\" : \"and\",\n    \"features\" : {\n      \"markup_element\" : \"ol\"\n    }\n  },\n  \"indirect_object\" : null,\n  \"complements\" : [ ],\n  \"modifiers\" : [ ],\n  \"features\" : {\n    \"markup_element\" : \"span\",\n    \"markup_attributes\" : \"class=\\\"explanation\\\"\"\n  }\n}")})}), responses={@ApiResponse(responseCode="200", content={@Content(mediaType="text/html"), @Content(mediaType="text/plain"), @Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Document not found")})
    public Response nlgExpanderWithQuery(@Context HttpServletResponse ignoredResponse, @Context Request ignoredRequest, @Parameter(name="phrase", description="description of sentence to be expanded", required=true) PhraseEnvironment phraseEnvironment, @HeaderParam(value="Accept") String accept, @HeaderParam(value="prov_xpand_only") String ignoredExpandOnlyParam) {
        specTypes.Phrase the_request_phrase = phraseEnvironment.getPhrase();
        scala.collection.immutable.Map<String, String> the_request_context = phraseEnvironment.getContext();
        org.openprovenance.prov.vanilla.Document the_request_document = phraseEnvironment.getDocument();
        String the_request_query = phraseEnvironment.getQuery();
        scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, String>> the_request_select = phraseEnvironment.getSelect();
        scala.collection.immutable.Map<String, Object> the_request_profiles = phraseEnvironment.getProfiles();
        defs.Dictionary the_request_dictionary = phraseEnvironment.getDictionary();
        String the_request_the_profile = phraseEnvironment.getTheProfile();
        int the_request_format = phraseEnvironment.getFormat();
        defs.Plan planFromRequest = new defs.Plan("internalQuery", the_request_select, (Object)the_request_query, the_request_phrase, the_request_context, null);
        RealiserFactory factory = new RealiserFactory(planFromRequest, the_request_dictionary, the_request_profiles);
        ProvFactory pf = new ProvFactory();
        org.openprovenance.prov.scala.immutable.Document document = pf.newDocument((Document)the_request_document);
        RealiserFactory.Realiser realiser = factory.make(document);
        Seq realisations = realiser.realisePlan(planFromRequest, the_request_the_profile, the_request_format);
        Option head = realisations.headOption();
        if (head.nonEmpty()) {
            String theString = (String)((Tuple3)((Tuple3)head.get())._1())._1();
            switch (accept) {
                case "application/json": {
                    logger.debug("producing json");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("result", theString);
                    return ServiceUtils.composeResponseOK(map).type(accept).build();
                }
                case "text/html": {
                    logger.debug("producing html");
                    return ServiceUtils.composeResponseOK((Object)theString).type(accept).build();
                }
                case "text/plain": {
                    logger.debug("producing plain text");
                    return ServiceUtils.composeResponseOK((Object)theString).type(accept).build();
                }
            }
            throw new UnsupportedOperationException("media type not supported: " + accept);
        }
        return ServiceUtils.composeResponseOK((Object)"empty").type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Map<?, ?> doPost(String url, String requestBody) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(url);
        StringEntity responseBody = new StringEntity(requestBody);
        request.addHeader("content-type", "application/json");
        request.addHeader("accept", "application/json");
        request.setEntity((HttpEntity)responseBody);
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        return (Map)this.objectMapper.readValue(response.getEntity().getContent(), Map.class);
    }

    @GET
    @Path(value="/authenticate")
    @Tag(name="nlg")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response authenticate(@Context HttpServletResponse ignoredResponse, @Context HttpServletRequest ignoredRequest, @QueryParam(value="code") String code) throws IOException {
        logger.debug("Authenticate: received code " + code);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("client_id", this.client_id);
        m.put("client_secret", this.client_secret);
        m.put("code", code);
        String requestBody = this.objectMapper.writeValueAsString(m);
        logger.debug("Getting access token: " + requestBody);
        System.out.println("Getting access token: " + requestBody);
        Map<?, ?> result = this.doPost("https://github.com/login/oauth/access_token", requestBody);
        logger.debug("Obtained " + String.valueOf(result));
        String access_token = (String)result.get("access_token");
        logger.debug("Obtained access_token " + access_token);
        logger.debug("Authenticate: now redirecting ");
        return this.utils.composeResponseSeeOther("../../xplain/view/editor?github_access_token=" + access_token).build();
    }

    @POST
    @Path(value="/xplan")
    @Tag(name="nlg")
    @Consumes(value={"application/json"})
    @Produces(value={"text/xml"})
    public Response blockly(@Context HttpServletResponse ignoredResponse, @Context HttpServletRequest ignoredRequest, specTypes.Phrase phrase) throws ServletException, IOException {
        Root root;
        logger.debug("toBlocky");
        if (phrase instanceof defs.Paragraph) {
            Collection ll = CollectionConverters.IterableHasAsJava((Iterable)((defs.Paragraph)phrase).items()).asJavaCollection();
            LinkedList<Block> res = new LinkedList<Block>();
            for (specTypes.Phrase p : ll) {
                res.add(p.toBlockly());
            }
            root = new Root(res);
        } else {
            root = new Root(phrase.toBlockly());
        }
        StreamingOutput promise = out -> new BlocklySerializer(true).serialiseBlock(out, (Object)root, true);
        return ServiceUtils.composeResponseOK((Object)promise).type("text/xml").build();
    }

    @POST
    @Path(value="/conversion")
    @Tag(name="nlg")
    @Consumes(value={"text/provenance-notation", "application/ld+json", "application/json"})
    @Produces(value={"text/provenance-notation", "application/json", "application/ld+json", "image/svg+xml", "image/png", "image/jpeg", "application/pdf"})
    public Response conversion(@Context HttpServletResponse ignoredResponse, @Context Request request, org.openprovenance.prov.vanilla.Document document) {
        logger.debug("conversion");
        org.openprovenance.prov.model.ProvFactory factory = InteropFramework.getDefaultFactory();
        InteropFramework interop = new InteropFramework(factory);
        List vs = interop.getVariants();
        Variant v = request.selectVariant(vs);
        if (v == null) {
            return this.utils.composeResponseNotAcceptable(vs);
        }
        String mediaType = v.getMediaType().toString();
        StreamingOutput promise = out -> interop.writeDocument(out, (Document)document, mediaType, true);
        return ServiceUtils.composeResponseOK((Object)promise).type(mediaType).build();
    }
}

