/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.sparql;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.Prologue;
import org.openprovenance.prov.sparql.CommandLine;
import org.openprovenance.prov.sparql.Config;

public class Reasoning {
    public static final String JSON = "JSON";
    public static final String XML = "XML";
    public static final String TEXT = "TEXT";

    public static void execute(Config config) throws IOException {
        String ontologyFile = config.getOntology();
        String rdfFile = config.getInfile();
        String outFile = config.getOutfile();
        String outFormat = config.getOutformat();
        if (outFormat == null) {
            if (outFile != null) {
                if (outFile.endsWith(".json")) {
                    outFormat = JSON;
                } else if (outFile.endsWith(".xml")) {
                    outFormat = XML;
                } else if (outFile.endsWith(".txt")) {
                    outFormat = TEXT;
                }
            } else {
                outFormat = TEXT;
            }
        }
        if (outFile != null) {
            System.setOut(new PrintStream(new FileOutputStream(outFile)));
        }
        String sparqlQueryFile = config.getQuery();
        String sparqlQuery = new String(Files.readAllBytes(Paths.get(sparqlQueryFile, new String[0])));
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        RDFDataMgr.read((Model)ontModel, (String)ontologyFile, (Lang)Lang.TURTLE);
        Model dataModel = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)dataModel, (String)rdfFile, (Lang)Lang.JSONLD);
        ontModel.addSubModel(dataModel);
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        InfModel infModel = ModelFactory.createInfModel((Reasoner)reasoner, (Model)ontModel);
        Query query = QueryFactory.create((String)sparqlQuery);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)infModel);){
            ResultSet results = qexec.execSelect();
            if (outFormat.equals(JSON)) {
                ResultSetFormatter.outputAsJSON((OutputStream)System.out, (ResultSet)results);
            } else if (outFormat.equals(XML)) {
                ResultSetFormatter.outputAsXML((OutputStream)System.out, (ResultSet)results);
            } else {
                ResultSetFormatter.out((OutputStream)System.out, (ResultSet)results, (Prologue)query);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        CommandLine.main(new String[]{"-infile", "src/test/resources/pc1-full.jsonld", "-query", "src/test/resources/q1.rq", "-outformat", TEXT});
    }
}

