/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.ValueConverter;
import org.openprovenance.prov.template.expander.ExpandUtil;
import org.openprovenance.prov.template.log2prov.FileBuilder;

public class CompilerUtil {
    static ProvUtilities u = new ProvUtilities();

    public String capitalize(String templateName) {
        return templateName.substring(0, 1).toUpperCase() + templateName.substring(1);
    }

    public void extractVariablesAndAttributes(Bundle bundle, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, ProvFactory pFactory) {
        for (Statement statement : bundle.getStatement()) {
            Set vars = ExpandUtil.freeVariables((Statement)statement);
            allVars.addAll(vars);
            allVars.addAll(ExpandUtil.freeVariables((Bundle)bundle));
            HashSet vars2 = ExpandUtil.freeAttributeVariables((Statement)statement, (ProvFactory)pFactory);
            allAtts.addAll(vars2);
        }
    }

    public TypeSpec.Builder generateClassInit(String name) {
        return TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassInit(String name, String packge, String supername) {
        return TypeSpec.classBuilder((String)name).addSuperinterface((TypeName)ClassName.get((String)packge, (String)supername, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassInitExtends(String name, String packge, String supername) {
        return TypeSpec.classBuilder((String)name).superclass((TypeName)ClassName.get((String)packge, (String)supername, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateInterfaceInit(String name) {
        return TypeSpec.interfaceBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassBuilder3(String name) {
        return TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassBuilder2(String name) {
        return TypeSpec.classBuilder((String)name).superclass(FileBuilder.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(ProvFactory.class, "pf", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(ValueConverter.class, "vc", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
    }

    public MethodSpec generateConstructor2(Hashtable<QualifiedName, String> vmap) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ProvFactory.class, "pf", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"pf", "pf"});
        for (Map.Entry<QualifiedName, String> e : vmap.entrySet()) {
            QualifiedName q = e.getKey();
            builder.addStatement("this.$N = pf.newQualifiedName($S,$S,$S)", new Object[]{e.getValue(), q.getNamespaceURI(), q.getLocalPart(), q.getPrefix()});
        }
        builder.addStatement("this.vc = new ValueConverter(pf)", new Object[0]);
        builder.addStatement("register(this)", new Object[0]);
        return builder.build();
    }

    public String camelcase(String s) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s);
    }

    public Set<QualifiedName> allQualifiedNames(Statement statement) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        for (int i = 0; i < ExpandUtil.getFirstTimeIndex((Statement)statement); ++i) {
            Object o = u.getter(statement, i);
            if (o instanceof QualifiedName) {
                QualifiedName name = (QualifiedName)o;
                result.add(name);
                continue;
            }
            if (!(o instanceof List)) continue;
            List ll = (List)o;
            for (QualifiedName name : ll) {
                result.add(name);
            }
        }
        return result;
    }

    public HashSet<QualifiedName> allQualifiedNamesInAttributes(Statement statement, ProvFactory pf) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        Collection ll = pf.getAttributes(statement);
        for (Attribute attr : ll) {
            result.add(attr.getElementName());
            if (attr.getType() != null) {
                result.add(attr.getType());
            }
            if (!(attr.getValue() instanceof QualifiedName)) continue;
            result.add((QualifiedName)attr.getValue());
        }
        return result;
    }

    public void allQualifiedNames(Bundle bundle, Set<QualifiedName> result, ProvFactory pFactory) {
        result.add(bundle.getId());
        for (Statement statement : bundle.getStatement()) {
            Set<QualifiedName> vars = this.allQualifiedNames(statement);
            result.addAll(vars);
            HashSet<QualifiedName> vars2 = this.allQualifiedNamesInAttributes(statement, pFactory);
            result.addAll(vars2);
        }
    }

    public Document readDocumentFromFile(String file) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object interop = this.getInteropFramework();
        Method method = interop.getClass().getMethod("readDocumentFromFile", String.class);
        Document doc = (Document)method.invoke(interop, file);
        return doc;
    }

    public void writeDocument(String file, Document doc) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object interop = this.getInteropFramework();
        Method method = interop.getClass().getMethod("writeDocument", String.class, Document.class);
        method.invoke(interop, file, doc);
    }

    public Object getInteropFramework() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = Class.forName("org.openprovenance.prov.interop.InteropFramework");
        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        return ctor.newInstance(new Object[0]);
    }
}

