/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Iterator;
import javax.lang.model.element.Modifier;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.TemplateCompiler;
import org.openprovenance.prov.template.compiler.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.TemplatesCompilerConfig;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.template.log2prov.Runner;
import org.openprovenance.prov.vanilla.ProvFactory;

public class ConfigProcessor {
    private static final String PREFIX_LOG_VAR = "___";
    private static final String GET_NODES_METHOD = "getNodes";
    private static final String BUILDER_INTERFACE = "Builder";
    private static final String INIT = "Init";
    public static final String BUILDERS = "builders";
    public static final String PF = "pf";
    public static final String GET_SUCCESSOR_METHOD = "getSuccessors";
    public static final String GET_NAME = "getName";
    private static final String LOGGER_INTERFACE = "LoggerInterface";
    private static final String TESTER_FILE = "ExampleTest";
    private static final String GET_BUILDERS_METHOD = "getBuilders";
    public static final String CLIENT_PACKAGE = "org.openprovenance.prov.client";
    static ObjectMapper objectMapper = new ObjectMapper();
    final CompilerUtil cu = new CompilerUtil();

    public static int processTemplateGenerationConfig(String template_builder, org.openprovenance.prov.model.ProvFactory pFactory) {
        ConfigProcessor cp = new ConfigProcessor();
        try {
            TemplatesCompilerConfig configs = (TemplatesCompilerConfig)objectMapper.readValue(new File(template_builder), TemplatesCompilerConfig.class);
            String root_dir = configs.destination + "/" + configs.name;
            new File(root_dir).mkdirs();
            String cli_lib = configs.name + "_cli";
            String cli_dir = root_dir + "/" + cli_lib;
            new File(cli_dir).mkdirs();
            String l2p_lib = configs.name + "_l2p";
            String l2p_dir = root_dir + "/" + l2p_lib;
            new File(l2p_dir).mkdirs();
            String l2p_src_dir = l2p_dir + "/src/main/java";
            String l2p_test_src_dir = l2p_dir + "/src/test/java";
            String cli_src_dir = cli_dir + "/src/main/java";
            new File(l2p_src_dir).mkdirs();
            new File(cli_src_dir).mkdirs();
            new File(l2p_test_src_dir).mkdirs();
            TemplateCompiler tc = new TemplateCompiler(pFactory);
            cp.makeRootPom(configs, root_dir, cli_lib, l2p_lib);
            cp.makeSubPom(configs, cli_dir, cli_lib, false);
            cp.makeSubPom(configs, l2p_dir, l2p_lib, true);
            for (TemplateCompilerConfig config : configs.templates) {
                System.out.println(config.toString());
                cp.doProcessEntry(tc, config, configs, cli_src_dir, l2p_src_dir, pFactory);
            }
            String init_dir = l2p_src_dir + "/" + configs.init_package.replace('.', '/') + "/";
            String test_dir = l2p_test_src_dir + "/" + configs.init_package.replace('.', '/') + "/";
            JavaFile init = cp.generateInitializer(tc, configs);
            tc.saveToFile(init_dir, init_dir + "Init.java", init);
            String logger_dir = cli_src_dir + "/" + configs.logger_package.replace('.', '/') + "/";
            String openprovenance_dir = cli_src_dir + "/" + CLIENT_PACKAGE.replace('.', '/') + "/";
            JavaFile logger = cp.generateLogger(tc, configs);
            tc.saveToFile(logger_dir, logger_dir + configs.logger + ".java", logger);
            JavaFile intface = cp.generateBuilderInterface(tc, configs);
            tc.saveToFile(openprovenance_dir, openprovenance_dir + "Builder.java", intface);
            JavaFile intface2 = cp.generateLoggerInterface(tc, configs);
            tc.saveToFile(openprovenance_dir, openprovenance_dir + "LoggerInterface.java", intface2);
            JavaFile testfile = cp.generateTestFile(tc, configs);
            tc.saveToFile(test_dir, test_dir + "ExampleTest.java", testfile);
            cp.generateScript(configs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public JavaFile generateTestFile(TemplateCompiler tc, TemplatesCompilerConfig configs) {
        TypeSpec.Builder builder = this.cu.generateClassInitExtends(TESTER_FILE, "junit.framework", "TestCase");
        MethodSpec.Builder mbuilder = MethodSpec.methodBuilder((String)"testMain").addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).returns(Void.TYPE).addStatement("$T pf=org.openprovenance.prov.interop.InteropFramework.getDefaultFactory()", new Object[]{org.openprovenance.prov.model.ProvFactory.class});
        for (TemplateCompilerConfig template : configs.templates) {
            String bn = tc.templateNameClass(template.name);
            mbuilder.addStatement("System.setOut(new java.io.PrintStream(\"target/" + template.name + ".provn\"))", new Object[0]);
            mbuilder.addStatement("$T.main(null)", new Object[]{ClassName.get((String)template.package_, (String)bn, (String[])new String[0])});
        }
        MethodSpec method = mbuilder.build();
        builder.addMethod(method);
        TypeSpec theInitializer = builder.build();
        JavaFile myfile = JavaFile.builder((String)configs.init_package, (TypeSpec)theInitializer).addFileComment("Generated Automatically by ProvToolbox for templates config $S", new Object[]{configs.name}).build();
        return myfile;
    }

    public void doProcessEntry(TemplateCompiler tbg, TemplateCompilerConfig config, TemplatesCompilerConfig configs, String cli_src_dir, String l2p_src_dir, org.openprovenance.prov.model.ProvFactory pFactory) {
        JsonNode bindings_schema = this.get_bindings_schema(config);
        try {
            Document doc = this.readDocumentFromFile(config);
            tbg.generate(doc, config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", bindings_schema);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("could not find Interop Framework");
            e.printStackTrace();
            System.out.println(Arrays.asList("doc", config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", bindings_schema));
        }
    }

    public JsonNode get_bindings_schema(TemplateCompilerConfig config) {
        JsonNode bindings_schema = null;
        if (config.bindings != null) {
            try {
                bindings_schema = objectMapper.readTree(new File(config.bindings));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bindings_schema;
    }

    public Document readDocumentFromFile(TemplateCompilerConfig config) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.cu.readDocumentFromFile(config.template);
    }

    public boolean makeRootPom(TemplatesCompilerConfig configs, String root_dir, String cli_lib, String l2p_lib) {
        Model model = new Model();
        model.setGroupId(configs.group);
        model.setArtifactId(configs.name);
        model.setVersion(configs.version);
        model.setName(configs.name);
        model.setPackaging("pom");
        model.setDescription(configs.description);
        model.setModelVersion("4.0.0");
        model.addModule(cli_lib);
        model.addModule(l2p_lib);
        this.addCompilerDeclaration(model);
        try {
            new MavenXpp3Writer().write((Writer)new FileWriter(root_dir + "/pom.xml"), model);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean makeSubPom(TemplatesCompilerConfig configs, String dir, String name, boolean dependencies) {
        Model model = new Model();
        model.setArtifactId(name);
        model.setName(name);
        model.setPackaging("jar");
        model.setDescription(configs.description + " (" + name + ")");
        Parent parent = new Parent();
        parent.setArtifactId(configs.name);
        parent.setGroupId(configs.group);
        parent.setVersion(configs.version);
        model.setParent(parent);
        model.setModelVersion("4.0.0");
        if (dependencies) {
            this.addProvDependency("prov-model", model);
            this.addProvDependency("prov-n", model);
            this.addProvDependency("prov-template-compiler", model);
            this.addProvDependency("prov-interop-light", model);
            this.addJunitDependency(model);
        }
        try {
            new MavenXpp3Writer().write((Writer)new FileWriter(dir + "/pom.xml"), model);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getProvPackageId() {
        return "org.openprovenance.prov";
    }

    public void addProvDependency(String artifact, Model model) {
        Dependency dep = new Dependency();
        dep.setArtifactId(artifact);
        dep.setGroupId(this.getProvPackageId());
        dep.setVersion(this.getProvVersion());
        model.addDependency(dep);
    }

    public void addJunitDependency(Model model) {
        Dependency dep = new Dependency();
        dep.setArtifactId("junit");
        dep.setGroupId("junit");
        dep.setVersion("4.11");
        dep.setScope("test");
        model.addDependency(dep);
    }

    public void addCompilerDeclaration(Model model) {
        Plugin plugin1 = new Plugin();
        plugin1.setGroupId("org.apache.maven.plugins");
        plugin1.setArtifactId("maven-compiler-plugin");
        plugin1.setVersion("3.8.1");
        StringBuilder configString1 = new StringBuilder().append("<configuration>").append("<source>1.8</source>").append("<target>1.8</target>").append("</configuration>");
        Plugin plugin2 = new Plugin();
        plugin2.setGroupId("org.apache.maven.plugins");
        plugin2.setArtifactId("maven-javadoc-plugin");
        plugin2.setVersion("3.1.1");
        StringBuilder configString2 = new StringBuilder().append("<configuration>").append("<source>1.8</source>").append("</configuration>");
        Xpp3Dom config1 = null;
        Xpp3Dom config2 = null;
        try {
            config1 = Xpp3DomBuilder.build((Reader)new StringReader(configString1.toString()));
            config2 = Xpp3DomBuilder.build((Reader)new StringReader(configString2.toString()));
        }
        catch (IOException | XmlPullParserException ex) {
            throw new RuntimeException("Issue creating config for enforcer plugin", ex);
        }
        PluginManagement pm = new PluginManagement();
        pm.addPlugin(plugin1);
        plugin1.setConfiguration((Object)config1);
        pm.addPlugin(plugin2);
        plugin2.setConfiguration((Object)config2);
        Build build = new Build();
        model.setBuild(build);
        build.setPluginManagement(pm);
    }

    public String getProvVersion() {
        return Configuration.toolboxVersion;
    }

    private JavaFile generateInitializer(TemplateCompiler tc, TemplatesCompilerConfig configs) {
        int size = configs.templates.length;
        TypeSpec.Builder builder = this.cu.generateClassInit(INIT);
        builder.addField(String[].class, BUILDERS, new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        builder.addField(org.openprovenance.prov.model.ProvFactory.class, PF, new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder block = CodeBlock.builder();
        block.addStatement("$N = new String[$L]", new Object[]{BUILDERS, size});
        int count = 0;
        for (TemplateCompilerConfig config : configs.templates) {
            block.addStatement("$N[$L]=$S", new Object[]{BUILDERS, count, config.package_ + "." + tc.templateNameClass(config.name)});
            ++count;
        }
        block.addStatement("pf=$T.getFactory()", new Object[]{ProvFactory.class});
        builder.addStaticBlock(block.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"init").addStatement("return $T.registerBuilders($N,$N)", new Object[]{FileBuilder.class, BUILDERS, PF}).returns(Boolean.TYPE).addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        builder.addMethod(this.generateMain());
        TypeSpec theInitializer = builder.build();
        JavaFile myfile = JavaFile.builder((String)configs.init_package, (TypeSpec)theInitializer).addFileComment("Generated Automatically by ProvToolbox for templates config $S", new Object[]{configs.name}).build();
        return myfile;
    }

    public MethodSpec generateMain() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"main").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Void.TYPE).addParameter(String[].class, "args", new Modifier[0]).addException(Exception.class).addStatement("init()", new Object[0]).addStatement("$T.main($N)", new Object[]{Runner.class, "args"});
        return builder.build();
    }

    private JavaFile generateLogger(TemplateCompiler tc, TemplatesCompilerConfig configs) {
        TypeSpec.Builder builder = this.cu.generateClassInit(configs.logger);
        builder.addSuperinterface((TypeName)ClassName.get((String)CLIENT_PACKAGE, (String)LOGGER_INTERFACE, (String[])new String[0]));
        String packge = null;
        for (TemplateCompilerConfig config : configs.templates) {
            String templateNameClass = tc.templateNameClass(config.name);
            packge = config.package_ + ".client";
            ClassName className = ClassName.get((String)packge, (String)templateNameClass, (String[])new String[0]);
            FieldSpec fspec = FieldSpec.builder((TypeName)className, (String)(PREFIX_LOG_VAR + config.name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("new $T()", new Object[]{className}).build();
            builder.addField(fspec);
        }
        Object names = "";
        boolean first = true;
        for (TemplateCompilerConfig templateCompilerConfig : configs.templates) {
            if (first) {
                first = false;
            } else {
                names = (String)names + ", ";
            }
            names = (String)names + PREFIX_LOG_VAR + templateCompilerConfig.name;
        }
        ClassName cln = ClassName.get((String)CLIENT_PACKAGE, (String)BUILDER_INTERFACE, (String[])new String[0]);
        ArrayTypeName builderArrayType = ArrayTypeName.of((TypeName)cln);
        FieldSpec fspec = FieldSpec.builder((TypeName)builderArrayType, (String)"__builders", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("new $T[] {" + (String)names + "}", new Object[]{cln}).build();
        builder.addField(fspec);
        builder.addMethod(this.generateGetBuilderMethod(builderArrayType));
        for (TemplateCompilerConfig config : configs.templates) {
            builder.addMethod(this.generateStaticLogMethod(config, tc));
        }
        TypeSpec typeSpec = builder.build();
        JavaFile myfile = JavaFile.builder((String)configs.logger_package, (TypeSpec)typeSpec).addFileComment("Generated Automatically by ProvToolbox for templates config $S", new Object[]{configs.name}).build();
        return myfile;
    }

    private JavaFile generateBuilderInterface(TemplateCompiler tc, TemplatesCompilerConfig configs) {
        TypeSpec.Builder builder = this.cu.generateInterfaceInit(BUILDER_INTERFACE);
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)GET_NODES_METHOD).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(int[].class);
        builder.addMethod(builder2.build());
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)GET_SUCCESSOR_METHOD).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TemplateCompiler.hashmapType);
        builder.addMethod(builder3.build());
        MethodSpec.Builder builder4 = MethodSpec.methodBuilder((String)GET_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class);
        builder.addMethod(builder4.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = JavaFile.builder((String)CLIENT_PACKAGE, (TypeSpec)theInterface).addFileComment("Generated Automatically by ProvToolbox for templates config $S", new Object[]{configs.name}).build();
        return myfile;
    }

    private JavaFile generateLoggerInterface(TemplateCompiler tc, TemplatesCompilerConfig configs) {
        TypeSpec.Builder builder = this.cu.generateInterfaceInit(LOGGER_INTERFACE);
        ClassName cln = ClassName.get((String)CLIENT_PACKAGE, (String)BUILDER_INTERFACE, (String[])new String[0]);
        ArrayTypeName builderArrayType = ArrayTypeName.of((TypeName)cln);
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)GET_BUILDERS_METHOD).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)builderArrayType);
        builder.addMethod(builder2.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = JavaFile.builder((String)CLIENT_PACKAGE, (TypeSpec)theInterface).addFileComment("Generated Automatically by ProvToolbox for templates config $S", new Object[]{configs.name}).build();
        return myfile;
    }

    public MethodSpec generateStaticLogMethod(TemplateCompilerConfig config, TemplateCompiler tc) {
        String loggerName = tc.loggerName(config.name);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)loggerName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.STATIC}).returns(String.class);
        JsonNode bindings_schema = this.get_bindings_schema(config);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        JsonNode the_documentation = bindings_schema.get("@documentation");
        tc.generateSpecializedParameters(builder, the_var);
        tc.generateSpecializedParametersJavadoc(builder, the_var, the_documentation);
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return $N." + loggerName + "(" + (String)args + ")", new Object[]{PREFIX_LOG_VAR + config.name});
        return builder.build();
    }

    public MethodSpec generateGetBuilderMethod(ArrayTypeName builderArrayType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)GET_BUILDERS_METHOD).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)builderArrayType);
        builder.addStatement("return __builders", new Object[0]);
        return builder.build();
    }

    public void generateScript(TemplatesCompilerConfig configs) {
        new File(configs.script_dir).mkdirs();
        try {
            String path = configs.script_dir + "/" + configs.script;
            PrintStream os = new PrintStream(path);
            InputStream in = this.getClass().getResourceAsStream("script.sh");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                line = line.replace("${SCRIPT}", configs.script);
                line = line.replace("${VERSION}", configs.version);
                line = line.replace("${NAME}", configs.name);
                line = line.replace("${PACKAGE}", configs.init_package.replace(".", "/"));
                line = line.replace("${INIT}", configs.init_package + ".Init");
                os.println(line);
                line = reader.readLine();
            }
            os.close();
            in.close();
            Files.setPosixFilePermissions(new File(path).toPath(), PosixFilePermissions.fromString("rwxr-xr-x"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

