/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.template.compiler.CompilerSQL;
import org.openprovenance.prov.template.compiler.CompilerUtil;

public class CompilerClient {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    private final ProvFactory pFactory;
    private final boolean debugComment = true;
    private final CompilerSQL compilerSQL;
    static final ParameterizedTypeName hashmapType = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(Integer.class), TypeName.get(int[].class)});
    private boolean foundEscape = false;
    TypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});

    public CompilerClient(ProvFactory pFactory, CompilerSQL compilerSQL) {
        this.pFactory = pFactory;
        this.compilerSQL = compilerSQL;
    }

    public TypeSpec.Builder generateClassInit(String builderName, String builderPackage, String processorName, String processorPackage, String supername) {
        return TypeSpec.classBuilder((String)builderName).addSuperinterface((TypeName)ClassName.get((String)builderPackage, (String)supername, (String[])new String[0])).addSuperinterface((TypeName)ClassName.get((String)builderPackage, (String)"SQL", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public JavaFile generateClientLib(Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        IndexedDocument indexed = new IndexedDocument(this.pFactory, this.pFactory.newDocument(), true);
        CompilerUtil.u.forAllStatement(bun.getStatement(), (StatementAction)indexed);
        return this.generateClientLib_aux(doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema, indexed);
    }

    JavaFile generateClientLib_aux(Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema, IndexedDocument indexed) {
        TypeSpec.Builder builder = this.generateClassInit(name, "org.openprovenance.prov.client", this.compilerUtil.processorNameClass(templateName), packge, "Builder");
        if (bindings_schema != null) {
            builder.addMethod(this.generateClientCSVConverterMethod_aux(allVars, allAtts, name, templateName, this.compilerUtil.loggerName(templateName), packge, bindings_schema));
            builder.addMethod(this.generateClientSQLConverterMethod_aux(allVars, allAtts, name, templateName, this.compilerUtil.loggerName(templateName), packge, bindings_schema));
            builder.addMethod(this.generateClientMethod2(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod2PureCsv(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod3static(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod3(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod4static(allVars, allAtts, name, templateName, bindings_schema, indexed));
            builder.addField(this.generateField4aBeanConverter(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aBeanConverter2(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aSQLConverter2(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aArgs2CsvConverter(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aRecord2SqlConverter(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aRecord2CsvConverter(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(FieldSpec.builder((TypeName)hashmapType, (String)"__successors", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getSuccessors()", new Object[0]).build());
            builder.addField(FieldSpec.builder(int[].class, (String)"__nodes", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getNodes()", new Object[0]).build());
            builder.addMethod(this.generateClientMethod4(allVars, allAtts, name, templateName, bindings_schema, indexed));
            builder.addMethod(this.nameAccessorGenerator(templateName));
            builder.addMethod(this.generateRecordCsvProcessorMethod());
            builder.addMethod(this.generateFactoryMethodWithBean(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addMethod(this.generateFactoryMethodToBeanWithArray(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addMethod(this.generateNewBean(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addMethod(this.generateExamplarBean(allVars, allAtts, name, templateName, packge, bindings_schema));
        }
        this.compilerSQL.generateSQLstatements(builder, allVars, allAtts, name, templateName, bindings_schema);
        builder.addMethod(this.compilerSQL.generateClientSQLMethod2(allVars, allAtts, name, templateName, bindings_schema));
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox ($N) for template $N", new Object[]{this.getClass().getName(), templateName}).build();
        return myfile;
    }

    public MethodSpec nameAccessorGenerator(String templateName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return $S", new Object[]{templateName});
        return builder.build();
    }

    public MethodSpec generateClientMethod_aux(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String invoke, String loggerName, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)loggerName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod_aux()"});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add(loggerName + " client side logging method\n", new Object[0]);
        JsonNode the_var1 = bindings_schema.get("var");
        Iterator iter1 = the_var1.fieldNames();
        while (iter1.hasNext()) {
            String key = (String)iter1.next();
            String newkey = "__" + key;
            jdoc.add("@param " + newkey + " " + this.compilerUtil.getJavaTypeForDeclaredType(the_var1, key) + "\n", new Object[0]);
        }
        jdoc.add("@return java.lang.String\n", new Object[0]);
        builder.addJavadoc(jdoc.build());
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String var = "sb";
        builder.addStatement("$T $N=new $T()", new Object[]{StringBuffer.class, var, StringBuffer.class});
        String args = var;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key), newkey, new Modifier[0]);
            args = args + ", " + newkey;
        }
        builder.addStatement("$N(" + args + ")", new Object[]{invoke});
        builder.addStatement("return $N.toString()", new Object[]{var});
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        return this.generateClientMethod2(allVars, allAtts, name, template, bindings_schema, true);
    }

    public MethodSpec generateClientMethod2PureCsv(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        return this.generateClientMethod2(allVars, allAtts, name, template, bindings_schema, false);
    }

    public MethodSpec generateClientCSVConverterMethod_aux(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String loggerName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(template, packge, ClassName.get(String.class));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"args2csv").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(processorClassName);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientCSVConverterMethod_aux()"});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add(loggerName + " client side logging method\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{processorClassNameNotParametrised});
        builder.addJavadoc(jdoc.build());
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String sb = "sb";
        String var = "";
        builder.addStatement("$T $N=new $T()", new Object[]{StringBuffer.class, sb, StringBuffer.class});
        builder.addStatement("$T $N=this", new Object[]{ClassName.get((String)packge, (String)name, (String[])new String[0]), "self"});
        Object args = "";
        Object args2 = "";
        boolean first = true;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        builder.addStatement("return (" + (String)args + ") -> { $N.$N(sb," + (String)args2 + "); return sb.toString(); }", new Object[]{"self", loggerName});
        MethodSpec method = builder.build();
        return method;
    }

    private FieldSpec generateField4aBeanConverter(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        TypeName myType = this.processorClassType(templateName, packge, ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(templateName), (String[])new String[0]));
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aArgs2BeanConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        JsonNode the_var = bindings_schema.get("var");
        Object args = "";
        Object args2 = "";
        boolean first = true;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        fbuilder.initializer(" (" + (String)args + ") -> { return $N(" + (String)args2 + "); }", new Object[]{"toBean"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aBeanConverter2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(templateName), (String[])new String[0])});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aRecord2BeanConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer(" (Object [] record) -> { return $N(record); }", new Object[]{"toBean"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aSQLConverter2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(templateName, packge, ClassName.get(String.class));
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)processorClassName, (String)"aBean2SqlConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer("$N()", new Object[]{"bean2sql"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aArgs2CsvConverter(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(templateName, packge, ClassName.get(String.class));
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)processorClassName, (String)"aArgs2CsVConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer("$N()", new Object[]{"args2csv"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aRecord2SqlConverter(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aRecord2SqlConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer(" (Object [] record) -> { return $N(record).process($N); }", new Object[]{"toBean", "aBean2SqlConverter"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aRecord2CsvConverter(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aRecord2CsvConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer(" (Object [] record) -> { return $N(record).process($N); }", new Object[]{"toBean", "aArgs2CsVConverter"});
        return fbuilder.build();
    }

    public MethodSpec generateClientSQLConverterMethod_aux(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String loggerName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(template, packge, ClassName.get(String.class));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"bean2sql").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(processorClassName);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientSQLConverterMethod_aux()"});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add(loggerName + " client side logging method\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{processorClassNameNotParametrised});
        builder.addJavadoc(jdoc.build());
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String sb = "sb";
        String var = "";
        builder.addStatement("$T $N=new $T()", new Object[]{StringBuffer.class, sb, StringBuffer.class});
        builder.addStatement("$T $N=this", new Object[]{ClassName.get((String)packge, (String)name, (String[])new String[0]), "self"});
        Object args = "";
        Object args2 = "";
        boolean first = true;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        builder.addStatement("return (" + (String)args + ") -> { $N.$N(sb," + (String)args2 + "); return sb.toString(); }", new Object[]{"self", "sqlTuple"});
        MethodSpec method = builder.build();
        return method;
    }

    private TypeName processorClassType(String template, String packge, ParameterizedTypeName parameterizedTypeName) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        return name;
    }

    private TypeName processorClassType(String template, String packge, ClassName cl) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{cl});
        return name;
    }

    private TypeName processorClassType(String template, String packge) {
        return ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]);
    }

    public MethodSpec generateClientMethod2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, boolean legacy) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(this.compilerUtil.loggerName(template) + (legacy ? "_impure" : ""))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        String var = "sb";
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod2()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addParameter(StringBuffer.class, var, new Modifier[0]);
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key), newkey, new Modifier[0]);
        }
        iter = the_var.fieldNames();
        Object constant = (legacy ? "[\"" : "\"") + template + "\"";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newName = "__" + key;
            Class<?> clazz = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
            boolean isQualifiedName = the_var.get(key).get(0).get("@id") != null;
            constant = (String)constant + ",";
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            constant = "";
            if (String.class.equals(clazz)) {
                String myStatement = "$N.append($N)";
                String myEscapeStatement = "$N.append($T.escapeJavaScript($N))";
                boolean doEscape = false;
                if (!isQualifiedName) {
                    boolean bl = doEscape = the_var.get(key).get(0).get(0).get("@escape") != null;
                    if (doEscape) {
                        this.foundEscape = true;
                    }
                }
                builder.beginControlFlow("if ($N==null)", new Object[]{newName});
                if (legacy) {
                    builder.addStatement("$N.append($N)", new Object[]{var, newName});
                }
                builder.nextControlFlow("else", new Object[0]).addStatement("$N.append($S)", new Object[]{var, "\""});
                if (doEscape) {
                    builder.addStatement(myEscapeStatement, new Object[]{var, ClassName.get((String)"org.openprovenance.apache.commons.lang", (String)"StringEscapeUtils", (String[])new String[0]), newName});
                } else {
                    builder.addStatement(myStatement, new Object[]{var, newName});
                }
                builder.addStatement("$N.append($S)", new Object[]{var, "\""}).endControlFlow();
                continue;
            }
            builder.beginControlFlow("if ($N==null)", new Object[]{newName});
            builder.nextControlFlow("else", new Object[0]);
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            builder.addStatement("$N.append($N)", new Object[]{var, newName});
            builder.endControlFlow();
        }
        constant = (String)constant + (Serializable)(legacy ? Character.valueOf(']') : "");
        builder.addStatement("$N.append($S)", new Object[]{var, constant});
        MethodSpec method = builder.build();
        return method;
    }

    public boolean getFoundEscape() {
        return this.foundEscape;
    }

    public MethodSpec generateClientMethod3static(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(int[].class);
        String var = "sb";
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod3static()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter = the_var.fieldNames();
        int count = 0;
        LinkedList<Integer> ll = new LinkedList<Integer>();
        while (iter.hasNext()) {
            ++count;
            String key = (String)iter.next();
            if (the_var.get(key).get(0).get("@id") == null) continue;
            ll.add(count);
        }
        Object nodes = "";
        boolean first = true;
        Iterator iterator = ll.iterator();
        while (iterator.hasNext()) {
            int elem = (Integer)iterator.next();
            if (first) {
                first = false;
            } else {
                nodes = (String)nodes + ", ";
            }
            nodes = (String)nodes + elem;
        }
        builder.addStatement("return new int[] {" + (String)nodes + "}", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod3(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(int[].class);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod3()"});
        builder.addStatement("return __nodes", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateRecordCsvProcessorMethod() {
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"record2csv").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of(Object.class), (String)"record", (Modifier[])new Modifier[0]).build()).returns(this.myType);
        builder5.addStatement("return $N", new Object[]{"aRecord2CsvConverter"});
        return builder5.build();
    }

    public MethodSpec generateClientMethod4(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)CompilerUtil.hashmapType);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod4()"});
        builder.addStatement("return __successors", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod4static(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)CompilerUtil.hashmapType);
        String var = "sb";
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod4static()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter2 = the_var.fieldNames();
        int count2 = 0;
        HashMap<QualifiedName, Integer> index = new HashMap<QualifiedName, Integer>();
        while (iter2.hasNext()) {
            ++count2;
            String key = (String)iter2.next();
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                index.put(qn, count2);
            }
        }
        builder.addStatement("$T table = new $T()", new Object[]{CompilerUtil.hashmapType, CompilerUtil.hashmapType});
        Iterator iter = the_var.fieldNames();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            String key = (String)iter.next();
            if (the_var.get(key).get(0).get("@id") == null) continue;
            Set successors = new HashSet();
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                successors = indexed.traverseDerivations(qn);
                break;
            }
            Object initializer = "";
            boolean first = true;
            for (QualifiedName successor : successors) {
                int i = (Integer)index.get(successor);
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i;
            }
            builder.addStatement("table.put($L,new int[] { " + (String)initializer + "})", new Object[]{count});
        }
        builder.addStatement("return table", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateFactoryMethodWithBean(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toBean").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]));
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key), newkey, new Modifier[0]);
        }
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0])});
        Iterator iter2 = the_var.fieldNames();
        String args = "";
        while (iter2.hasNext()) {
            String key = (String)iter2.next();
            String newkey = "__" + key;
            String statement = "bean.$N=$N";
            builder.addStatement(statement, new Object[]{key, newkey});
        }
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateFactoryMethodToBeanWithArray(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toBean").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]));
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addParameter(Object[].class, "record", new Modifier[0]);
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0])});
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String statement;
            String key = (String)iter.next();
            Class<?> declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
            String converter = this.compilerUtil.getConverterForDeclaredType(declaredJavaType);
            String converter2 = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
            if (converter2 == null) {
                statement = "bean.$N=($T) record[" + count + "]";
                builder.addStatement(statement, new Object[]{key, declaredJavaType});
            } else {
                statement = "bean.$N=(record[" + count + "]==null)?0:$N((String)(record[" + count + "]))";
                builder.addStatement(statement, new Object[]{key, converter2});
            }
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateNewBean(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"newBean").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]));
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0])});
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateExamplarBean(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"examplar").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]));
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0])});
        for (QualifiedName qualifiedName : allVars) {
            Iterator iter3 = the_var.fieldNames();
            while (iter3.hasNext()) {
                String key3 = (String)iter3.next();
                if (!qualifiedName.getLocalPart().equals(key3)) continue;
                builder.addStatement("bean.$N=$S", new Object[]{qualifiedName.getLocalPart(), "example_" + qualifiedName.getLocalPart()});
            }
        }
        JsonNode the_var2 = bindings_schema == null ? null : bindings_schema.get("var");
        for (QualifiedName q : allAtts) {
            String declaredType = null;
            Class<?> declaredJavaType = null;
            if (the_var2 != null) {
                Iterator iter3 = the_var2.fieldNames();
                while (iter3.hasNext()) {
                    String key3 = (String)iter3.next();
                    if (!q.getLocalPart().equals(key3)) continue;
                    declaredType = this.compilerUtil.getDeclaredType(the_var2, key3);
                    declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(the_var2, key3);
                }
            }
            String example = this.compilerUtil.generateExampleForType(declaredType, q.getLocalPart(), this.pFactory);
            String converter = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
            if (converter == null) {
                builder.addStatement("bean.$N=$S", new Object[]{q.getLocalPart(), example});
                continue;
            }
            builder.addStatement("bean.$N=$N($S)", new Object[]{q.getLocalPart(), converter, example});
        }
        builder.addStatement("return bean", new Object[0]);
        MethodSpec methodSpec = builder.build();
        return methodSpec;
    }

    public JavaFile generateSQLInterface(String packge) {
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInit("SQL");
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"getSQLInsert").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class);
        builder.addMethod(builder2.build());
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)"getSQLInsertStatement").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class);
        builder.addMethod(builder3.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = JavaFile.builder((String)"org.openprovenance.prov.client", (TypeSpec)theInterface).addFileComment("Generated Automatically by ProvToolbox", new Object[0]).build();
        return myfile;
    }

    public MethodSpec clientAccessorGenerator(String templateName, String packge) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getClientBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"org.openprovenance.prov.client", (String)"Builder", (String[])new String[0]));
        builder.addStatement("return new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.templateNameClass(templateName), (String[])new String[0])});
        return builder.build();
    }
}

