/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.JsonSchemaTesting;
import org.openprovenance.prov.template.compiler.TemplatesCompilerConfig;

public class CompilerDocumentation {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    ObjectMapper om = new ObjectMapper();
    Map<String, Object> jsonSchemaAsAMap = this.initializeSchemaMap();
    private PrintStream os = null;
    boolean draft04 = false;
    final Tester tester = new Tester();

    public Map<String, Object> initializeSchemaMap() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("definitions", new HashMap());
        res.put("allOf", new LinkedList());
        res.put("type", "object");
        return res;
    }

    public PrintStream getOutputStream() {
        return this.os;
    }

    public void generateDocumentation(String documentationFile, String templateName, String root_dir, JsonNode bindings_schema) {
        if (this.os == null) {
            new File(root_dir).mkdirs();
        }
        String path = root_dir + "/" + documentationFile;
        try {
            if (this.os == null) {
                this.os = new PrintStream(new FileOutputStream(path));
                this.os.println("<html>");
                this.os.println("<body>");
                this.os.println("<head>");
                this.os.println(" <meta content=\"text/html;charset=utf-8\" http-equiv=\"Content-Type\"/>");
                this.os.println(" <meta content=\"utf-8\" http-equiv=\"encoding\"/>");
                this.os.println(" <link rel='stylesheet' href='../css/provtemplate.css'>");
                this.os.println("</head>");
            }
            JsonNode the_var = bindings_schema.get("var");
            JsonNode the_context = bindings_schema.get("context");
            JsonNode the_documentation = bindings_schema.get("@documentation");
            Iterator iter = the_var.fieldNames();
            boolean first = true;
            this.os.println("<div class='csv_template' id='template_" + templateName + "'>");
            this.os.println("<h2>" + templateName + "</h2>");
            this.os.println("<div class='csv_intro'>");
            String docString = this.compilerUtil.noNode(the_documentation) ? "No @documentation." : the_documentation.textValue();
            this.os.println(docString);
            this.os.println("</div>");
            this.os.println("<ul>");
            int column = 0;
            LinkedList<String> required = new LinkedList<String>();
            required.add("isA");
            this.os.println("<li>");
            this.os.println(this.makeSpan(String.valueOf(column), "csv_column"));
            this.os.println(this.makeSpan(templateName, "csv_field_header") + ":");
            this.os.println(this.makeSpan("Constant field for the name of this template", "csv_doc"));
            ++column;
            this.os.println("</li>");
            while (iter.hasNext()) {
                String key = (String)iter.next();
                required.add(key);
                this.os.println("<li>");
                this.os.println(this.makeSpan(String.valueOf(column), "csv_column"));
                this.os.println(this.makeSpan(key, "csv_field"));
                String jsonType = this.convertToJsonType(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName());
                String declaredType = this.compilerUtil.getDeclaredType(the_var, key);
                this.os.println(this.makeSpan(jsonType, "csv_type") + ":");
                JsonNode entry = the_var.path(key);
                if (entry != null && !(entry instanceof MissingNode)) {
                    JsonNode jsonNode;
                    JsonNode firstNode = entry.get(0);
                    if (firstNode instanceof ArrayNode) {
                        firstNode = ((ArrayNode)firstNode).get(0);
                    }
                    String documentation = this.compilerUtil.noNode(jsonNode = firstNode.get("@documentation")) ? "" : jsonNode.textValue();
                    JsonNode jsonNode2 = firstNode.get("@type");
                    this.os.println(this.makeSpan(documentation, "csv_doc"));
                }
                this.os.println("</li>");
                ++column;
            }
            this.os.println("</ul>");
            this.os.println("</div>");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String makeSpan(String key, String classe) {
        return "<span class='" + classe + "'>" + key + "</span> ";
    }

    public Object defaultValue(String jsonType) {
        switch (jsonType) {
            case "integer": {
                return 0;
            }
            case "float": {
                return 0.0;
            }
        }
        return null;
    }

    public String title(String key) {
        return key;
    }

    public String get$id() {
        if (this.draft04) {
            return "id";
        }
        return "$id";
    }

    String convertToJsonType(String name) {
        switch (name) {
            case "java.lang.String": {
                return "string";
            }
            case "java.lang.Integer": {
                return "integer";
            }
            case "java.lang.Float": {
                return "float";
            }
        }
        throw new UnsupportedOperationException("conversion to json type " + name);
    }

    public void generateDocumentationEnd(TemplatesCompilerConfig configs, String cli_webjar_dir) {
        this.os.println("</body>");
        this.os.println("</html>");
        this.getOutputStream().close();
    }

    public JsonSchema setupJsonSchemaFromClasspath(String file) {
        System.out.println("### getting schema from classpath " + file);
        JsonSchema schema2 = this.tester.getJsonSchemaFromClasspath(file);
        return schema2;
    }

    public JsonSchema setupJsonSchemaFromClasspathV7(String file) {
        System.out.println("### getting schema from classpath " + file);
        JsonSchema schema2 = this.tester.getJsonSchemaFromClasspathV7(file);
        return schema2;
    }

    public JsonSchema setupJsonSchemaFromFile(String file) throws FileNotFoundException {
        System.out.println("#### getting schema from File " + file);
        JsonSchema schema2 = this.tester.getJsonSchemaFromFile(file);
        return schema2;
    }

    public Set<ValidationMessage> checkSchema(JsonSchema schema, String file) throws IOException {
        JsonNode node = this.om.readTree(new File(file));
        Set errors = schema.validate(node);
        return errors;
    }

    static class Tester
    extends JsonSchemaTesting {
        Tester() {
        }

        @Override
        public JsonSchema getJsonSchemaFromClasspath(String name) {
            return super.getJsonSchemaFromClasspath(name);
        }

        @Override
        public JsonSchema getJsonSchemaFromClasspathV7(String name) {
            return super.getJsonSchemaFromClasspathV7(name);
        }

        @Override
        protected JsonSchema getJsonSchemaFromFile(String name) throws FileNotFoundException {
            return super.getJsonSchemaFromFile(name);
        }
    }
}

