/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.JsonSchemaTesting;

public class CompilerJsonSchema {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    ObjectMapper om = new ObjectMapper();
    Map<String, Object> jsonSchemaAsAMap = this.initializeSchemaMap();
    boolean draft04 = false;
    final Tester tester = new Tester();

    public void generateJSonSchemaEnd(String jsonschema, String root_dir) {
        new File(root_dir).mkdirs();
        String path = root_dir + "/" + jsonschema;
        this.jsonSchemaAsAMap.put(this.get$id(), "https://openprovenance.org/template/beans#" + jsonschema);
        this.jsonSchemaAsAMap.put("type", "object");
        this.jsonSchemaAsAMap.put("title", "The Root Schema");
        try {
            this.om.writerWithDefaultPrettyPrinter().writeValue(new File(path), this.jsonSchemaAsAMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> initializeSchemaMap() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("definitions", new HashMap());
        res.put("allOf", new LinkedList());
        res.put("type", "object");
        return res;
    }

    public void generateJSonSchema(String jsonschema, String templateName, String root_dir, JsonNode bindings_schema) {
        HashMap<String, Object> atype;
        String key;
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter = the_var.fieldNames();
        boolean first = true;
        HashMap<String, Object> aSchema = new HashMap<String, Object>();
        aSchema.put(this.get$id(), "#/definitions/" + templateName);
        aSchema.put("type", "object");
        HashMap properties = new HashMap();
        aSchema.put("properties", properties);
        LinkedList<String> required = new LinkedList<String>();
        required.add("isA");
        while (iter.hasNext()) {
            JsonNode entry;
            key = (String)iter.next();
            required.add(key);
            atype = new HashMap();
            atype.put(this.get$id(), "#/definitions/" + templateName + "/properties/" + key);
            atype.put("title", this.title(key));
            String jsonType = this.convertToJsonType(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName());
            atype.put("type", jsonType);
            Object defaultValue = this.defaultValue(jsonType);
            if (defaultValue != null) {
                atype.put("default", defaultValue);
            }
            if ((entry = the_var.path(key)) != null && !(entry instanceof MissingNode)) {
                JsonNode jsonNode;
                JsonNode firstNode = entry.get(0);
                if (firstNode instanceof ArrayNode) {
                    firstNode = ((ArrayNode)firstNode).get(0);
                }
                String documentation = this.compilerUtil.noNode(jsonNode = firstNode.get("@documentation")) ? "" : jsonNode.textValue();
                JsonNode jsonNode2 = firstNode.get("@type");
                atype.put("description", documentation + " (" + jsonType + ")");
            }
            properties.put(key, atype);
        }
        key = "isA";
        atype = new HashMap<String, Object>();
        atype.put(this.get$id(), "#/definitions/" + templateName + "/properties/" + key);
        atype.put("title", this.title(key));
        atype.put("type", "string");
        atype.put("readOnly", "true");
        atype.put("default", templateName);
        atype.put("pattern", "^" + templateName + "$");
        properties.put(key, atype);
        atype.put("required", true);
        this.jsonSchemaAsAMap.put("properties", Map.of("isA", Map.of("type", "string", "pattern", "^template_block$")));
        aSchema.put("required", required);
        aSchema.put("additionalProperties", false);
        ((Map)this.jsonSchemaAsAMap.get("definitions")).put(templateName, aSchema);
        HashMap<String, Map<Object, Object>> ifThenBlock = new HashMap<String, Map<Object, Object>>();
        HashMap<String, Object> ifBlock = new HashMap<String, Object>();
        ifThenBlock.put("if", ifBlock);
        ifThenBlock.put("then", Map.of("$ref", "#/definitions/" + templateName));
        ifBlock.put("type", "object");
        ifBlock.put("properties", Map.of("isA", Map.of("const", templateName)));
        ((List)this.jsonSchemaAsAMap.get("allOf")).add(ifThenBlock);
    }

    public Object defaultValue(String jsonType) {
        switch (jsonType) {
            case "integer": {
                return 0;
            }
            case "float": {
                return 0.0;
            }
        }
        return null;
    }

    public String title(String key) {
        return key;
    }

    public String get$id() {
        if (this.draft04) {
            return "id";
        }
        return "$id";
    }

    String convertToJsonType(String name) {
        switch (name) {
            case "java.lang.String": {
                return "string";
            }
            case "java.lang.Integer": {
                return "integer";
            }
            case "java.lang.Float": {
                return "float";
            }
        }
        throw new UnsupportedOperationException("conversion to json type " + name);
    }

    public JsonSchema setupJsonSchemaFromClasspath(String file) {
        System.out.println("### getting schema from classpath " + file);
        JsonSchema schema2 = this.tester.getJsonSchemaFromClasspath(file);
        return schema2;
    }

    public JsonSchema setupJsonSchemaFromClasspathV7(String file) {
        System.out.println("### getting schema from classpath " + file);
        JsonSchema schema2 = this.tester.getJsonSchemaFromClasspathV7(file);
        return schema2;
    }

    public JsonSchema setupJsonSchemaFromFile(String file) throws FileNotFoundException {
        System.out.println("#### getting schema from File " + file);
        JsonSchema schema2 = this.tester.getJsonSchemaFromFile(file);
        return schema2;
    }

    public Set<ValidationMessage> checkSchema(JsonSchema schema, String file) throws IOException {
        JsonNode node = this.om.readTree(new File(file));
        Set errors = schema.validate(node);
        return errors;
    }

    static class Tester
    extends JsonSchemaTesting {
        Tester() {
        }

        @Override
        public JsonSchema getJsonSchemaFromClasspath(String name) {
            return super.getJsonSchemaFromClasspath(name);
        }

        @Override
        public JsonSchema getJsonSchemaFromClasspathV7(String name) {
            return super.getJsonSchemaFromClasspathV7(name);
        }

        @Override
        protected JsonSchema getJsonSchemaFromFile(String name) throws FileNotFoundException {
            return super.getJsonSchemaFromFile(name);
        }
    }
}

