/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.template.compiler.CompilerUtil;

public class CompilerProcessor {
    private final ProvFactory pFactory;
    private final CompilerUtil compilerUtil = new CompilerUtil();

    public CompilerProcessor(ProvFactory pFactory) {
        this.pFactory = pFactory;
    }

    public JavaFile generateProcessor(Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        IndexedDocument indexed = new IndexedDocument(this.pFactory, this.pFactory.newDocument(), true);
        CompilerUtil.u.forAllStatement(bun.getStatement(), (StatementAction)indexed);
        return this.generateProcessor_aux(doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema, indexed);
    }

    public TypeSpec.Builder generateProcessorClassInit(String name, String packge, String supername) {
        return TypeSpec.interfaceBuilder((String)name).addTypeVariable(TypeVariableName.get((String)"T")).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private JavaFile generateProcessor_aux(Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema, IndexedDocument indexed) {
        TypeSpec.Builder builder = this.generateProcessorClassInit(name, "org.openprovenance.prov.client", "Bean");
        String loggerName = this.compilerUtil.loggerName(templateName);
        MethodSpec.Builder mbuilder = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).returns((TypeName)TypeVariableName.get((String)"T"));
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        CodeBlock.Builder jdoc = CodeBlock.builder();
        JsonNode the_documentation = bindings_schema.get("@documentation");
        JsonNode the_return = bindings_schema.get("@return");
        String docString = this.compilerUtil.noNode(the_documentation) ? "No @documentation" : the_documentation.textValue();
        String retString = this.compilerUtil.noNode(the_return) ? "@return not specified" : the_return.textValue();
        jdoc.add(docString, new Object[0]);
        jdoc.add("\n\n", new Object[0]);
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            mbuilder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key), key, new Modifier[0]);
            JsonNode entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode)) {
                JsonNode jsonNode;
                JsonNode firstNode = entry.get(0);
                if (firstNode instanceof ArrayNode) {
                    firstNode = ((ArrayNode)firstNode).get(0);
                }
                String documentation = this.compilerUtil.noNode(jsonNode = firstNode.get("@documentation")) ? "-- no @documentation" : jsonNode.textValue();
                JsonNode jsonNode2 = firstNode.get("@type");
                String type = this.compilerUtil.noNode(jsonNode2) ? "xsd:string" : jsonNode2.textValue();
                jdoc.add("@param $N $L (expected type: $L)\n", new Object[]{key, documentation, type});
                continue;
            }
            jdoc.add("@param $N -- no bindings schemas \n", new Object[]{key});
        }
        jdoc.add(retString, new Object[0]);
        mbuilder.addJavadoc(jdoc.build());
        builder.addMethod(mbuilder.build());
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox ($N) for template $N", new Object[]{this.getClass().getName(), templateName}).build();
        return myfile;
    }
}

