/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.log2prov;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class ProxyManagement {
    static boolean debug = false;

    public static <T> T simpleProxy(Class iface, InvocationHandler handler, Class ... otherIfaces) {
        Class[] allInterfaces = (Class[])Stream.concat(Stream.of(iface), Stream.of(otherIfaces)).distinct().toArray(Class[]::new);
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), allInterfaces, handler);
    }

    public <T> T facadeProxy(Class<T> iface, Object remoteObject) {
        return ProxyManagement.simpleProxy(iface, new PassthroughInvocationHandler(remoteObject, new Class[]{iface}), new Class[0]);
    }

    public static class PassthroughInvocationHandler
    implements InvocationHandler {
        private final Object unknownObject;
        private final Class<?>[] localInterfaces;
        Map<Class<?>, Class<?>> mapper = new HashMap();
        Map<Method, Method> mMapper = new HashMap<Method, Method>();

        public PassthroughInvocationHandler(Object unknownObject, Class<?>[] localInterfaces) {
            this.unknownObject = unknownObject;
            this.localInterfaces = localInterfaces;
            Class<?>[] unknownInterfaces = unknownObject.getClass().getInterfaces();
            for (Class<?> localInterface : localInterfaces) {
                boolean found = false;
                for (Class<?> unknownInterface : unknownInterfaces) {
                    if (!unknownInterface.getSimpleName().equals(localInterface.getSimpleName())) continue;
                    this.mapper.put(localInterface, unknownInterface);
                    found = true;
                    break;
                }
                if (found) continue;
                this.mapper.put(localInterface, unknownObject.getClass());
            }
            this.mapper.entrySet().forEach(e -> {
                Class localClass = (Class)e.getKey();
                Class remoteClass = (Class)e.getValue();
                for (Method lMethod : localClass.getDeclaredMethods()) {
                    for (Method rMethod : remoteClass.getDeclaredMethods()) {
                        if (!lMethod.getName().equals(rMethod.getName()) || lMethod.getParameterCount() != rMethod.getParameterCount()) continue;
                        this.mMapper.put(lMethod, rMethod);
                    }
                }
            });
        }

        @Override
        public Object invoke(Object proxy, Method lMethod, Object[] args) throws Throwable {
            if (debug) {
                System.out.println("Calling invoke with lMethod " + lMethod);
            }
            Method rMethod = this.mMapper.get(lMethod);
            if (debug) {
                System.out.println("Calling invoke with rMethod " + rMethod);
            }
            return rMethod.invoke(this.unknownObject, args);
        }
    }
}

