/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.apache.commons.text.StringSubstitutor;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.template.compiler.CompilerClient;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.StatementCompilerAction;
import org.openprovenance.prov.template.expander.ExpandAction;
import org.openprovenance.prov.template.expander.ExpandUtil;

public class CompilerBuilder {
    private final CompilerClient compilerClient;
    private final boolean withMain;
    private final CompilerUtil compilerUtil = new CompilerUtil();
    private final ProvFactory pFactory;

    public CompilerBuilder(boolean withMain, CompilerClient compilerClient, ProvFactory pFactory) {
        this.compilerClient = compilerClient;
        this.pFactory = pFactory;
        this.withMain = withMain;
    }

    public JavaFile generateBuilderSpecification(Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generateBuilderSpecification_aux(doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema);
    }

    JavaFile generateBuilderSpecification_aux(Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        TypeSpec.Builder builder = this.compilerUtil.generateClassBuilder2(name);
        Hashtable<QualifiedName, String> vmap = this.generateQualifiedNames(doc, builder);
        builder.addMethod(this.compilerUtil.generateConstructor2(vmap));
        builder.addMethod(this.generateTemplateGenerator(allVars, allAtts, doc, vmap, bindings_schema));
        builder.addMethod(this.compilerClient.nameAccessorGenerator(templateName));
        builder.addMethod(this.compilerClient.clientAccessorGenerator(templateName, packge + ".client"));
        if (this.withMain) {
            builder.addMethod(this.generateMain(allVars, allAtts, name, bindings_schema));
        }
        if (bindings_schema != null) {
            builder.addMethod(this.generateFactoryMethod(allVars, allAtts, name, bindings_schema));
            builder.addMethod(this.generateFactoryMethodWithArray(allVars, allAtts, name, bindings_schema));
        }
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox ($N) for template $N", new Object[]{this.getClass().getName(), templateName}).build();
        return myfile;
    }

    public MethodSpec generateTemplateGenerator(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, Document doc, Hashtable<QualifiedName, String> vmap, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"generator").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Document.class).addStatement("$T nullqn = null", new Object[]{QualifiedName.class}).addStatement("$T attrs=null", new Object[]{StatementCompilerAction.cl_collectionOfAttributes}).addStatement("$T __C_document = pf.newDocument()", new Object[]{Document.class});
        for (QualifiedName qualifiedName : allVars) {
            builder.addParameter(QualifiedName.class, qualifiedName.getLocalPart(), new Modifier[0]);
        }
        for (QualifiedName qualifiedName : allAtts) {
            if (allVars.contains(qualifiedName)) continue;
            builder.addParameter(Object.class, qualifiedName.getLocalPart(), new Modifier[0]);
        }
        for (QualifiedName qualifiedName : allVars) {
            if (!ExpandUtil.isGensymVariable((QualifiedName)qualifiedName)) continue;
            String vgen = qualifiedName.getLocalPart();
            builder.addStatement("if ($N==null) $N=$T.getUUIDQualifiedName2(pf)", new Object[]{vgen, vgen, ExpandAction.class});
        }
        StatementCompilerAction action = new StatementCompilerAction(this.pFactory, allVars, allAtts, vmap, builder, "__C_document.getStatementOrBundle()", bindings_schema);
        for (StatementOrBundle s : doc.getStatementOrBundle()) {
            CompilerUtil.u.doAction(s, (StatementAction)action);
        }
        builder.addStatement("new $T().updateNamespaces(__C_document)", new Object[]{ProvUtilities.class});
        builder.addStatement("return __C_document", new Object[0]);
        MethodSpec methodSpec = builder.build();
        return methodSpec;
    }

    public Hashtable<QualifiedName, String> generateQualifiedNames(Document doc, TypeSpec.Builder builder) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> set = new HashSet<QualifiedName>();
        this.compilerUtil.allQualifiedNames(bun, set, this.pFactory);
        set.remove(this.pFactory.newQualifiedName("http://openprovenance.org/tmpl#", "label", "tmpl"));
        set.add(this.pFactory.getName().PROV_LABEL);
        Hashtable<QualifiedName, String> qnVariables = new Hashtable<QualifiedName, String>();
        for (QualifiedName qn : set) {
            if (ExpandUtil.isVariable((QualifiedName)qn)) continue;
            String v = this.variableForQualifiedName(qn);
            qnVariables.put(qn, v);
            builder.addField(QualifiedName.class, v, new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        }
        return qnVariables;
    }

    public String variableForQualifiedName(QualifiedName qn) {
        return "_Q_" + qn.getPrefix() + "_" + qn.getLocalPart();
    }

    public MethodSpec generateFactoryMethod(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, JsonNode bindings_schema) {
        JsonNode entry;
        String newName;
        String key;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"make").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Document.class).addStatement("$T __C_document = null", new Object[]{Document.class}).addStatement("$T __C_ns = new Namespace()", new Object[]{Namespace.class}).addStatement("$T subst= new StringSubstitutor(getVariableMap())", new Object[]{StringSubstitutor.class});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        this.compilerUtil.generateSpecializedParameters(builder, the_var);
        Iterator iter2 = the_context.fieldNames();
        while (iter2.hasNext()) {
            String prefix = (String)iter2.next();
            String uri = the_context.get(prefix).textValue();
            builder.addStatement("__C_ns.register($S,subst.replace($S))", new Object[]{prefix, uri});
        }
        Object args = "";
        boolean first = true;
        HashSet<String> seen = new HashSet<String>();
        for (QualifiedName q : allVars) {
            key = q.getLocalPart();
            seen.add(key);
            newName = this.compilerUtil.varPrefix(key);
            entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode)) {
                String s = entry.get(0).get("@id").textValue();
                JsonNode toEscapeEntry = entry.get(0).get("@escape");
                boolean toEscape = toEscapeEntry != null && toEscapeEntry.textValue() != null && "true".equals(toEscapeEntry.textValue());
                String s2 = "\"" + s.replace("*", "\" + $N + \"") + "\"";
                if (toEscape) {
                    builder.addStatement("$T $N=($N==null)?null:__C_ns.stringToQualifiedName(" + s2 + ",pf,false)", new Object[]{QualifiedName.class, newName, key, key});
                } else {
                    builder.addStatement("$T $N=($N==null)?null:__C_ns.stringToQualifiedName(" + s2 + ",pf)", new Object[]{QualifiedName.class, newName, key, key});
                }
            } else {
                builder.addStatement("$T $N=null", new Object[]{QualifiedName.class, newName});
            }
            if (first) {
                first = false;
                args = newName;
                continue;
            }
            args = (String)args + ", " + newName;
        }
        for (QualifiedName q : allAtts) {
            JsonNode jentry;
            newName = key = q.getLocalPart();
            if (seen.contains(key)) continue;
            entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode) && (jentry = entry.get(0).get("@id")) != null) {
                String s = jentry.textValue();
                String s2 = "\"" + s.replace("*", "\" + $N + \"") + "\"";
                newName = this.compilerUtil.attPrefix(key);
                builder.addStatement("$T $N=($N==null)?null:__C_ns.stringToQualifiedName(" + s2 + ",pf)", new Object[]{QualifiedName.class, newName, key, key});
            }
            if (first) {
                first = false;
                args = newName;
                continue;
            }
            args = (String)args + ", " + newName;
        }
        builder.addStatement("__C_document = generator(" + (String)args + ")", new Object[0]);
        builder.addStatement("return __C_document", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateFactoryMethodWithArray(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"make").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Document.class);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addParameter(Object[].class, "record", new Modifier[0]);
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String statement;
            String key = (String)iter.next();
            Class<?> atype = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
            String converter = this.compilerUtil.getConverterForDeclaredType(atype);
            if (converter == null) {
                statement = "$T $N=($T) record[" + count + "]";
                builder.addStatement(statement, new Object[]{atype, key, atype});
            } else {
                statement = "$T $N=$N(record[" + count + "])";
                builder.addStatement(statement, new Object[]{atype, key, converter});
            }
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return make(" + (String)args + ")", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    /*
     * WARNING - void declaration
     */
    public MethodSpec generateMain(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, JsonNode bindings_schema) {
        void var7_14;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"main").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Void.TYPE).addParameter(String[].class, "args", new Modifier[0]).addStatement("$T pf=org.openprovenance.prov.interop.InteropFramework.getDefaultFactory()", new Object[]{ProvFactory.class}).addStatement("$N me=new $N(pf)", new Object[]{name, name});
        for (QualifiedName qualifiedName : allVars) {
            builder.addStatement("$T $N=pf.newQualifiedName($S,$S,$S)", new Object[]{QualifiedName.class, this.compilerUtil.varPrefix(qualifiedName.getLocalPart()), "http://example.org/", qualifiedName.getLocalPart(), "ex"});
        }
        JsonNode the_var2 = bindings_schema == null ? null : bindings_schema.get("var");
        for (QualifiedName q : allAtts) {
            String declaredType = null;
            if (the_var2 != null) {
                Iterator iter = the_var2.fieldNames();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    if (!q.getLocalPart().equals(key)) continue;
                    declaredType = this.compilerUtil.getDeclaredType(the_var2, key);
                }
            }
            Iterator<QualifiedName> example = this.compilerUtil.generateExampleForType(declaredType, q.getLocalPart(), this.pFactory);
            builder.addStatement("$T $N=$S", new Object[]{String.class, this.compilerUtil.attPrefix(q.getLocalPart()), example});
        }
        String string = "";
        boolean first = true;
        HashSet<String> seen = new HashSet<String>();
        for (QualifiedName q : allVars) {
            if (first) {
                first = false;
                String string2 = this.compilerUtil.varPrefix(q.getLocalPart());
            } else {
                void var7_10;
                String string3 = (String)var7_10 + ", " + this.compilerUtil.varPrefix(q.getLocalPart());
            }
            seen.add(q.getLocalPart());
        }
        for (QualifiedName q : allAtts) {
            if (seen.contains(q.getLocalPart())) continue;
            String key = this.compilerUtil.attPrefix(q.getLocalPart());
            if (first) {
                first = false;
                String string4 = key;
                continue;
            }
            String string5 = (String)var7_14 + ", " + key;
        }
        builder.addStatement("$T document=me.generator(" + (String)var7_14 + ")", new Object[]{Document.class});
        builder.addStatement("new org.openprovenance.prov.interop.InteropFramework().writeDocument(System.out,org.openprovenance.prov.interop.Formats.ProvFormat.PROVN,document)", new Object[0]);
        if (bindings_schema != null) {
            void var7_18;
            JsonNode the_var = bindings_schema.get("var");
            Iterator iter = the_var.fieldNames();
            String string6 = "";
            first = true;
            int count = 0;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (first) {
                    first = false;
                    String string7 = this.compilerUtil.createExamplar(the_var, key, count++, this.pFactory);
                    continue;
                }
                String string8 = (String)var7_18 + ", " + this.compilerUtil.createExamplar(the_var, key, count++, this.pFactory);
            }
            builder.addStatement("document=me.make(" + (String)var7_18 + ")", new Object[0]);
            builder.addStatement("new org.openprovenance.prov.interop.InteropFramework().writeDocument(System.out,org.openprovenance.prov.interop.Formats.ProvFormat.PROVN,document)", new Object[0]);
        }
        MethodSpec method = builder.build();
        return method;
    }
}

