/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.JavaFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerBuilder;
import org.openprovenance.prov.template.compiler.CompilerBuilderInit;
import org.openprovenance.prov.template.compiler.CompilerClient;
import org.openprovenance.prov.template.compiler.CompilerClientTest;
import org.openprovenance.prov.template.compiler.CompilerDocumentation;
import org.openprovenance.prov.template.compiler.CompilerJsonSchema;
import org.openprovenance.prov.template.compiler.CompilerLogger;
import org.openprovenance.prov.template.compiler.CompilerMaven;
import org.openprovenance.prov.template.compiler.CompilerProcessor;
import org.openprovenance.prov.template.compiler.CompilerSQL;
import org.openprovenance.prov.template.compiler.CompilerSimpleBean;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.TemplatesCompilerConfig;

public class ConfigProcessor {
    public static final String PREFIX_LOG_VAR = "___";
    public static final String GET_NODES_METHOD = "getNodes";
    public static final String BUILDER_INTERFACE = "Builder";
    public static final String INIT = "Init";
    public static final String BUILDERS = "builders";
    public static final String PF = "pf";
    public static final String GET_SUCCESSOR_METHOD = "getSuccessors";
    public static final String GET_NAME = "getName";
    public static final String LOGGER_INTERFACE = "LoggerInterface";
    public static final String PROCESSOR_ARGS_INTERFACE = "ProcessorArgsInterface";
    public static final String TESTER_FILE = "ExampleTest";
    public static final String GET_BUILDERS_METHOD = "getBuilders";
    public static final String CLIENT_PACKAGE = "org.openprovenance.prov.client";
    public static final String RECORD_CSV_PROCESSOR_METHOD = "record2csv";
    public static final String ARGS_CSV_CONVERSION_METHOD = "args2csv";
    public static final String BEAN_SQL_CONVERSION_METHOD = "bean2sql";
    public static final String PROCESSOR_CONVERTER = "processorConverter";
    public static final String ARGS2RECORD_CONVERTER = "aArgs2RecordConverter";
    public static final String A_BEAN_SQL_CONVERTER = "aBean2SqlConverter";
    public static final String A_ARGS_BEAN_CONVERTER = "aArgs2BeanConverter";
    public static final String A_ARGS_CSV_CONVERTER = "aArgs2CsVConverter";
    public static final String A_RECORD_BEAN_CONVERTER = "aRecord2BeanConverter";
    public static final String A_RECORD_CSV_CONVERTER = "aRecord2CsvConverter";
    public static final String A_RECORD_SQL_CONVERTER = "aRecord2SqlConverter";
    public static final String BUILDER = "Builder";
    private final ProvFactory pFactory;
    private final CompilerSQL compilerSQL;
    boolean withMain = true;
    public static final ObjectMapper objectMapper = new ObjectMapper();
    private final CompilerUtil compilerUtil = new CompilerUtil();
    private final CompilerLogger compilerLogger = new CompilerLogger();
    private final CompilerMaven compilerMaven = new CompilerMaven(this);
    private final CompilerDocumentation compilerDocumentation = new CompilerDocumentation();
    private final CompilerClient compilerClient;
    private final CompilerBuilder compilerBuilder;
    private final CompilerBuilderInit compilerBuilderInit;
    private final CompilerSimpleBean compilerSimpleBean;
    private final CompilerProcessor compilerProcessor;
    private final CompilerJsonSchema compilerJsonSchema;
    private final CompilerClientTest compilerClientTest;
    final String compilerVersion = this.readCompilerVersion();

    public ConfigProcessor(ProvFactory pFactory) {
        this.pFactory = pFactory;
        this.compilerSQL = new CompilerSQL();
        this.compilerClient = new CompilerClient(pFactory, this.compilerSQL);
        this.compilerBuilder = new CompilerBuilder(this.withMain, this.compilerClient, pFactory);
        this.compilerBuilderInit = new CompilerBuilderInit(pFactory);
        this.compilerSimpleBean = new CompilerSimpleBean(pFactory);
        this.compilerProcessor = new CompilerProcessor(pFactory);
        this.compilerJsonSchema = new CompilerJsonSchema();
        this.compilerClientTest = new CompilerClientTest();
    }

    public String readCompilerVersion() {
        return Configuration.getPropertiesFromClasspath(this.getClass(), (String)"compiler.properties").getProperty("compiler.version");
    }

    public int processTemplateGenerationConfig(String template_builder, ProvFactory pFactory) {
        try {
            TemplatesCompilerConfig configs = (TemplatesCompilerConfig)objectMapper.readValue(new File(template_builder), TemplatesCompilerConfig.class);
            String root_dir = configs.destination + "/" + configs.name;
            new File(root_dir).mkdirs();
            String cli_lib = configs.name + "_cli";
            String cli_dir = root_dir + "/" + cli_lib;
            new File(cli_dir).mkdirs();
            String l2p_lib = configs.name + "_l2p";
            String l2p_dir = root_dir + "/" + l2p_lib;
            new File(l2p_dir).mkdirs();
            String l2p_src_dir = l2p_dir + "/src/main/java";
            String l2p_test_src_dir = l2p_dir + "/src/test/java";
            String cli_src_dir = cli_dir + "/src/main/java";
            String cli_test_src_dir = cli_dir + "/src/test/java";
            String cli_webjar_dir = cli_dir + "/src/main/resources/META-INF/resources/webjars/" + configs.name + "_cli/" + configs.version;
            String cli_webjar_bindings_dir = cli_webjar_dir + "/bindings";
            String cli_webjar_templates_dir = cli_webjar_dir + "/templates";
            new File(l2p_src_dir).mkdirs();
            new File(cli_src_dir).mkdirs();
            new File(l2p_test_src_dir).mkdirs();
            new File(cli_test_src_dir).mkdirs();
            new File(cli_webjar_dir).mkdirs();
            new File(cli_webjar_bindings_dir).mkdirs();
            new File(cli_webjar_templates_dir).mkdirs();
            for (TemplateCompilerConfig config : configs.templates) {
                System.out.println(config.toString());
                this.doGenerateServerForEntry(config, configs, cli_src_dir, l2p_src_dir, pFactory, cli_webjar_dir);
                FileUtils.copyFileToDirectory((File)new File(config.template), (File)new File(cli_webjar_templates_dir));
                FileUtils.copyFileToDirectory((File)new File(config.bindings), (File)new File(cli_webjar_bindings_dir));
            }
            this.generateJSonSchemaEnd(configs, cli_src_dir);
            this.generateSQLEnd(configs, cli_src_dir);
            this.generateDocumentationEnd(configs, cli_src_dir);
            this.doGenerateProject(configs, root_dir, cli_lib, l2p_lib, l2p_dir, l2p_src_dir, l2p_test_src_dir, cli_test_src_dir, cli_webjar_dir);
            this.doGenerateClientAndProject(configs, cli_lib, cli_dir, cli_src_dir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void generateJSonSchemaEnd(TemplatesCompilerConfig configs, String cli_src_dir) {
        if (configs.jsonschema != null) {
            this.compilerJsonSchema.generateJSonSchemaEnd(configs.jsonschema, cli_src_dir + "/../resources");
        }
    }

    public void generateSQLEnd(TemplatesCompilerConfig configs, String cli_src_dir) {
        if (configs.sqlFile != null) {
            this.compilerSQL.generateSQLEnd(configs.sqlFile, cli_src_dir + "/../resources");
        }
    }

    public void generateDocumentationEnd(TemplatesCompilerConfig configs, String cli_webjar_dir) {
        if (configs.documentation != null) {
            this.compilerDocumentation.generateDocumentationEnd(configs, cli_webjar_dir);
        }
    }

    public void doGenerateProject(TemplatesCompilerConfig configs, String root_dir, String cli_lib, String l2p_lib, String l2p_dir, String l2p_src_dir, String l2p_test_src_dir, String cli_test_src_dir, String cli_webjar_dir) {
        String init_dir = l2p_src_dir + "/" + configs.init_package.replace('.', '/') + "/";
        JavaFile init = this.compilerBuilderInit.generateInitializer(configs);
        this.compilerUtil.saveToFile(init_dir, init_dir + "Init.java", init);
        String l2p_test_dir = l2p_test_src_dir + "/" + configs.init_package.replace('.', '/') + "/";
        JavaFile testfile = this.compilerMaven.generateTestFile_l2p(configs);
        this.compilerUtil.saveToFile(l2p_test_dir, l2p_test_dir + "ExampleTest.java", testfile);
        this.compilerMaven.makeRootPom(configs, root_dir, cli_lib, l2p_lib);
        this.compilerMaven.makeSubPom(configs, l2p_dir, l2p_lib, true, false, false, false);
        String cli_test_dir = cli_test_src_dir + "/" + configs.init_package.replace('.', '/') + "/";
        JavaFile testfile2 = this.compilerClientTest.generateTestFile_cli(configs);
        this.compilerUtil.saveToFile(cli_test_dir, cli_test_dir + "ExampleTest.java", testfile2);
    }

    public void doGenerateClientAndProject(TemplatesCompilerConfig configs, String cli_lib, String cli_dir, String cli_src_dir) {
        String logger_dir = cli_src_dir + "/" + configs.logger_package.replace('.', '/') + "/";
        String openprovenance_dir = cli_src_dir + "/" + CLIENT_PACKAGE.replace('.', '/') + "/";
        this.compilerMaven.makeSubPom(configs, cli_dir, cli_lib, false, configs.jsweet, true, this.compilerClient.getFoundEscape());
        JavaFile logger = this.compilerLogger.generateLogger(configs);
        this.compilerUtil.saveToFile(logger_dir, logger_dir + configs.logger + ".java", logger);
        JavaFile intface = this.compilerLogger.generateBuilderInterface(configs);
        this.compilerUtil.saveToFile(openprovenance_dir, openprovenance_dir + "Builder.java", intface);
        JavaFile intface2 = this.compilerLogger.generateLoggerInterface(configs);
        this.compilerUtil.saveToFile(openprovenance_dir, openprovenance_dir + "LoggerInterface.java", intface2);
        JavaFile intface3 = this.compilerLogger.generateProcessorArgsInterface(configs);
        this.compilerUtil.saveToFile(openprovenance_dir, openprovenance_dir + "ProcessorArgsInterface.java", intface3);
        this.exportMiscFiles(configs, cli_dir, cli_lib);
        this.compilerMaven.generateScript(configs);
    }

    private void exportMiscFiles(TemplatesCompilerConfig configs, String cli_dir, String cli_lib) {
        String targetLocation;
        InputStream is;
        if (configs.jsweet) {
            is = this.getClass().getResourceAsStream("/js/TemplateManager.js");
            targetLocation = cli_dir + "/src/main/js";
            try {
                FileUtils.copyToFile((InputStream)is, (File)new File(targetLocation + "/TemplateManager.js"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        is = this.getClass().getResourceAsStream("/css/provtemplate.css");
        targetLocation = cli_dir + "/src/main/css";
        try {
            FileUtils.copyToFile((InputStream)is, (File)new File(targetLocation + "/provtemplate.css"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JsonNode readTree(File file) throws IOException {
        return objectMapper.readTree(file);
    }

    public Document readDocumentFromFile(TemplateCompilerConfig config) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.compilerUtil.readDocumentFromFile(config.template);
    }

    public void doGenerateServerForEntry(TemplateCompilerConfig config, TemplatesCompilerConfig configs, String cli_src_dir, String l2p_src_dir, ProvFactory pFactory, String cli_webjar_dir) {
        JsonNode bindings_schema = this.compilerUtil.get_bindings_schema(config);
        try {
            Document doc = this.readDocumentFromFile(config);
            this.generate(doc, config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", configs.sbean, configs.jsonschema, configs.documentation, bindings_schema, cli_webjar_dir);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("could not find Interop Framework");
            e.printStackTrace();
            System.out.println(Arrays.asList("doc", config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", bindings_schema));
        }
    }

    public void doGenerateServerForEntry1(Document doc, TemplateCompilerConfig config, TemplatesCompilerConfig configs, String cli_src_dir, String l2p_src_dir, String cli_webjar_dir) {
        JsonNode bindings_schema = this.compilerUtil.get_bindings_schema(config);
        try {
            this.generate(doc, config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", configs.sbean, configs.jsonschema, configs.documentation, bindings_schema, cli_webjar_dir);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public boolean generate(Document doc, String templateName, String packge, String cli_src_dir, String l2p_src_dir, String resource, boolean sbean, String jsonschema, String documentation, JsonNode bindings_schema, String cli_webjar_dir) {
        try {
            String bn = this.compilerUtil.templateNameClass(templateName);
            String bean = this.compilerUtil.beanNameClass(templateName);
            String processor = this.compilerUtil.processorNameClass(templateName);
            String destinationDir = l2p_src_dir + "/" + packge.replace('.', '/') + "/";
            String destinationDir2 = cli_src_dir + "/" + packge.replace('.', '/') + "/client/";
            String destination = destinationDir + bn + ".java";
            String destination2 = destinationDir2 + bn + ".java";
            String destinationSQL = destinationDir2 + "SQL.java";
            String destination3 = destinationDir2 + bean + ".java";
            String destination4 = destinationDir2 + processor + ".java";
            JavaFile spec = this.compilerBuilder.generateBuilderSpecification(doc, bn, templateName, packge, resource, bindings_schema);
            boolean val1 = this.compilerUtil.saveToFile(destinationDir, destination, spec);
            JavaFile spec2 = this.compilerClient.generateClientLib(doc, bn, templateName, packge + ".client", resource, bindings_schema);
            boolean val2 = this.compilerUtil.saveToFile(destinationDir2, destination2, spec2);
            JavaFile spec2b = this.compilerClient.generateSQLInterface(packge + ".client");
            boolean val2b = this.compilerUtil.saveToFile(destinationDir2, destinationSQL, spec2b);
            val2 &= val2b;
            boolean val3 = true;
            boolean val4 = true;
            if (sbean) {
                JavaFile spec3 = this.compilerSimpleBean.generateSimpleBean(doc, bean, templateName, packge + ".client", resource, bindings_schema);
                val3 = this.compilerUtil.saveToFile(destinationDir2, destination3, spec3);
                JavaFile spec4 = this.compilerProcessor.generateProcessor(doc, processor, templateName, packge + ".client", resource, bindings_schema);
                val4 = this.compilerUtil.saveToFile(destinationDir2, destination4, spec4);
                this.compilerJsonSchema.generateJSonSchema(jsonschema, templateName, cli_src_dir + "/../resources", bindings_schema);
                this.compilerSQL.generateSQL(jsonschema + "SQL", templateName, cli_src_dir + "/../sql", bindings_schema);
                String cli_webjar_html_dir = cli_webjar_dir + "/html";
                new File(cli_webjar_html_dir).mkdirs();
                this.compilerDocumentation.generateDocumentation(documentation, templateName, cli_webjar_html_dir, bindings_schema);
            }
            return val1 & val2 & val3 & val4;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public CompilerJsonSchema getCompilerJsonSchema() {
        return this.compilerJsonSchema;
    }
}

