/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Iterator;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.TemplatesCompilerConfig;

public class CompilerLogger {
    private final CompilerUtil compilerUtil = new CompilerUtil();

    JavaFile generateLogger(TemplatesCompilerConfig configs) {
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(configs.logger);
        builder.addSuperinterface((TypeName)ClassName.get((String)"org.openprovenance.prov.client", (String)"LoggerInterface", (String[])new String[0]));
        String packge = null;
        for (TemplateCompilerConfig config : configs.templates) {
            String templateNameClass = this.compilerUtil.templateNameClass(config.name);
            packge = config.package_ + ".client";
            ClassName className = ClassName.get((String)packge, (String)templateNameClass, (String[])new String[0]);
            FieldSpec fspec = FieldSpec.builder((TypeName)className, (String)("___" + config.name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("new $T()", new Object[]{className}).build();
            builder.addField(fspec);
        }
        Object names = "";
        boolean first = true;
        for (TemplateCompilerConfig templateCompilerConfig : configs.templates) {
            if (first) {
                first = false;
            } else {
                names = (String)names + ", ";
            }
            names = (String)names + "___" + templateCompilerConfig.name;
        }
        ClassName cln = ClassName.get((String)"org.openprovenance.prov.client", (String)"Builder", (String[])new String[0]);
        ArrayTypeName builderArrayType = ArrayTypeName.of((TypeName)cln);
        FieldSpec fspec = FieldSpec.builder((TypeName)builderArrayType, (String)"__builders", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("new $T[] {" + (String)names + "}", new Object[]{cln}).build();
        builder.addField(fspec);
        builder.addMethod(this.generateGetBuilderMethod(builderArrayType));
        for (TemplateCompilerConfig config : configs.templates) {
            builder.addMethod(this.generateStaticLogMethod(config));
            builder.addMethod(this.generateStaticBeanMethod(config));
        }
        TypeSpec typeSpec = builder.build();
        JavaFile myfile = JavaFile.builder((String)configs.logger_package, (TypeSpec)typeSpec).addFileComment("Generated Automatically by ProvToolbox ($N) for templates config $N", new Object[]{this.getClass().getName(), configs.name}).build();
        return myfile;
    }

    JavaFile generateBuilderInterface(TemplatesCompilerConfig configs) {
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInit("Builder");
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(int[].class);
        builder.addMethod(builder2.build());
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)"getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)CompilerUtil.hashmapType);
        builder.addMethod(builder3.build());
        MethodSpec.Builder builder4 = MethodSpec.methodBuilder((String)"getName").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class);
        builder.addMethod(builder4.build());
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"record2csv").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of(Object.class), (String)"record", (Modifier[])new Modifier[0]).build()).returns((TypeName)myType);
        builder.addMethod(builder5.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = JavaFile.builder((String)"org.openprovenance.prov.client", (TypeSpec)theInterface).addFileComment("Generated Automatically by ProvToolbox for templates config $S", new Object[]{configs.name}).build();
        return myfile;
    }

    JavaFile generateLoggerInterface(TemplatesCompilerConfig configs) {
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInit("LoggerInterface");
        ClassName cln = ClassName.get((String)"org.openprovenance.prov.client", (String)"Builder", (String[])new String[0]);
        ArrayTypeName builderArrayType = ArrayTypeName.of((TypeName)cln);
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"getBuilders").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)builderArrayType);
        builder.addMethod(builder2.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = JavaFile.builder((String)"org.openprovenance.prov.client", (TypeSpec)theInterface).addFileComment("Generated Automatically by ProvToolbox ($N) for templates config $S", new Object[]{this.getClass().getName(), configs.name}).build();
        return myfile;
    }

    public MethodSpec generateStaticLogMethod(TemplateCompilerConfig config) {
        String loggerName = this.compilerUtil.loggerName(config.name);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)loggerName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.STATIC}).returns(String.class);
        JsonNode bindings_schema = this.compilerUtil.get_bindings_schema(config);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        JsonNode the_documentation = bindings_schema.get("@documentation");
        JsonNode the_return = bindings_schema.get("@return");
        this.compilerUtil.generateSpecializedParameters(builder, the_var);
        this.compilerUtil.generateSpecializedParametersJavadoc(builder, the_var, the_documentation, the_return);
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return $N.$N().process(" + (String)args + ")", new Object[]{"___" + config.name, "args2csv"});
        return builder.build();
    }

    public MethodSpec generateStaticBeanMethod(TemplateCompilerConfig config) {
        String beanCreatorName = "bean" + this.compilerUtil.capitalize(config.name);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)beanCreatorName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.STATIC}).returns((TypeName)ClassName.get((String)(config.package_ + ".client"), (String)this.compilerUtil.beanNameClass(config.name), (String[])new String[0]));
        JsonNode bindings_schema = this.compilerUtil.get_bindings_schema(config);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        JsonNode the_documentation = bindings_schema.get("@documentation");
        JsonNode the_return = bindings_schema.get("@return");
        this.compilerUtil.generateSpecializedParameters(builder, the_var);
        this.compilerUtil.generateSpecializedParametersJavadoc(builder, the_var, the_documentation, the_return);
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return $N.$N.process(" + (String)args + ")", new Object[]{"___" + config.name, "aArgs2BeanConverter"});
        return builder.build();
    }

    public MethodSpec generateGetBuilderMethod(ArrayTypeName builderArrayType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getBuilders").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)builderArrayType);
        builder.addStatement("return __builders", new Object[0]);
        return builder.build();
    }

    public JavaFile generateProcessorArgsInterface(TemplatesCompilerConfig configs) {
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInitParameter("ProcessorArgsInterface", "T");
        Object[] args = new Object[]{};
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.get(args.getClass()), (String)"args", (Modifier[])new Modifier[0]).build()).returns((TypeName)TypeVariableName.get((String)"T"));
        builder.addMethod(builder2.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = JavaFile.builder((String)"org.openprovenance.prov.client", (TypeSpec)theInterface).addFileComment("Generated Automatically by ProvToolbox ($N) for templates config $S by class generateProcessorArgsInterface()", new Object[]{this.getClass().getName(), configs.name}).build();
        return myfile;
    }
}

