/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.apache.commons.text.CaseUtils;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.ValueConverter;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.TemplateCompilerConfig;
import org.openprovenance.prov.template.expander.ExpandUtil;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.template.log2prov.interfaces.ProxyClientAccessorInterface;

public class CompilerUtil {
    static final ProvUtilities u = new ProvUtilities();
    static final ParameterizedTypeName hashmapType = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(Integer.class), TypeName.get(int[].class)});

    public String capitalize(String templateName) {
        return templateName.substring(0, 1).toUpperCase() + templateName.substring(1);
    }

    public String templateNameClass(String templateName) {
        return this.capitalize(templateName) + "Builder";
    }

    public String beanNameClass(String templateName) {
        return this.capitalize(templateName) + "Bean";
    }

    public String processorNameClass(String templateName) {
        return this.capitalize(templateName) + "Processor";
    }

    public String loggerName(String template) {
        return "log" + this.capitalize(template);
    }

    public String sqlName(String template) {
        return "sqlTuple";
    }

    public void extractVariablesAndAttributes(Bundle bundle, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, ProvFactory pFactory) {
        for (Statement statement : bundle.getStatement()) {
            Set vars = ExpandUtil.freeVariables((Statement)statement);
            allVars.addAll(vars);
            allVars.addAll(ExpandUtil.freeVariables((Bundle)bundle));
            HashSet vars2 = ExpandUtil.freeAttributeVariables((Statement)statement, (ProvFactory)pFactory);
            allAtts.addAll(vars2);
        }
    }

    public TypeSpec.Builder generateClassInit(String name) {
        return TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassInitExtends(String name, String packge, String supername) {
        return TypeSpec.classBuilder((String)name).superclass((TypeName)ClassName.get((String)packge, (String)supername, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateInterfaceInit(String name) {
        return TypeSpec.interfaceBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateInterfaceInitParameter(String name, String type) {
        return TypeSpec.interfaceBuilder((String)name).addTypeVariable(TypeVariableName.get((String)type)).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassBuilder3(String name) {
        return TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassBuilder2(String name) {
        return TypeSpec.classBuilder((String)name).superclass(FileBuilder.class).addSuperinterface((TypeName)ClassName.get(ProxyClientAccessorInterface.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(ProvFactory.class, "pf", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(ValueConverter.class, "vc", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
    }

    public MethodSpec generateConstructor2(Hashtable<QualifiedName, String> vmap) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ProvFactory.class, "pf", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"pf", "pf"});
        for (Map.Entry<QualifiedName, String> e : vmap.entrySet()) {
            QualifiedName q = e.getKey();
            builder.addStatement("this.$N = pf.newQualifiedName($S,$S,$S)", new Object[]{e.getValue(), q.getNamespaceURI(), q.getLocalPart(), q.getPrefix()});
        }
        builder.addStatement("this.vc = new ValueConverter(pf)", new Object[0]);
        builder.addStatement("register(this)", new Object[0]);
        return builder.build();
    }

    public String camelcase(String s) {
        return CaseUtils.toCamelCase((String)s, (boolean)true, (char[])new char[0]);
    }

    public Set<QualifiedName> allQualifiedNames(Statement statement) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        for (int i = 0; i < ExpandUtil.getFirstTimeIndex((Statement)statement); ++i) {
            Object o = u.getter(statement, i);
            if (o instanceof QualifiedName) {
                QualifiedName name = (QualifiedName)o;
                result.add(name);
                continue;
            }
            if (!(o instanceof List)) continue;
            List ll = (List)o;
            for (QualifiedName name : ll) {
                result.add(name);
            }
        }
        return result;
    }

    public HashSet<QualifiedName> allQualifiedNamesInAttributes(Statement statement, ProvFactory pf) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        Collection ll = pf.getAttributes(statement);
        for (Attribute attr : ll) {
            result.add(attr.getElementName());
            if (attr.getType() != null) {
                result.add(attr.getType());
            }
            if (!(attr.getValue() instanceof QualifiedName)) continue;
            result.add((QualifiedName)attr.getValue());
        }
        return result;
    }

    public void allQualifiedNames(Bundle bundle, Set<QualifiedName> result, ProvFactory pFactory) {
        result.add(bundle.getId());
        for (Statement statement : bundle.getStatement()) {
            Set<QualifiedName> vars = this.allQualifiedNames(statement);
            result.addAll(vars);
            HashSet<QualifiedName> vars2 = this.allQualifiedNamesInAttributes(statement, pFactory);
            result.addAll(vars2);
        }
    }

    public Document readDocumentFromFile(String file) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object interop = this.getInteropFramework();
        Method method = interop.getClass().getMethod("readDocumentFromFile", String.class);
        Document doc = (Document)method.invoke(interop, file);
        return doc;
    }

    public void writeDocument(String file, Document doc) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object interop = this.getInteropFramework();
        Method method = interop.getClass().getMethod("writeDocument", String.class, Document.class);
        method.invoke(interop, file, doc);
    }

    public Object getInteropFramework() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = Class.forName("org.openprovenance.prov.interop.InteropFramework");
        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        return ctor.newInstance(new Object[0]);
    }

    public boolean saveToFile(String destinationDir, String destination, JavaFile spec) {
        try {
            File dir = new File(destinationDir);
            if (!dir.exists() && !dir.mkdirs()) {
                System.err.println("failed to create directory " + destinationDir);
                return false;
            }
            PrintWriter out = new PrintWriter(destination);
            out.print(spec);
            out.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public JsonNode get_bindings_schema(TemplateCompilerConfig config) {
        JsonNode bindings_schema = null;
        if (config.bindings != null) {
            try {
                bindings_schema = ConfigProcessor.objectMapper.readTree(new File(config.bindings));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bindings_schema;
    }

    public Class<?> getJavaTypeForDeclaredType(JsonNode the_var, String key) {
        if (the_var.get(key).get(0).get("@id") != null) {
            return String.class;
        }
        if (the_var.get(key).get(0).get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + the_var);
            throw new UnsupportedOperationException();
        }
        JsonNode hasType = the_var.get(key).get(0).get(0).get("@type");
        if (hasType != null) {
            String keyType;
            switch (keyType = hasType.textValue()) {
                case "xsd:int": {
                    return Integer.class;
                }
                case "xsd:long": {
                    return Long.class;
                }
                case "xsd:string": {
                    return String.class;
                }
                case "xsd:boolean": {
                    return Boolean.class;
                }
                case "xsd:float": {
                    return Float.class;
                }
                case "xsd:double": {
                    return Double.class;
                }
                case "xsd:dateTime": {
                    return String.class;
                }
            }
            throw new UnsupportedOperationException();
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + the_var);
        throw new UnsupportedOperationException();
    }

    public void generateSpecializedParameters(MethodSpec.Builder builder, JsonNode the_var) {
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            builder.addParameter(this.getJavaTypeForDeclaredType(the_var, key), key, new Modifier[0]);
        }
    }

    public void generateSpecializedParametersJavadoc(MethodSpec.Builder builder, JsonNode the_var, JsonNode the_documentation, JsonNode the_return) {
        String docString = this.noNode(the_documentation) ? "No @documentation." : the_documentation.textValue();
        String retString = this.noNode(the_return) ? "@return not documented." : the_return.textValue();
        builder.addJavadoc(docString, new Object[0]);
        builder.addJavadoc("\n\n", new Object[0]);
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            JsonNode entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode)) {
                JsonNode jsonNode;
                JsonNode firstNode = entry.get(0);
                if (firstNode instanceof ArrayNode) {
                    firstNode = ((ArrayNode)firstNode).get(0);
                }
                String documentation = this.noNode(jsonNode = firstNode.get("@documentation")) ? "-- no @documentation" : jsonNode.textValue();
                JsonNode jsonNode2 = firstNode.get("@type");
                String type = this.noNode(jsonNode2) ? "xsd:string" : jsonNode2.textValue();
                builder.addJavadoc("@param $N $L (expected type: $L)\n", new Object[]{key, documentation, type});
                continue;
            }
            builder.addJavadoc("@param $N -- no bindings schemas \n", new Object[]{key});
        }
        builder.addJavadoc(retString, new Object[0]);
    }

    public boolean noNode(JsonNode jsonNode2) {
        return jsonNode2 == null || jsonNode2 instanceof MissingNode || jsonNode2 instanceof NullNode;
    }

    public String generateExampleForType(String declaredType, String localPart, ProvFactory pFactory) {
        if (declaredType == null) {
            return "test_" + localPart;
        }
        switch (declaredType) {
            case "xsd:dateTime": {
                return pFactory.newTimeNow().toXMLFormat();
            }
            case "xsd:float": {
                return "123.00f";
            }
            case "xsd:int": {
                return "12345";
            }
        }
        return "test_" + localPart;
    }

    public String createExamplar(JsonNode the_var, String key, int num, ProvFactory pFactory) {
        if (the_var.get(key).get(0).get("@id") != null) {
            return "\"v" + num + "\"";
        }
        if (the_var.get(key).get(0).get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + the_var);
            throw new UnsupportedOperationException();
        }
        JsonNode hasType = the_var.get(key).get(0).get(0).get("@type");
        if (hasType != null) {
            String keyType;
            switch (keyType = hasType.textValue()) {
                case "xsd:int": {
                    return "" + num;
                }
                case "xsd:long": {
                    return num + "L";
                }
                case "xsd:string": {
                    return "\"v" + num + "\"";
                }
                case "xsd:boolean": {
                    return "true";
                }
                case "xsd:float": {
                    return num + ".01f";
                }
                case "xsd:double": {
                    return num + ".01d";
                }
                case "xsd:dateTime": {
                    return "\"" + pFactory.newTimeNow().toXMLFormat() + "\"";
                }
            }
            throw new UnsupportedOperationException();
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + the_var);
        throw new UnsupportedOperationException();
    }

    public String getDeclaredType(JsonNode the_var, String key) {
        if (the_var.get(key).get(0).get("@id") != null) {
            return "prov:QualifiedName";
        }
        if (the_var.get(key).get(0).get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + the_var);
            throw new UnsupportedOperationException();
        }
        JsonNode hasType = the_var.get(key).get(0).get(0).get("@type");
        if (hasType != null) {
            String keyType = hasType.textValue();
            return keyType;
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + the_var);
        throw new UnsupportedOperationException();
    }

    public String varPrefix(String localPart) {
        return "__var_" + localPart;
    }

    public String attPrefix(String localPart) {
        return "__att_" + localPart;
    }

    public String getConverterForDeclaredType2(Class cl) {
        if (cl != null) {
            String keyType;
            switch (keyType = cl.getName()) {
                case "java.lang.Integer": {
                    return "Integer.valueOf";
                }
                case "java.lang.Long": {
                    return "Long.valueOf";
                }
                case "java.lang.String": {
                    return null;
                }
                case "java.lang.Boolean": {
                    return "Boolean.valueOf";
                }
                case "java.lang.Float": {
                    return "Float.valueOf";
                }
                case "java.lang.Double": {
                    return "Double.valueOf";
                }
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public String getConverterForDeclaredType(Class cl) {
        if (cl != null) {
            String keyType;
            switch (keyType = cl.getName()) {
                case "java.lang.Integer": {
                    return "toInt";
                }
                case "java.lang.Long": {
                    return "toLong";
                }
                case "java.lang.String": {
                    return null;
                }
                case "java.lang.Boolean": {
                    return "toBoolean";
                }
                case "java.lang.Float": {
                    return "toFloat";
                }
                case "java.lang.Double": {
                    return "toDouble";
                }
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }
}

