/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.expansion;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.MethodSpec;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;
import org.openprovenance.prov.template.compiler.expansion.CompilerExpansionBuilder;
import org.openprovenance.prov.template.expander.ExpandUtil;
import org.openprovenance.prov.template.expander.MissingAttributeValue;

public class StatementTypeAction
implements StatementAction {
    public static String AGENT_URI = "http://www.w3.org/ns/prov#Agent";
    public static String ENTITY_URI = "http://www.w3.org/ns/prov#Entity";
    public static String ACTIVITY_URI = "http://www.w3.org/ns/prov#Activity";
    public static String BUNDLE_URI = "http://www.w3.org/ns/prov#Bundle";
    public static String WASDERIVEDFROM_URI = "http://www.w3.org/ns/prov#WasDerivedFrom";
    private final JsonNode bindings_schema;
    private final Map<String, Collection<String>> knownTypes;
    private final Map<String, Collection<String>> unknownTypes;
    private final MethodSpec.Builder mbuilder;
    private Set<QualifiedName> allVars;
    private Set<QualifiedName> allAtts;
    private ProvFactory pFactory;
    private Hashtable<QualifiedName, String> vmap;
    public static String bnNS = "http://openprovenance.org/blank#";
    public static String bnPrefix = "bn";
    static int count = 0;

    public StatementTypeAction(ProvFactory pFactory, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, Hashtable<QualifiedName, String> vmap, MethodSpec.Builder builder, String target, JsonNode bindings_schema, Map<String, Collection<String>> knownTypes, Map<String, Collection<String>> unknownTypes, MethodSpec.Builder mbuilder) {
        this.pFactory = pFactory;
        this.allVars = allVars;
        this.allAtts = allAtts;
        this.vmap = vmap;
        this.bindings_schema = bindings_schema;
        this.knownTypes = knownTypes;
        this.unknownTypes = unknownTypes;
        this.mbuilder = mbuilder;
    }

    public Map<String, Collection<String>> getKnownTypes() {
        return this.knownTypes;
    }

    public Map<String, Collection<String>> getUnknownTypes() {
        return this.unknownTypes;
    }

    public void registerTypes(QualifiedName id, List<Type> types) {
        if (id != null) {
            types.forEach(type -> {
                Object o = type.getValue();
                if (o instanceof QualifiedName) {
                    QualifiedName qn = (QualifiedName)o;
                    if (ExpandUtil.isVariable((QualifiedName)qn)) {
                        this.registerUnknownType(id, qn.getUri());
                    } else {
                        this.registerAType(id, qn.getUri());
                    }
                }
            });
        }
    }

    public void registerTypes(QualifiedName id, String suffix, List<Type> types) {
        if (id != null) {
            types.forEach(type -> {
                Object o = type.getValue();
                if (o instanceof QualifiedName) {
                    QualifiedName qn = (QualifiedName)o;
                    if (ExpandUtil.isVariable((QualifiedName)qn)) {
                        this.registerUnknownType(id, suffix, qn.getUri());
                    } else {
                        this.registerAType(id, suffix, qn.getUri());
                    }
                }
            });
        }
    }

    public void registerTypes2(QualifiedName id, Collection<QualifiedName> types) {
        if (id != null && types != null) {
            types.forEach(qn -> {
                if (ExpandUtil.isVariable((QualifiedName)qn)) {
                    this.registerUnknownType(id, qn.getUri());
                } else {
                    this.registerAType(id, qn.getUri());
                }
            });
        }
    }

    public void registerTypes2(QualifiedName id, String suffix, Collection<QualifiedName> types) {
        if (id != null && types != null) {
            types.forEach(qn -> {
                if (ExpandUtil.isVariable((QualifiedName)qn)) {
                    this.registerUnknownType(id, suffix, qn.getUri());
                } else {
                    this.registerAType(id, suffix, qn.getUri());
                }
            });
        }
    }

    public void registerAgent(QualifiedName id) {
        this.registerAType(id, AGENT_URI);
    }

    public void registerEntity(QualifiedName id) {
        this.registerAType(id, ENTITY_URI);
    }

    public void registerActivity(QualifiedName id) {
        this.registerAType(id, ACTIVITY_URI);
    }

    public void registerBundle(QualifiedName id) {
        this.registerAType(id, BUNDLE_URI);
    }

    private void registerAType(QualifiedName id, String type) {
        if (id != null) {
            String uri = id.getUri();
            this.knownTypes.computeIfAbsent(uri, k -> new HashSet());
            this.knownTypes.get(uri).add(type);
        }
    }

    private void registerAType(QualifiedName id, String suffix, String type) {
        if (id != null) {
            String uri = id.getUri() + suffix;
            this.knownTypes.computeIfAbsent(uri, k -> new HashSet());
            this.knownTypes.get(uri).add(type);
        }
    }

    private void registerUnknownType(QualifiedName id, String type) {
        if (id != null) {
            String uri = id.getUri();
            this.unknownTypes.computeIfAbsent(uri, k -> new HashSet());
            this.unknownTypes.get(uri).add(type);
        }
    }

    private void registerUnknownType(QualifiedName id, String suffix, String type) {
        if (id != null) {
            String uri = id.getUri() + suffix;
            this.unknownTypes.computeIfAbsent(uri, k -> new HashSet());
            this.unknownTypes.get(uri).add(type);
        }
    }

    public void doAction(Activity s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getId());
    }

    public void doAction(Used s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getEntity());
    }

    public void doAction(WasGeneratedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getEntity());
    }

    public void doAction(WasInvalidatedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getEntity());
    }

    public void doAction(WasStartedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getStarter());
        this.registerEntity(s.getTrigger());
    }

    public void doAction(Agent s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerAgent(s.getId());
    }

    public void doAction(AlternateOf s) {
    }

    public void doAction(WasAssociatedWith s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerAgent(s.getAgent());
        this.registerEntity(s.getPlan());
    }

    public void doAction(WasAttributedTo s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerAgent(s.getAgent());
        this.registerEntity(s.getEntity());
    }

    public void doAction(WasInfluencedBy s) {
        this.registerTypes(s.getId(), s.getType());
    }

    public void doAction(ActedOnBehalfOf s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerAgent(s.getResponsible());
        this.registerAgent(s.getDelegate());
        this.registerActivity(s.getActivity());
    }

    public Collection<QualifiedName> doCollectElementVariables(Statement s, String search) {
        return CompilerExpansionBuilder.doCollectElementVariables(this.pFactory, s, search);
    }

    public static QualifiedName gensym() {
        return new org.openprovenance.prov.vanilla.QualifiedName(bnNS, "n" + count++, bnPrefix);
    }

    public void doAction(WasDerivedFrom s) {
        Collection<QualifiedName> qualifiedNames = this.doCollectElementVariables((Statement)s, "http://openprovenance.org/tmpl#activityType");
        if (s.getId() == null) {
            s.setId(StatementTypeAction.gensym());
        }
        this.mbuilder.addComment("wdf $N", new Object[]{s.getId().getUri()});
        this.registerAType(s.getId(), WASDERIVEDFROM_URI);
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getUsedEntity());
        this.registerEntity(s.getGeneratedEntity());
        this.registerActivity(s.getActivity());
        if (qualifiedNames != null && !qualifiedNames.isEmpty()) {
            this.registerTypes2(s.getId(), qualifiedNames);
            this.dynamicRegisterTypes((Identifiable)s, qualifiedNames);
        }
    }

    private void dynamicRegisterTypes(Identifiable s, Collection<QualifiedName> qualifiedNames) {
        if (qualifiedNames == null) {
            return;
        }
        String tmp = "_tmp_" + s.getId().getLocalPart();
        Collection<QualifiedName> activities = this.doCollectElementVariables((Statement)s, "http://openprovenance.org/tmpl#activity");
        if (activities == null || activities.isEmpty()) {
            throw new MissingAttributeValue("http://openprovenance.org/tmpl#activity in relation " + s);
        }
        String localPart = s.getId().getLocalPart() + ".";
        String suffix = activities.stream().findFirst().get().getLocalPart();
        this.mbuilder.addStatement("$T $N=pf.newQualifiedName($S,$S+$N.getLocalPart(),$S)", new Object[]{QualifiedName.class, tmp, s.getId().getNamespaceURI(), localPart, suffix, s.getId().getPrefix()});
        this.mbuilder.addStatement("knownTypeMap.computeIfAbsent($N, k -> new $T<>())", new Object[]{tmp, HashSet.class});
        this.mbuilder.addStatement("knownTypeMap.get($N).add($S)", new Object[]{tmp, WASDERIVEDFROM_URI});
        qualifiedNames.forEach(q -> {
            if (ExpandUtil.isVariable((QualifiedName)q)) {
                this.mbuilder.addStatement("unknownTypeMap.computeIfAbsent($N, k -> new $T<>())", new Object[]{tmp, HashSet.class});
                this.mbuilder.addStatement("unknownTypeMap.get($N).add($N.getUri())", new Object[]{tmp, q.getLocalPart()});
            } else {
                this.mbuilder.addStatement("knownTypeMap.get($N).add($S)", new Object[]{tmp, q.getUri()});
            }
        });
    }

    public void doAction(DictionaryMembership s) {
    }

    public void doAction(DerivedByRemovalFrom s) {
    }

    public void doAction(WasEndedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getEnder());
        this.registerEntity(s.getTrigger());
    }

    public void doAction(Entity s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getId());
    }

    public void doAction(HadMember s) {
        this.registerEntity(s.getCollection());
        s.getEntity().forEach(this::registerEntity);
    }

    public void doAction(MentionOf s) {
    }

    public void doAction(SpecializationOf s) {
        this.registerEntity(s.getGeneralEntity());
        this.registerEntity(s.getSpecificEntity());
    }

    public void doAction(QualifiedSpecializationOf s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getGeneralEntity());
        this.registerEntity(s.getSpecificEntity());
    }

    public void doAction(QualifiedAlternateOf s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getAlternate1());
        this.registerEntity(s.getAlternate2());
    }

    public void doAction(QualifiedHadMember s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getCollection());
        s.getEntity().forEach(this::registerEntity);
    }

    public void doAction(DerivedByInsertionFrom s) {
    }

    public void doAction(WasInformedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getInformant());
        this.registerActivity(s.getInformed());
    }

    public void doAction(Bundle bun, ProvUtilities provUtilities) {
        this.registerBundle(bun.getId());
        StatementTypeAction action2 = new StatementTypeAction(this.pFactory, this.allVars, this.allAtts, this.vmap, null, null, this.bindings_schema, this.knownTypes, this.unknownTypes, this.mbuilder);
        for (Statement s : bun.getStatement()) {
            provUtilities.doAction((StatementOrBundle)s, (StatementAction)action2);
        }
    }
}

