/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.expansion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.template.compiler.CompilerClient;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.expansion.StatementTypeAction;

public class CompilerTypeManagement {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    private final ProvFactory pFactory;
    private final boolean withMain;
    private final CompilerClient compilerClient;
    private final boolean debugComment;
    private Map<String, Collection<String>> knownTypes;
    private Map<String, Collection<String>> unknownTypes;
    public static final ParameterizedTypeName Map_QN_S_of_String = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(QualifiedName.class), ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{TypeName.get(String.class)})});
    public static final ParameterizedTypeName Map_S_Map_S_to_Function = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{TypeName.get(Object.class), TypeName.get(String.class)})})});
    public static final ParameterizedTypeName Map_S_to_Function = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{TypeName.get(Object.class), TypeName.get(String.class)})});
    public static final ParameterizedTypeName Function_O_S = ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{TypeName.get(Object.class), TypeName.get(String.class)});

    public CompilerTypeManagement(boolean withMain, CompilerClient compilerClient, ProvFactory pFactory, boolean debugComment) {
        this.pFactory = pFactory;
        this.withMain = withMain;
        this.compilerClient = compilerClient;
        this.debugComment = debugComment;
    }

    public JavaFile generateTypeDeclaration(Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        this.knownTypes = new HashMap<String, Collection<String>>();
        this.unknownTypes = new HashMap<String, Collection<String>>();
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generateTypeDeclaration_aux(doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema);
    }

    public Map<String, Collection<String>> getKnownTypes() {
        return this.knownTypes;
    }

    public Map<String, Collection<String>> getUnknownTypes() {
        return this.unknownTypes;
    }

    public JavaFile generateTypeDeclaration_aux(Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        MethodSpec.Builder mbuilder = MethodSpec.methodBuilder((String)"call").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"T"));
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        this.compilerUtil.generateDocumentSpecializedParameters(mbuilder, the_var);
        StatementTypeAction action = new StatementTypeAction(this.pFactory, allVars, allAtts, null, null, "__C_document.getStatementOrBundle()", bindings_schema, this.knownTypes, this.unknownTypes, mbuilder, this.compilerUtil);
        for (StatementOrBundle s : doc.getStatementOrBundle()) {
            CompilerUtil.u.doAction(s, (StatementAction)action);
        }
        for (QualifiedName q : allVars) {
            String key = q.getLocalPart();
            JsonNode entry = the_var.path(key);
            if (entry == null || entry instanceof MissingNode) continue;
            mbuilder.addComment("Declare $N", new Object[]{q.getLocalPart()});
            ((Collection)this.knownTypes.getOrDefault(q.getUri(), new LinkedList())).forEach(type -> {
                mbuilder.beginControlFlow("if ($N!=null) ", new Object[]{q.getLocalPart()});
                mbuilder.addStatement("knownTypeMap.computeIfAbsent($N, k -> new $T<>())", new Object[]{q.getLocalPart(), HashSet.class});
                mbuilder.addStatement("knownTypeMap.get($N).add($S)", new Object[]{q.getLocalPart(), type});
                mbuilder.endControlFlow();
            });
            ((Collection)this.unknownTypes.getOrDefault(q.getUri(), new LinkedList())).forEach(type -> {
                mbuilder.beginControlFlow("if ($N!=null) ", new Object[]{q.getLocalPart()});
                mbuilder.addComment(type, new Object[0]);
                String typeVar = type.substring(type.indexOf("#") + 1);
                mbuilder.beginControlFlow("if ($N!=null) ", new Object[]{typeVar});
                mbuilder.addStatement("unknownTypeMap.computeIfAbsent($N, k -> new $T<>())", new Object[]{q.getLocalPart(), HashSet.class});
                mbuilder.addStatement("unknownTypeMap.get($N).add((($T)$N).getUri())", new Object[]{q.getLocalPart(), QualifiedName.class, typeVar});
                mbuilder.endControlFlow();
                mbuilder.endControlFlow();
            });
        }
        mbuilder.addStatement("return null", new Object[0]);
        MethodSpec.Builder cbuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        cbuilder.addStatement("this.knownTypeMap=knownTypeMap", new Object[0]);
        cbuilder.addStatement("this.unknownTypeMap=unknownTypeMap", new Object[0]);
        cbuilder.addStatement("this.propertyConverters=propertyConverters", new Object[0]);
        cbuilder.addStatement("this.pf=org.openprovenance.prov.interop.InteropFramework.getDefaultFactory()", new Object[0]);
        cbuilder.addParameter((TypeName)Map_QN_S_of_String, "knownTypeMap", new Modifier[0]);
        cbuilder.addParameter((TypeName)Map_QN_S_of_String, "unknownTypeMap", new Modifier[0]);
        cbuilder.addParameter((TypeName)Map_S_Map_S_to_Function, "propertyConverters", new Modifier[0]);
        TypeSpec.Builder builder = this.compilerUtil.generateTypeManagementClass(name);
        builder.addTypeVariable(TypeVariableName.get((String)"T"));
        ParameterizedTypeName superinterface = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)(name + "Interface"), (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        builder.addSuperinterface((TypeName)superinterface);
        builder.addField(ProvFactory.class, "pf", new Modifier[]{Modifier.PRIVATE});
        builder.addField((TypeName)Map_QN_S_of_String, "knownTypeMap", new Modifier[]{Modifier.PRIVATE});
        builder.addField((TypeName)Map_QN_S_of_String, "unknownTypeMap", new Modifier[]{Modifier.PRIVATE});
        builder.addField((TypeName)Map_S_Map_S_to_Function, "propertyConverters", new Modifier[]{Modifier.PRIVATE});
        builder.addMethod(cbuilder.build());
        builder.addMethod(mbuilder.build());
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox ($N) for template $N", new Object[]{this.getClass().getName() + ".generateTypeDeclaration_aux()", templateName}).build();
        return myfile;
    }
}

