/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.types;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.template.log2prov.RecordProcessor;
import org.openprovenance.prov.template.types.NullDocumentProcessor;
import org.openprovenance.prov.template.types.PK_CommandLineArguments;
import org.openprovenance.prov.template.types.TypesRecordProcessor;

public class ProvenanceKernels {
    static final boolean debug = true;
    static TypeReference<Map<String, Integer>> mapRef = new TypeReference<Map<String, Integer>>(){};
    static TypeReference<Map<String, String>> mapStringRef = new TypeReference<Map<String, String>>(){};
    static TypeReference<Map<String, Map<String, String>>> propertyConverterRef = new TypeReference<Map<String, Map<String, String>>>(){};

    public static void main(String[] args) throws IOException {
        String[] args0 = Arrays.copyOfRange(args, 1, args.length);
        PK_CommandLineArguments cliArgs = PK_CommandLineArguments.parse("<Executable> " + args[0], args0);
        ObjectMapper om = new ObjectMapper();
        if (cliArgs != null) {
            String debug = cliArgs.debug;
            String infile = cliArgs.infile;
            String outfile = cliArgs.outfile;
            String knowntypesFile = cliArgs.knowntypes;
            String knownrelationsFile = cliArgs.knownrelations;
            int setOffset = cliArgs.setOffset;
            int relationOffset = cliArgs.relationOffset;
            int levelOffset = cliArgs.levelOffset;
            String translationFile = cliArgs.translation;
            int levelNumber = cliArgs.levelNumber;
            boolean addLevel0ToAllLevels = cliArgs.addLevel0ToAllLevels;
            String propertyConverters = cliArgs.propertyConverters;
            InputStream is = "-".equals(infile) ? System.in : new FileInputStream(infile);
            NullDocumentProcessor dp = new NullDocumentProcessor();
            RecordProcessor rp = null;
            Map<String, Integer> knownTypes = knowntypesFile != null ? (Map<String, Integer>)om.readValue(new File(knowntypesFile), mapRef) : Map.of("http://www.w3.org/ns/prov#Entity", 1, "http://www.w3.org/ns/prov#Activity", 2, "http://www.w3.org/ns/prov#Agent", 3);
            Map translation = translationFile == null || translationFile.equals("") ? Map.of() : (Map)om.readValue(new File(translationFile), mapStringRef);
            Map<Set<Integer>, Integer> knownTypesSets = knownTypes.keySet().stream().collect(Collectors.toMap(k -> Set.of((Integer)knownTypes.get(k)), knownTypes::get));
            LinkedList<Pair<String, Object[]>> records = new LinkedList<Pair<String, Object[]>>();
            HashMap knownRelations = knownrelationsFile == null ? new HashMap() : (Map)om.readValue(new File(knownrelationsFile), mapRef);
            Map<String, Integer> knownRelations2 = knownRelations.keySet().stream().collect(Collectors.toMap(r -> r, r -> (Integer)knownRelations.get(r) + relationOffset));
            Map propertyConvertersMap = propertyConverters == null ? Map.of() : (Map)om.readValue(new File(propertyConverters), propertyConverterRef);
            TypesRecordProcessor trp = new TypesRecordProcessor(knownTypes, knownTypesSets, knownRelations2, relationOffset, levelOffset, translation, levelNumber, addLevel0ToAllLevels, propertyConvertersMap, records);
            Map<String, Object> result = FileBuilder.reader(is, dp, rp, trp);
            if (outfile != null) {
                om.writerWithDefaultPrettyPrinter().writeValue((OutputStream)new FileOutputStream(outfile), result);
            }
        }
    }
}

