/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.template.compiler.CompilerUtil;

public class CompilerSQL {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    ObjectMapper om = new ObjectMapper();
    Map<String, String> tableDeclarations = new HashMap<String, String>();
    Map<String, String> nameMap = this.initNameMap();
    private final boolean debugComment = true;

    public void generateSQLEnd(String sqlFile, String root_dir) {
        new File(root_dir).mkdirs();
        String path = root_dir + "/" + sqlFile;
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(path));
            for (String k : this.tableDeclarations.keySet()) {
                ps.println(this.tableDeclarations.get(k));
                ps.println("\n\n");
            }
            ps.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateSQL(String jsonschema, String templateName, String root_dir, JsonNode bindings_schema) {
        Object res = "";
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter = the_var.fieldNames();
        boolean first = true;
        res = (String)res + "\nCREATE TABLE " + templateName + "\n(\n";
        while (iter.hasNext()) {
            JsonNode jsonNode;
            String key = (String)iter.next();
            if (first) {
                first = false;
            } else {
                res = (String)res + ",\n";
            }
            String sqlType = this.convertToSQLType(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName());
            res = (String)res + "  " + this.sqlify(key) + " " + sqlType;
            JsonNode entry = the_var.path(key);
            if (entry == null || entry instanceof MissingNode) continue;
            JsonNode firstNode = entry.get(0);
            if (firstNode instanceof ArrayNode) {
                firstNode = ((ArrayNode)firstNode).get(0);
            }
            String documentation = this.compilerUtil.noNode(jsonNode = firstNode.get("@documentation")) ? "" : jsonNode.textValue();
            JsonNode jsonNode2 = firstNode.get("@type");
        }
        res = (String)res + "\n);\n\n";
        this.tableDeclarations.put(templateName, (String)res);
    }

    public void generateSQLstatements(TypeSpec.Builder builder, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, JsonNode bindings_schema) {
        StringBuffer sb = new StringBuffer();
        this.getInsertStringAndCount(templateName, bindings_schema.get("var"), sb);
        FieldSpec.Builder builder1 = FieldSpec.builder(String.class, (String)"_sqlInsert1", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
        builder1.initializer("$S", new Object[]{sb.toString()});
        builder.addField(builder1.build());
        builder.addMethod(this.generateSQLInsert(allVars, allAtts, name, templateName, bindings_schema));
        builder.addMethod(this.generateSQLInsertStatement(allVars, allAtts, name, templateName, bindings_schema));
    }

    public MethodSpec generateSQLInsert(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        String loggerName = this.compilerUtil.loggerName(template);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSQLInsert").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        builder.addStatement("return _sqlInsert1", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateSQLInsertStatement(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        String loggerName = this.compilerUtil.loggerName(template);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSQLInsertStatement").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        StringBuffer sb = new StringBuffer();
        int count = this.getInsertStringAndCount(template, the_var, sb);
        sb = new StringBuffer();
        sb.append(" VALUES (");
        boolean first = true;
        for (int i = 0; i < count; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("?");
        }
        sb.append(");");
        builder.addStatement("return _sqlInsert1+$S", new Object[]{sb.toString()});
        MethodSpec method = builder.build();
        return method;
    }

    public int getInsertStringAndCount(String template, JsonNode the_var, StringBuffer sb) {
        sb.append("INSERT INTO  ");
        sb.append(template);
        sb.append(" (");
        boolean first = true;
        int count = 0;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.sqlify(key));
            ++count;
        }
        sb.append(")");
        return count;
    }

    private Map<String, String> initNameMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("order", "_order");
        return res;
    }

    public String sqlify(String key) {
        return this.nameMap.getOrDefault(key, key);
    }

    String convertToSQLType(String name) {
        switch (name) {
            case "java.lang.String": {
                return "text";
            }
            case "java.lang.Integer": {
                return "int";
            }
            case "java.lang.Float": {
                return "float";
            }
            case "java.lang.Boolean": {
                return "BOOLEAN";
            }
        }
        throw new UnsupportedOperationException("conversion to SQL type " + name);
    }

    public MethodSpec generateClientSQLMethod2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.compilerUtil.sqlName(template)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        String var = "sb";
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientSQLMethod2()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addParameter(StringBuffer.class, var, new Modifier[0]);
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key), newkey, new Modifier[0]);
        }
        iter = the_var.fieldNames();
        Object constant = "(";
        boolean first = true;
        while (iter.hasNext()) {
            boolean isQualifiedName;
            String key = (String)iter.next();
            String newName = "__" + key;
            Class<?> clazz = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
            boolean bl = isQualifiedName = the_var.get(key).get(0).get("@id") != null;
            if (first) {
                first = false;
            } else {
                constant = (String)constant + ",";
            }
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            constant = "";
            if (String.class.equals(clazz)) {
                String myStatement = "$N.append($N)";
                String myEscapeStatement = "$N.append($T.escapeJavaScript($N))";
                boolean doEscape = false;
                if (!isQualifiedName) {
                    boolean bl2 = doEscape = the_var.get(key).get(0).get(0).get("@escape") != null;
                    if (doEscape) {
                        // empty if block
                    }
                }
                builder.beginControlFlow("if ($N==null)", new Object[]{newName});
                builder.addStatement("$N.append($S)", new Object[]{var, "''"});
                builder.nextControlFlow("else", new Object[0]).addStatement("$N.append($S)", new Object[]{var, "'"});
                if (doEscape) {
                    builder.addStatement(myEscapeStatement, new Object[]{var, ClassName.get((String)"org.openprovenance.apache.commons.lang", (String)"StringEscapeUtils", (String[])new String[0]), newName});
                } else {
                    builder.addStatement(myStatement, new Object[]{var, newName});
                }
                builder.addStatement("$N.append($S)", new Object[]{var, "'"}).endControlFlow();
                continue;
            }
            builder.beginControlFlow("if ($N==null)", new Object[]{newName});
            builder.addStatement("$N.append($S)", new Object[]{var, "''"});
            builder.nextControlFlow("else", new Object[0]);
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            builder.addStatement("$N.append($N)", new Object[]{var, newName});
            builder.endControlFlow();
        }
        builder.addStatement("$N.append($S)", new Object[]{var, ")"});
        MethodSpec method = builder.build();
        return method;
    }
}

