/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openprovenance.prov.model.exception.InvalidCaseException;
import org.openprovenance.prov.template.types.Descriptor;
import org.openprovenance.prov.template.types.DescriptorTree;

@JsonPropertyOrder(value={"@type", "value"})
public class DescriptorAtom
implements Descriptor {
    List<String> value;

    public DescriptorAtom(String value) {
        this.value = List.of(value);
    }

    public DescriptorAtom(List<String> value) {
        this.value = value;
    }

    @Override
    public String toText(Function<String, String> relationTranslator) {
        return this.value.stream().collect(Collectors.joining(","));
    }

    @Override
    @JsonProperty(value="@type")
    public String getCategory() {
        return "atom";
    }

    public List<String> getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Descriptor o) {
        if (o instanceof DescriptorTree) {
            return -1;
        }
        if (o instanceof DescriptorAtom) {
            return this.value.toString().compareTo(((DescriptorAtom)o).value.toString());
        }
        throw new InvalidCaseException(o.toString());
    }
}

