/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.template.compiler.CompilerUtil;

public class CompilerSimpleBean {
    private final ProvFactory pFactory;
    private final CompilerUtil compilerUtil = new CompilerUtil();

    public CompilerSimpleBean(ProvFactory pFactory) {
        this.pFactory = pFactory;
    }

    public JavaFile generateSimpleBean(Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        IndexedDocument indexed = new IndexedDocument(this.pFactory, this.pFactory.newDocument(), true);
        CompilerUtil.u.forAllStatement(bun.getStatement(), (StatementAction)indexed);
        return this.generateSimpleBean_aux(doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema, indexed);
    }

    public TypeSpec.Builder generateBeanClassInit(String name, String packge, String supername) {
        return TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private JavaFile generateSimpleBean_aux(Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema, IndexedDocument indexed) {
        TypeSpec.Builder builder = this.generateBeanClassInit(name, "org.openprovenance.prov.client", "Bean");
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        FieldSpec.Builder b0 = FieldSpec.builder(String.class, (String)"isA", (Modifier[])new Modifier[0]);
        b0.addModifiers(new Modifier[]{Modifier.PUBLIC});
        b0.addModifiers(new Modifier[]{Modifier.FINAL});
        b0.initializer("$S", new Object[]{templateName});
        builder.addField(b0.build());
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            FieldSpec.Builder b = FieldSpec.builder(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key), (String)key, (Modifier[])new Modifier[0]);
            b.addModifiers(new Modifier[]{Modifier.PUBLIC});
            JsonNode entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode)) {
                JsonNode jsonNode;
                JsonNode firstNode = entry.get(0);
                if (firstNode instanceof ArrayNode) {
                    firstNode = ((ArrayNode)firstNode).get(0);
                }
                String documentation = this.compilerUtil.noNode(jsonNode = firstNode.get("@documentation")) ? "-- no @documentation" : jsonNode.textValue();
                JsonNode jsonNode2 = firstNode.get("@type");
                String type = this.compilerUtil.noNode(jsonNode2) ? "xsd:string" : jsonNode2.textValue();
                b.addJavadoc("$N: $L (expected type: $L)\n", new Object[]{key, documentation, type});
            } else {
                b.addJavadoc("$N -- no bindings schemas \n", new Object[]{key});
            }
            builder.addField(b.build());
        }
        MethodSpec mbuild = this.generateInvokeProcessor(allVars, allAtts, name, templateName, packge, bindings_schema);
        builder.addMethod(mbuild);
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox ($N) for template $N", new Object[]{this.getClass().getName(), templateName}).build();
        return myfile;
    }

    static TypeName processorClassType(CompilerUtil compilerUtil, String template, String packge) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        return name;
    }

    public static TypeName processorInterfaceType(CompilerUtil compilerUtil, String template, String packge) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)(compilerUtil.templateNameClass(template) + "Interface"), (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        return name;
    }

    public MethodSpec generateInvokeProcessor(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"T")).addTypeVariable(TypeVariableName.get((String)"T"));
        String loggerName = this.compilerUtil.loggerName(template);
        builder.addParameter(CompilerSimpleBean.processorClassType(this.compilerUtil, template, packge), "processor", new Modifier[0]);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return processor.process(" + (String)args + ")", new Object[0]);
        return builder.build();
    }
}

