/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.tuple.Pair;
import org.openprovenance.apache.commons.lang.StringEscapeUtils;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.template.compiler.CompilerSQL;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.expander.ExpandUtil;

public class CompilerClient {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    private final ProvFactory pFactory;
    private final boolean debugComment = true;
    private final CompilerSQL compilerSQL;
    static final ParameterizedTypeName hashmapType = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(Integer.class), TypeName.get(int[].class)});
    private boolean foundEscape = false;
    TypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
    Map<String, Set<Pair<QualifiedName, WasDerivedFrom>>> successors1 = new HashMap<String, Set<Pair<QualifiedName, WasDerivedFrom>>>();
    Map<String, Set<Pair<QualifiedName, WasAttributedTo>>> successors2 = new HashMap<String, Set<Pair<QualifiedName, WasAttributedTo>>>();
    Map<String, Set<Pair<QualifiedName, HadMember>>> successors3 = new HashMap<String, Set<Pair<QualifiedName, HadMember>>>();
    Map<String, Set<Pair<QualifiedName, QualifiedHadMember>>> successors3b = new HashMap<String, Set<Pair<QualifiedName, QualifiedHadMember>>>();
    Map<String, Set<Pair<QualifiedName, SpecializationOf>>> successors4 = new HashMap<String, Set<Pair<QualifiedName, SpecializationOf>>>();

    public CompilerClient(ProvFactory pFactory, CompilerSQL compilerSQL) {
        this.pFactory = pFactory;
        this.compilerSQL = compilerSQL;
    }

    public TypeSpec.Builder generateClassInit(String builderName, String builderPackage, String processorName, String processorPackage, String supername) {
        return TypeSpec.classBuilder((String)builderName).addSuperinterface((TypeName)ClassName.get((String)builderPackage, (String)supername, (String[])new String[0])).addSuperinterface((TypeName)ClassName.get((String)builderPackage, (String)"SQL", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public Pair<JavaFile, Map<Integer, List<Integer>>> generateClientLib(Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema, IndexedDocument indexed) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generateClientLib_aux(doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema, indexed);
    }

    Pair<JavaFile, Map<Integer, List<Integer>>> generateClientLib_aux(Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema, IndexedDocument indexed) {
        TypeSpec.Builder builder = this.generateClassInit(name, "org.openprovenance.prov.client", this.compilerUtil.processorNameClass(templateName), packge, "Builder");
        Map successorTable = null;
        if (bindings_schema != null) {
            builder.addMethod(this.generateClientCSVConverterMethod_aux(allVars, allAtts, name, templateName, this.compilerUtil.loggerName(templateName), packge, bindings_schema));
            builder.addMethod(this.generateClientSQLConverterMethod_aux(allVars, allAtts, name, templateName, this.compilerUtil.loggerName(templateName), packge, bindings_schema));
            builder.addMethod(this.generateArgsToRecordMethod(allVars, allAtts, name, templateName, this.compilerUtil.loggerName(templateName), packge, bindings_schema));
            builder.addMethod(this.generateProcessorConverter(allVars, allAtts, name, templateName, this.compilerUtil.loggerName(templateName), packge, bindings_schema));
            builder.addMethod(this.generateProcessorConverter2(allVars, allAtts, name, templateName, this.compilerUtil.loggerName(templateName), packge, bindings_schema));
            builder.addMethod(this.generateApplyMethod(allVars, allAtts, name, templateName, this.compilerUtil.loggerName(templateName), packge, bindings_schema));
            builder.addMethod(this.generateClientMethod2(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod2PureCsv(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod3static(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod3(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod4static(allVars, allAtts, name, templateName, bindings_schema, indexed));
            Pair<MethodSpec, Map<Integer, List<Integer>>> methodSpecMapPair = this.generateClientMethod5static(allVars, allAtts, name, templateName, bindings_schema, indexed);
            builder.addMethod((MethodSpec)methodSpecMapPair.getLeft());
            successorTable = (Map)methodSpecMapPair.getRight();
            builder.addMethod(this.generateClientMethod6static(allVars, allAtts, name, templateName, bindings_schema, indexed));
            builder.addField(this.generateField4VarArray(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aBeanConverter(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aBeanConverter2(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aSQLConverter2(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aArgs2CsvConverter(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aRecord2SqlConverter(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(this.generateField4aRecord2CsvConverter(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addField(FieldSpec.builder((TypeName)CompilerUtil.mapType, (String)"__successors", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getSuccessors()", new Object[0]).build());
            builder.addField(FieldSpec.builder((TypeName)CompilerUtil.mapType, (String)"__successors2", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getTypedSuccessors()", new Object[0]).build());
            builder.addField(FieldSpec.builder(int[].class, (String)"__nodes", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getNodes()", new Object[0]).build());
            builder.addMethod(this.generateClientMethod4(allVars, allAtts, name, templateName, bindings_schema, indexed));
            builder.addMethod(this.generateClientMethod4b(allVars, allAtts, name, templateName, bindings_schema, indexed));
            builder.addMethod(this.nameAccessorGenerator(templateName));
            builder.addMethod(this.generatePropertyOrderMethod());
            builder.addMethod(this.generateRecordCsvProcessorMethod());
            builder.addMethod(this.generateFactoryMethodWithBean(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addMethod(this.generateFactoryMethodToBeanWithArray(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addMethod(this.generateNewBean(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addMethod(this.generateExamplarBean(allVars, allAtts, name, templateName, packge, bindings_schema));
        }
        this.compilerSQL.generateSQLstatements(builder, allVars, allAtts, name, templateName, bindings_schema);
        builder.addMethod(this.compilerSQL.generateClientSQLMethod2(allVars, allAtts, name, templateName, bindings_schema));
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox ($N) for template $N", new Object[]{this.getClass().getName(), templateName}).build();
        return Pair.of((Object)myfile, successorTable);
    }

    public MethodSpec nameAccessorGenerator(String templateName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return $S", new Object[]{templateName});
        return builder.build();
    }

    public MethodSpec generateClientMethod_aux(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String invoke, String loggerName, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)loggerName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod_aux()"});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add(loggerName + " client side logging method\n", new Object[0]);
        JsonNode the_var1 = bindings_schema.get("var");
        Iterator iter1 = the_var1.fieldNames();
        while (iter1.hasNext()) {
            String key = (String)iter1.next();
            String newkey = "__" + key;
            jdoc.add("@param " + newkey + " " + this.compilerUtil.getJavaTypeForDeclaredType(the_var1, key) + "\n", new Object[0]);
        }
        jdoc.add("@return java.lang.String\n", new Object[0]);
        builder.addJavadoc(jdoc.build());
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String var = "sb";
        builder.addStatement("$T $N=new $T()", new Object[]{StringBuffer.class, var, StringBuffer.class});
        String args = var;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key), newkey, new Modifier[0]);
            args = args + ", " + newkey;
        }
        builder.addStatement("$N(" + args + ")", new Object[]{invoke});
        builder.addStatement("return $N.toString()", new Object[]{var});
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        return this.generateClientMethod2(allVars, allAtts, name, template, bindings_schema, true);
    }

    public MethodSpec generateClientMethod2PureCsv(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        return this.generateClientMethod2(allVars, allAtts, name, template, bindings_schema, false);
    }

    public MethodSpec generateClientCSVConverterMethod_aux(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String loggerName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(template, packge, ClassName.get(String.class));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"args2csv").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(processorClassName);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientCSVConverterMethod_aux()"});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add(loggerName + " client side logging method\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{processorClassNameNotParametrised});
        builder.addJavadoc(jdoc.build());
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String var = "";
        builder.addStatement("$T $N=this", new Object[]{ClassName.get((String)packge, (String)name, (String[])new String[0]), "self"});
        Object args = "";
        Object args2 = "";
        boolean first = true;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        builder.addStatement("return (" + (String)args + ") -> { $T sb=new $T();$N.$N(sb," + (String)args2 + "); return sb.toString(); }", new Object[]{StringBuffer.class, StringBuffer.class, "self", loggerName});
        MethodSpec method = builder.build();
        return method;
    }

    private FieldSpec generateField4aBeanConverter(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        TypeName myType = this.processorClassType(templateName, packge, ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(templateName), (String[])new String[0]));
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aArgs2BeanConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        JsonNode the_var = bindings_schema.get("var");
        Object args = "";
        Object args2 = "";
        boolean first = true;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        fbuilder.initializer(" (" + (String)args + ") -> { return $N(" + (String)args2 + "); }", new Object[]{"toBean"});
        return fbuilder.build();
    }

    private FieldSpec generateField4VarArray(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)ArrayTypeName.of(String.class), (String)"propertyOrder", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        JsonNode the_var = bindings_schema.get("var");
        String args = "";
        Object args2 = "new String[] { \"isA\" ";
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            args2 = (String)args2 + ", ";
            args2 = (String)args2 + " \"" + key + "\"";
        }
        fbuilder.initializer((String)args2 + "}", new Object[0]);
        return fbuilder.build();
    }

    private FieldSpec generateField4aBeanConverter2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(templateName), (String[])new String[0])});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aRecord2BeanConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer(" (Object [] record) -> { return $N(record); }", new Object[]{"toBean"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aSQLConverter2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(templateName, packge, ClassName.get(String.class));
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)processorClassName, (String)"aBean2SqlConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer("$N()", new Object[]{"bean2sql"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aArgs2CsvConverter(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(templateName, packge, ClassName.get(String.class));
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)processorClassName, (String)"aArgs2CsVConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer("$N()", new Object[]{"args2csv"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aRecord2SqlConverter(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aRecord2SqlConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer(" (Object [] record) -> { return $N(record).process($N); }", new Object[]{"toBean", "aBean2SqlConverter"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aRecord2CsvConverter(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aRecord2CsvConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer(" (Object [] record) -> { return $N(record).process($N); }", new Object[]{"toBean", "aArgs2CsVConverter"});
        return fbuilder.build();
    }

    public MethodSpec generateClientSQLConverterMethod_aux(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String loggerName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(template, packge, ClassName.get(String.class));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"bean2sql").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(processorClassName);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientSQLConverterMethod_aux()"});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add(loggerName + " client side logging method\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{processorClassNameNotParametrised});
        builder.addJavadoc(jdoc.build());
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String var = "";
        builder.addStatement("$T $N=this", new Object[]{ClassName.get((String)packge, (String)name, (String[])new String[0]), "self"});
        Object args = "";
        Object args2 = "";
        boolean first = true;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        builder.addStatement("return (" + (String)args + ") -> { $T sb=new $T(); $N.$N(sb," + (String)args2 + "); return sb.toString(); }", new Object[]{StringBuffer.class, StringBuffer.class, "self", "sqlTuple"});
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateArgsToRecordMethod(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String loggerName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(template, packge, ArrayTypeName.of(Object.class));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"aArgs2RecordConverter").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(processorClassName);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateArgsToRecordMethod()"});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add("Returns a converter from arguments to record\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{processorClassNameNotParametrised});
        builder.addJavadoc(jdoc.build());
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String var = "";
        Object args = "";
        Object args2 = "";
        boolean first = true;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        builder.addStatement("return (" + (String)args + ") -> {  return new Object [] { getName(), " + (String)args2 + "}; }", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateProcessorConverter(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String loggerName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(template, packge, TypeVariableName.get((String)"T"));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"processorConverter").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).returns(processorClassName);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateProcessorConverter()"});
        ParameterizedTypeName parameterType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        builder.addParameter((TypeName)parameterType, "processor", new Modifier[]{Modifier.FINAL});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add("Returns a converter from Processor taking arguments to Processor taking record\n", new Object[0]);
        jdoc.add("@param processor a transformer for this template\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{processorClassNameNotParametrised});
        builder.addJavadoc(jdoc.build());
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String var = "";
        Object args = "";
        Object args2 = "";
        boolean first = true;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(the_var, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        builder.addStatement("return (" + (String)args + ") -> {  return processor.process(new Object [] { getName(), " + (String)args2 + "}); }", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateProcessorConverter2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String loggerName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(template, packge, TypeVariableName.get((String)"T"));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        ClassName returnTypeNotParametrised = ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"processorConverter").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).returns((TypeName)returnType);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateProcessorConverter2()"});
        builder.addParameter(processorClassName, "processor", new Modifier[]{Modifier.FINAL});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add("Returns a converter from Processor taking arguments to Processor taking record\n", new Object[0]);
        jdoc.add("@param processor a transformer for this template\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{returnTypeNotParametrised});
        builder.addJavadoc(jdoc.build());
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String var = "";
        Object args = "";
        Object args2 = "";
        int count = 1;
        boolean first = true;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            Class<?> declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
            String type = declaredJavaType.getName();
            String converter = this.compilerUtil.getConverterForDeclaredType(declaredJavaType);
            String converter2 = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
            String expression = converter2 == null ? "(" + type + ") record[" + count + "]" : "(record[" + count + "]==null)?null:((record[" + count + "] instanceof String)?" + converter2 + "((String)(record[" + count + "])):(" + type + ")(record[" + count + "]))";
            args = (String)args + type + " " + newkey;
            args2 = (String)args2 + " " + expression;
            ++count;
        }
        builder.addStatement("return (Object [] record) -> {  return processor.process(" + (String)args2 + "); }", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateApplyMethod(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String loggerName, String packge, JsonNode bindings_schema) {
        TypeName processorClassName = this.processorClassType(template, packge, TypeVariableName.get((String)"T"));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).returns((TypeName)TypeVariableName.get((String)"T"));
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateApplyMethod()"});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add("Apply method\n", new Object[0]);
        jdoc.add("@param processor a transformer for this template\n", new Object[0]);
        jdoc.add("@param record as an array of Objects\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{TypeVariableName.get((String)"T")});
        builder.addJavadoc(jdoc.build());
        String var_processor = "processor";
        String var_record = "record";
        builder.addParameter(processorClassName, "processor", new Modifier[0]);
        builder.addParameter((TypeName)ArrayTypeName.of(Object.class), "record", new Modifier[0]);
        builder.addStatement("return toBean($N).process($N)", new Object[]{"record", "processor"});
        MethodSpec method = builder.build();
        return method;
    }

    private TypeName processorClassType(String template, String packge, TypeVariableName t) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{t});
        return name;
    }

    private TypeName processorClassType(String template, String packge, ParameterizedTypeName parameterizedTypeName) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{parameterizedTypeName});
        return name;
    }

    private TypeName processorClassType(String template, String packge, ArrayTypeName arrayTypeName) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{arrayTypeName});
        return name;
    }

    private TypeName processorClassType(String template, String packge, ClassName cl) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{cl});
        return name;
    }

    private TypeName processorClassType(String template, String packge) {
        return ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]);
    }

    public MethodSpec generateClientMethod2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, boolean legacy) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(this.compilerUtil.loggerName(template) + (legacy ? "_impure" : ""))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        String var = "sb";
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod2()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addParameter(StringBuffer.class, var, new Modifier[0]);
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key), newkey, new Modifier[0]);
        }
        iter = the_var.fieldNames();
        Object constant = (legacy ? "[" : "") + StringEscapeUtils.escapeCsv((String)template);
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newName = "__" + key;
            Class<?> clazz = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
            boolean isQualifiedName = the_var.get(key).get(0).get("@id") != null;
            constant = (String)constant + ",";
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            constant = "";
            if (String.class.equals(clazz)) {
                String myStatement = "$N.append($N)";
                String myEscapeStatement = "$N.append($T.escapeCsv($N))";
                boolean doEscape = false;
                if (!isQualifiedName) {
                    boolean bl = doEscape = the_var.get(key).get(0).get(0).get("@escape") != null;
                    if (doEscape) {
                        this.foundEscape = true;
                    }
                }
                builder.beginControlFlow("if ($N==null)", new Object[]{newName});
                if (legacy) {
                    builder.addStatement("$N.append($N)", new Object[]{var, newName});
                }
                builder.nextControlFlow("else", new Object[0]);
                if (doEscape) {
                    builder.addStatement(myEscapeStatement, new Object[]{var, ClassName.get((String)"org.openprovenance.apache.commons.lang", (String)"StringEscapeUtils", (String[])new String[0]), newName});
                } else {
                    builder.addStatement(myStatement, new Object[]{var, newName});
                }
                builder.endControlFlow();
                continue;
            }
            builder.beginControlFlow("if ($N==null)", new Object[]{newName});
            builder.nextControlFlow("else", new Object[0]);
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            builder.addStatement("$N.append($N)", new Object[]{var, newName});
            builder.endControlFlow();
        }
        constant = (String)constant + (Serializable)(legacy ? Character.valueOf(']') : "");
        builder.addStatement("$N.append($S)", new Object[]{var, constant});
        MethodSpec method = builder.build();
        return method;
    }

    public boolean getFoundEscape() {
        return this.foundEscape;
    }

    public MethodSpec generateClientMethod3static(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(int[].class);
        String var = "sb";
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod3static()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter = the_var.fieldNames();
        int count = 0;
        LinkedList<Integer> ll = new LinkedList<Integer>();
        while (iter.hasNext()) {
            ++count;
            String key = (String)iter.next();
            if (the_var.get(key).get(0).get("@id") == null) continue;
            ll.add(count);
        }
        Object nodes = "";
        boolean first = true;
        Iterator iterator = ll.iterator();
        while (iterator.hasNext()) {
            int elem = (Integer)iterator.next();
            if (first) {
                first = false;
            } else {
                nodes = (String)nodes + ", ";
            }
            nodes = (String)nodes + elem;
        }
        builder.addStatement("return new int[] {" + (String)nodes + "}", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod3(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(int[].class);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod3()"});
        builder.addStatement("return __nodes", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generatePropertyOrderMethod() {
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"getPropertyOrder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String[].class);
        builder5.addStatement("return $N", new Object[]{"propertyOrder"});
        return builder5.build();
    }

    public MethodSpec generateRecordCsvProcessorMethod() {
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"record2csv").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of(Object.class), (String)"record", (Modifier[])new Modifier[0]).build()).returns(this.myType);
        builder5.addStatement("return $N", new Object[]{"aRecord2CsvConverter"});
        return builder5.build();
    }

    public MethodSpec generateClientMethod4(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)CompilerUtil.mapType);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod4()"});
        builder.addStatement("return __successors", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod4b(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getTypedSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)CompilerUtil.mapType);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod4b()"});
        builder.addStatement("return __successors2", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod4static(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)CompilerUtil.mapType);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod4static()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter2 = the_var.fieldNames();
        int count2 = 0;
        HashMap<QualifiedName, Integer> index = new HashMap<QualifiedName, Integer>();
        while (iter2.hasNext()) {
            ++count2;
            String key = (String)iter2.next();
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                index.put(qn, count2);
            }
        }
        builder.addStatement("$T table = new $T()", new Object[]{CompilerUtil.mapType, hashmapType});
        Iterator iter = the_var.fieldNames();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            String key = (String)iter.next();
            if (the_var.get(key).get(0).get("@id") == null) continue;
            Set successors = new HashSet();
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                successors = indexed.traverseDerivations(qn);
                break;
            }
            Object initializer = "";
            boolean first = true;
            for (QualifiedName successor : successors) {
                int i = (Integer)index.get(successor);
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i;
            }
            builder.addStatement("table.put($L,new int[] { " + (String)initializer + "})", new Object[]{count});
        }
        builder.addStatement("return table", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public void calculateTypedSuccessors(Set<QualifiedName> allVars, JsonNode bindings_schema, IndexedDocument indexed, Map<String, Set<Pair<QualifiedName, WasDerivedFrom>>> successors1, Map<String, Set<Pair<QualifiedName, WasAttributedTo>>> successors2, Map<String, Set<Pair<QualifiedName, HadMember>>> successors3, Map<String, Set<Pair<QualifiedName, QualifiedHadMember>>> successors3b, Map<String, Set<Pair<QualifiedName, SpecializationOf>>> successors4) {
        JsonNode the_var = bindings_schema.get("var");
        Iterator iter = the_var.fieldNames();
        block0: while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!this.compilerUtil.isVariableDenotingQualifiedName(key, the_var)) continue;
            for (QualifiedName qn : allVars) {
                Set pairs4;
                Set pairs3;
                Set pairs2;
                if (!key.equals(qn.getLocalPart())) continue;
                Set pairs1 = indexed.traverseDerivationsWithRelations(qn);
                if (!pairs1.isEmpty()) {
                    successors1.put(key, pairs1);
                }
                if (!(pairs2 = indexed.traverseAttributionsWithRelations(qn)).isEmpty()) {
                    successors2.put(key, pairs2);
                }
                if (!(pairs3 = indexed.traverseReverseMembershipsWithRelations(qn)).isEmpty()) {
                    for (Pair pair3 : pairs3) {
                        if (pair3.getRight() instanceof QualifiedHadMember) {
                            successors3b.computeIfAbsent(key, k -> new HashSet());
                            successors3b.get(key).add((Pair<QualifiedName, QualifiedHadMember>)Pair.of((Object)((QualifiedName)pair3.getLeft()), (Object)((QualifiedHadMember)pair3.getRight())));
                            continue;
                        }
                        successors3.computeIfAbsent(key, k -> new HashSet());
                        successors3.get(key).add((Pair<QualifiedName, HadMember>)pair3);
                    }
                }
                if ((pairs4 = indexed.traverseSpecializationsWithRelations(qn)).isEmpty()) continue block0;
                successors4.put(key, pairs4);
                continue block0;
            }
        }
    }

    public Map<String, Set<Pair<QualifiedName, WasDerivedFrom>>> getSuccessors1() {
        return this.successors1;
    }

    public Map<String, Set<Pair<QualifiedName, WasAttributedTo>>> getSuccessors2() {
        return this.successors2;
    }

    public Map<String, Set<Pair<QualifiedName, HadMember>>> getSuccessors3() {
        return this.successors3;
    }

    public Map<String, Set<Pair<QualifiedName, QualifiedHadMember>>> getSuccessors3b() {
        return this.successors3b;
    }

    public Map<String, Set<Pair<QualifiedName, SpecializationOf>>> getSuccessors4() {
        return this.successors4;
    }

    public Pair<MethodSpec, Map<Integer, List<Integer>>> generateClientMethod5static(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getTypedSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)CompilerUtil.mapType);
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod5static()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        this.successors1 = new HashMap<String, Set<Pair<QualifiedName, WasDerivedFrom>>>();
        this.successors2 = new HashMap<String, Set<Pair<QualifiedName, WasAttributedTo>>>();
        this.successors3 = new HashMap<String, Set<Pair<QualifiedName, HadMember>>>();
        this.successors3b = new HashMap<String, Set<Pair<QualifiedName, QualifiedHadMember>>>();
        this.successors4 = new HashMap<String, Set<Pair<QualifiedName, SpecializationOf>>>();
        this.calculateTypedSuccessors(allVars, bindings_schema, indexed, this.successors1, this.successors2, this.successors3, this.successors3b, this.successors4);
        Iterator iter2 = the_var.fieldNames();
        int count2 = 0;
        HashMap<QualifiedName, Integer> index = new HashMap<QualifiedName, Integer>();
        while (iter2.hasNext()) {
            ++count2;
            String key = (String)iter2.next();
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                index.put(qn, count2);
            }
        }
        builder.addStatement("$T table = new $T()", new Object[]{CompilerUtil.mapType, hashmapType});
        Iterator iter = the_var.fieldNames();
        int count = 0;
        HashMap tableValues = new HashMap();
        while (iter.hasNext()) {
            int i;
            ++count;
            String key = (String)iter.next();
            if (the_var.get(key).get(0).get("@id") == null) continue;
            Set successors1 = new HashSet();
            Set successors2 = new HashSet();
            Set successors3 = new HashSet();
            HashSet successors3b = new HashSet();
            Set successors4 = new HashSet();
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                successors1 = indexed.traverseDerivationsWithRelations(qn);
                successors2 = indexed.traverseAttributionsWithRelations(qn);
                successors3 = indexed.traverseReverseMembershipsWithRelations(qn);
                successors4 = indexed.traverseSpecializationsWithRelations(qn);
                break;
            }
            Object initializer = "";
            LinkedList<Integer> rowValues = new LinkedList<Integer>();
            boolean first = true;
            for (Pair successor : successors1) {
                i = (Integer)index.get(successor.getLeft());
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i + ", " + this.relationTypeNumber((Relation)successor.getRight()) + " /* " + ((WasDerivedFrom)successor.getRight()).getKind() + " */";
                rowValues.add(i);
                rowValues.add(this.relationTypeNumber((Relation)successor.getRight()));
            }
            for (Pair successor2 : successors2) {
                i = (Integer)index.get(successor2.getLeft());
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i + ", " + this.relationTypeNumber((Relation)successor2.getRight()) + " /* " + ((WasAttributedTo)successor2.getRight()).getKind() + " */";
                rowValues.add(i);
                rowValues.add(this.relationTypeNumber((Relation)successor2.getRight()));
            }
            for (Pair successor3 : successors3) {
                i = (Integer)index.get(successor3.getLeft());
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i + ", " + this.relationTypeNumber((Relation)successor3.getRight()) + " /* " + ((HadMember)successor3.getRight()).getKind() + " */";
                rowValues.add(i);
                rowValues.add(this.relationTypeNumber((Relation)successor3.getRight()));
            }
            for (Pair successor4 : successors4) {
                i = (Integer)index.get(successor4.getLeft());
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i + ", " + this.relationTypeNumber((Relation)successor4.getRight()) + " /* " + ((SpecializationOf)successor4.getRight()).getKind() + " */";
                rowValues.add(i);
                rowValues.add(this.relationTypeNumber((Relation)successor4.getRight()));
            }
            builder.addStatement("table.put($L,new int[] { " + (String)initializer + "})", new Object[]{count});
            tableValues.put(count, rowValues);
        }
        builder.addStatement("return table", new Object[0]);
        MethodSpec method = builder.build();
        return Pair.of((Object)method, tableValues);
    }

    public MethodSpec generateClientMethod6static(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getAllTypes").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.get(String[].class));
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateClientMethod6static()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        HashSet<String> allTypes = new HashSet<String>();
        for (StatementOrBundle sOrb : indexed.toDocument().getStatementOrBundle()) {
            if (!(sOrb instanceof HasType)) continue;
            for (Object tp : ((HasType)sOrb).getType()) {
                QualifiedName qn;
                Object val = tp.getValue();
                if (!(val instanceof QualifiedName) || ExpandUtil.isVariable((QualifiedName)(qn = (QualifiedName)val))) continue;
                allTypes.add(qn.getUri());
            }
        }
        List<String> knownTypes = this.getCommonTypes0();
        ArrayList sortedList = new ArrayList(allTypes);
        Collections.sort(sortedList);
        knownTypes.addAll(sortedList);
        builder.addStatement("String [] table = new String[$L]", new Object[]{knownTypes.size()});
        int count = 0;
        for (String s : knownTypes) {
            builder.addStatement("table[$L]=$S", new Object[]{count, s});
            ++count;
        }
        builder.addStatement("return table", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public List<String> getCommonTypes0() {
        ArrayList<String> knownTypes = new ArrayList<String>();
        knownTypes.add("http://www.w3.org/ns/prov#Entity");
        knownTypes.add("http://www.w3.org/ns/prov#Activity");
        knownTypes.add("http://www.w3.org/ns/prov#Agent");
        return knownTypes;
    }

    public int relationTypeNumber(Relation rel) {
        return rel.getKind().ordinal();
    }

    public MethodSpec generateFactoryMethodWithBean(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toBean").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]));
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateFactoryMethodWithBean()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(the_var, key), newkey, new Modifier[0]);
        }
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0])});
        Iterator iter2 = the_var.fieldNames();
        String args = "";
        while (iter2.hasNext()) {
            String key = (String)iter2.next();
            String newkey = "__" + key;
            String statement = "bean.$N=$N";
            builder.addStatement(statement, new Object[]{key, newkey});
        }
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateFactoryMethodToBeanWithArray(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toBean").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]));
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateFactoryMethodToBeanWithArray()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addParameter(Object[].class, "record", new Modifier[0]);
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0])});
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String statement;
            String key = (String)iter.next();
            Class<?> declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
            String converter = this.compilerUtil.getConverterForDeclaredType(declaredJavaType);
            String converter2 = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
            if (converter2 == null) {
                statement = "bean.$N=($T) record[" + count + "]";
                builder.addStatement(statement, new Object[]{key, declaredJavaType});
            } else {
                statement = "bean.$N=(record[" + count + "]==null)?null:((record[" + count + "] instanceof String)?$N((String)(record[" + count + "])):($T)(record[" + count + "]))";
                builder.addStatement(statement, new Object[]{key, converter2, declaredJavaType});
            }
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateNewBean(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"newBean").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]));
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateNewBean()"});
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0])});
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateExamplarBean(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"examplar").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]));
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateExamplarBean()"});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template), (String[])new String[0])});
        for (QualifiedName qualifiedName : allVars) {
            Iterator iter3 = the_var.fieldNames();
            while (iter3.hasNext()) {
                String key3 = (String)iter3.next();
                if (!qualifiedName.getLocalPart().equals(key3)) continue;
                builder.addStatement("bean.$N=$S", new Object[]{qualifiedName.getLocalPart(), "example_" + qualifiedName.getLocalPart()});
            }
        }
        JsonNode the_var2 = bindings_schema == null ? null : bindings_schema.get("var");
        for (QualifiedName q : allAtts) {
            String declaredType = null;
            Class<?> declaredJavaType = null;
            if (the_var2 != null) {
                Iterator iter3 = the_var2.fieldNames();
                while (iter3.hasNext()) {
                    String key3 = (String)iter3.next();
                    if (!q.getLocalPart().equals(key3)) continue;
                    declaredType = this.compilerUtil.getDeclaredType(the_var2, key3);
                    declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(the_var2, key3);
                }
            }
            String example = this.compilerUtil.generateExampleForType(declaredType, q.getLocalPart(), this.pFactory);
            String converter = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
            if (converter == null) {
                builder.addStatement("bean.$N=$S", new Object[]{q.getLocalPart(), example});
                continue;
            }
            builder.addStatement("bean.$N=$N($S)", new Object[]{q.getLocalPart(), converter, example});
        }
        builder.addStatement("return bean", new Object[0]);
        MethodSpec methodSpec = builder.build();
        return methodSpec;
    }

    public JavaFile generateSQLInterface(String packge) {
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInit("SQL");
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"getSQLInsert").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class);
        builder.addMethod(builder2.build());
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)"getSQLInsertStatement").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class);
        builder.addMethod(builder3.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = JavaFile.builder((String)"org.openprovenance.prov.client", (TypeSpec)theInterface).addFileComment("Generated by ProvToolbox method $N", new Object[]{this.getClass().getName() + ".generateSQLInterface()"}).build();
        return myfile;
    }

    public MethodSpec clientAccessorGenerator(String templateName, String packge) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getClientBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"org.openprovenance.prov.client", (String)"Builder", (String[])new String[0]));
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".clientAccessorGenerator()"});
        builder.addStatement("return new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.templateNameClass(templateName), (String[])new String[0])});
        return builder.build();
    }

    public MethodSpec typedRecordGenerator(String templateName, String packge) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getTypedRecord").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)(this.compilerUtil.templateNameClass(templateName) + "TypedRecord"), (String[])new String[0]));
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".typeRecordGenerator()"});
        builder.addStatement("return new $T()", new Object[]{ClassName.get((String)packge, (String)(this.compilerUtil.templateNameClass(templateName) + "TypedRecord"), (String[])new String[0])});
        return builder.build();
    }
}

