/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.types;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.template.log2prov.ProxyManagement;
import org.openprovenance.prov.template.log2prov.interfaces.ProxyClientInterface;
import org.openprovenance.prov.template.log2prov.interfaces.ProxyMakerInterface;
import org.openprovenance.prov.template.types.Descriptor;
import org.openprovenance.prov.template.types.DescriptorAtom;
import org.openprovenance.prov.template.types.DescriptorTree;
import org.openprovenance.prov.template.types.TMap;

public class TypesRecordProcessor {
    static Logger logger = LogManager.getLogger(TypesRecordProcessor.class);
    private final Map<Integer, Map<String, Integer>> levelTypeIndex;
    private final Map<Integer, Map<Set<Integer>, Integer>> levelTypeSetIndex;
    private final List<Pair<String, Object[]>> records;
    private final Map<String, Integer> knownRelations;
    private final Map<String, Integer> allRelations;
    private final int relationOffset;
    private final int levelOffset;
    private final Map<String, String> translation;
    private final Map<Integer, Map<List<List<Integer>>, Integer>> levelRelTypeSetIndex;
    private final int levelNumber;
    private final boolean addLevel0ToAllLevels;
    private final Map<String, Map<String, BiFunction<Object, String, Collection<String>>>> propertyConverters;
    private final Map<String, Map<String, BiFunction<Object, String, Collection<String>>>> idataConverters;
    private int relationCount;
    private final Collection<String> rejectedTypes;
    private Map<Integer, List<String>> level0SR;
    final Map<String, Object> result = new HashMap<String, Object>();
    final TMap tMap = new TMap();
    BinaryOperator<Map<String, Set<String>>> mergeIDataMaps = (m1, m2) -> {
        if (m2 == null) {
            return m1;
        }
        HashMap res = m1 == null ? new HashMap() : new HashMap(m1);
        m2.keySet().forEach(k -> {
            res.computeIfAbsent(k, _k -> new HashSet());
            ((Set)res.get(k)).addAll((Collection)m2.get(k));
        });
        return res;
    };
    static Comparator<Collection<Integer>> collectionComparator = (o1, o2) -> {
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareTo(s2);
    };
    private final Function<Object, Collection<String>> identity = o -> List.of();
    private final BiFunction<Object, String, Collection<String>> biidentity = (o, s) -> List.of();
    private final BinaryOperator<Function<Object, Collection<String>>> compose = (f1, f2) -> o -> {
        Collection c2;
        LinkedList ll = new LinkedList();
        Collection c1 = (Collection)f1.apply(o);
        if (c1 != null) {
            ll.addAll(c1);
        }
        if ((c2 = (Collection)f2.apply(o)) != null) {
            ll.addAll(c2);
        }
        return ll;
    };
    private final BinaryOperator<BiFunction<Object, String, Collection<String>>> bicompose = (f1, f2) -> (o, s) -> {
        Collection c2;
        LinkedList ll = new LinkedList();
        Collection c1 = (Collection)f1.apply(o, s);
        if (c1 != null) {
            ll.addAll(c1);
        }
        if ((c2 = (Collection)f2.apply(o, s)) != null) {
            ll.addAll(c2);
        }
        return ll;
    };

    public TypesRecordProcessor(Map<String, Integer> knownLevel0TypeIndex, Map<Set<Integer>, Integer> knownTypesSets, Map<String, Integer> knownRelations, int relationOffset, int levelOffset, Map<String, String> translation, int levelNumber, boolean addLevel0ToAllLevels, Map<String, Map<String, List<String>>> propertyConverters, Map<String, Map<String, List<String>>> idataConverters, Collection<String> rejectedTypes, List<Pair<String, Object[]>> records) {
        this.levelTypeIndex = new HashMap<Integer, Map<String, Integer>>();
        this.levelTypeIndex.put(0, new HashMap<String, Integer>(knownLevel0TypeIndex));
        this.levelTypeSetIndex = new HashMap<Integer, Map<Set<Integer>, Integer>>();
        this.levelTypeSetIndex.put(0, new HashMap<Set<Integer>, Integer>(knownTypesSets));
        this.knownRelations = knownRelations;
        this.allRelations = new HashMap<String, Integer>();
        this.allRelations.putAll(knownRelations);
        this.relationCount = this.newPossibleIndex(this.allRelations.values()) + 100;
        this.levelRelTypeSetIndex = new HashMap<Integer, Map<List<List<Integer>>, Integer>>();
        this.relationOffset = relationOffset;
        this.levelOffset = levelOffset;
        this.translation = translation;
        this.records = records;
        this.rejectedTypes = rejectedTypes;
        this.levelNumber = levelNumber;
        this.addLevel0ToAllLevels = addLevel0ToAllLevels;
        this.propertyConverters = propertyConverters == null ? null : this.initialisePropertyConverters(propertyConverters);
        this.idataConverters = idataConverters == null ? null : this.initialisePropertyConverters(idataConverters);
    }

    public void process(String methodName, Object[] args) {
        this.records.add((Pair<String, Object[]>)Pair.of((Object)methodName, (Object)args));
    }

    public Map<String, Integer> levelN(HashMap<String, FileBuilder> registry, HashMap<String, Object> clientRegistry, ProxyManagement pm, Map<String, Integer> mapLevelN, int levelNext, Map<String, Integer> mapLevel0) {
        Map<String, List> sortedMapLevelNP1pretty;
        HashMap mapLevelNP1 = new HashMap();
        HashMap mapLevelNP1pretty = new HashMap();
        for (Pair<String, Object[]> pair : this.records) {
            String methodName = (String)pair.getKey();
            Object[] record = (Object[])pair.getRight();
            FileBuilder builder = registry.get(methodName);
            Object remoteClientBuilder = clientRegistry.get(methodName);
            ProxyMakerInterface makerBuilder = pm.facadeProxy(ProxyMakerInterface.class, builder);
            ProxyClientInterface clientBuilder = pm.facadeProxy(ProxyClientInterface.class, remoteClientBuilder);
            Object[] typedRecord = (Object[])makerBuilder.make(record, makerBuilder.getTypedRecord());
            HashMap<String, Collection<int[]>> mapLevelNP1_tmp = new HashMap<String, Collection<int[]>>();
            makerBuilder.propagateTypes(typedRecord, mapLevelN, mapLevelNP1_tmp, mapLevel0);
            Map<String, Collection> mapLevelNP1_tmp2 = mapLevelNP1_tmp.keySet().stream().collect(Collectors.toMap(k -> k, k -> this.filterTypes((Collection)mapLevelNP1_tmp.get(k), clientBuilder, this.tMap)));
            Map<String, Collection> mapLevelNP1pretty_tmp = mapLevelNP1_tmp2.keySet().stream().collect(Collectors.toMap(s -> s, s -> ((Collection)mapLevelNP1_tmp2.get(s)).stream().map(a -> this.constructType((int[])a, clientBuilder, this.tMap)).collect(Collectors.toList())));
            mapLevelNP1_tmp.keySet().forEach(key -> {
                mapLevelNP1.computeIfAbsent(key, s -> new LinkedList());
                ((Collection)mapLevelNP1.get(key)).addAll((Collection)mapLevelNP1_tmp.get(key));
            });
            mapLevelNP1pretty_tmp.keySet().forEach(key -> {
                mapLevelNP1pretty.computeIfAbsent(key, s -> new LinkedList());
                ((Collection)mapLevelNP1pretty.get(key)).addAll((Collection)mapLevelNP1pretty_tmp.get(key));
            });
        }
        this.result.put("allRelations", this.allRelations);
        this.tMap.allRelations = this.swap(this.allRelations);
        this.result.put("tmap", this.tMap);
        this.result.put("mapLevel" + levelNext, mapLevelNP1);
        Map<String, List> tmp_finalSortedMapLevelNP1pretty = sortedMapLevelNP1pretty = mapLevelNP1pretty.keySet().stream().collect(Collectors.toMap(s -> s, s -> ((Collection)mapLevelNP1pretty.get(s)).stream().sorted(collectionComparator).collect(Collectors.toList())));
        sortedMapLevelNP1pretty = !this.addLevel0ToAllLevels ? tmp_finalSortedMapLevelNP1pretty : tmp_finalSortedMapLevelNP1pretty.keySet().stream().collect(Collectors.toMap(s -> s, s -> {
            List ll = (List)tmp_finalSortedMapLevelNP1pretty.get(s);
            ll.add(0, List.of(Integer.valueOf(-1), (Integer)mapLevel0.get(s)));
            return ll;
        }));
        this.result.put("level" + levelNext, sortedMapLevelNP1pretty);
        this.levelRelTypeSetIndex.computeIfAbsent(levelNext, n -> new HashMap());
        Map<List<List<Integer>>, Integer> levelNRelTypeSetIndex = this.levelRelTypeSetIndex.get(levelNext);
        int count = this.newPossibleIndex(levelNRelTypeSetIndex.values(), this.levelOffset * levelNext + this.relationOffset);
        for (List coll : sortedMapLevelNP1pretty.values()) {
            if (levelNRelTypeSetIndex.get(coll) != null) continue;
            levelNRelTypeSetIndex.put(coll, count++);
        }
        this.result.put("levelNRelTypeSetIndex" + levelNext, levelNRelTypeSetIndex);
        this.tMap.assign("levelNRelTypeSetIndex", levelNext, this.swap(levelNRelTypeSetIndex));
        Map<String, List> finalSortedMapLevelNP1pretty1 = sortedMapLevelNP1pretty;
        Map<String, Integer> levelNS = sortedMapLevelNP1pretty.keySet().stream().collect(Collectors.toMap(s -> s, s -> (Integer)levelNRelTypeSetIndex.get(finalSortedMapLevelNP1pretty1.get(s))));
        this.result.put("level" + levelNext + "S", levelNS);
        return levelNS;
    }

    public Map<String, Collection<Integer>> computeTypesPerNode(int bound) {
        HashMap<String, Collection<Integer>> types = new HashMap<String, Collection<Integer>>();
        for (int count = 0; count < bound; ++count) {
            Map levelNS = (Map)this.result.get("level" + count + "S");
            levelNS.keySet().forEach(k -> {
                types.computeIfAbsent((String)k, n -> new HashSet());
                ((Collection)types.get(k)).add((Integer)levelNS.get(k));
            });
        }
        this.result.put("allTypes", types);
        return types;
    }

    public Map<Integer, Integer> computeFeatureVector(Map<String, Collection<Integer>> types) {
        System.out.println("computedFeatureVector");
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        Collection<Collection<Integer>> allCollections = types.values();
        for (Collection<Integer> coll : allCollections) {
            for (int value : coll) {
                counts.putIfAbsent(value, 0);
                counts.put(value, 1 + (Integer)counts.get(value));
            }
        }
        this.result.put("counts", counts);
        this.tMap.features = counts;
        this.tMap.merge();
        Map idata = (Map)this.result.get("idata0");
        Map<Integer, List> structuredDescriptors = this.tMap.allLevelsCompact.keySet().stream().collect(Collectors.toMap(k -> k, k1 -> this.getStructuredDescriptors((Integer)k1, idata)));
        this.tMap.structuredDescriptors = structuredDescriptors;
        return counts;
    }

    public List<Descriptor> getStructuredDescriptors(Integer k, Map<String, Map<String, Set<String>>> idata) {
        return k < this.levelOffset ? this.getStructuredDescriptors0(k, idata) : this.getStructuredDescriptorsN(k, idata);
    }

    public List<Descriptor> getStructuredDescriptorsN(Integer k, Map<String, Map<String, Set<String>>> idata) {
        Map<List<Integer>, Long> m = this.tMap.allLevelsCompact.get(k);
        return m.keySet().stream().map(ss -> this.convertToDescriptor((List<Integer>)ss, (Long)m.get(ss), idata)).sorted().collect(Collectors.toList());
    }

    public List<Descriptor> getStructuredDescriptors0(Integer k, Map<String, Map<String, Set<String>>> idata) {
        return Collections.singletonList(new DescriptorAtom(k, this.tMap.level0S.get(k).stream().map(this::getDescriptor0).collect(Collectors.toList()), this.getIdata(k, idata)));
    }

    public List<String> getStructuredDescriptorString0(Integer k) {
        return this.tMap.level0S.get(k).stream().map(this::getDescriptor0).collect(Collectors.toList());
    }

    private Descriptor convertToDescriptor(List<Integer> ll, Long count, Map<String, Map<String, Set<String>>> idata) {
        if (ll.get(0) == -1) {
            return new DescriptorAtom(ll.get(1), this.getStructuredDescriptorString0(ll.get(1)), this.getIdata(ll.get(1), idata));
        }
        return new DescriptorTree(ll.get(1), count, this.tMap.allRelations.get(ll.get(0)), this.getStructuredDescriptors(ll.get(1), idata));
    }

    static String numeral(Long count) {
        if (1L == count) {
            return "";
        }
        return count + " ";
    }

    private String translateRelation(String s) {
        if (this.translation != null) {
            return this.translation.getOrDefault(s, s);
        }
        return s;
    }

    public String getDescriptor0(Integer k) {
        return TypesRecordProcessor.localName(this.tMap.level0.get(k));
    }

    public Map<String, Set<String>> getIdata(Integer k, Map<String, Map<String, Set<String>>> idata) {
        List<String> strings = this.level0SR.get(k);
        if (strings == null) {
            return null;
        }
        Map<String, Set<String>> res = strings.stream().map(idata::get).reduce(new HashMap(), this.mergeIDataMaps);
        return res;
    }

    public static String localName(String s) {
        int pos = s.lastIndexOf("#");
        if (pos > 0) {
            return s.substring(pos + 1);
        }
        pos = s.lastIndexOf("/");
        if (pos > 0) {
            return s.substring(pos + 1);
        }
        return s;
    }

    public Collection<int[]> filterTypes(Collection<int[]> types, ProxyClientInterface clientBuilder, TMap tMap) {
        return types.stream().filter(r -> this.filterTypeRecord((int[])r, clientBuilder, tMap)).collect(Collectors.toList());
    }

    public boolean filterTypeRecord(int[] typeRecord, ProxyClientInterface clientBuilder, TMap tMap) {
        if (this.rejectedTypes == null || this.rejectedTypes.isEmpty()) {
            return true;
        }
        int out = typeRecord[0];
        int outType = typeRecord[1];
        int relType = typeRecord[2];
        int inType = typeRecord[3];
        int in = typeRecord[4];
        String rel = this.prettifyType(clientBuilder, tMap, out, outType, relType, in);
        boolean result = !this.rejectedTypes.contains(rel);
        return result;
    }

    public List<Integer> constructType(int[] typeRecord, ProxyClientInterface clientBuilder, TMap tMap) {
        int out = typeRecord[0];
        int outType = typeRecord[1];
        int relType = typeRecord[2];
        int inType = typeRecord[3];
        int in = typeRecord[4];
        String rel = this.prettifyType(clientBuilder, tMap, out, outType, relType, in);
        if (this.allRelations.get(rel) == null) {
            this.allRelations.put(rel, this.relationCount);
            ++this.relationCount;
        }
        return List.of(this.allRelations.get(rel), Integer.valueOf(inType));
    }

    private String prettifyType(ProxyClientInterface clientBuilder, TMap tMap, int out, int outType, int relType, int in) {
        StringBuffer sb = new StringBuffer();
        sb.append(clientBuilder.getName());
        sb.append(".");
        sb.append(clientBuilder.getPropertyOrder()[out]);
        sb.append(".");
        sb.append(TypesRecordProcessor.niceRelationName(StatementOrBundle.Kind.values()[outType]));
        sb.append(".");
        sb.append(clientBuilder.getPropertyOrder()[in]);
        if (relType != -1) {
            sb.append("[");
            sb.append(tMap.level0S.get(relType).stream().map(i -> TypesRecordProcessor.localName(tMap.level0.get(i))).collect(Collectors.joining(",", "", "")));
            sb.append("]");
        }
        String rel = sb.toString();
        return rel;
    }

    private static String niceRelationName(StatementOrBundle.Kind value) {
        switch (value) {
            case PROV_ENTITY: {
                return "ent";
            }
            case PROV_ACTIVITY: {
                return "act";
            }
            case PROV_AGENT: {
                return "ag";
            }
            case PROV_USAGE: {
                return "usd";
            }
            case PROV_GENERATION: {
                return "wgb";
            }
            case PROV_INVALIDATION: {
                return "wib";
            }
            case PROV_START: {
                return "wsb";
            }
            case PROV_END: {
                return "web";
            }
            case PROV_COMMUNICATION: {
                return "winf";
            }
            case PROV_DERIVATION: {
                return "wdf";
            }
            case PROV_ASSOCIATION: {
                return "waw";
            }
            case PROV_ATTRIBUTION: {
                return "wat";
            }
            case PROV_DELEGATION: {
                return "aobo";
            }
            case PROV_INFLUENCE: {
                return "winfl";
            }
            case PROV_ALTERNATE: {
                return "alt";
            }
            case PROV_SPECIALIZATION: {
                return "spe";
            }
            case PROV_MENTION: {
                return "mention";
            }
            case PROV_MEMBERSHIP: {
                return "mem";
            }
            case PROV_BUNDLE: {
                return "bun";
            }
        }
        throw new IllegalStateException("Unexpected value: " + value);
    }

    public <ALPHA, BETA> Map<BETA, ALPHA> swap(Map<ALPHA, BETA> m) {
        return m.keySet().stream().collect(Collectors.toMap(m::get, a -> a));
    }

    public Map<String, Integer> level0(Map<QualifiedName, Set<String>> knownTypeMap, Map<QualifiedName, Set<String>> unknownTypeMap, Map<String, Map<String, BiFunction<Object, String, Collection<String>>>> propertyConverters, Map<QualifiedName, Map<String, Set<String>>> idata) {
        Map<String, Set<String>> knownTypeMap2 = knownTypeMap.keySet().stream().collect(Collectors.toMap(QualifiedName::getUri, knownTypeMap::get));
        Map<String, Set<String>> unknownTypeMap2 = unknownTypeMap.keySet().stream().collect(Collectors.toMap(QualifiedName::getUri, unknownTypeMap::get));
        Map<String, Map> idata2 = idata.keySet().stream().collect(Collectors.toMap(QualifiedName::getUri, idata::get));
        Map<String, Integer> level0TypeIndex = this.levelTypeIndex.get(0);
        Collection<Integer> level0Values = level0TypeIndex.values();
        Set<String> allValues = this.flattenAllValues(knownTypeMap2, unknownTypeMap2);
        Set<String> newValues = this.findNewValues(allValues, level0TypeIndex);
        int nextIndex = this.newPossibleIndex(level0Values);
        List ordered = newValues.stream().sorted().collect(Collectors.toList());
        for (String s2 : ordered) {
            level0TypeIndex.put(s2, nextIndex);
            ++nextIndex;
        }
        Map<String, Set> knownTypeMap3 = knownTypeMap2.keySet().stream().collect(Collectors.toMap(s -> s, s -> ((Set)knownTypeMap2.get(s)).stream().map(level0TypeIndex::get).collect(Collectors.toSet())));
        Map<String, Set> unknownTypeMap3 = unknownTypeMap2.keySet().stream().collect(Collectors.toMap(s -> s, s -> ((Set)unknownTypeMap2.get(s)).stream().map(level0TypeIndex::get).collect(Collectors.toSet())));
        Map level0 = TypesRecordProcessor.mergeMapsOfSets(knownTypeMap3, unknownTypeMap3);
        this.result.put("level0TypeIndex", level0TypeIndex);
        this.result.put("level0", level0);
        this.result.put("idata0", idata2);
        this.tMap.level0 = this.swap(level0TypeIndex);
        HashSet allSetValues = new HashSet(level0.values());
        Map<Set<Integer>, Integer> level0TypeSetIndex = this.levelTypeSetIndex.get(0);
        Set<Set<Integer>> knownTypeSets = level0TypeSetIndex.keySet();
        HashSet newTypeSets = new HashSet(allSetValues);
        newTypeSets.removeAll(knownTypeSets);
        Collection<Integer> level0SValues = level0TypeSetIndex.values();
        int nextIndexS = this.newPossibleIndex(level0SValues);
        List orderedS = newTypeSets.stream().sorted(collectionComparator).collect(Collectors.toList());
        for (Set s3 : orderedS) {
            level0TypeSetIndex.put(s3, nextIndexS);
            ++nextIndexS;
        }
        this.result.put("level0STypeIndex", level0TypeSetIndex);
        Map<String, Integer> level0S = level0.keySet().stream().collect(Collectors.toMap(s -> s, s -> (Integer)level0TypeSetIndex.get(level0.get(s))));
        this.result.put("level0S", level0S);
        Map<Integer, List<String>> level0SR = TypesRecordProcessor.invertMapUsingGroupingBy(level0S);
        this.result.put("level0SR", level0SR);
        this.level0SR = level0SR;
        this.tMap.level0S = this.swap(level0TypeSetIndex);
        return level0S;
    }

    public Map<String, Object> getResult() {
        return this.result;
    }

    public void computeLevels(HashMap<String, FileBuilder> registry, HashMap<String, Object> clientRegistry, ProxyManagement pm, Map<QualifiedName, Set<String>> knownTypeMap, Map<QualifiedName, Set<String>> unknownTypeMap, Map<String, Map<String, BiFunction<Object, String, Collection<String>>>> propertyConverters, Map<String, Map<String, BiFunction<Object, String, Collection<String>>>> idataConverters, Map<QualifiedName, Map<String, Set<String>>> idata, int bound) {
        Map<String, Integer> level0;
        Map<String, Integer> level = level0 = this.level0(knownTypeMap, unknownTypeMap, propertyConverters, idata);
        for (int i = 1; i < bound; ++i) {
            System.out.println("levelN " + i);
            level = this.levelN(registry, clientRegistry, pm, level, i, level0);
        }
        System.out.println("Done computeLevels");
    }

    public static <ALPHA, BETA> Map<ALPHA, Set<BETA>> mergeMapsOfSets(Map<ALPHA, Set<BETA>> map1, Map<ALPHA, Set<BETA>> map2) {
        HashMap result = new HashMap(map2);
        map1.forEach((k, v) -> result.merge((Object)k, (Set)v, (v1, v2) -> {
            TreeSet set = new TreeSet(v1);
            set.addAll(v2);
            return set;
        }));
        return result;
    }

    public static <ALPHA, BETA> Map<ALPHA, List<BETA>> mergeMapsOfLists(Map<ALPHA, List<BETA>> map1, Map<ALPHA, List<BETA>> map2) {
        HashMap result = new HashMap(map2);
        map1.forEach((k, v) -> result.merge((Object)k, (List)v, (v1, v2) -> {
            LinkedList set = new LinkedList(v1);
            set.addAll(v2);
            return set;
        }));
        return result;
    }

    private static <V, K> Map<V, List<K>> invertMapUsingGroupingBy(Map<K, V> map) {
        Map inversedMap = map.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        return inversedMap;
    }

    private int newPossibleIndex(Collection<Integer> level0Values, int defaultValue) {
        return (level0Values.isEmpty() ? defaultValue : Collections.max(level0Values)) + 1;
    }

    private int newPossibleIndex(Collection<Integer> level0Values) {
        return (level0Values.isEmpty() ? 0 : Collections.max(level0Values)) + 1;
    }

    private Set<String> findNewValues(Set<String> allValues, Map<String, Integer> level0TypeIndex) {
        HashSet<String> newValues = new HashSet<String>(allValues);
        newValues.removeAll(level0TypeIndex.keySet());
        return newValues;
    }

    private Set<String> flattenAllValues(Map<String, Set<String>> knownTypeMap2, Map<String, Set<String>> unknownTypeMap2) {
        Set allValues1 = knownTypeMap2.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set allValues2 = unknownTypeMap2.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet<String> allValues = new HashSet<String>();
        allValues.addAll(allValues1);
        allValues.addAll(allValues2);
        return allValues;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public Map<String, Map<String, BiFunction<Object, String, Collection<String>>>> getPropertyConverters() {
        return this.propertyConverters;
    }

    public Map<String, Map<String, BiFunction<Object, String, Collection<String>>>> getIDataConverters() {
        return this.idataConverters;
    }

    public Map<String, Map<String, BiFunction<Object, String, Collection<String>>>> initialisePropertyConverters(Map<String, Map<String, List<String>>> converters) {
        return converters.keySet().stream().collect(Collectors.toMap(s -> s, s -> this.initialise((Map)converters.get(s))));
    }

    public Map<String, BiFunction<Object, String, Collection<String>>> initialise(Map<String, List<String>> m) {
        return m.keySet().stream().collect(Collectors.toMap(s -> s, s -> ((List)m.get(s)).stream().map(fname -> this.initialize((String)s, (String)fname)).reduce(this.biidentity, this.bicompose)));
    }

    private BiFunction<Object, String, Collection<String>> initialize(String property, String classname) {
        try {
            return (BiFunction)Class.forName(classname).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("fail to initialize property converter " + classname + " for property " + property);
        }
    }
}

