/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.TemplatesCompilerConfig;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.template.log2prov.Runner;
import org.openprovenance.prov.template.types.ProvenanceKernels;
import org.openprovenance.prov.vanilla.ProvFactory;

public class CompilerBuilderInit {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    private final org.openprovenance.prov.model.ProvFactory pFactory;

    public CompilerBuilderInit(org.openprovenance.prov.model.ProvFactory pFactory) {
        this.pFactory = pFactory;
    }

    JavaFile generateInitializer(TemplatesCompilerConfig configs) {
        int size = configs.templates.length;
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("Init");
        builder.addField(String[].class, "builders", new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        builder.addField(String[].class, "typeManagers", new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        builder.addField(org.openprovenance.prov.model.ProvFactory.class, "pf", new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder block = CodeBlock.builder();
        block.addStatement("$N = new String[$L]", new Object[]{"builders", size});
        block.addStatement("$N = new String[$L]", new Object[]{"typeManagers", size});
        int count = 0;
        for (TemplateCompilerConfig config : configs.templates) {
            block.addStatement("$N[$L]=$S", new Object[]{"builders", count, config.package_ + "." + this.compilerUtil.templateNameClass(config.name)});
            block.addStatement("$N[$L]=$S", new Object[]{"typeManagers", count, config.package_ + "." + this.compilerUtil.templateNameClass(config.name) + "TypeManagement"});
            ++count;
        }
        block.addStatement("pf=$T.getFactory()", new Object[]{ProvFactory.class});
        builder.addStaticBlock(block.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"init").addStatement("return $T.registerBuilders($N,$N)", new Object[]{FileBuilder.class, "builders", "pf"}).returns(Boolean.TYPE).addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        builder.addMethod(this.generateMain());
        TypeSpec theInitializer = builder.build();
        JavaFile myfile = JavaFile.builder((String)configs.init_package, (TypeSpec)theInitializer).addFileComment("Generated Automatically by ProvToolbox ($N) for templates config $N", new Object[]{this.getClass().getName(), configs.name}).build();
        return myfile;
    }

    public MethodSpec generateMain() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"main").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Void.TYPE).addParameter(String[].class, "args", new Modifier[0]).addException(Exception.class).addStatement("init()", new Object[0]).beginControlFlow("if ($S.equals(args[0]))", new Object[]{"kernel"}).addStatement("System.out.println(\"arguments \" + $T.of(args))", new Object[]{List.class}).addStatement("$T.main($N)", new Object[]{ProvenanceKernels.class, "args"}).nextControlFlow("else", new Object[0]).addStatement("$T.main($N)", new Object[]{Runner.class, "args"}).endControlFlow();
        return builder.build();
    }
}

