/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.expansion;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.template.compiler.CompilerClient;
import org.openprovenance.prov.template.compiler.CompilerUtil;

public class CompilerTypedRecord {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    private final ProvFactory pFactory;
    private final boolean withMain;
    private final CompilerClient compilerClient;
    private final boolean debugComment;

    public CompilerTypedRecord(boolean withMain, CompilerClient compilerClient, ProvFactory pFactory, boolean debugComment) {
        this.pFactory = pFactory;
        this.withMain = withMain;
        this.compilerClient = compilerClient;
        this.debugComment = debugComment;
    }

    public JavaFile generatedTypedRecordConstructor(Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generateTypeDeclaration_aux(doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema);
    }

    public JavaFile generateTypeDeclaration_aux(Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        MethodSpec.Builder mbuilder = MethodSpec.methodBuilder((String)"call").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeVariableName.get(Object[].class));
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        this.compilerUtil.generateDocumentSpecializedParameters(mbuilder, the_var);
        String allArgs = this.compilerUtil.generateArgumentsListForCall(the_var, null);
        mbuilder.addStatement("return new Object[] { $S , " + allArgs + "}", new Object[]{templateName});
        TypeSpec.Builder builder = this.compilerUtil.generateTypedRecordClass(name);
        ParameterizedTypeName superinterface = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)(name + "Interface"), (String[])new String[0]), (TypeName[])new TypeName[]{TypeName.get(Object[].class)});
        builder.addSuperinterface((TypeName)superinterface);
        builder.addMethod(mbuilder.build());
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox ($N) for template $N", new Object[]{this.getClass().getName() + "generateTypeDeclaration_aux()", templateName}).build();
        return myfile;
    }
}

