/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.expansion;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.expansion.CompilerExpansionBuilder;
import org.openprovenance.prov.template.compiler.expansion.CompilerTypeManagement;
import org.openprovenance.prov.template.expander.ExpandUtil;
import org.openprovenance.prov.template.expander.MissingAttributeValue;

public class StatementTypeAction
implements StatementAction {
    public static String AGENT_URI = "http://www.w3.org/ns/prov#Agent";
    public static String ENTITY_URI = "http://www.w3.org/ns/prov#Entity";
    public static String ACTIVITY_URI = "http://www.w3.org/ns/prov#Activity";
    public static String BUNDLE_URI = "http://www.w3.org/ns/prov#Bundle";
    public static String WASDERIVEDFROM_URI = "http://www.w3.org/ns/prov#WasDerivedFrom";
    public static String QUALIFIEDHADMEMBER_URI = "http://openprovenance.org/prov/extension#HadMember";
    private final JsonNode bindings_schema;
    private final Map<String, Collection<String>> knownTypes;
    private final Map<String, Collection<String>> unknownTypes;
    private final MethodSpec.Builder mbuilder;
    private final CompilerUtil compilerUtil;
    private Set<QualifiedName> allVars;
    private Set<QualifiedName> allAtts;
    private final ProvFactory pFactory;
    private Hashtable<QualifiedName, String> vmap;
    public final QualifiedName PROV_EXT_NS_ID;
    static final Class<HashSet> collectionClass = HashSet.class;
    public static String bnNS = "http://openprovenance.org/blank#";
    public static String bnPrefix = "bn";
    static int count = 0;
    static int anotherCounter = 0;
    static int iDataCounter = 0;

    public StatementTypeAction(ProvFactory pFactory, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, Hashtable<QualifiedName, String> vmap, MethodSpec.Builder builder, String target, JsonNode bindings_schema, Map<String, Collection<String>> knownTypes, Map<String, Collection<String>> unknownTypes, MethodSpec.Builder mbuilder, CompilerUtil compilerUtil) {
        this.pFactory = pFactory;
        this.allVars = allVars;
        this.allAtts = allAtts;
        this.vmap = vmap;
        this.bindings_schema = bindings_schema;
        this.knownTypes = knownTypes;
        this.unknownTypes = unknownTypes;
        this.mbuilder = mbuilder;
        this.compilerUtil = compilerUtil;
        this.PROV_EXT_NS_ID = pFactory.newQualifiedName("http://openprovenance.org/prov/extension#", "id", "provxt");
    }

    public Map<String, Collection<String>> getKnownTypes() {
        return this.knownTypes;
    }

    public Map<String, Collection<String>> getUnknownTypes() {
        return this.unknownTypes;
    }

    public void registerTypes(QualifiedName id, List<Type> types) {
        if (id != null) {
            types.forEach(type -> {
                Object o = type.getValue();
                if (o instanceof QualifiedName) {
                    QualifiedName qn = (QualifiedName)o;
                    if (ExpandUtil.isVariable((QualifiedName)qn)) {
                        this.registerUnknownType(id, qn.getUri());
                    } else {
                        this.registerAType(id, qn.getUri());
                    }
                }
            });
        }
    }

    public void registerTypes(QualifiedName id, String suffix, List<Type> types) {
        if (id != null) {
            types.forEach(type -> {
                Object o = type.getValue();
                if (o instanceof QualifiedName) {
                    QualifiedName qn = (QualifiedName)o;
                    if (ExpandUtil.isVariable((QualifiedName)qn)) {
                        this.registerUnknownType(id, suffix, qn.getUri());
                    } else {
                        this.registerAType(id, suffix, qn.getUri());
                    }
                }
            });
        }
    }

    public void registerTypes2(QualifiedName id, Collection<QualifiedName> types) {
        if (id != null && types != null) {
            types.forEach(qn -> {
                if (ExpandUtil.isVariable((QualifiedName)qn)) {
                    this.registerUnknownType(id, qn.getUri());
                } else {
                    this.registerAType(id, qn.getUri());
                }
            });
        }
    }

    public void registerTypes2(QualifiedName id, String suffix, Collection<QualifiedName> types) {
        if (id != null && types != null) {
            types.forEach(qn -> {
                if (ExpandUtil.isVariable((QualifiedName)qn)) {
                    this.registerUnknownType(id, suffix, qn.getUri());
                } else {
                    this.registerAType(id, suffix, qn.getUri());
                }
            });
        }
    }

    public void registerAgent(QualifiedName id) {
        this.registerAType(id, AGENT_URI);
    }

    public void registerEntity(QualifiedName id) {
        this.registerAType(id, ENTITY_URI);
    }

    public void registerActivity(QualifiedName id) {
        this.registerAType(id, ACTIVITY_URI);
    }

    public void registerBundle(QualifiedName id) {
        this.registerAType(id, BUNDLE_URI);
    }

    private void registerAType(QualifiedName id, String type) {
        if (id != null) {
            String uri = id.getUri();
            this.knownTypes.computeIfAbsent(uri, k -> new HashSet());
            this.knownTypes.get(uri).add(type);
        }
    }

    private void registerAType(QualifiedName id, String suffix, String type) {
        if (id != null) {
            String uri = id.getUri() + suffix;
            this.knownTypes.computeIfAbsent(uri, k -> new HashSet());
            this.knownTypes.get(uri).add(type);
        }
    }

    private void registerUnknownType(QualifiedName id, String type) {
        if (id != null) {
            String uri = id.getUri();
            this.unknownTypes.computeIfAbsent(uri, k -> new HashSet());
            this.unknownTypes.get(uri).add(type);
        }
    }

    private void registerUnknownType(QualifiedName id, String suffix, String type) {
        if (id != null) {
            String uri = id.getUri() + suffix;
            this.unknownTypes.computeIfAbsent(uri, k -> new HashSet());
            this.unknownTypes.get(uri).add(type);
        }
    }

    public void doAction(Activity s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getId());
        Collection attributes = this.pFactory.getAttributes((Statement)s);
        this.doRegisterTypesForAttributes((Identifiable)s, attributes, ACTIVITY_URI);
        this.doRegisterIDataForAttributes((Identifiable)s, attributes, s.getType(), ACTIVITY_URI);
    }

    public void doAction(Used s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getEntity());
    }

    public void doAction(WasGeneratedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getEntity());
    }

    public void doAction(WasInvalidatedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getEntity());
    }

    public void doAction(WasStartedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getStarter());
        this.registerEntity(s.getTrigger());
    }

    public void doAction(Agent s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerAgent(s.getId());
        Collection attributes = this.pFactory.getAttributes((Statement)s);
        attributes.add(this.pFactory.newType((Object)this.pFactory.newQualifiedName("http://www.w3.org/ns/prov#", "Agent", "prov"), this.pFactory.getName().PROV_QUALIFIED_NAME));
        this.doRegisterTypesForAttributes((Identifiable)s, attributes, AGENT_URI);
        this.doRegisterIDataForAttributes((Identifiable)s, attributes, s.getType(), AGENT_URI);
    }

    public void doAction(Entity s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getId());
        Collection attributes = this.pFactory.getAttributes((Statement)s);
        this.doRegisterTypesForAttributes((Identifiable)s, attributes, ENTITY_URI);
        this.doRegisterIDataForAttributes((Identifiable)s, attributes, s.getType(), ENTITY_URI);
    }

    public void doAction(AlternateOf s) {
    }

    public void doAction(WasAssociatedWith s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerAgent(s.getAgent());
        this.registerEntity(s.getPlan());
    }

    public void doAction(WasAttributedTo s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerAgent(s.getAgent());
        this.registerEntity(s.getEntity());
    }

    public void doAction(WasInfluencedBy s) {
        this.registerTypes(s.getId(), s.getType());
    }

    public void doAction(ActedOnBehalfOf s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerAgent(s.getResponsible());
        this.registerAgent(s.getDelegate());
        this.registerActivity(s.getActivity());
    }

    public Collection<QualifiedName> doCollectElementVariables(Statement s, String search) {
        return CompilerExpansionBuilder.doCollectElementVariables(this.pFactory, s, search);
    }

    public static QualifiedName gensym() {
        return new org.openprovenance.prov.vanilla.QualifiedName(bnNS, "n" + count++, bnPrefix);
    }

    public void doAction(WasDerivedFrom s) {
        Collection<QualifiedName> qualifiedNames = this.doCollectElementVariables((Statement)s, "http://openprovenance.org/tmpl#activityType");
        if (s.getId() == null) {
            s.setId(StatementTypeAction.gensym());
        }
        this.mbuilder.addComment("wdf $N", new Object[]{s.getId().getUri()});
        this.registerAType(s.getId(), WASDERIVEDFROM_URI);
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getUsedEntity());
        this.registerEntity(s.getGeneratedEntity());
        this.registerActivity(s.getActivity());
        if (qualifiedNames != null && !qualifiedNames.isEmpty()) {
            this.registerTypes2(s.getId(), qualifiedNames);
            this.dynamicRegisterTypes((Identifiable)s, qualifiedNames, WASDERIVEDFROM_URI);
        }
    }

    private void doRegisterTypesForAttributes(Identifiable s, Collection<Attribute> attributes, String expressionUri) {
        if (ExpandUtil.isGensymVariable((QualifiedName)s.getId())) {
            return;
        }
        JsonNode the_var = this.bindings_schema.get("var");
        this.mbuilder.beginControlFlow("if ($N!=null) ", new Object[]{s.getId().getLocalPart()});
        String tmp_Conv = "tmp_Conv" + anotherCounter++;
        this.mbuilder.addStatement("$T $N=propertyConverters.get($S)", new Object[]{CompilerTypeManagement.Map_S_to_Function, tmp_Conv, expressionUri});
        this.mbuilder.beginControlFlow("if ($N!=null) ", new Object[]{tmp_Conv});
        HashMap seen = new HashMap();
        attributes.forEach(attr -> {
            boolean first_encounter;
            String attributeUri = attr.getElementName().getUri();
            Object value = attr.getValue();
            if ("http://openprovenance.org/tmpl#".equals(attr.getElementName().getNamespaceURI())) {
                return;
            }
            if ("http://openprovenance.org/tmpl#".equals(attr.getElementName().getNamespaceURI())) {
                return;
            }
            Object tmp_Conv2 = (String)seen.get(attributeUri);
            if (tmp_Conv2 == null) {
                tmp_Conv2 = tmp_Conv + "_" + this.cleanUpName(attributeUri);
                seen.put(attributeUri, tmp_Conv2);
                first_encounter = true;
            } else {
                first_encounter = false;
            }
            if (first_encounter) {
                this.mbuilder.addStatement("$T $N=$N.get($S)", new Object[]{CompilerTypeManagement.Function_O_Col_S, tmp_Conv2, tmp_Conv, attributeUri});
            }
            this.mbuilder.beginControlFlow("if ($N!=null) ", new Object[]{tmp_Conv2});
            if (value instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)value;
                if (ExpandUtil.isVariable((QualifiedName)qn)) {
                    String key = qn.getLocalPart();
                    Class<?> atype = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
                    this.mbuilder.addStatement("unknownTypeMap.computeIfAbsent($N, k -> new HashSet<>())", new Object[]{s.getId().getLocalPart()});
                    if (atype.equals(QualifiedName.class)) {
                        this.mbuilder.addStatement("if ($N!=null) unknownTypeMap.get($N).addAll($N.apply($N.getUri(), $N.getUri()))", new Object[]{key, s.getId().getLocalPart(), tmp_Conv2, key, s.getId().getLocalPart()});
                    } else {
                        this.mbuilder.addStatement("if ($N!=null) unknownTypeMap.get($N).addAll($N.apply($N, $N.getUri()))", new Object[]{key, s.getId().getLocalPart(), tmp_Conv2, key, s.getId().getLocalPart()});
                    }
                } else {
                    this.mbuilder.addStatement("knownTypeMap.computeIfAbsent($N, k -> new HashSet<>())", new Object[]{s.getId().getLocalPart()});
                    this.mbuilder.addStatement("knownTypeMap.get($N).addAll($N.apply($S,$N.getUri()))", new Object[]{s.getId().getLocalPart(), tmp_Conv2, qn.getUri(), s.getId().getLocalPart()});
                }
            } else if (value instanceof String || value instanceof LangString || value instanceof Integer) {
                Object aString = String.valueOf(value);
                if (value instanceof LangString) {
                    LangString ls = (LangString)value;
                    String lang = ls.getLang();
                    aString = lang != null ? ls.getValue() + "~" + lang : ls.getValue();
                }
                this.mbuilder.addStatement("unknownTypeMap.get($N).addAll($N.apply($S,$N.getUri()))", new Object[]{s.getId().getLocalPart(), tmp_Conv2, aString, s.getId().getLocalPart()});
            } else {
                throw new UnsupportedOperationException("doRegisterTypesForAttributes with attribute value " + value + " for element " + attributeUri);
            }
            this.mbuilder.endControlFlow();
        });
        this.mbuilder.endControlFlow();
        this.mbuilder.endControlFlow();
    }

    private void doRegisterIDataForAttributes(Identifiable s, Collection<Attribute> attributes, List<Type> types, String expressionUri) {
        if (ExpandUtil.isGensymVariable((QualifiedName)s.getId())) {
            return;
        }
        JsonNode the_var = this.bindings_schema.get("var");
        this.mbuilder.beginControlFlow("if ($N!=null) ", new Object[]{s.getId().getLocalPart()});
        String tmp_Conv = "itmp_Conv" + iDataCounter++;
        this.mbuilder.addStatement("$T $N=null;", new Object[]{CompilerTypeManagement.Map_S_to_TriFunction, tmp_Conv});
        for (Type type : types) {
            Object o = type.getValue();
            if (o instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)o;
                if (ExpandUtil.isVariable((QualifiedName)qn)) {
                    this.mbuilder.addStatement("if (($N==null)&&($N!=null)) $N=idataConverters.get($N.getUri())", new Object[]{tmp_Conv, qn.getLocalPart(), tmp_Conv, qn.getLocalPart()});
                    continue;
                }
                this.mbuilder.addStatement("if ($N==null) $N=idataConverters.get($S)", new Object[]{tmp_Conv, tmp_Conv, qn.getUri()});
                continue;
            }
            if (o instanceof String) {
                String str = (String)o;
                this.mbuilder.addStatement("if ($N==null) $N=idataConverters.get($S)", new Object[]{tmp_Conv, tmp_Conv, str});
                continue;
            }
            throw new UnsupportedOperationException("doRegisterIDataForAttributes: Not supported type " + o);
        }
        this.mbuilder.addStatement("if ($N==null) $N=idataConverters.get($S)", new Object[]{tmp_Conv, tmp_Conv, expressionUri});
        this.mbuilder.beginControlFlow("if ($N!=null) ", new Object[]{tmp_Conv});
        HashMap seen = new HashMap();
        LinkedList<Attribute> attributes2 = new LinkedList<Attribute>(attributes);
        attributes2.add(this.pFactory.newAttribute(this.PROV_EXT_NS_ID, (Object)s.getId(), this.pFactory.getName().PROV_QUALIFIED_NAME));
        attributes2.forEach(attr -> {
            boolean first_encounter;
            String attributeUri = attr.getElementName().getUri();
            Object value = attr.getValue();
            if ("http://openprovenance.org/tmpl#".equals(attr.getElementName().getNamespaceURI())) {
                return;
            }
            if ("http://openprovenance.org/tmpl#".equals(attr.getElementName().getNamespaceURI())) {
                return;
            }
            Object tmp_Conv2 = (String)seen.get(attributeUri);
            if (tmp_Conv2 == null) {
                tmp_Conv2 = tmp_Conv + "_" + this.cleanUpName(attributeUri);
                seen.put(attributeUri, tmp_Conv2);
                first_encounter = true;
            } else {
                first_encounter = false;
            }
            if (first_encounter) {
                this.mbuilder.addStatement("$T $N=$N.get($S)", new Object[]{CompilerTypeManagement.TriFunction_O_Col_S, tmp_Conv2, tmp_Conv, attributeUri});
            }
            this.mbuilder.beginControlFlow("if ($N!=null) ", new Object[]{tmp_Conv2});
            if (value instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)value;
                if (ExpandUtil.isVariable((QualifiedName)qn)) {
                    String key = qn.getLocalPart();
                    Class<?> atype = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
                    this.mbuilder.addStatement("idata.computeIfAbsent($N, k -> new $T<>())", new Object[]{s.getId().getLocalPart(), HashMap.class});
                    if (atype.equals(QualifiedName.class)) {
                        this.mbuilder.beginControlFlow("if /* option 1 */ ($N!=null)", new Object[]{key});
                        String pairVariable = "p";
                        String pairVariable2 = "p2";
                        this.mbuilder.addStatement("$T $N=$N.apply($N.getUri(), $N.getUri(), $S))", new Object[]{CompilerTypeManagement.CollectionOfPairsOfStringAndString, pairVariable, tmp_Conv2, key, s.getId().getLocalPart(), attributeUri});
                        CodeBlock.Builder subBuilder = CodeBlock.builder();
                        subBuilder.addStatement("idata.get($N).computeIfAbsent($N.getLeft(), k -> new $T<>())", new Object[]{s.getId().getLocalPart(), pairVariable2, collectionClass});
                        subBuilder.addStatement("idata.get($N).get($N.getLeft()).addAll($N.getRight())", new Object[]{s.getId().getLocalPart(), pairVariable2, pairVariable2});
                        this.mbuilder.beginControlFlow("$N.forEach(p2 -> ", new Object[]{pairVariable});
                        this.mbuilder.addCode(subBuilder.build());
                        this.mbuilder.endControlFlow(")", new Object[0]);
                        this.mbuilder.endControlFlow();
                    } else {
                        this.mbuilder.beginControlFlow("if /* option 2 */ ($N!=null)", new Object[]{key});
                        String pairVariable = "p";
                        String pairVariable2 = "p2";
                        this.mbuilder.addStatement("$T $N=$N.apply($N,  $N.getUri(), $S)", new Object[]{CompilerTypeManagement.CollectionOfPairsOfStringAndString, pairVariable, tmp_Conv2, key, s.getId().getLocalPart(), attributeUri});
                        CodeBlock.Builder subBuilder = CodeBlock.builder();
                        subBuilder.addStatement("idata.get($N).computeIfAbsent($N.getLeft(), k -> new $T<>())", new Object[]{s.getId().getLocalPart(), pairVariable2, collectionClass});
                        subBuilder.addStatement("idata.get($N).get($N.getLeft()).addAll($N.getRight())", new Object[]{s.getId().getLocalPart(), pairVariable2, pairVariable2});
                        this.mbuilder.beginControlFlow("$N.forEach(p2 -> ", new Object[]{pairVariable});
                        this.mbuilder.addCode(subBuilder.build());
                        this.mbuilder.endControlFlow(")", new Object[0]);
                        this.mbuilder.endControlFlow();
                    }
                } else {
                    this.mbuilder.addStatement("// option 3", new Object[0]);
                    this.mbuilder.addStatement("idata.computeIfAbsent($N, k -> new $T<>())", new Object[]{s.getId().getLocalPart(), HashMap.class});
                    String pairVariable = "p";
                    String pairVariable2 = "p2";
                    this.mbuilder.addStatement("$T $N=$N.apply($S,  $N.getUri(), $S)", new Object[]{CompilerTypeManagement.CollectionOfPairsOfStringAndString, pairVariable, tmp_Conv2, attributeUri, s.getId().getLocalPart(), attributeUri});
                    CodeBlock.Builder subBuilder = CodeBlock.builder();
                    subBuilder.addStatement("idata.get($N).computeIfAbsent($N.getLeft(), k -> new $T<>())", new Object[]{s.getId().getLocalPart(), pairVariable2, collectionClass});
                    subBuilder.addStatement("idata.get($N).get($N.getLeft()).addAll($N.getRight())", new Object[]{s.getId().getLocalPart(), pairVariable2, pairVariable2});
                    this.mbuilder.beginControlFlow("$N.forEach(p2 -> ", new Object[]{pairVariable});
                    this.mbuilder.addCode(subBuilder.build());
                    this.mbuilder.endControlFlow(")", new Object[0]);
                }
            } else if (value instanceof String || value instanceof LangString || value instanceof Integer) {
                Object aString = String.valueOf(value);
                if (value instanceof LangString) {
                    LangString ls = (LangString)value;
                    String lang = ls.getLang();
                    aString = lang != null ? ls.getValue() + "~" + lang : ls.getValue();
                }
                this.mbuilder.addStatement("// option 4", new Object[0]);
                this.mbuilder.addStatement("idata.computeIfAbsent($N, k -> new $T<>())", new Object[]{s.getId().getLocalPart(), HashMap.class});
                String pairVariable = "p";
                String pairVariable2 = "p2";
                this.mbuilder.addStatement("$T $N=$N.apply($S, $N.getUri(), $S)", new Object[]{CompilerTypeManagement.CollectionOfPairsOfStringAndString, pairVariable, tmp_Conv2, aString, s.getId().getLocalPart(), attributeUri});
                CodeBlock.Builder subBuilder = CodeBlock.builder();
                subBuilder.addStatement("idata.get($N).computeIfAbsent($N.getLeft(), k -> new $T<>())", new Object[]{s.getId().getLocalPart(), pairVariable2, collectionClass});
                subBuilder.addStatement("idata.get($N).get($N.getLeft()).addAll($N.getRight())", new Object[]{s.getId().getLocalPart(), pairVariable2, pairVariable2});
                this.mbuilder.beginControlFlow("$N.forEach(p2 -> ", new Object[]{pairVariable});
                this.mbuilder.addCode(subBuilder.build());
                this.mbuilder.endControlFlow(")", new Object[0]);
            } else {
                throw new UnsupportedOperationException("doRegisterIDataForAttributes with attribute value " + value + " for element " + attributeUri);
            }
            this.mbuilder.endControlFlow();
        });
        this.mbuilder.endControlFlow();
        this.mbuilder.endControlFlow();
    }

    private String cleanUpName(String elementName) {
        return Base64.getEncoder().withoutPadding().encodeToString(elementName.getBytes(StandardCharsets.UTF_8));
    }

    private void dynamicRegisterTypes(Identifiable s, Collection<QualifiedName> qualifiedNames, String relationURI) {
        if (qualifiedNames == null) {
            return;
        }
        String tmp = "_tmp_" + s.getId().getLocalPart();
        Collection<QualifiedName> activities = this.doCollectElementVariables((Statement)s, "http://openprovenance.org/tmpl#activity");
        if (activities == null || activities.isEmpty()) {
            throw new MissingAttributeValue("http://openprovenance.org/tmpl#activity in relation " + s);
        }
        String localPart = s.getId().getLocalPart() + ".";
        String suffix = activities.stream().findFirst().get().getLocalPart();
        this.mbuilder.addStatement("$T $N=pf.newQualifiedName($S,$S+$N.getLocalPart(),$S)", new Object[]{QualifiedName.class, tmp, s.getId().getNamespaceURI(), localPart, suffix, s.getId().getPrefix()});
        this.mbuilder.addStatement("knownTypeMap.computeIfAbsent($N, k -> new $T<>())", new Object[]{tmp, HashSet.class});
        this.mbuilder.addStatement("knownTypeMap.get($N).add($S)", new Object[]{tmp, relationURI});
        qualifiedNames.forEach(q -> {
            if (ExpandUtil.isVariable((QualifiedName)q)) {
                this.mbuilder.addStatement("unknownTypeMap.computeIfAbsent($N, k -> new $T<>())", new Object[]{tmp, HashSet.class});
                this.mbuilder.addStatement("unknownTypeMap.get($N).add($N.getUri())", new Object[]{tmp, q.getLocalPart()});
            } else {
                this.mbuilder.addStatement("knownTypeMap.get($N).add($S)", new Object[]{tmp, q.getUri()});
            }
        });
    }

    public void doAction(DictionaryMembership s) {
    }

    public void doAction(DerivedByRemovalFrom s) {
    }

    public void doAction(WasEndedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getActivity());
        this.registerEntity(s.getEnder());
        this.registerEntity(s.getTrigger());
    }

    public void doAction(HadMember s) {
        this.registerEntity(s.getCollection());
        s.getEntity().forEach(this::registerEntity);
    }

    public void doAction(MentionOf s) {
    }

    public void doAction(SpecializationOf s) {
        this.registerEntity(s.getGeneralEntity());
        this.registerEntity(s.getSpecificEntity());
    }

    public void doAction(QualifiedSpecializationOf s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getGeneralEntity());
        this.registerEntity(s.getSpecificEntity());
    }

    public void doAction(QualifiedAlternateOf s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getAlternate1());
        this.registerEntity(s.getAlternate2());
    }

    public void doAction(QualifiedHadMember s) {
        Collection<QualifiedName> qualifiedNames = this.doCollectElementVariables((Statement)s, "http://openprovenance.org/tmpl#activityType");
        if (s.getId() == null) {
            s.setId(StatementTypeAction.gensym());
        }
        this.mbuilder.addComment("qualified mem $N", new Object[]{s.getId().getUri()});
        this.registerTypes(s.getId(), s.getType());
        this.registerEntity(s.getCollection());
        s.getEntity().forEach(this::registerEntity);
        this.registerAType(s.getId(), QUALIFIEDHADMEMBER_URI);
        if (qualifiedNames != null && !qualifiedNames.isEmpty()) {
            this.registerTypes2(s.getId(), qualifiedNames);
            this.dynamicRegisterTypes((Identifiable)s, qualifiedNames, QUALIFIEDHADMEMBER_URI);
        }
    }

    public void doAction(DerivedByInsertionFrom s) {
    }

    public void doAction(WasInformedBy s) {
        this.registerTypes(s.getId(), s.getType());
        this.registerActivity(s.getInformant());
        this.registerActivity(s.getInformed());
    }

    public void doAction(Bundle bun, ProvUtilities provUtilities) {
        this.registerBundle(bun.getId());
        StatementTypeAction action2 = new StatementTypeAction(this.pFactory, this.allVars, this.allAtts, this.vmap, null, null, this.bindings_schema, this.knownTypes, this.unknownTypes, this.mbuilder, this.compilerUtil);
        for (Statement s : bun.getStatement()) {
            provUtilities.doAction((StatementOrBundle)s, (StatementAction)action2);
        }
    }
}

