/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.tuple.Triple;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.common.BeanKind;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.NameDescriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerBeanGenerator {
    public static final String JAVADOC_NO_DOCUMENTATION = "xsd:string";
    public static final String PROCESSOR_PARAMETER_NAME = "__processor";
    private final CompilerUtil compilerUtil = new CompilerUtil();
    public Map<String, Map<String, Triple<String, List<String>, TemplateBindingsSchema>>> variantTable = new HashMap<String, Map<String, Triple<String, List<String>, TemplateBindingsSchema>>>();
    static final ParameterizedTypeName classOfUnknown = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"?")});

    public SpecificationFile generateBean(TemplatesCompilerConfig configs, Locations locations, String templateName, TemplateBindingsSchema bindingsSchema, BeanKind beanKind, BeanDirection beanDirection, String consistOf, List<String> sharing, String extension, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        Object name = this.compilerUtil.beanNameClass(templateName, beanDirection);
        if (extension != null) {
            name = (String)name + extension;
        }
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit((String)name);
        switch (beanKind) {
            case SIMPLE: {
                builder.addJavadoc("A Simple Bean", new Object[0]);
                break;
            }
            case COMPOSITE: {
                builder.addJavadoc("A composite Bean", new Object[0]);
            }
        }
        String packge = locations.getFilePackage(beanDirection);
        switch (beanDirection) {
            case INPUTS: {
                builder.addJavadoc(" that only contains the input of this template.", new Object[0]);
                break;
            }
            case OUTPUTS: {
                builder.addJavadoc(" that only contains the outputs of this template.", new Object[0]);
                break;
            }
            case COMMON: {
                builder.addJavadoc(" that captures all variables of this template.", new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + beanDirection);
            }
        }
        String directory = locations.convertToDirectory(packge);
        if (sharing != null) {
            builder.addJavadoc("\n This includes shared variables $N.", new Object[]{sharing.toString()});
        }
        FieldSpec.Builder b0 = FieldSpec.builder(String.class, (String)"isA", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer("$S", new Object[]{templateName});
        builder.addField(b0.build());
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        if (beanDirection == BeanDirection.OUTPUTS) {
            FieldSpec.Builder b = FieldSpec.builder(Integer.class, (String)"ID", (Modifier[])new Modifier[0]);
            b.addModifiers(new Modifier[]{Modifier.PUBLIC});
            b.addJavadoc("Allows for database key to be returned.", new Object[0]);
            builder.addField(b.build());
        }
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            if (beanDirection != BeanDirection.COMMON && beanKind != BeanKind.COMPOSITE && (beanDirection != BeanDirection.OUTPUTS || !ConfigProcessor.descriptorUtils.isOutput(key, bindingsSchema)) && (beanDirection != BeanDirection.INPUTS || !ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema) && (sharing == null || !sharing.contains(key)))) continue;
            FieldSpec.Builder b = FieldSpec.builder(this.compilerUtil.getJavaTypeForDeclaredType(theVar, key), (String)key, (Modifier[])new Modifier[0]);
            b.addModifiers(new Modifier[]{Modifier.PUBLIC});
            Descriptor descriptor = theVar.get(key).get(0);
            Function<NameDescriptor, Void> nf = nd -> {
                String documentation = nd.getDocumentation() == null ? "-- no @documentation" : nd.getDocumentation();
                String type = nd.getType() == null ? JAVADOC_NO_DOCUMENTATION : nd.getType();
                b.addJavadoc("$N: $L (expected type: $L)\n", new Object[]{key, documentation, type});
                if (sharing != null && sharing.contains(key)) {
                    b.addJavadoc("This is a shared variable in a template composition.\n", new Object[0]);
                }
                return null;
            };
            Function<AttributeDescriptor, Void> af = nd -> {
                String documentation = nd.getDocumentation() == null ? "-- no @documentation" : nd.getDocumentation();
                String type = nd.getType() == null ? JAVADOC_NO_DOCUMENTATION : nd.getType();
                b.addJavadoc("$N: $L (expected type: $L)\n", new Object[]{key, documentation, type});
                if (sharing != null && sharing.contains(key)) {
                    b.addJavadoc("This is a shared variable in a template composition.\n ", new Object[0]);
                }
                return null;
            };
            ConfigProcessor.descriptorUtils.getFromDescriptor(descriptor, af, nf);
            builder.addField(b.build());
        }
        if (beanKind == BeanKind.SIMPLE && beanDirection == BeanDirection.COMMON) {
            MethodSpec mbuild = this.generateInvokeProcessor(templateName, packge, bindingsSchema);
            builder.addMethod(mbuild);
        } else if (beanKind == BeanKind.COMPOSITE) {
            String variant = null;
            if (sharing != null) {
                variant = this.newVariant(consistOf, sharing, configs);
            }
            this.generateCompositeList(consistOf, packge, builder, beanDirection, variant, sharing);
            this.generateCompositeListExtender(consistOf, packge, builder, beanDirection, variant, sharing);
        }
        TypeSpec spec = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(spec, templateName, packge, stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, packge);
    }

    String newVariant(String templateName, List<String> sharing, TemplatesCompilerConfig configs) {
        String shared = this.stringForSharedVariables(sharing);
        this.variantTable.putIfAbsent(templateName, new HashMap());
        Triple<String, List<String>, TemplateBindingsSchema> triple = this.variantTable.get(templateName).get(shared);
        if (triple == null) {
            String extension = "_" + (this.variantTable.get(templateName).keySet().size() + 1);
            TemplateCompilerConfig config = Arrays.stream(configs.templates).filter(c -> Objects.equals(c.name, templateName)).findFirst().get();
            SimpleTemplateCompilerConfig sConfig = (SimpleTemplateCompilerConfig)config;
            SimpleTemplateCompilerConfig sConfig2 = sConfig.cloneAsInstanceInComposition(templateName + extension);
            TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema(sConfig2);
            this.variantTable.get(templateName).put(shared, (Triple<String, List<String>, TemplateBindingsSchema>)Triple.of((Object)extension, sharing, (Object)bindingsSchema));
            return extension;
        }
        return (String)triple.getLeft();
    }

    private String stringForSharedVariables(List<String> sharing) {
        return sharing.stream().sorted().collect(Collectors.joining("_"));
    }

    private void generateCompositeList(String templateName, String packge, TypeSpec.Builder builder, BeanDirection beanDirection, String variant, List<String> sharing) {
        String name = this.compilerUtil.beanNameClass(templateName, beanDirection, variant);
        ClassName consistsOfClass = ClassName.get((String)packge, (String)name, (String[])new String[0]);
        ParameterizedTypeName elementList = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{consistsOfClass});
        FieldSpec.Builder b1 = FieldSpec.builder((TypeName)elementList, (String)"__elements", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).initializer("new $T<>()", new Object[]{LinkedList.class});
        b1.addJavadoc("List of composed templates generated Automatically by ProvToolbox ($N.$N()) for template $N.", new Object[]{this.getClass().getSimpleName(), "generateCompositeList", templateName});
        if (variant != null) {
            b1.addJavadoc("\nVariant $N for shared variables $N ($N).", new Object[]{variant, this.stringForSharedVariables(sharing), sharing.toString()});
        }
        builder.addField(b1.build());
        FieldSpec.Builder b2 = FieldSpec.builder((TypeName)classOfUnknown, (String)"consistsOf", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Class of elements inside this composite", new Object[0]).initializer("$T.class", new Object[]{consistsOfClass});
        builder.addField(b2.build());
        if (variant != null) {
            for (String shared : sharing) {
                this.generateMutatorForSharedVariables(templateName, packge, builder, beanDirection, variant, shared, name);
                this.generateMutatorForDistinctVariables(templateName, packge, builder, beanDirection, variant, shared, name);
            }
        }
    }

    private void generateMutatorForDistinctVariables(String templateName, String packge, TypeSpec.Builder builder, BeanDirection beanDirection, String variant, String shared, String name) {
        MethodSpec.Builder mbuild = MethodSpec.methodBuilder((String)("distinct" + this.compilerUtil.capitalize(shared))).addParameter((TypeName)ClassName.get(Integer.class), "v", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.compilerUtil.specWithComment(mbuild);
        String countName = "__count";
        mbuild.addStatement("final int [] $N= { $N }", new Object[]{countName, "v"});
        mbuild.addStatement("$N.forEach(b -> { b.$N=$N[0]--; })", new Object[]{"__elements", shared, countName});
        builder.addMethod(mbuild.build());
    }

    private void generateMutatorForSharedVariables(String templateName, String packge, TypeSpec.Builder builder, BeanDirection beanDirection, String variant, String shared, String name) {
        MethodSpec.Builder mbuild = MethodSpec.methodBuilder((String)("shareAll" + this.compilerUtil.capitalize(shared))).addParameter((TypeName)ClassName.get(Integer.class), "v", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.compilerUtil.specWithComment(mbuild);
        mbuild.addStatement("$N.forEach(b -> { b.$N=$N; })", new Object[]{"__elements", shared, "v"});
        builder.addMethod(mbuild.build());
    }

    private void generateCompositeListExtender(String templateName, String packge, TypeSpec.Builder builder, BeanDirection beanDirection, String variant, List<String> sharing) {
        String name = this.compilerUtil.beanNameClass(templateName, beanDirection, variant);
        MethodSpec.Builder mbuilder = MethodSpec.methodBuilder((String)"__addElements").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get(Object.class), "o", new Modifier[0]);
        this.compilerUtil.specWithComment(mbuilder);
        mbuilder.addStatement("$N.add(($T)o)", new Object[]{"__elements", ClassName.get((String)packge, (String)name, (String[])new String[0])});
        builder.addMethod(mbuilder.build());
    }

    private TypeName processorClassType(String template, String packge) {
        return ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{ConfigProcessor.typeT});
    }

    public MethodSpec generateInvokeProcessor(String template, String packge, TemplateBindingsSchema bindingsSchema) {
        Collection<String> fieldNames = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        if (fieldNames.contains(PROCESSOR_PARAMETER_NAME)) {
            throw new IllegalStateException("Template " + template + " contains variable __processor " + fieldNames);
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ConfigProcessor.typeT).addTypeVariable(ConfigProcessor.typeT);
        builder.addParameter(this.processorClassType(template, packge), PROCESSOR_PARAMETER_NAME, new Modifier[0]);
        builder.addStatement("return $N.$N($L)", new Object[]{PROCESSOR_PARAMETER_NAME, "process", String.join((CharSequence)", ", fieldNames)});
        return builder.build();
    }

    public void generateSimpleConfigsWithVariants(Locations locations, TemplatesCompilerConfig configs) {
        this.variantTable.keySet().forEach(templateName -> {
            Map<String, Triple<String, List<String>, TemplateBindingsSchema>> allVariants = this.variantTable.get(templateName);
            allVariants.keySet().forEach(shared -> {
                Triple pair = (Triple)allVariants.get(shared);
                String extension = (String)pair.getLeft();
                List sharing = (List)pair.getMiddle();
                TemplateBindingsSchema bindingsSchema = (TemplateBindingsSchema)pair.getRight();
                SpecificationFile spec = this.generateBean(configs, locations, (String)templateName, bindingsSchema, BeanKind.SIMPLE, BeanDirection.INPUTS, null, sharing, extension, this.compilerUtil.beanNameClass((String)templateName, BeanDirection.INPUTS, extension) + ".java");
                spec.save();
            });
        });
    }
}

