/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanKind;
import org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.AttributeDescriptorList;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.NameDescriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerSQL {
    public static final String SMALL_INDENTATION = "  ";
    private final CompilerUtil compilerUtil = new CompilerUtil();
    ObjectMapper om = new ObjectMapper();
    public final boolean withRelationId;
    private final String tableKey;
    Map<String, String> tableDeclarations = new LinkedHashMap<String, String>();
    Map<String, String> functionDeclarations = new LinkedHashMap<String, String>();
    Map<String, String> primitiveDeclarations = new LinkedHashMap<String, String>();
    Map<String, String> typeDeclarations = new LinkedHashMap<String, String>();
    Map<String, String> arrayFunctionDeclarations = new LinkedHashMap<String, String>();
    Map<String, String> nameMap = this.initNameMap();
    private final boolean debugComment = true;

    public CompilerSQL(boolean withRelationId, String tableKey) {
        this.withRelationId = withRelationId;
        this.tableKey = tableKey;
    }

    public void generateSQLEnd(String sqlFile, String root_dir) {
        new File(root_dir).mkdirs();
        String path = root_dir + "/" + sqlFile;
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(path));
            for (String k : this.primitiveDeclarations.keySet()) {
                ps.println(this.primitiveDeclarations.get(k));
                ps.println("\n\n");
            }
            for (String k : this.typeDeclarations.keySet()) {
                ps.println(this.typeDeclarations.get(k));
                ps.println("\n\n");
            }
            for (String k : this.tableDeclarations.keySet()) {
                ps.println(this.tableDeclarations.get(k));
                ps.println("\n\n");
            }
            for (String k : this.functionDeclarations.keySet()) {
                ps.println(this.functionDeclarations.get(k));
                ps.println("\n\n");
            }
            for (String k : this.arrayFunctionDeclarations.keySet()) {
                ps.println(this.arrayFunctionDeclarations.get(k));
                ps.println("\n\n");
            }
            ps.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateSQL(String jsonschema, String templateName, String root_dir, TemplateBindingsSchema templateBindingsSchema) {
        Object res = "";
        Map<String, List<Descriptor>> var = templateBindingsSchema.getVar();
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema);
        boolean first = true;
        res = (String)res + "-- Generated by method " + this.getClass().getName() + ".generateSQL()\n";
        res = (String)res + "\nCREATE TABLE IF NOT EXISTS " + templateName + "\n(\n";
        if (this.withRelationId) {
            first = false;
            res = (String)res + SMALL_INDENTATION + this.tableKey + " SERIAL";
        }
        String documentation = null;
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema)) {
            if (first) {
                first = false;
            } else {
                res = (String)res + ",\n";
            }
            String sqlType = CompilerSQL.convertToSQLType(this.compilerUtil.getJavaTypeForDeclaredType(var, key).getName());
            Descriptor entry = var.get(key).get(0);
            documentation = this.retrieveDocumentation(entry);
            if (documentation != null) {
                res = (String)res + "    --  " + documentation + "\n";
            }
            res = (String)res + SMALL_INDENTATION + this.sqlify(key) + " " + sqlType;
        }
        res = (String)res + "\n);\n\n";
        this.tableDeclarations.put(templateName, (String)res);
        this.generateSqlTypeDeclaration(templateName, templateBindingsSchema, var);
    }

    private void generateSqlTypeDeclaration(String templateName, TemplateBindingsSchema templateBindingsSchema, Map<String, List<Descriptor>> var) {
        StringBuilder res2 = new StringBuilder();
        boolean first = true;
        res2.append("\n-- Generated by method ").append(this.getClass().getName()).append(".generateSqlTypeDeclaration()");
        res2.append("\nDROP TYPE IF EXISTS ").append(templateName).append("_type CASCADE;\n");
        res2.append("CREATE TYPE ").append(templateName).append("_type").append(" AS ");
        res2.append(" (\n");
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema)) {
            first = this.sepIfNotFirst(res2, first, ",\n");
            String sqlType = CompilerSqlComposer.getTheSqlType(this.compilerUtil, key, templateBindingsSchema, var);
            String sqlType2 = CompilerSQL.convertToSQLType(this.compilerUtil.getJavaTypeForDeclaredType(var, key).getName());
            res2.append(SMALL_INDENTATION).append(key).append(" ").append(sqlType);
        }
        res2.append("\n );\n");
        this.typeDeclarations.put(templateName, res2.toString());
    }

    private String retrieveDocumentation(Descriptor entry) {
        String documentation = ConfigProcessor.descriptorUtils.getFromDescriptor(entry, AttributeDescriptor::getDocumentation, NameDescriptor::getDocumentation);
        return documentation;
    }

    public void generateSQLstatements(TypeSpec.Builder builder, String templateName, TemplateBindingsSchema bindingsSchema, BeanKind beanKind) {
        StringBuffer sb = new StringBuffer();
        this.getInsertStringAndCount(templateName, ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema), sb);
        FieldSpec.Builder builder1 = FieldSpec.builder(String.class, (String)"_sqlInsert1", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
        builder1.initializer("$S", new Object[]{sb.toString()});
        builder.addField(builder1.build());
        builder.addMethod(this.generateSQLInsert(templateName, beanKind));
        builder.addMethod(this.generateSQLInsertStatement(templateName, bindingsSchema, beanKind));
    }

    public MethodSpec generateSQLInsert(String template, BeanKind beanKind) {
        String loggerName = this.compilerUtil.loggerName(template);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSQLInsert").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        this.compilerUtil.specWithComment(builder);
        if (beanKind.equals((Object)BeanKind.COMPOSITE)) {
            builder.addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
        } else {
            builder.addStatement("return _sqlInsert1", new Object[0]);
        }
        return builder.build();
    }

    public MethodSpec generateSQLInsertStatement(String template, TemplateBindingsSchema bindingsSchema, BeanKind beanKind) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSQLInsertStatement").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        this.compilerUtil.specWithComment(builder);
        if (beanKind.equals((Object)BeanKind.COMPOSITE)) {
            builder.addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
        } else {
            Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
            StringBuffer sb = new StringBuffer();
            int count = this.getInsertStringAndCount(template, variables, sb);
            sb = new StringBuffer();
            sb.append(" VALUES (");
            boolean first = true;
            for (int i = 0; i < count; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(");");
            builder.addStatement("return _sqlInsert1+$S", new Object[]{sb.toString()});
        }
        return builder.build();
    }

    public int getInsertStringAndCount(String template, Collection<String> variables, StringBuffer sb) {
        sb.append("INSERT INTO  ");
        sb.append(template);
        sb.append(" (");
        boolean first = true;
        int count = 0;
        for (String key : variables) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.sqlify(key));
            ++count;
        }
        sb.append(")");
        return count;
    }

    private Map<String, String> initNameMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("order", "_order");
        return res;
    }

    public String sqlify(String key) {
        return this.nameMap.getOrDefault(key, key);
    }

    public static String convertToSQLType(String name) {
        switch (name) {
            case "java.lang.String": {
                return "TEXT";
            }
            case "java.lang.Integer": {
                return "INT";
            }
            case "java.lang.Float": {
                return "FLOAT";
            }
            case "java.lang.Boolean": {
                return "BOOLEAN";
            }
        }
        throw new UnsupportedOperationException("conversion to SQL type " + name);
    }

    public MethodSpec generateCommonSQLMethod2(String template, TemplateBindingsSchema bindingsSchema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.compilerUtil.sqlName(template)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        String var = "sb";
        this.compilerUtil.specWithComment(builder);
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> fieldNames = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        builder.addParameter(StringBuffer.class, var, new Modifier[0]);
        for (String key : fieldNames) {
            String newkey = "__" + key;
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(theVar, key), newkey, new Modifier[0]);
        }
        Object constant = "(";
        boolean first = true;
        for (String key : fieldNames) {
            String newName = "__" + key;
            Class<?> clazz = this.compilerUtil.getJavaTypeForDeclaredType(theVar, key);
            boolean isQualifiedName = this.compilerUtil.isVariableDenotingQualifiedName(key, theVar);
            if (first) {
                first = false;
            } else {
                constant = (String)constant + ",";
            }
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            constant = "";
            if (String.class.equals(clazz)) {
                String myStatement = "$N.append($N)";
                String myEscapeStatement = "$N.append($T.escapeJavaScript($N))";
                boolean doEscape = false;
                if (!isQualifiedName) {
                    Descriptor descriptor = theVar.get(key).get(0);
                    boolean bl = doEscape = ((AttributeDescriptorList)descriptor).getItems().get(0).getEscape() != null;
                    if (doEscape) {
                        // empty if block
                    }
                }
                builder.beginControlFlow("if ($N==null)", new Object[]{newName});
                builder.addStatement("$N.append($S)", new Object[]{var, "''"});
                builder.nextControlFlow("else", new Object[0]).addStatement("$N.append($S)", new Object[]{var, "'"});
                if (doEscape) {
                    builder.addStatement(myEscapeStatement, new Object[]{var, ClassName.get((String)"org.openprovenance.apache.commons.lang", (String)"StringEscapeUtils", (String[])new String[0]), newName});
                } else {
                    builder.addStatement(myStatement, new Object[]{var, newName});
                }
                builder.addStatement("$N.append($S)", new Object[]{var, "'"}).endControlFlow();
                continue;
            }
            builder.beginControlFlow("if ($N==null)", new Object[]{newName});
            builder.addStatement("$N.append($S)", new Object[]{var, "''"});
            builder.nextControlFlow("else", new Object[0]);
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            builder.addStatement("$N.append($N)", new Object[]{var, newName});
            builder.endControlFlow();
        }
        builder.addStatement("$N.append($S)", new Object[]{var, ")"});
        MethodSpec method = builder.build();
        return method;
    }

    public void generateSQLPrimitiveTables(Map<String, Map<String, String>> sqlTables) {
        if (sqlTables != null) {
            for (String table : sqlTables.keySet()) {
                StringBuilder res = new StringBuilder();
                boolean first = true;
                res.append("-- Generated by method ").append(this.getClass().getName()).append(".generateSQLPrimitiveTables()\n");
                res.append("\nCREATE TABLE IF NOT EXISTS ").append(table);
                res.append(" (\n");
                Map<String, String> sqlTable = sqlTables.get(table);
                for (String key : sqlTable.keySet()) {
                    first = this.sepIfNotFirst(res, first, ",\n");
                    res.append(SMALL_INDENTATION).append(key).append(" ").append(sqlTable.get(key));
                }
                res.append("\n );\n");
                this.primitiveDeclarations.put(table, res.toString());
            }
        }
    }

    private String convertToTypeDeclarationOnly(String s) {
        return s.replace(" NOT NULL DEFAULT NOW()", "");
    }

    public void generateSQLInsertFunction(String jsonschema, String templateName, String consistOf, String root_dir, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        new CompilerSqlComposer(this.withRelationId, this.tableKey, this.functionDeclarations, this.arrayFunctionDeclarations).generateSQLInsertFunction(jsonschema, templateName, consistOf, root_dir, templateBindingsSchema, shared);
        if (shared != null && shared.size() > 0) {
            new CompilerSqlComposer(this.withRelationId, this.tableKey, this.functionDeclarations, this.arrayFunctionDeclarations).generateSQLInsertArrayFunction(templateName, consistOf, templateBindingsSchema, shared);
        }
    }

    private boolean sepIfNotFirst(StringBuilder res, boolean first) {
        return this.sepIfNotFirst(res, first, ", ");
    }

    private boolean sepIfNotFirst(StringBuilder res, boolean first, String sep) {
        if (first) {
            first = false;
        } else {
            res.append(sep);
        }
        return first;
    }
}

