/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.CompositeTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerBeanCompleter {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    final boolean sqlCode = false;

    SpecificationFile generateBeanCompleter(TemplatesCompilerConfig configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        if (configs.beanProcessor == null) {
            throw new NullPointerException("beanProcessor is null");
        }
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("BeanCompleter");
        builder.addSuperinterface((TypeName)ClassName.get((String)locations.getFilePackage(configs.beanProcessor), (String)configs.beanProcessor, (String[])new String[0]));
        builder.addField(CompilerUtil.mapType, "m", new Modifier[]{Modifier.FINAL});
        MethodSpec.Builder callMe2 = MethodSpec.methodBuilder((String)"getMap").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(CompilerUtil.classType, "cl", new Modifier[0]).addParameter(String.class, "key", new Modifier[0]).returns((TypeName)CompilerUtil.typeT).addTypeVariable(CompilerUtil.typeT);
        this.compilerUtil.specWithComment(callMe2);
        callMe2.addStatement("return ($T) m.get($N)", new Object[]{CompilerUtil.typeT, "key"});
        builder.addMethod(callMe2.build());
        TypeSpec.Builder inface = this.compilerUtil.generateInterfaceInit("Getter");
        inface.addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(CompilerUtil.classType, "cl", new Modifier[0]).addParameter(String.class, "col", new Modifier[0]).returns((TypeName)CompilerUtil.typeT).addTypeVariable(CompilerUtil.typeT).build());
        builder.addType(inface.build());
        builder.addField((TypeName)TypeVariableName.get((String)"Getter"), "getter", new Modifier[]{Modifier.FINAL});
        MethodSpec.Builder cbuilder2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(CompilerUtil.mapType, "m", new Modifier[0]);
        this.compilerUtil.specWithComment(cbuilder2);
        cbuilder2.addStatement("this.$N = $N", new Object[]{"m", "m"}).addComment("The following code implements this assignment, in a way that jsweet can compile", new Object[0]).addComment("this.getter = this::getMap", new Object[0]);
        cbuilder2.addStatement("this.getter = $L", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)TypeVariableName.get((String)"Getter")).addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(CompilerUtil.classType, "cl", new Modifier[0]).addParameter(String.class, "col", new Modifier[0]).returns((TypeName)CompilerUtil.typeT).addTypeVariable(CompilerUtil.typeT).addStatement("return getMap(cl, col)", new Object[0]).build()).build()});
        builder.addMethod(cbuilder2.build());
        MethodSpec.Builder cbuilder3 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeVariableName.get((String)"Getter"), "getter", new Modifier[0]);
        this.compilerUtil.specWithComment(cbuilder3);
        cbuilder3.addStatement("this.$N = null", new Object[]{"m"}).addStatement("this.getter = ($N) getter", new Object[]{"Getter"});
        builder.addMethod(cbuilder3.build());
        for (TemplateCompilerConfig config : configs.templates) {
            String beanNameClass = this.compilerUtil.commonNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)beanNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(ParameterSpec.builder((TypeName)className, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)className);
            if (config instanceof SimpleTemplateCompilerConfig) {
                this.compilerUtil.specWithComment(mspec);
                TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema((SimpleTemplateCompilerConfig)config);
                for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
                    if (!ConfigProcessor.descriptorUtils.isOutput(key, bindingsSchema)) continue;
                    Class<?> cl = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
                    mspec.addStatement("$N.$N= getter.get($N.class,$S)", new Object[]{"bean", key, cl.getSimpleName(), key});
                }
                mspec.addStatement("return $N", new Object[]{"bean"});
            } else {
                this.compilerUtil.specWithComment(mspec);
                CompositeTemplateCompilerConfig config1 = (CompositeTemplateCompilerConfig)config;
                String consistOf = config1.consistsOf;
                String composeeName = this.compilerUtil.commonNameClass(consistOf);
                ClassName composeeClass = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)composeeName, (String[])new String[0]);
                mspec.addStatement("boolean nextExists=true", new Object[0]);
                mspec.beginControlFlow("for ($T composee: $N.$N)", new Object[]{composeeClass, "bean", "__elements"});
                mspec.beginControlFlow("if (nextExists) ", new Object[0]);
                mspec.addStatement("$N(composee)", new Object[]{"process"});
                mspec.addStatement("nextExists = next()", new Object[0]);
                mspec.nextControlFlow("else", new Object[0]);
                mspec.addStatement("System.out.println($S)", new Object[]{"Not enough record in the result"});
                mspec.endControlFlow();
                mspec.endControlFlow();
                mspec.addStatement("return $N", new Object[]{"bean"});
            }
            builder.addMethod(mspec.build());
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"next").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return true", new Object[0]).build());
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }
}

