/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.CompositeTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerBeanCompleter2Composite {
    public static final String OUT_VAR = "out";
    private final CompilerUtil compilerUtil = new CompilerUtil();

    SpecificationFile generateBeanCompleter2Composite(TemplatesCompilerConfig configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        if (configs.beanProcessor == null) {
            throw new NullPointerException("beanProcessor is null");
        }
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("CompositeBeanCompleter2");
        builder.addField(CompilerUtil.listMapType, "ll", new Modifier[]{Modifier.FINAL});
        builder.addField(CompilerUtil.mapType, "m", new Modifier[]{Modifier.FINAL});
        MethodSpec.Builder cbuilder2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(CompilerUtil.mapType, "m", new Modifier[0]);
        this.compilerUtil.specWithComment(cbuilder2);
        cbuilder2.addStatement("this.$N = ($T) $N.get($S)", new Object[]{"ll", CompilerUtil.listMapType, "m", "__elements"}).addStatement("this.$N = $N", new Object[]{"m", "m"});
        builder.addMethod(cbuilder2.build());
        for (TemplateCompilerConfig config : configs.templates) {
            locations.updateWithConfig(config);
            if (config instanceof SimpleTemplateCompilerConfig) continue;
            CompositeTemplateCompilerConfig config1 = (CompositeTemplateCompilerConfig)config;
            String consistsOf = config1.consistsOf;
            String outputBeanNameClass = this.compilerUtil.outputsNameClass(config.name);
            String inputBeanNameClass = this.compilerUtil.inputsNameClass(config.name);
            ClassName outputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputBeanNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = this.createProcessMethod(consistsOf, locations.getFilePackage(BeanDirection.OUTPUTS), outputClassName, true);
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    private MethodSpec.Builder createProcessMethod(String consistsOf, String integrator_package, ClassName cutputClassName, boolean isOutput) {
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)cutputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)cutputClassName);
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("$N.$N=($T)$N.get($S)", new Object[]{"bean", "ID", Integer.class, "m", "ID"});
        mspec.beginControlFlow("for ($T $N: $N)", new Object[]{CompilerUtil.mapType, "m", "ll"});
        ClassName composee = ClassName.get((String)integrator_package, (String)this.compilerUtil.outputsNameClass(consistsOf), (String[])new String[0]);
        mspec.addStatement("$T $N=new $T()", new Object[]{composee, OUT_VAR, composee});
        mspec.addStatement("$N.__addElements(new $N($N).process($N))", new Object[]{"bean", "BeanCompleter2", "m", OUT_VAR});
        mspec.endControlFlow();
        mspec.addStatement("return $N", new Object[]{"bean"});
        return mspec;
    }
}

