/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.common;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.tuple.Pair;
import org.openprovenance.apache.commons.lang.StringEscapeUtils;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.template.compiler.CompilerSQL;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.common.BeanKind;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.AttributeDescriptorList;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.NameDescriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;
import org.openprovenance.prov.template.expander.ExpandUtil;

public class CompilerCommon {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    private final ProvFactory pFactory;
    private final boolean debugComment = true;
    private final CompilerSQL compilerSQL;
    private boolean foundEscape = false;
    TypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
    Map<String, Set<Pair<QualifiedName, WasDerivedFrom>>> successors1 = new HashMap<String, Set<Pair<QualifiedName, WasDerivedFrom>>>();
    Map<String, Set<Pair<QualifiedName, WasAttributedTo>>> successors2 = new HashMap<String, Set<Pair<QualifiedName, WasAttributedTo>>>();
    Map<String, Set<Pair<QualifiedName, HadMember>>> successors3 = new HashMap<String, Set<Pair<QualifiedName, HadMember>>>();
    Map<String, Set<Pair<QualifiedName, QualifiedHadMember>>> successors3b = new HashMap<String, Set<Pair<QualifiedName, QualifiedHadMember>>>();
    Map<String, Set<Pair<QualifiedName, SpecializationOf>>> successors4 = new HashMap<String, Set<Pair<QualifiedName, SpecializationOf>>>();

    public CompilerCommon(ProvFactory pFactory, CompilerSQL compilerSQL) {
        this.pFactory = pFactory;
        this.compilerSQL = compilerSQL;
    }

    public TypeSpec.Builder generateClassInit(String builderName, String builderPackage, String processorName, String supername) {
        return TypeSpec.classBuilder((String)builderName).addSuperinterface((TypeName)ClassName.get((String)builderPackage, (String)supername, (String[])new String[0])).addSuperinterface((TypeName)ClassName.get((String)builderPackage, (String)"SQL", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public Pair<SpecificationFile, Map<Integer, List<Integer>>> generateCommonLib(TemplatesCompilerConfig configs, Locations locations, Document doc, String name, String templateName, String packageName, TemplateBindingsSchema bindingsSchema, IndexedDocument indexed, String logger, BeanKind beanKind, String fileName) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generateCommonLib_aux(configs, locations, allVars, allAtts, name, templateName, packageName, bindingsSchema, indexed, logger, beanKind, fileName);
    }

    Pair<SpecificationFile, Map<Integer, List<Integer>>> generateCommonLib_aux(TemplatesCompilerConfig configs, Locations locations, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packageName, TemplateBindingsSchema bindingsSchema, IndexedDocument indexed, String logger, BeanKind beanKind, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.generateClassInit(name, "org.openprovenance.prov.client", this.compilerUtil.processorNameClass(templateName), "Builder");
        Map successorTable = null;
        builder.addMethod(this.generateNameAccessor(templateName));
        builder.addMethod(this.generatePropertyOrderMethod());
        builder.addField(this.generateFieldPropertyOrder(bindingsSchema));
        builder.addMethod(this.generateCommonMethodGetNodes(beanKind));
        builder.addMethod(this.generateCommonMethodGetSuccessors(beanKind));
        builder.addMethod(this.generateCommonMethodGetTypedSuccessors(beanKind));
        builder.addMethod(this.generateRecordCsvProcessorMethod(beanKind));
        this.compilerSQL.generateSQLstatements(builder, templateName, bindingsSchema, beanKind);
        ClassName integratorClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)this.compilerUtil.integratorBuilderNameClass(templateName), (String[])new String[0]);
        builder.addField(FieldSpec.builder((TypeName)integratorClassName, (String)"__integrator", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{integratorClassName}).build());
        MethodSpec.Builder builder1 = MethodSpec.methodBuilder((String)"getIntegrator").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.compilerUtil.specWithComment(builder1);
        builder1.returns((TypeName)integratorClassName).addStatement("return __integrator", new Object[0]);
        builder.addMethod(builder1.build());
        if (beanKind == BeanKind.SIMPLE) {
            builder.addMethod(this.generateCommonCSVConverterMethod_aux(allVars, allAtts, name, templateName, this.compilerUtil.loggerName(templateName), packageName, bindingsSchema));
            builder.addMethod(this.generateCommonSQLConverterMethod_aux(name, templateName, this.compilerUtil.loggerName(templateName), packageName, bindingsSchema));
            builder.addMethod(this.generateArgsToRecordMethod(templateName, packageName, bindingsSchema));
            builder.addMethod(this.generateProcessorConverter(templateName, packageName, bindingsSchema, BeanDirection.COMMON));
            builder.addMethod(this.generateProcessorConverter2(templateName, packageName, bindingsSchema));
            builder.addMethod(this.generateApplyMethod(templateName, packageName));
            builder.addMethod(this.generateCommonMethod2(templateName, bindingsSchema));
            builder.addMethod(this.generateCommonMethod2PureCsv(templateName, bindingsSchema));
            builder.addMethod(this.generateCommonMethod3static(bindingsSchema));
            builder.addMethod(this.generateCommonMethod4static(allVars, bindingsSchema, indexed));
            Pair<MethodSpec, Map<Integer, List<Integer>>> methodSpecMapPair = this.generateCommonMethod5static(allVars, bindingsSchema, indexed);
            builder.addMethod((MethodSpec)methodSpecMapPair.getLeft());
            successorTable = (Map)methodSpecMapPair.getRight();
            builder.addMethod(this.generateCommonMethod6static(indexed));
            builder.addField(this.generateFieldOutputs(allVars, allAtts, name, templateName, packageName, bindingsSchema));
            builder.addField(this.generateFieldInputs(allVars, allAtts, name, templateName, packageName, bindingsSchema));
            builder.addField(this.generateFieldCompulsoryInputs(allVars, allAtts, name, templateName, packageName, bindingsSchema));
            builder.addField(this.generateField4aBeanConverter(templateName, packageName, bindingsSchema));
            builder.addField(this.generateField4aBeanConverter2("toBean", templateName, packageName, "aRecord2BeanConverter", BeanDirection.COMMON));
            builder.addField(this.generateField4aSQLConverter2(name, templateName, packageName));
            builder.addField(this.generateField4aArgs2CsvConverter(name, templateName, packageName));
            builder.addField(this.generateField4aRecord2SqlConverter(templateName));
            builder.addField(this.generateField4aRecord2CsvConverter(name, templateName, packageName));
            builder.addField(FieldSpec.builder((TypeName)CompilerUtil.mapIntArrayType, (String)"__successors", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getSuccessors()", new Object[0]).build());
            builder.addField(FieldSpec.builder((TypeName)CompilerUtil.mapIntArrayType, (String)"__successors2", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getTypedSuccessors()", new Object[0]).build());
            builder.addField(FieldSpec.builder(int[].class, (String)"__nodes", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getNodes()", new Object[0]).build());
            builder.addMethod(this.generateOutputsMethod());
            builder.addMethod(this.generateCompulsoryInputsMethod());
            builder.addMethod(this.generateInputsMethod());
            builder.addMethod(this.generateFactoryMethodToBeanWithArray("toBean", templateName, packageName, bindingsSchema, BeanDirection.COMMON, null, null));
            builder.addMethod(this.generateFactoryMethodWithBean(templateName, packageName, bindingsSchema));
            builder.addMethod(this.generateNewBean(templateName, packageName));
            builder.addMethod(this.generateExamplarBean(allVars, allAtts, templateName, packageName, bindingsSchema));
            builder.addMethod(this.compilerSQL.generateCommonSQLMethod2(templateName, bindingsSchema));
        } else {
            builder.addField(this.generateField4aBeanConverter3("toBean", templateName, packageName, "aRecord2BeanConverter", BeanDirection.COMMON));
            builder.addMethod(this.generateFactoryMethodToBeanWithArrayComposite("toBean", templateName, packageName, bindingsSchema, locations.getFilePackage(logger), logger, BeanDirection.COMMON, null, null));
        }
        TypeSpec bean = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(bean, configs, packageName, stackTraceElement);
        SpecificationFile spec = new SpecificationFile(myfile, locations.convertToDirectory(packageName), fileName, packageName);
        return Pair.of((Object)spec, successorTable);
    }

    public MethodSpec generateNameAccessor(String templateName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getName").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        this.compilerUtil.specWithComment(builder);
        builder.addStatement("return $S", new Object[]{templateName});
        return builder.build();
    }

    public MethodSpec generateCommonMethod2(String template, TemplateBindingsSchema bindingsSchema) {
        return this.generateCommonMethod2(template, bindingsSchema, true);
    }

    public MethodSpec generateCommonMethod2PureCsv(String template, TemplateBindingsSchema bindingsSchema) {
        return this.generateCommonMethod2(template, bindingsSchema, false);
    }

    public MethodSpec generateCommonCSVConverterMethod_aux(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, String loggerName, String packge, TemplateBindingsSchema bindingsSchema) {
        TypeName processorClassName = this.processorClassType(template, packge, ClassName.get(String.class));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"args2csv").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(processorClassName);
        this.compilerUtil.specWithComment(builder);
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add(loggerName + " client side logging method\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{processorClassNameNotParametrised});
        builder.addJavadoc(jdoc.build());
        builder.addStatement("$T $N=this", new Object[]{ClassName.get((String)packge, (String)name, (String[])new String[0]), "self"});
        Map<String, List<Descriptor>> var = bindingsSchema.getVar();
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        StringBuilder args = new StringBuilder();
        StringBuilder args2 = new StringBuilder();
        boolean first = true;
        for (String key : variables) {
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args.append(", ");
                args2.append(", ");
            }
            args.append(this.compilerUtil.getJavaTypeForDeclaredType(var, key).getName()).append(" ").append(newkey);
            args2.append(" ").append(newkey);
        }
        builder.addStatement("return (" + args + ") -> { $T sb=new $T();$N.$N(sb," + args2 + "); return sb.toString(); }", new Object[]{StringBuffer.class, StringBuffer.class, "self", loggerName});
        MethodSpec method = builder.build();
        return method;
    }

    private FieldSpec generateField4aBeanConverter(String templateName, String packge, TemplateBindingsSchema bindingsSchema) {
        TypeName myType = this.processorClassType(templateName, packge, ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(templateName), (String[])new String[0]));
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aArgs2BeanConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Object args = "";
        Object args2 = "";
        boolean first = true;
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(theVar, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        fbuilder.initializer(" (" + (String)args + ") -> { return $N(" + (String)args2 + "); }", new Object[]{"toBean"});
        return fbuilder.build();
    }

    private FieldSpec generateFieldPropertyOrder(TemplateBindingsSchema bindingsSchema) {
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)ArrayTypeName.of(String.class), (String)"propertyOrder", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        String args = "";
        Object args2 = "new String[] { $S ";
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        for (String key : variables) {
            args2 = (String)args2 + ", ";
            args2 = (String)args2 + " \"" + key + "\"";
        }
        fbuilder.initializer((String)args2 + "}", new Object[]{"isA"});
        return fbuilder.build();
    }

    private FieldSpec generateFieldOutputs(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, TemplateBindingsSchema bindingsSchema) {
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)ArrayTypeName.of(String.class), (String)"outputs", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        Map<String, List<Descriptor>> var = bindingsSchema.getVar();
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        Object args = "new String[] { ";
        boolean first = true;
        for (String key : variables) {
            if (!ConfigProcessor.descriptorUtils.isOutput(key, bindingsSchema)) continue;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
            }
            args = (String)args + " \"" + key + "\"";
        }
        fbuilder.initializer((String)args + "}", new Object[0]);
        return fbuilder.build();
    }

    private FieldSpec generateFieldInputs(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, TemplateBindingsSchema bindingsSchema) {
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)ArrayTypeName.of(String.class), (String)"inputs", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        Object args = "new String[] { ";
        boolean first = true;
        for (String key : variables) {
            if (!ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema)) continue;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
            }
            args = (String)args + " \"" + key + "\"";
        }
        fbuilder.initializer((String)args + "}", new Object[0]);
        return fbuilder.build();
    }

    private FieldSpec generateFieldCompulsoryInputs(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, TemplateBindingsSchema bindingsSchema) {
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)ArrayTypeName.of(String.class), (String)"compulsoryInputs", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        Object args = "new String[] { ";
        boolean first = true;
        for (String key : variables) {
            if (!ConfigProcessor.descriptorUtils.isCompulsoryInput(key, bindingsSchema)) continue;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
            }
            args = (String)args + " \"" + key + "\"";
        }
        fbuilder.initializer((String)args + "}", new Object[0]);
        return fbuilder.build();
    }

    public FieldSpec generateField4aBeanConverter3(String toBean, String templateName, String packge, String fieldName, BeanDirection direction) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"RecordsProcessorInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(templateName, direction), (String[])new String[0])});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.addJavadoc("Generated by method $N", new Object[]{this.getClass().getName() + ".generateField4aBeanConverter3()"});
        fbuilder.initializer(" ($T records) -> { return $N(records); }", new Object[]{CompilerUtil.listOfArrays, toBean});
        return fbuilder.build();
    }

    public FieldSpec generateField4aBeanConverter2(String toBean, String templateName, String packge, String fieldName, BeanDirection direction) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(templateName, direction), (String[])new String[0])});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.addJavadoc("Generated by method $N", new Object[]{this.getClass().getName() + ".generateField4aBeanConverter2()"});
        fbuilder.initializer(" (Object [] record) -> { return $N(record); }", new Object[]{toBean});
        return fbuilder.build();
    }

    private FieldSpec generateField4aSQLConverter2(String name, String templateName, String packge) {
        TypeName processorClassName = this.processorClassType(templateName, packge, ClassName.get(String.class));
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)processorClassName, (String)"aBean2SqlConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.addJavadoc("Generated by method $N", new Object[]{this.getClass().getName() + ".generateField4aSQLConverter2()"});
        fbuilder.initializer("$N()", new Object[]{"bean2sql"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aArgs2CsvConverter(String name, String templateName, String packge) {
        TypeName processorClassName = this.processorClassType(templateName, packge, ClassName.get(String.class));
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)processorClassName, (String)"aArgs2CsVConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer("$N()", new Object[]{"args2csv"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aRecord2SqlConverter(String templateName) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aRecord2SqlConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.initializer(" (Object [] record) -> { return $N(record).process($N); }", new Object[]{"toBean", "aBean2SqlConverter"});
        return fbuilder.build();
    }

    private FieldSpec generateField4aRecord2CsvConverter(String name, String templateName, String packge) {
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        FieldSpec.Builder fbuilder = FieldSpec.builder((TypeName)myType, (String)"aRecord2CsvConverter", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        fbuilder.addJavadoc("Generated by method $N", new Object[]{this.getClass().getName() + ".generateField4aRecord2CsvConverter()"});
        fbuilder.initializer(" (Object [] record) -> { return $N(record).process($N); }", new Object[]{"toBean", "aArgs2CsVConverter"});
        return fbuilder.build();
    }

    public MethodSpec generateCommonSQLConverterMethod_aux(String name, String template, String loggerName, String packge, TemplateBindingsSchema bindingsSchema) {
        TypeName processorClassName = this.processorClassType(template, packge, ClassName.get(String.class));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"bean2sql").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(processorClassName);
        this.compilerUtil.specWithComment(builder);
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add(loggerName + " client side logging method\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{processorClassNameNotParametrised});
        builder.addJavadoc(jdoc.build());
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        builder.addStatement("$T $N=this", new Object[]{ClassName.get((String)packge, (String)name, (String[])new String[0]), "self"});
        Object args = "";
        Object args2 = "";
        boolean first = true;
        for (String key : variables) {
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(theVar, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        builder.addStatement("return (" + (String)args + ") -> { $T sb=new $T(); $N.$N(sb," + (String)args2 + "); return sb.toString(); }", new Object[]{StringBuffer.class, StringBuffer.class, "self", "sqlTuple"});
        return builder.build();
    }

    public MethodSpec generateArgsToRecordMethod(String template, String packge, TemplateBindingsSchema bindingsSchema) {
        TypeName processorClassName = this.processorClassType(template, packge, ArrayTypeName.of(Object.class));
        TypeName processorClassNameNotParametrised = this.processorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"aArgs2RecordConverter").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(processorClassName);
        this.compilerUtil.specWithComment(builder);
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add("Returns a converter from arguments to record\n", new Object[0]);
        jdoc.add("@return $T\n", new Object[]{processorClassNameNotParametrised});
        builder.addJavadoc(jdoc.build());
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        Object args = "";
        Object args2 = "";
        boolean first = true;
        for (String key : variables) {
            String newkey = "__" + key;
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            args = (String)args + this.compilerUtil.getJavaTypeForDeclaredType(theVar, key).getName() + " " + newkey;
            args2 = (String)args2 + " " + newkey;
        }
        builder.addStatement("return (" + (String)args + ") -> {  return new Object [] { getName(), " + (String)args2 + "}; }", new Object[0]);
        return builder.build();
    }

    public MethodSpec generateProcessorConverter(String template, String packge, TemplateBindingsSchema bindingsSchema, BeanDirection beanDirection) {
        boolean isOutput;
        String newKey;
        TypeName returnClassName = beanDirection == BeanDirection.COMMON ? this.processorClassType(template, packge, CompilerUtil.typeT) : this.integratorClassType(template, packge, CompilerUtil.typeT);
        TypeName returnClassNameNotParametrised = beanDirection == BeanDirection.COMMON ? this.processorClassType(template, packge) : this.integratorClassType(template, packge);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"processorConverter").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).returns(returnClassName);
        this.compilerUtil.specWithComment(builder);
        ParameterizedTypeName parameterType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        String processor = this.compilerUtil.generateNewNameForVariable("processor");
        builder.addParameter((TypeName)parameterType, processor, new Modifier[]{Modifier.FINAL});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add("Returns a converter from Processor taking arguments to Processor taking record\n", new Object[0]);
        jdoc.add("@param $N a transformer for this template\n", new Object[]{processor});
        jdoc.add("@param <T> type variable for the result of processor\n", new Object[0]);
        jdoc.add("@return $T&lt;$T&gt;\n", new Object[]{returnClassNameNotParametrised, TypeVariableName.get((String)"T")});
        builder.addJavadoc(jdoc.build());
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> fieldNames = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        StringBuilder args = new StringBuilder();
        StringBuilder args2 = new StringBuilder();
        boolean first = true;
        for (String key : fieldNames) {
            newKey = this.compilerUtil.generateNewNameForVariable(key);
            isOutput = ConfigProcessor.descriptorUtils.isOutput(key, bindingsSchema);
            if (beanDirection != BeanDirection.COMMON && isOutput) continue;
            if (first) {
                first = false;
            } else {
                args.append(", ");
            }
            args.append(this.compilerUtil.getJavaTypeForDeclaredType(theVar, key).getName()).append(" ").append(newKey);
        }
        first = true;
        for (String key : fieldNames) {
            newKey = this.compilerUtil.generateNewNameForVariable(key);
            isOutput = ConfigProcessor.descriptorUtils.isOutput(key, bindingsSchema);
            if (first) {
                first = false;
            } else {
                args2.append(", ");
            }
            if (beanDirection != BeanDirection.COMMON && isOutput) {
                args2.append(" null");
                continue;
            }
            args2.append(" ").append(newKey);
        }
        builder.addStatement("return ($L) -> {  return $N.process(new Object [] { getName(), $L}); }", new Object[]{args, processor, args2});
        return builder.build();
    }

    public MethodSpec generateProcessorConverter2(String template, String packge, TemplateBindingsSchema bindingsSchema) {
        TypeName processorClassName = this.processorClassType(template, packge, CompilerUtil.typeT);
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{CompilerUtil.typeT});
        ClassName returnTypeNotParametrised = ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"processorConverter").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(CompilerUtil.typeT).returns((TypeName)returnType);
        this.compilerUtil.specWithComment(builder);
        builder.addParameter(processorClassName, "processor", new Modifier[]{Modifier.FINAL});
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add("Returns a converter from Processor taking arguments to Processor taking record\n", new Object[0]);
        jdoc.add("@param processor a transformer for this template\n", new Object[0]);
        jdoc.add("@param <T> type variable for the result of processor\n", new Object[0]);
        jdoc.add("@return $T&lt;$T&gt;\n", new Object[]{returnTypeNotParametrised, CompilerUtil.typeT});
        builder.addJavadoc(jdoc.build());
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> fieldNames = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        Object args = "";
        Object args2 = "";
        int count = 1;
        boolean first = true;
        for (String key : fieldNames) {
            String newkey = this.compilerUtil.generateNewNameForVariable(key);
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
                args2 = (String)args2 + ", ";
            }
            Class<?> declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(theVar, key);
            String type = declaredJavaType.getName();
            String converter = this.compilerUtil.getConverterForDeclaredType(declaredJavaType);
            String converter2 = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
            String expression = converter2 == null ? "(" + type + ") record[" + count + "]" : "(record[" + count + "]==null)?null:((record[" + count + "] instanceof String)?" + converter2 + "((String)(record[" + count + "])):(" + type + ")(record[" + count + "]))";
            args = (String)args + type + " " + newkey;
            args2 = (String)args2 + " " + expression;
            ++count;
        }
        builder.addStatement("return (Object [] record) -> {  return processor.process(" + (String)args2 + "); }", new Object[0]);
        return builder.build();
    }

    public MethodSpec generateApplyMethod(String template, String packge) {
        TypeName processorClassName = this.processorClassType(template, packge, TypeVariableName.get((String)"T"));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).returns((TypeName)TypeVariableName.get((String)"T"));
        this.compilerUtil.specWithComment(builder);
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add("Apply method\n", new Object[0]);
        jdoc.add("@param processor a transformer for this template\n", new Object[0]);
        jdoc.add("@param record as an array of Objects\n", new Object[0]);
        jdoc.add("@param <T> type variable for the result of processor\n", new Object[0]);
        jdoc.add("@return an object of type $T\n", new Object[]{TypeVariableName.get((String)"T")});
        builder.addJavadoc(jdoc.build());
        String var_processor = "processor";
        String var_record = "record";
        builder.addParameter(processorClassName, "processor", new Modifier[0]);
        builder.addParameter((TypeName)ArrayTypeName.of(Object.class), "record", new Modifier[0]);
        builder.addStatement("return toBean($N).process($N)", new Object[]{"record", "processor"});
        MethodSpec method = builder.build();
        return method;
    }

    private TypeName processorClassType(String template, String packge, TypeVariableName t) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{t});
        return name;
    }

    private TypeName integratorClassType(String template, String packge, TypeVariableName t) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.integratorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{t});
        return name;
    }

    private TypeName processorClassType(String template, String packge, ParameterizedTypeName parameterizedTypeName) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{parameterizedTypeName});
        return name;
    }

    private TypeName processorClassType(String template, String packge, ArrayTypeName arrayTypeName) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{arrayTypeName});
        return name;
    }

    private TypeName processorClassType(String template, String packge, ClassName cl) {
        ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]), (TypeName[])new TypeName[]{cl});
        return name;
    }

    private TypeName processorClassType(String template, String packge) {
        return ClassName.get((String)packge, (String)this.compilerUtil.processorNameClass(template), (String[])new String[0]);
    }

    private TypeName integratorClassType(String template, String packge) {
        return ClassName.get((String)packge, (String)this.compilerUtil.integratorNameClass(template), (String[])new String[0]);
    }

    public MethodSpec generateCommonMethod2(String template, TemplateBindingsSchema bindingsSchema, boolean legacy) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(this.compilerUtil.loggerName(template) + (legacy ? "_impure" : ""))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        String var = "sb";
        this.compilerUtil.specWithComment(builder);
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> fieldNames = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        builder.addParameter(StringBuffer.class, var, new Modifier[0]);
        for (String key : fieldNames) {
            String newkey = this.compilerUtil.generateNewNameForVariable(key);
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(theVar, key), newkey, new Modifier[0]);
        }
        Object constant = (legacy ? "[" : "") + StringEscapeUtils.escapeCsv((String)template);
        for (String key : fieldNames) {
            String newName = this.compilerUtil.generateNewNameForVariable(key);
            Class<?> clazz = this.compilerUtil.getJavaTypeForDeclaredType(theVar, key);
            boolean isQualifiedName = theVar.get(key).get(0) instanceof NameDescriptor;
            constant = (String)constant + ",";
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            constant = "";
            if (String.class.equals(clazz)) {
                String myStatement = "$N.append($N)";
                String myEscapeStatement = "$N.append($T.escapeCsv($N))";
                boolean doEscape = false;
                if (!isQualifiedName) {
                    boolean bl = doEscape = ((AttributeDescriptorList)theVar.get(key).get(0)).getItems().get(0).getEscape() != null;
                    if (doEscape) {
                        this.foundEscape = true;
                    }
                }
                builder.beginControlFlow("if ($N==null)", new Object[]{newName});
                if (legacy) {
                    builder.addStatement("$N.append($N)", new Object[]{var, newName});
                }
                builder.nextControlFlow("else", new Object[0]);
                if (doEscape) {
                    builder.addStatement(myEscapeStatement, new Object[]{var, ClassName.get((String)"org.openprovenance.apache.commons.lang", (String)"StringEscapeUtils", (String[])new String[0]), newName});
                } else {
                    builder.addStatement(myStatement, new Object[]{var, newName});
                }
                builder.endControlFlow();
                continue;
            }
            builder.beginControlFlow("if ($N==null)", new Object[]{newName});
            builder.nextControlFlow("else", new Object[0]);
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            builder.addStatement("$N.append($N)", new Object[]{var, newName});
            builder.endControlFlow();
        }
        constant = (String)constant + (Serializable)(legacy ? Character.valueOf(']') : "");
        builder.addStatement("$N.append($S)", new Object[]{var, constant});
        return builder.build();
    }

    public boolean getFoundEscape() {
        return this.foundEscape;
    }

    public MethodSpec generateCommonMethod3static(TemplateBindingsSchema bindingsSchema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(int[].class);
        this.compilerUtil.specWithComment(builder);
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> fieldNames = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        int count = 0;
        LinkedList<Integer> ll = new LinkedList<Integer>();
        for (String key : fieldNames) {
            ++count;
            if (!(theVar.get(key).get(0) instanceof NameDescriptor)) continue;
            ll.add(count);
        }
        Object nodes = "";
        boolean first = true;
        Iterator iterator = ll.iterator();
        while (iterator.hasNext()) {
            int elem = (Integer)iterator.next();
            if (first) {
                first = false;
            } else {
                nodes = (String)nodes + ", ";
            }
            nodes = (String)nodes + elem;
        }
        builder.addStatement("return new int[] {" + (String)nodes + "}", new Object[0]);
        return builder.build();
    }

    public MethodSpec generateCommonMethodGetNodes(BeanKind beanKind) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(int[].class);
        this.compilerUtil.specWithComment(builder);
        if (beanKind.equals((Object)BeanKind.COMPOSITE)) {
            CompilerCommon.generateUnsupportedException(builder);
        } else {
            builder.addStatement("return $N", new Object[]{"__nodes"});
        }
        MethodSpec method = builder.build();
        return method;
    }

    public static void generateUnsupportedException(MethodSpec.Builder builder) {
        builder.addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    public MethodSpec generatePropertyOrderMethod() {
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"getPropertyOrder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String[].class);
        this.compilerUtil.specWithComment(builder5);
        builder5.addStatement("return $N", new Object[]{"propertyOrder"});
        return builder5.build();
    }

    public MethodSpec generateOutputsMethod() {
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"getOutputs").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String[].class);
        this.compilerUtil.specWithComment(builder5);
        builder5.addStatement("return $N", new Object[]{"outputs"});
        return builder5.build();
    }

    public MethodSpec generateCompulsoryInputsMethod() {
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"getCompulsoryInputs").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String[].class);
        this.compilerUtil.specWithComment(builder5);
        builder5.addStatement("return $N", new Object[]{"compulsoryInputs"});
        return builder5.build();
    }

    public MethodSpec generateInputsMethod() {
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"getInputs").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String[].class);
        this.compilerUtil.specWithComment(builder5);
        builder5.addStatement("return $N", new Object[]{"inputs"});
        return builder5.build();
    }

    public MethodSpec generateRecordCsvProcessorMethod(BeanKind beanKind) {
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"record2csv").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of(Object.class), (String)"record", (Modifier[])new Modifier[0]).build()).returns(this.myType);
        this.compilerUtil.specWithComment(builder5);
        if (beanKind.equals((Object)BeanKind.COMPOSITE)) {
            CompilerCommon.generateUnsupportedException(builder5);
        } else {
            builder5.addStatement("return $N", new Object[]{"aRecord2CsvConverter"});
        }
        return builder5.build();
    }

    public MethodSpec generateCommonMethodGetSuccessors(BeanKind beanKind) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)CompilerUtil.mapIntArrayType);
        this.compilerUtil.specWithComment(builder);
        if (beanKind.equals((Object)BeanKind.COMPOSITE)) {
            CompilerCommon.generateUnsupportedException(builder);
        } else {
            builder.addStatement("return __successors", new Object[0]);
        }
        return builder.build();
    }

    public MethodSpec generateCommonMethodGetTypedSuccessors(BeanKind beanKind) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getTypedSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)CompilerUtil.mapIntArrayType);
        this.compilerUtil.specWithComment(builder);
        if (beanKind.equals((Object)BeanKind.COMPOSITE)) {
            CompilerCommon.generateUnsupportedException(builder);
        } else {
            builder.addStatement("return __successors2", new Object[0]);
        }
        return builder.build();
    }

    public MethodSpec generateCommonMethod4static(Set<QualifiedName> allVars, TemplateBindingsSchema bindingsSchema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)CompilerUtil.mapIntArrayType);
        this.compilerUtil.specWithComment(builder);
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> fieldNames = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        int count2 = 0;
        HashMap<QualifiedName, Integer> index = new HashMap<QualifiedName, Integer>();
        for (String key : fieldNames) {
            ++count2;
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                index.put(qn, count2);
            }
        }
        builder.addStatement("$T table = new $T()", new Object[]{CompilerUtil.mapIntArrayType, CompilerUtil.hashmapType});
        int count = 0;
        for (String key : fieldNames) {
            ++count;
            if (!(theVar.get(key).get(0) instanceof NameDescriptor)) continue;
            Set successors = new HashSet();
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                successors = indexed.traverseDerivations(qn);
                break;
            }
            Object initializer = "";
            boolean first = true;
            for (QualifiedName successor : successors) {
                int i = (Integer)index.get(successor);
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i;
            }
            builder.addStatement("table.put($L,new int[] { " + (String)initializer + "})", new Object[]{count});
        }
        builder.addStatement("return table", new Object[0]);
        return builder.build();
    }

    public void calculateTypedSuccessors(Set<QualifiedName> allVars, Map<String, List<Descriptor>> theVar, Collection<String> fieldNames, IndexedDocument indexed, Map<String, Set<Pair<QualifiedName, WasDerivedFrom>>> successors1, Map<String, Set<Pair<QualifiedName, WasAttributedTo>>> successors2, Map<String, Set<Pair<QualifiedName, HadMember>>> successors3, Map<String, Set<Pair<QualifiedName, QualifiedHadMember>>> successors3b, Map<String, Set<Pair<QualifiedName, SpecializationOf>>> successors4) {
        block0: for (String key : fieldNames) {
            if (!this.compilerUtil.isVariableDenotingQualifiedName(key, theVar)) continue;
            for (QualifiedName qn : allVars) {
                Set pairs4;
                Set pairs3;
                Set pairs2;
                if (!key.equals(qn.getLocalPart())) continue;
                Set pairs1 = indexed.traverseDerivationsWithRelations(qn);
                if (!pairs1.isEmpty()) {
                    successors1.put(key, pairs1);
                }
                if (!(pairs2 = indexed.traverseAttributionsWithRelations(qn)).isEmpty()) {
                    successors2.put(key, pairs2);
                }
                if (!(pairs3 = indexed.traverseReverseMembershipsWithRelations(qn)).isEmpty()) {
                    for (Pair pair3 : pairs3) {
                        if (pair3.getRight() instanceof QualifiedHadMember) {
                            successors3b.computeIfAbsent(key, k -> new HashSet());
                            successors3b.get(key).add((Pair<QualifiedName, QualifiedHadMember>)Pair.of((Object)((QualifiedName)pair3.getLeft()), (Object)((QualifiedHadMember)pair3.getRight())));
                            continue;
                        }
                        successors3.computeIfAbsent(key, k -> new HashSet());
                        successors3.get(key).add((Pair<QualifiedName, HadMember>)pair3);
                    }
                }
                if ((pairs4 = indexed.traverseSpecializationsWithRelations(qn)).isEmpty()) continue block0;
                successors4.put(key, pairs4);
                continue block0;
            }
        }
    }

    public Map<String, Set<Pair<QualifiedName, WasDerivedFrom>>> getSuccessors1() {
        return this.successors1;
    }

    public Map<String, Set<Pair<QualifiedName, WasAttributedTo>>> getSuccessors2() {
        return this.successors2;
    }

    public Map<String, Set<Pair<QualifiedName, HadMember>>> getSuccessors3() {
        return this.successors3;
    }

    public Map<String, Set<Pair<QualifiedName, QualifiedHadMember>>> getSuccessors3b() {
        return this.successors3b;
    }

    public Map<String, Set<Pair<QualifiedName, SpecializationOf>>> getSuccessors4() {
        return this.successors4;
    }

    public Pair<MethodSpec, Map<Integer, List<Integer>>> generateCommonMethod5static(Set<QualifiedName> allVars, TemplateBindingsSchema bindingsSchema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getTypedSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)CompilerUtil.mapIntArrayType);
        this.compilerUtil.specWithComment(builder);
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> fieldNames = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        this.successors1 = new HashMap<String, Set<Pair<QualifiedName, WasDerivedFrom>>>();
        this.successors2 = new HashMap<String, Set<Pair<QualifiedName, WasAttributedTo>>>();
        this.successors3 = new HashMap<String, Set<Pair<QualifiedName, HadMember>>>();
        this.successors3b = new HashMap<String, Set<Pair<QualifiedName, QualifiedHadMember>>>();
        this.successors4 = new HashMap<String, Set<Pair<QualifiedName, SpecializationOf>>>();
        this.calculateTypedSuccessors(allVars, theVar, fieldNames, indexed, this.successors1, this.successors2, this.successors3, this.successors3b, this.successors4);
        int count2 = 0;
        HashMap<QualifiedName, Integer> index = new HashMap<QualifiedName, Integer>();
        for (String key : fieldNames) {
            ++count2;
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                index.put(qn, count2);
            }
        }
        builder.addStatement("$T table = new $T()", new Object[]{CompilerUtil.mapIntArrayType, CompilerUtil.hashmapType});
        int count = 0;
        HashMap tableValues = new HashMap();
        for (String key : fieldNames) {
            int i;
            ++count;
            if (!(theVar.get(key).get(0) instanceof NameDescriptor)) continue;
            Set successors1 = new HashSet();
            Set successors2 = new HashSet();
            Set successors3 = new HashSet();
            HashSet successors3b = new HashSet();
            Set successors4 = new HashSet();
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                successors1 = indexed.traverseDerivationsWithRelations(qn);
                successors2 = indexed.traverseAttributionsWithRelations(qn);
                successors3 = indexed.traverseReverseMembershipsWithRelations(qn);
                successors4 = indexed.traverseSpecializationsWithRelations(qn);
                break;
            }
            Object initializer = "";
            LinkedList<Integer> rowValues = new LinkedList<Integer>();
            boolean first = true;
            for (Pair successor : successors1) {
                i = (Integer)index.get(successor.getLeft());
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i + ", " + this.relationTypeNumber((Relation)successor.getRight()) + " /* " + ((WasDerivedFrom)successor.getRight()).getKind() + " */";
                rowValues.add(i);
                rowValues.add(this.relationTypeNumber((Relation)successor.getRight()));
            }
            for (Pair successor2 : successors2) {
                i = (Integer)index.get(successor2.getLeft());
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i + ", " + this.relationTypeNumber((Relation)successor2.getRight()) + " /* " + ((WasAttributedTo)successor2.getRight()).getKind() + " */";
                rowValues.add(i);
                rowValues.add(this.relationTypeNumber((Relation)successor2.getRight()));
            }
            for (Pair successor3 : successors3) {
                i = (Integer)index.get(successor3.getLeft());
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i + ", " + this.relationTypeNumber((Relation)successor3.getRight()) + " /* " + ((HadMember)successor3.getRight()).getKind() + " */";
                rowValues.add(i);
                rowValues.add(this.relationTypeNumber((Relation)successor3.getRight()));
            }
            for (Pair successor4 : successors4) {
                i = (Integer)index.get(successor4.getLeft());
                if (first) {
                    first = false;
                } else {
                    initializer = (String)initializer + ", ";
                }
                initializer = (String)initializer + i + ", " + this.relationTypeNumber((Relation)successor4.getRight()) + " /* " + ((SpecializationOf)successor4.getRight()).getKind() + " */";
                rowValues.add(i);
                rowValues.add(this.relationTypeNumber((Relation)successor4.getRight()));
            }
            builder.addStatement("table.put($L,new int[] { " + (String)initializer + "})", new Object[]{count});
            tableValues.put(count, rowValues);
        }
        builder.addStatement("return table", new Object[0]);
        MethodSpec method = builder.build();
        return Pair.of((Object)method, tableValues);
    }

    public MethodSpec generateCommonMethod6static(IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getAllTypes").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.get(String[].class));
        this.compilerUtil.specWithComment(builder);
        HashSet<String> allTypes = new HashSet<String>();
        for (StatementOrBundle sOrb : indexed.toDocument().getStatementOrBundle()) {
            if (!(sOrb instanceof HasType)) continue;
            for (Type tp : ((HasType)sOrb).getType()) {
                QualifiedName qn;
                Object val = tp.getValue();
                if (!(val instanceof QualifiedName) || ExpandUtil.isVariable((QualifiedName)(qn = (QualifiedName)val))) continue;
                allTypes.add(qn.getUri());
            }
        }
        List<String> knownTypes = this.getCommonTypes0();
        ArrayList sortedList = new ArrayList(allTypes);
        Collections.sort(sortedList);
        knownTypes.addAll(sortedList);
        builder.addStatement("String [] table = new String[$L]", new Object[]{knownTypes.size()});
        int count = 0;
        for (String s : knownTypes) {
            builder.addStatement("table[$L]=$S", new Object[]{count, s});
            ++count;
        }
        builder.addStatement("return table", new Object[0]);
        return builder.build();
    }

    public List<String> getCommonTypes0() {
        ArrayList<String> knownTypes = new ArrayList<String>();
        knownTypes.add("http://www.w3.org/ns/prov#Entity");
        knownTypes.add("http://www.w3.org/ns/prov#Activity");
        knownTypes.add("http://www.w3.org/ns/prov#Agent");
        return knownTypes;
    }

    public int relationTypeNumber(Relation rel) {
        return rel.getKind().ordinal();
    }

    public MethodSpec generateFactoryMethodWithBean(String template, String packge, TemplateBindingsSchema bindingsSchema) {
        String newkey;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toBean").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(template), (String[])new String[0]));
        this.compilerUtil.specWithComment(builder);
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        for (String key : variables) {
            newkey = this.compilerUtil.generateNewNameForVariable(key);
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key), newkey, new Modifier[0]);
        }
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(template), (String[])new String[0])});
        for (String key : variables) {
            newkey = this.compilerUtil.generateNewNameForVariable(key);
            String statement = "bean.$N=$N";
            builder.addStatement(statement, new Object[]{key, newkey});
        }
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateFactoryMethodToBeanWithArrayComposite(String toBean, String template, String packge, TemplateBindingsSchema bindingsSchema, String loggerPackage, String logger, BeanDirection direction, String extension, List<String> sharing) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)toBean).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template, direction), (String[])new String[0]));
        this.compilerUtil.specWithComment(builder);
        if (extension != null) {
            builder.addComment("Refers to variant $S, sharing variables $L", new Object[]{extension, sharing.toString()});
        }
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        builder.addParameter(CompilerUtil.listOfArrays, "records", new Modifier[0]);
        builder.addStatement("$T record=records.get(0)", new Object[]{Object[].class});
        ClassName className = ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template, direction), (String[])new String[0]);
        builder.addStatement("$T bean=new $T()", new Object[]{className, className});
        int count = 1;
        for (String key : variables) {
            Class<?> declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
            String converter = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
            if (direction == BeanDirection.COMMON || ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema) || sharing != null && sharing.contains(key)) {
                String statement;
                String comment = "";
                if (sharing != null && sharing.contains(key)) {
                    comment = "/* shared */";
                }
                if (converter == null) {
                    statement = "bean.$N=($T) record[" + count + "] $L";
                    builder.addStatement(statement, new Object[]{key, declaredJavaType, comment});
                } else {
                    statement = "bean.$N=(record[" + count + "]==null)?null:((record[" + count + "] instanceof String)?$N((String)(record[" + count + "])):($T)(record[" + count + "])) $L";
                    builder.addStatement(statement, new Object[]{key, converter, declaredJavaType, comment});
                }
            }
            ++count;
        }
        builder.addStatement("bean.$N=new $T<>()", new Object[]{"__elements", LinkedList.class});
        builder.beginControlFlow("for (int i=1;i<records.size(); i++) ", new Object[0]);
        if (extension == null) {
            builder.addStatement("bean.$N($T.simpleBeanConverters.get(records.get(i)[0]).process(records.get(i)))", new Object[]{"__addElements", ClassName.get((String)loggerPackage, (String)logger, (String[])new String[0])});
        } else {
            builder.addComment("this code will only work if there is a single variant for this template", new Object[0]);
            builder.addStatement("bean.$N(toInputs$L(records.get(i)))", new Object[]{"__addElements", extension});
        }
        builder.endControlFlow();
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateFactoryMethodToBeanWithArray(String toBean, String template, String packge, TemplateBindingsSchema bindingsSchema, BeanDirection direction, String extension, List<String> shared) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)toBean).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template, direction, extension), (String[])new String[0]));
        this.compilerUtil.specWithComment(builder);
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        builder.addParameter(Object[].class, "record", new Modifier[0]);
        ClassName className = ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template, direction, extension), (String[])new String[0]);
        builder.addStatement("$T bean=new $T()", new Object[]{className, className});
        builder.addJavadoc("Converter to bean of type $T for template $N.\n", new Object[]{className, template});
        if (shared != null) {
            builder.addJavadoc("Variant $N of class $T to support shared variables $N\n", new Object[]{extension, ClassName.get((String)packge, (String)this.compilerUtil.beanNameClass(template, direction), (String[])new String[0]), shared.toString()});
        }
        builder.addJavadoc("@param record an array of objects\n", new Object[0]);
        builder.addJavadoc("@return a bean\n", new Object[0]);
        int count = 1;
        for (String key : variables) {
            Class<?> declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
            String converter = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
            if (direction == BeanDirection.COMMON || ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema) || shared != null && shared.contains(key)) {
                String statement;
                if (converter == null) {
                    statement = "bean.$N=($T) record[" + count + "]";
                    builder.addStatement(statement, new Object[]{key, declaredJavaType});
                } else {
                    statement = "bean.$N=(record[" + count + "]==null)?null:((record[" + count + "] instanceof String)?$N((String)(record[" + count + "])):($T)(record[" + count + "]))";
                    builder.addStatement(statement, new Object[]{key, converter, declaredJavaType});
                }
            }
            ++count;
        }
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateNewBean(String template, String packge) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"newBean").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(template), (String[])new String[0]));
        this.compilerUtil.specWithComment(builder);
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(template), (String[])new String[0])});
        builder.addStatement("return bean", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateExamplarBean(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String template, String packge, TemplateBindingsSchema bindingsSchema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"examplar").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(template), (String[])new String[0]));
        this.compilerUtil.specWithComment(builder);
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        builder.addStatement("$T bean=new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(template), (String[])new String[0]), ClassName.get((String)packge, (String)this.compilerUtil.commonNameClass(template), (String[])new String[0])});
        for (QualifiedName q : allVars) {
            List<Descriptor> descriptors = theVar.get(q.getLocalPart());
            Descriptor qDescriptor = descriptors == null ? null : descriptors.get(0);
            Iterator<String> idType = qDescriptor == null ? null : ConfigProcessor.descriptorUtils.getFromDescriptor(qDescriptor, AttributeDescriptor::getType, NameDescriptor::getType);
            for (String key3 : variables) {
                if (!q.getLocalPart().equals(key3)) continue;
                if (idType == null) {
                    builder.addStatement("bean.$N=$S", new Object[]{q.getLocalPart(), "example_" + q.getLocalPart()});
                    continue;
                }
                String example = this.compilerUtil.generateExampleForType((String)((Object)idType), q.getLocalPart(), this.pFactory);
                Class<?> declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(theVar, key3);
                String converter = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
                if (converter == null) {
                    builder.addStatement("bean.$N=$S", new Object[]{q.getLocalPart(), example});
                    continue;
                }
                builder.addStatement("bean.$N=$N($S)", new Object[]{q.getLocalPart(), converter, example});
            }
        }
        for (QualifiedName q : allAtts) {
            String declaredType = null;
            Class<?> declaredJavaType = null;
            for (String key3 : variables) {
                if (!q.getLocalPart().equals(key3)) continue;
                declaredType = this.compilerUtil.getDeclaredType(theVar, key3);
                declaredJavaType = this.compilerUtil.getJavaTypeForDeclaredType(theVar, key3);
            }
            String example = this.compilerUtil.generateExampleForType(declaredType, q.getLocalPart(), this.pFactory);
            String converter = this.compilerUtil.getConverterForDeclaredType2(declaredJavaType);
            if (converter == null) {
                builder.addStatement("bean.$N=$S", new Object[]{q.getLocalPart(), example});
                continue;
            }
            builder.addStatement("bean.$N=$N($S)", new Object[]{q.getLocalPart(), converter, example});
        }
        builder.addStatement("return bean", new Object[0]);
        return builder.build();
    }

    public SpecificationFile generateSQLInterface(TemplatesCompilerConfig configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInit("SQL");
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"getSQLInsert").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class);
        builder.addMethod(builder2.build());
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)"getSQLInsertStatement").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class);
        builder.addMethod(builder3.build());
        TypeSpec theInterface = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theInterface, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    public MethodSpec commonAccessorGenerator(String templateName, String packge) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getClientBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"org.openprovenance.prov.client", (String)"Builder", (String[])new String[0]));
        this.compilerUtil.specWithComment(builder);
        builder.addStatement("return new $T()", new Object[]{ClassName.get((String)packge, (String)this.compilerUtil.templateNameClass(templateName), (String[])new String[0])});
        return builder.build();
    }

    public MethodSpec typedRecordGenerator(String templateName, String packge) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getTypedRecord").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)(this.compilerUtil.templateNameClass(templateName) + "TypedRecord"), (String[])new String[0]));
        this.compilerUtil.specWithComment(builder);
        builder.addStatement("return new $T()", new Object[]{ClassName.get((String)packge, (String)(this.compilerUtil.templateNameClass(templateName) + "TypedRecord"), (String[])new String[0])});
        return builder.build();
    }
}

