/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.sql;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;

public class Collections {
    private Collections() {
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        return Arrays.asList(elements);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOf(Map.Entry<K, V> ... entries) {
        if (entries == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <E> List<E> emptyListOf(Class<E> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException();
        }
        return Collections.listOf(new Object[0]);
    }

    public static <K, V> Map<K, V> emptyMapOf(Class<K> keyType, Class<V> valueType) {
        if (keyType == null || valueType == null) {
            throw new IllegalArgumentException();
        }
        return Collections.mapOf(new Map.Entry[0]);
    }

    public static <E> int firstIndexWhere(List<E> list, Predicate<E> predicate) {
        Iterator<E> iterator = list.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (predicate.test(iterator.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E> int lastIndexWhere(List<E> list, Predicate<E> predicate) {
        int i = list.size();
        ListIterator<E> iterator = list.listIterator(i);
        while (iterator.hasPrevious()) {
            --i;
            if (!predicate.test(iterator.previous())) continue;
            return i;
        }
        return -1;
    }

    public static Object valueAt(Object root, Object ... path) {
        return Collections.valueAt(root, new LinkedList<Object>(Arrays.asList(path)));
    }

    private static Object valueAt(Object root, List<?> path) {
        Object value;
        if (root == null) {
            return null;
        }
        if (path.isEmpty()) {
            return root;
        }
        Object component = path.remove(0);
        if (root instanceof List && component instanceof Number) {
            value = ((List)root).get(((Number)component).intValue());
        } else if (root instanceof Map) {
            value = ((Map)root).get(component);
        } else {
            throw new IllegalArgumentException();
        }
        return Collections.valueAt(value, path);
    }
}

