/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.log2prov;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.template.log2prov.DocumentProcessor;
import org.openprovenance.prov.template.log2prov.ProxyManagement;
import org.openprovenance.prov.template.log2prov.RecordProcessor;
import org.openprovenance.prov.template.log2prov.interfaces.ProxyBeanInterface;
import org.openprovenance.prov.template.log2prov.interfaces.ProxyClientAccessorInterface;
import org.openprovenance.prov.template.log2prov.interfaces.ProxyMakerInterface;
import org.openprovenance.prov.template.log2prov.interfaces.ProxySQLInterface;
import org.openprovenance.prov.template.log2prov.interfaces.TriFunction;
import org.openprovenance.prov.template.types.TypesRecordProcessor;

public abstract class FileBuilder {
    static ObjectMapper mapper = new ObjectMapper();
    static Logger logger = LogManager.getLogger(FileBuilder.class);
    public static ProxyManagement pm = new ProxyManagement();
    public static final HashMap<String, FileBuilder> registry = new HashMap();
    public static final HashMap<String, Object> clientRegistry = new HashMap();
    private HashMap<String, String> variableMap = new HashMap();

    public static void reader(InputStream is, DocumentProcessor dp) {
        try {
            FileBuilder.reader(is, dp, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("io problem", e);
        }
    }

    public static void reader(InputStream r, DocumentProcessor dp, RecordProcessor rp) throws IOException {
        FileBuilder.reader(r, dp, rp, null);
    }

    public static Map<String, Object> reader(InputStream r, DocumentProcessor dp, RecordProcessor rp, TypesRecordProcessor tp) throws IOException {
        CSVParser parser = CSVParser.parse((InputStream)r, (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.DEFAULT);
        List records = parser.getRecords();
        HashMap<String, String> sqlInsert = new HashMap<String, String>();
        HashMap<QualifiedName, Set<String>> knownTypeMap = new HashMap<QualifiedName, Set<String>>();
        HashMap<QualifiedName, Set<String>> unknownTypeMap = new HashMap<QualifiedName, Set<String>>();
        HashMap<QualifiedName, Map<String, Collection<String>>> idata = new HashMap<QualifiedName, Map<String, Collection<String>>>();
        FileBuilder.processRecords(records, dp, rp, tp, sqlInsert, knownTypeMap, unknownTypeMap, idata);
        if (dp != null) {
            dp.end();
        }
        if (rp != null) {
            rp.end();
        }
        if (tp != null) {
            int bound = tp.getLevelNumber();
            tp.computeLevels(registry, clientRegistry, pm, knownTypeMap, unknownTypeMap, idata, bound);
            Map<String, Collection<Integer>> types = tp.computeTypesPerNode(bound);
            tp.computeFeatureVector(types);
            return tp.getResult();
        }
        return null;
    }

    public static void processRecords(List<CSVRecord> records, DocumentProcessor dp, RecordProcessor rp, TypesRecordProcessor tp, Map<String, String> sqlInsert, Map<QualifiedName, Set<String>> knownTypeMap, Map<QualifiedName, Set<String>> unknownTypeMap, Map<QualifiedName, Map<String, Collection<String>>> idata) {
        for (CSVRecord record : records) {
            int size = record.size();
            Object[] args = new Object[size];
            String methodName = null;
            for (int i = 0; i < size; ++i) {
                String s = record.get(i);
                if (i == 0) {
                    methodName = s;
                }
                args[i] = s == null || s.isEmpty() ? null : s;
            }
            FileBuilder.processRecord(methodName, args, dp, rp, tp, sqlInsert, knownTypeMap, unknownTypeMap, idata);
        }
    }

    public static void processRecord(String methodName, Object[] args, DocumentProcessor dp, RecordProcessor rp, TypesRecordProcessor tp, Map<String, String> sqlInsert, Map<QualifiedName, Set<String>> knownTypeMap, Map<QualifiedName, Set<String>> unknownTypeMap, Map<QualifiedName, Map<String, Collection<String>>> idata) {
        FileBuilder builder = registry.get(methodName);
        Object remoteClientBuilder = clientRegistry.get(methodName);
        ProxySQLInterface clientBuilder = pm.facadeProxy(ProxySQLInterface.class, remoteClientBuilder);
        if (builder == null) {
            logger.info("unknown method " + methodName + " in " + registry);
        } else {
            if (dp != null) {
                dp.process(builder.make(args));
            }
            if (rp != null) {
                FileBuilder.processRecordForSql(rp, sqlInsert, args, methodName, clientBuilder);
            }
            if (tp != null) {
                ProxyMakerInterface makerBuilder = pm.facadeProxy(ProxyMakerInterface.class, builder);
                Map<String, Map<String, BiFunction<Object, String, Collection<String>>>> propertyConverters = tp.getPropertyConverters();
                Map<String, Map<String, TriFunction<Object, String, String, Collection<Pair<String, Collection<String>>>>>> idataConverters = tp.getIDataConverters();
                Object typeManager = makerBuilder.getTypeManager(knownTypeMap, unknownTypeMap, propertyConverters, idata, idataConverters);
                makerBuilder.make(args, typeManager);
                tp.process(methodName, args);
            }
        }
    }

    private static void processRecordForSql(RecordProcessor rp, Map<String, String> sqlInsert, Object[] args, String methodName, ProxySQLInterface clientBuilder) {
        Object bean2sqlFun = clientBuilder.bean2sql();
        String finalMethodName = methodName;
        String insert = sqlInsert.computeIfAbsent(methodName, s -> {
            String tmp = clientBuilder.getSQLInsert();
            rp.insertHead(finalMethodName, tmp);
            return tmp;
        });
        Object bean = clientBuilder.toBean(args);
        ProxyBeanInterface proxyBean = pm.facadeProxy(ProxyBeanInterface.class, bean);
        rp.process(methodName, (String)proxyBean.process(bean2sqlFun));
    }

    public static void Oldreader(BufferedReader r, DocumentProcessor dp) {
        try {
            String line = r.readLine();
            while (line != null) {
                try {
                    Object[] objects = (Object[])mapper.readValue(line, Object[].class);
                    String methodName = (String)objects[0];
                    FileBuilder builder = registry.get(methodName);
                    if (builder != null) {
                        dp.process(builder.make(objects));
                    } else {
                        System.out.println("unknown method " + methodName);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                line = r.readLine();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public abstract Document make(Object[] var1);

    public static void register(FileBuilder builder) {
        registry.put(builder.getName(), builder);
        clientRegistry.put(builder.getName(), pm.facadeProxy(ProxyClientAccessorInterface.class, builder).getClientBuilder());
    }

    public abstract String getName();

    public static boolean registerBuilders(String[] builders, ProvFactory pf) {
        boolean ok = true;
        for (String builder : builders) {
            try {
                Class<?> cl = Class.forName(builder);
                cl.getDeclaredConstructor(ProvFactory.class).newInstance(pf);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                ok = false;
                e.printStackTrace();
            }
        }
        return ok;
    }

    public Integer toInt(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return Integer.valueOf(v.toString());
    }

    public Long toLong(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return Long.valueOf(v.toString());
    }

    public Float toFloat(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Float) {
            return (Float)v;
        }
        return Float.valueOf(v.toString());
    }

    public Double toDouble(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        return Double.valueOf(v.toString());
    }

    public Boolean toBoolean(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return Boolean.valueOf(v.toString());
    }

    public void register(Map<String, FileBuilder> m) {
        m.put(this.getName(), this);
    }

    public void setVariableMap(HashMap<String, String> m) {
        this.variableMap = m;
    }

    public HashMap<String, String> getVariableMap() {
        return this.variableMap;
    }
}

