/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.tuple.Triple;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerBeanChecker {
    private final CompilerUtil compilerUtil = new CompilerUtil();

    public SpecificationFile generateBeanChecker(TemplatesCompilerConfig configs, Locations locations, BeanDirection direction, Map<String, Map<String, Triple<String, List<String>, TemplateBindingsSchema>>> variantTable, String fileName) {
        String packageForBeans;
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(fileName);
        if (direction == BeanDirection.COMMON) {
            packageForBeans = locations.getFilePackage(configs.beanProcessor);
            builder.addSuperinterface((TypeName)ClassName.get((String)packageForBeans, (String)configs.beanProcessor, (String[])new String[0]));
        } else {
            packageForBeans = locations.getFilePackage("InputProcessor");
            builder.addSuperinterface((TypeName)ClassName.get((String)packageForBeans, (String)"InputProcessor", (String[])new String[0]));
        }
        MethodSpec.Builder mspec0 = MethodSpec.methodBuilder((String)"notNull").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.typeT, (String)"object", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(String.class, (String)"field", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(String.class, (String)"template", (Modifier[])new Modifier[0]).build()).addTypeVariable(ConfigProcessor.typeT).returns((TypeName)ConfigProcessor.typeT);
        this.compilerUtil.specWithComment(mspec0);
        mspec0.beginControlFlow("if (object==null)", new Object[0]).addStatement("throw new $T(\"The object field \" + field + \" is null in template \" + template)", new Object[]{IllegalStateException.class}).nextControlFlow("else", new Object[0]).addStatement("return object", new Object[0]).endControlFlow();
        builder.addMethod(mspec0.build());
        for (TemplateCompilerConfig config : configs.templates) {
            builder.addMethod(this.generateCheckerMethod(config.name, null, config, direction, packageForBeans, null));
        }
        if (variantTable != null) {
            variantTable.keySet().forEach(templateName -> {
                Map allVariants = (Map)variantTable.get(templateName);
                allVariants.keySet().forEach(shared -> {
                    Triple triple = (Triple)allVariants.get(shared);
                    String extension = (String)triple.getLeft();
                    List sharing = (List)triple.getMiddle();
                    TemplateBindingsSchema tbs = (TemplateBindingsSchema)triple.getRight();
                    TemplateCompilerConfig config = Arrays.stream(configs.templates).filter(c -> Objects.equals(c.name, templateName)).findFirst().get();
                    SimpleTemplateCompilerConfig sConfig = (SimpleTemplateCompilerConfig)config;
                    SimpleTemplateCompilerConfig sConfig2 = sConfig.cloneAsInstanceInComposition(templateName + extension);
                    builder.addMethod(this.generateCheckerMethod((String)templateName, extension, sConfig2, direction, packageForBeans, sharing));
                });
            });
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    public MethodSpec generateCheckerMethod(String templateName, String extension, TemplateCompilerConfig config, BeanDirection direction, String packageForBeans, List<String> sharing) {
        String beanNameClass = this.compilerUtil.beanNameClass(templateName, direction, extension);
        ClassName className = ClassName.get((String)packageForBeans, (String)beanNameClass, (String[])new String[0]);
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(ParameterSpec.builder((TypeName)className, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)className);
        this.compilerUtil.specWithComment(mspec);
        if (config instanceof SimpleTemplateCompilerConfig) {
            TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema((SimpleTemplateCompilerConfig)config);
            for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
                if (!ConfigProcessor.descriptorUtils.isCompulsoryInput(key, bindingsSchema)) continue;
                mspec.addStatement("$N(bean.$N,$S,$S)", new Object[]{"notNull", key, key, templateName});
            }
            if (sharing != null) {
                sharing.forEach(shared -> mspec.addStatement("$N(bean.$N,$S,$S) /* shared */", new Object[]{"notNull", shared, shared, templateName}));
            }
        } else {
            mspec.addStatement("bean.$N.forEach(el -> $N(el));", new Object[]{"__elements", "process"});
        }
        mspec.addStatement("return bean", new Object[0]);
        return mspec.build();
    }
}

