/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerTableConfigurator {
    private final CompilerUtil compilerUtil = new CompilerUtil();

    SpecificationFile generateTableConfigurator(TemplatesCompilerConfig configs, Locations locations) {
        return this.generateTableConfigurator(configs, false, locations);
    }

    SpecificationFile generateCompositeTableConfigurator(TemplatesCompilerConfig configs, Locations locations) {
        return this.generateTableConfigurator(configs, true, locations);
    }

    SpecificationFile generateTableConfigurator(TemplatesCompilerConfig configs, boolean compositeOnly, Locations locations) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        if (configs.tableConfigurator == null) {
            throw new NullPointerException("tableConfigurator is null");
        }
        Object tableClassName = compositeOnly ? "Composite" + configs.tableConfigurator : configs.tableConfigurator;
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInitParameter((String)tableClassName, CompilerUtil.typeT);
        for (TemplateCompilerConfig config : configs.templates) {
            if (compositeOnly && config instanceof SimpleTemplateCompilerConfig) continue;
            String templateNameClass = this.compilerUtil.templateNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)templateNameClass, (String[])new String[0]);
            MethodSpec mspec = MethodSpec.methodBuilder((String)config.name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)className, (String)"builder", (Modifier[])new Modifier[0]).build()).returns((TypeName)ConfigProcessor.typeT).build();
            builder.addMethod(mspec);
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage((String)tableClassName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), (String)tableClassName + ".java", myPackage);
    }
}

