/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;
import org.openprovenance.prov.template.expander.ExpandUtil;

public class StatementCompilerAction
implements StatementAction {
    private final JsonNode bindings_schema;
    private Set<QualifiedName> allVars;
    private Set<QualifiedName> allAtts;
    private MethodSpec.Builder builder;
    private String target;
    private ProvFactory pFactory;
    private Hashtable<QualifiedName, String> vmap;
    static final ClassName cl_collection = ClassName.get((String)"java.util", (String)"Collection", (String[])new String[0]);
    static final ClassName cl_list = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
    static final ClassName cl_linkedList = ClassName.get((String)"java.util", (String)"LinkedList", (String[])new String[0]);
    static final ClassName cl_attribute = ClassName.get((String)"org.openprovenance.prov.model", (String)"Attribute", (String[])new String[0]);
    static final TypeName cl_linkedListOfAttributes = ParameterizedTypeName.get((ClassName)cl_linkedList, (TypeName[])new TypeName[]{cl_attribute});
    static final TypeName cl_listOfAttributes = ParameterizedTypeName.get((ClassName)cl_list, (TypeName[])new TypeName[]{cl_attribute});
    static final TypeName cl_collectionOfAttributes = ParameterizedTypeName.get((ClassName)cl_collection, (TypeName[])new TypeName[]{cl_attribute});

    public StatementCompilerAction(ProvFactory pFactory, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, Hashtable<QualifiedName, String> vmap, MethodSpec.Builder builder, String target, JsonNode bindings_schema) {
        this.pFactory = pFactory;
        this.allVars = allVars;
        this.allAtts = allAtts;
        this.builder = builder;
        this.target = target;
        this.vmap = vmap;
        this.bindings_schema = bindings_schema;
    }

    public String local(QualifiedName id) {
        return id == null ? "nullqn" : id.getLocalPart();
    }

    public void doAction(Activity s) {
        String var = s.getId().getLocalPart();
        String start = this.doCollectElementVariable((Statement)s, "http://openprovenance.org/tmpl#startTime");
        String end = this.doCollectElementVariable((Statement)s, "http://openprovenance.org/tmpl#endTime");
        if (start == null) {
            if (end == null) {
                this.builder.addStatement("if ($N!=null) " + this.target + ".add(pf.newActivity($N,null,null" + this.generateAttributes((Statement)s) + "))", new Object[]{var, var});
            } else {
                this.builder.addStatement("if ($N!=null) " + this.target + ".add(pf.newActivity($N,null,($N==null)?null:pf.newISOTime($N.toString())" + this.generateAttributes((Statement)s) + "))", new Object[]{var, var, end, end});
            }
        } else if (end == null) {
            this.builder.addStatement("if ($N!=null) " + this.target + ".add(pf.newActivity($N,($N==null)?null:pf.newISOTime($N.toString()),null" + this.generateAttributes((Statement)s) + "))", new Object[]{var, var, start, start});
        } else {
            this.builder.addStatement("if ($N!=null) " + this.target + ".add(pf.newActivity($N,($N==null)?null:pf.newISOTime($N.toString()),($N==null)?null:pf.newISOTime($N.toString())" + this.generateAttributes((Statement)s) + "))", new Object[]{var, var, start, start, end, end});
        }
    }

    public void doAction(Used s) {
        String activity = this.local(s.getActivity());
        String entity = this.local(s.getEntity());
        this.builder.addStatement("if (($N!=null) &&  ($N!=null)) " + this.target + ".add(pf.newUsed($N,$N,$N,null" + this.generateAttributes((Statement)s) + "))", new Object[]{activity, entity, this.local(s.getId()), activity, entity});
    }

    public void doAction(WasStartedBy s) {
    }

    public void doAction(Agent s) {
        String var = s.getId().getLocalPart();
        this.builder.addStatement("if ($N!=null) " + this.target + ".add(pf.newAgent($N" + this.generateAttributes((Statement)s) + "))", new Object[]{var, var});
    }

    public void doAction(AlternateOf s) {
        this.builder.addStatement(this.target + ".add(pf.newAlternateOf($N,$N))", new Object[]{this.local(s.getAlternate2()), this.local(s.getAlternate1())});
    }

    public void doAction(WasAssociatedWith s) {
        this.builder.addStatement(this.target + ".add(pf.newWasAssociatedWith($N,$N,$N,$N" + this.generateAttributes((Statement)s) + "))", new Object[]{this.local(s.getId()), this.local(s.getActivity()), this.local(s.getAgent()), this.local(s.getPlan())});
    }

    public void doAction(WasAttributedTo s) {
        this.builder.addStatement(this.target + ".add(pf.newWasAttributedTo($N,$N,$N))", new Object[]{this.local(s.getId()), this.local(s.getEntity()), this.local(s.getAgent())});
    }

    public void doAction(WasInfluencedBy s) {
        this.builder.addStatement(this.target + ".add(pf.newWasInfluencedBy($N,$N,$N))", new Object[]{this.local(s.getId()), this.local(s.getInfluencee()), this.local(s.getInfluencer())});
    }

    public void doAction(ActedOnBehalfOf s) {
        String responsible = this.local(s.getResponsible());
        String delegate = this.local(s.getDelegate());
        if (s.getActivity() == null) {
            this.builder.addStatement("if (($N!=null) &&  ($N!=null)) " + this.target + ".add(pf.newActedOnBehalfOf($N,$N,$N,null" + this.generateAttributes((Statement)s) + "))", new Object[]{delegate, responsible, this.local(s.getId()), delegate, responsible});
        } else {
            String activity = this.local(s.getActivity());
            this.builder.addStatement("if (($N!=null) &&  ($N!=null)) " + this.target + ".add(pf.newActedOnBehalfOf($N,$N,$N,$N" + this.generateAttributes((Statement)s) + "))", new Object[]{delegate, responsible, this.local(s.getId()), delegate, responsible, activity});
        }
    }

    public void doAction(WasDerivedFrom s) {
        String generated = this.local(s.getGeneratedEntity());
        String used = this.local(s.getUsedEntity());
        this.builder.addStatement("if (($N!=null) &&  ($N!=null)) " + this.target + ".add(pf.newWasDerivedFrom($N,$N,$N))", new Object[]{generated, used, this.local(s.getId()), generated, used});
    }

    public void doAction(DictionaryMembership s) {
    }

    public void doAction(DerivedByRemovalFrom s) {
    }

    public void doAction(WasEndedBy s) {
    }

    public void doAction(Entity s) {
        String var = s.getId().getLocalPart();
        this.builder.addStatement("if ($N!=null) " + this.target + ".add(pf.newEntity($N" + this.generateAttributes((Statement)s) + "))", new Object[]{var, var});
    }

    public String generateAttributes(Statement s) {
        Collection<Attribute> attributes = this.doAttributesAction(s);
        return attributes.isEmpty() ? "" : ", attrs";
    }

    public Collection<Attribute> doAttributesAction(Statement s) {
        Collection attributes = this.pFactory.getAttributes(s);
        if (!attributes.isEmpty()) {
            this.builder.addStatement("attrs=new $T()", new Object[]{cl_linkedListOfAttributes});
            for (Attribute attribute : attributes) {
                QualifiedName element = attribute.getElementName();
                QualifiedName typeq = attribute.getType();
                Object value = attribute.getValue();
                if (value instanceof QualifiedName) {
                    QualifiedName vq = (QualifiedName)value;
                    if (ExpandUtil.isVariable((QualifiedName)vq)) {
                        if (this.reservedElement(element)) {
                            this.doReservedAttributeAction(this.builder, element, vq, typeq);
                            continue;
                        }
                        String localPart = vq.getLocalPart();
                        this.builder.addStatement("if ($N!=null) attrs.add(pf.newAttribute($N,$N,vc.getXsdType($N)))", new Object[]{localPart, this.vmap.get(element), localPart, localPart});
                        continue;
                    }
                    this.builder.addStatement("attrs.add(pf.newAttribute($N,$N,$N))", new Object[]{this.vmap.get(element), this.vmap.get(vq), this.vmap.get(typeq)});
                    continue;
                }
                if (value instanceof LangString) {
                    this.builder.addStatement("attrs.add(pf.newAttribute($N,$S,$N))", new Object[]{this.vmap.get(element), ((LangString)value).getValue(), this.vmap.get(typeq)});
                    continue;
                }
                this.builder.addStatement("attrs.add(pf.newAttribute($N,$S,$N))", new Object[]{this.vmap.get(element), value.toString(), this.vmap.get(typeq)});
            }
        }
        return attributes;
    }

    public void doReservedAttributeAction(MethodSpec.Builder builder2, QualifiedName element, QualifiedName vq, QualifiedName typeq) {
        String elementName = element.getUri();
        if ("http://openprovenance.org/tmpl#label".equals(elementName)) {
            this.builder.addStatement("if ($N!=null) attrs.add(pf.newAttribute($N,$N,vc.getXsdType($N)))", new Object[]{vq.getLocalPart(), this.vmap.get(this.pFactory.getName().PROV_LABEL), vq.getLocalPart(), vq.getLocalPart()});
        } else {
            if ("http://openprovenance.org/tmpl#time".equals(elementName)) {
                throw new UnsupportedOperationException();
            }
            if (!"http://openprovenance.org/tmpl#startTime".equals(elementName) && !"http://openprovenance.org/tmpl#endTime".equals(elementName)) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public boolean reservedElement(QualifiedName element) {
        String elementName = element.getUri();
        return "http://openprovenance.org/tmpl#label".equals(elementName) || "http://openprovenance.org/tmpl#time".equals(elementName) || "http://openprovenance.org/tmpl#startTime".equals(elementName) || "http://openprovenance.org/tmpl#endTime".equals(elementName);
    }

    public String doCollectElementVariable(Statement s, String search) {
        Collection attributes = this.pFactory.getAttributes(s);
        if (!attributes.isEmpty()) {
            for (Attribute attribute : attributes) {
                QualifiedName vq;
                QualifiedName element = attribute.getElementName();
                Object value = attribute.getValue();
                if (!(value instanceof QualifiedName) || !ExpandUtil.isVariable((QualifiedName)(vq = (QualifiedName)value)) || !search.equals(element.getUri())) continue;
                return vq.getLocalPart();
            }
        }
        return null;
    }

    public void doAction(WasGeneratedBy s) {
        this.builder.addStatement("if ($N!=null) " + this.target + ".add(pf.newWasGeneratedBy($N,$N,$N))", new Object[]{this.local(s.getEntity()), this.local(s.getId()), this.local(s.getEntity()), this.local(s.getActivity())});
    }

    public void doAction(WasInvalidatedBy s) {
        this.builder.addStatement("if ($N!=null) " + this.target + ".add(pf.newWasInvalidatedBy($N,$N,$N))", new Object[]{this.local(s.getEntity()), this.local(s.getId()), this.local(s.getEntity()), this.local(s.getActivity())});
    }

    public void doAction(HadMember s) {
        String element = this.local((QualifiedName)s.getEntity().get(0));
        String set = this.local(s.getCollection());
        this.builder.addStatement("if (($N!=null) && ($N!=null)) " + this.target + ".add(pf.newHadMember($N,$N))", new Object[]{element, set, set, element});
    }

    public void doAction(MentionOf s) {
    }

    public void doAction(SpecializationOf s) {
        this.builder.addStatement(this.target + ".add(pf.newSpecializationOf($N,$N))", new Object[]{this.local(s.getSpecificEntity()), this.local(s.getGeneralEntity())});
    }

    public void doAction(QualifiedSpecializationOf s) {
    }

    public void doAction(QualifiedAlternateOf s) {
    }

    public void doAction(QualifiedHadMember s) {
    }

    public void doAction(DerivedByInsertionFrom s) {
    }

    public void doAction(WasInformedBy s) {
    }

    public void doAction(Bundle bun, ProvUtilities provUtilities) {
        String id = bun.getId().getLocalPart();
        String id_ = id + "_";
        this.builder.addStatement("$T $N = pf.newNamedBundle($N,pf.newNamespace(),null)", new Object[]{Bundle.class, id_, id});
        this.builder.addStatement(this.target + ".add($N)", new Object[]{id_});
        String target2 = id_ + ".getStatement()";
        StatementCompilerAction action2 = new StatementCompilerAction(this.pFactory, this.allVars, this.allAtts, this.vmap, this.builder, target2, this.bindings_schema);
        for (Statement s : bun.getStatement()) {
            provUtilities.doAction((StatementOrBundle)s, (StatementAction)action2);
        }
    }
}

