/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerBeanEnactor2 {
    private final CompilerUtil compilerUtil = new CompilerUtil();

    SpecificationFile generateBeanEnactor2(TemplatesCompilerConfig configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        if (configs.beanProcessor == null) {
            throw new NullPointerException("beanProcessor is null");
        }
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("BeanEnactor2");
        builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        builder.addTypeVariable(ConfigProcessor.typeResult);
        ClassName queryInvokerClass = ClassName.get((String)locations.getFilePackage("QueryInvoker2"), (String)"QueryInvoker2", (String[])new String[0]);
        ClassName beanCompleterClass = ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0]);
        ClassName ioProcessorClass = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)"InputOutputProcessor", (String[])new String[0]);
        ClassName inputProcessorClass = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)"InputProcessor", (String[])new String[0]);
        builder.addSuperinterface((TypeName)ioProcessorClass);
        TypeSpec.Builder inface = this.compilerUtil.generateInterfaceInit("EnactorImplementation");
        inface.addTypeVariable(ConfigProcessor.typeResult);
        MethodSpec.Builder method1 = MethodSpec.methodBuilder((String)"generic_enact").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.typeOut, (String)"output", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.typeIn, (String)"bean", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.consumerIn, (String)"checker", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.biconsumerTypeIn, (String)"queryInvoker", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.biconsumerTypeOut, (String)"completeBean", (Modifier[])new Modifier[0]).build()).addTypeVariable(ConfigProcessor.typeIn).addTypeVariable(ConfigProcessor.typeOut).returns((TypeName)ConfigProcessor.typeOut);
        inface.addMethod(method1.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ConfigProcessor.typeResult, (String)"rs", (Modifier[])new Modifier[0]).build()).returns((TypeName)beanCompleterClass);
        inface.addMethod(method2.build());
        builder.addType(inface.build());
        builder.addField((TypeName)inputProcessorClass, "checker", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        ParameterizedTypeName ENACTOR_IMPLEMENTATION_TYPE = ParameterizedTypeName.get((ClassName)ClassName.get((String)(locations.getFilePackage("BeanEnactor2") + ".BeanEnactor2"), (String)"EnactorImplementation", (String[])new String[0]), (TypeName[])new TypeName[]{ConfigProcessor.typeResult});
        builder.addField((TypeName)ENACTOR_IMPLEMENTATION_TYPE, "realiser", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        MethodSpec.Builder cbuilder3 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ENACTOR_IMPLEMENTATION_TYPE, "realiser", new Modifier[0]).addParameter((TypeName)inputProcessorClass, "checker", new Modifier[0]);
        this.compilerUtil.specWithComment(cbuilder3);
        cbuilder3.addStatement("this.$N = $N", new Object[]{"realiser", "realiser"}).addStatement("this.$N = $N", new Object[]{"checker", "checker"});
        builder.addMethod(cbuilder3.build());
        for (TemplateCompilerConfig config : configs.templates) {
            locations.updateWithConfig(config);
            String outputNameClass = this.compilerUtil.outputsNameClass(config.name);
            String inputNameClass = this.compilerUtil.inputsNameClass(config.name);
            ClassName outputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputNameClass, (String[])new String[0]);
            ClassName inputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)inputNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)inputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)outputClassName);
            this.compilerUtil.specWithComment(mspec);
            mspec.addStatement("return $N.generic_enact(new $T(),bean,\n                b -> checker.process(b),\n                (sb,b) -> new $T(sb).process(b),\n                (rs,b) -> $N.beanCompleterFactory(rs).process(b))", new Object[]{"realiser", outputClassName, queryInvokerClass, "realiser"});
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }
}

