/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerTemplateInvoker {
    public static final String BEAN = "bean";
    private final CompilerUtil compilerUtil = new CompilerUtil();
    static TypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)});

    SpecificationFile generateTemplateInvoker(TemplatesCompilerConfig configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("TemplateInvoker").addSuperinterface((TypeName)ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)"InputOutputProcessor", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.ABSTRACT});
        for (TemplateCompilerConfig config : configs.templates) {
            ClassName completerClass;
            String inputsNameClass = this.compilerUtil.inputsNameClass(config.name);
            String outputsNameClass = this.compilerUtil.outputsNameClass(config.name);
            ClassName inputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)inputsNameClass, (String[])new String[0]);
            ClassName outputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputsNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)inputClassName, (String)BEAN, (Modifier[])new Modifier[0]).build()).returns((TypeName)outputClassName);
            this.compilerUtil.specWithComment(mspec);
            if (config instanceof SimpleTemplateCompilerConfig) {
                completerClass = ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0]);
                mspec.addStatement("return $N($T.class, $N, (m, o) -> new $T(m).process(o))", new Object[]{"generic_post_and_return", outputClassName, BEAN, completerClass});
            } else {
                completerClass = ClassName.get((String)locations.getFilePackage("CompositeBeanCompleter2"), (String)"CompositeBeanCompleter2", (String[])new String[0]);
                mspec.addStatement("return $N($T.class, $N, (m, o) -> {o.$N=new $T<>(); return new $T(m).process(o); })", new Object[]{"generic_post_and_return", outputClassName, BEAN, "__elements", LinkedList.class, completerClass});
            }
            builder.addMethod(mspec.build());
        }
        TypeVariableName inVar = TypeVariableName.get((String)"IN");
        TypeVariableName outVar = TypeVariableName.get((String)"OUT");
        ParameterizedTypeName biFunctionType = ParameterizedTypeName.get((ClassName)ClassName.get(BiFunction.class), (TypeName[])new TypeName[]{mapType, outVar, outVar});
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"generic_post_and_return").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{outVar}), (String)"clazz", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)inVar, (String)"inputs", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)biFunctionType, (String)"completer", (Modifier[])new Modifier[0]).build()).addTypeVariables(List.of(inVar, outVar)).returns((TypeName)outVar);
        builder.addMethod(mspec.build());
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }
}

