/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.log2prov;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.log2prov.DocumentConcatenatorProcessor;
import org.openprovenance.prov.template.log2prov.DocumentDiscarderProcessor;
import org.openprovenance.prov.template.log2prov.DocumentMergerProcessor;
import org.openprovenance.prov.template.log2prov.DocumentProcessor;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.template.log2prov.RecordSQLProcessor;
import org.openprovenance.prov.vanilla.ProvFactory;

public class Runner {
    static final boolean debug = false;
    private final org.openprovenance.prov.model.ProvFactory pf;
    final CompilerUtil cu = new CompilerUtil();

    public Runner(org.openprovenance.prov.model.ProvFactory pf) {
        this.pf = pf;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String in = args[0];
        String out = args[1];
        String flag = args[2];
        String extra = args.length > 3 ? args[3] : null;
        new Runner((org.openprovenance.prov.model.ProvFactory)ProvFactory.getFactory()).processLogWithTime(in, out, flag, extra);
    }

    public void processLogWithTime(String in, String out, String flag, String extra) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        long currentTime1 = System.currentTimeMillis();
        long currentTime2 = this.processLog(in, out, flag, extra);
        long currentTime3 = System.currentTimeMillis();
    }

    public long processLog(String in, String out, String flag, String extra) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        IndexedDocument iDoc = new IndexedDocument(this.pf, this.pf.newDocument(), true);
        InputStream is = "-".equals(in) ? System.in : new FileInputStream(in);
        DocumentProcessor dp = null;
        RecordSQLProcessor rp = null;
        if ("-merge".equals(flag)) {
            dp = new DocumentMergerProcessor(iDoc);
        }
        if ("-nomerge".equals(flag)) {
            dp = new DocumentConcatenatorProcessor(this.pf.newDocument());
        }
        if ("-discard".equals(flag)) {
            dp = new DocumentDiscarderProcessor(this.pf.newDocument());
        }
        if ("-db".equals(flag)) {
            rp = new RecordSQLProcessor(extra);
        }
        if ("-dbInit".equals(flag)) {
            if (rp == null) {
                rp = new RecordSQLProcessor(extra);
            }
            rp.initDb();
        }
        FileBuilder.reader(is, dp, rp);
        is.close();
        long currentTime2 = System.currentTimeMillis();
        if (dp != null) {
            this.cu.writeDocument(out, dp.getDocument());
        }
        if (rp != null) {
            if (extra != null) {
                PrintWriter pw = new PrintWriter(new FileOutputStream(extra));
                pw.println(rp.getDocument());
                pw.close();
            } else {
                System.out.println(rp.getDocument());
            }
        }
        return currentTime2;
    }
}

