/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openprovenance.prov.model.exception.InvalidCaseException;
import org.openprovenance.prov.template.types.Descriptor;
import org.openprovenance.prov.template.types.DescriptorAtom;
import org.openprovenance.prov.template.types.TypesRecordProcessor;

@JsonPropertyOrder(value={"@type", "number", "count", "relation", "arguments"})
public class DescriptorTree
implements Descriptor {
    final String category = "tree";
    final Integer number;
    long count;
    String relation;
    List<Descriptor> arguments;

    public DescriptorTree(Integer number, long count, String relation, List<Descriptor> arguments) {
        this.number = number;
        this.count = count;
        this.relation = relation;
        this.arguments = arguments;
    }

    @Override
    public String toText(Function<String, String> relationTranslator) {
        return TypesRecordProcessor.numeral(this.count) + relationTranslator.apply(this.relation) + this.arguments.stream().map(d -> d.toText(relationTranslator)).collect(Collectors.joining(",", "(", ")"));
    }

    @Override
    @JsonProperty(value="@type")
    public String getCategory() {
        return "tree";
    }

    public Integer getNumber() {
        return this.number;
    }

    public long getCount() {
        return this.count;
    }

    public String getRelation() {
        return this.relation;
    }

    public List<Descriptor> getArguments() {
        return this.arguments;
    }

    @Override
    public int compareTo(Descriptor o) {
        if (o instanceof DescriptorAtom) {
            return 1;
        }
        if (o instanceof DescriptorTree) {
            DescriptorTree that = (DescriptorTree)o;
            int relCompare = this.relation.compareTo(that.getRelation());
            if (relCompare != 0) {
                return relCompare;
            }
            int thisSize = this.arguments.size();
            int thatSize = that.arguments.size();
            int minSize = Math.min(thisSize, thatSize);
            for (int i = 0; i < minSize; ++i) {
                Descriptor thatDescriptor;
                Descriptor thisDescriptor = this.arguments.get(i);
                int descriptorCompare = thisDescriptor.compareTo(thatDescriptor = that.arguments.get(i));
                if (descriptorCompare == 0) continue;
                return descriptorCompare;
            }
            return Integer.compare(thisSize, thatSize);
        }
        throw new InvalidCaseException(o.toString());
    }
}

